/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend;

import com.adobe.cq.dam.cfm.headless.backend.FieldDefinition;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.function.Function;

public enum FragmentField implements FieldDefinition
{
    TITLE("asset", "jcr:content/jcr:title", "title", FragmentField::getString),
    UUID("asset", "jcr:uuid", "id", FragmentField::getString),
    CREATED_AT("asset", "jcr:created", "created/at", FragmentField::dateConversion),
    MODIFIED_AT("asset", "jcr:content/jcr:lastModified", "modified/at", FragmentField::dateConversion),
    MODIFIED_OR_CREATED_AT("asset", "jcr:content/jcr:lastModified", "asset", "jcr:created", "modifiedOrCreated/at", FragmentField::dateConversion),
    MODIFIED_BY("asset", "jcr:content/jcr:lastModifiedBy", "modified/by", FragmentField::getString),
    PUBLISHED_AT("asset", "jcr:content/cq:lastReplicated", "published/at", FragmentField::dateConversion),
    PUBLISHED_BY("asset", "jcr:content/cq:lastReplicatedBy", "published/by", FragmentField::getString),
    NAME("asset", "name()", "name", FragmentField::getString);

    private final String alias;
    private final String propertyPath;
    private final String secondaryAlias;
    private final String secondaryPropertyPath;
    private final String nameInResult;
    private final Function<String, Object> conversionFunc;

    private FragmentField(String alias, String propertyPath, String secondaryAlias, String secondaryPropertyPath, String nameInResult, Function<String, Object> conversionFunc) {
        this.alias = alias;
        this.propertyPath = propertyPath;
        this.secondaryAlias = secondaryAlias;
        this.secondaryPropertyPath = secondaryPropertyPath;
        this.nameInResult = nameInResult;
        this.conversionFunc = conversionFunc;
    }

    private FragmentField(String alias, String propertyPath, String nameInResult, Function<String, Object> conversionFunc) {
        this(alias, propertyPath, null, null, nameInResult, conversionFunc);
    }

    private FragmentField(String alias, String propertyPath, String nameInResult) {
        this(alias, propertyPath, nameInResult, o -> o);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public String getNameInResult() {
        return this.nameInResult;
    }

    @Override
    public Function<String, Object> getConversionFunc() {
        return this.conversionFunc;
    }

    @Override
    public String getSecondaryAlias() {
        return this.secondaryAlias;
    }

    @Override
    public String getSecondaryPropertyPath() {
        return this.secondaryPropertyPath;
    }

    static Calendar dateConversion(String value) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd['T']HH:mm[:ss][.SSS]['Z'][z]");
        if (value == null) {
            return null;
        }
        TemporalAccessor result = formatter.parse(value);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, result.get(ChronoField.YEAR));
        calendar.set(2, result.get(ChronoField.MONTH_OF_YEAR) - 1);
        calendar.set(5, result.get(ChronoField.DAY_OF_MONTH));
        calendar.set(11, result.get(ChronoField.HOUR_OF_DAY));
        calendar.set(12, result.get(ChronoField.MINUTE_OF_HOUR));
        calendar.set(13, result.get(ChronoField.SECOND_OF_MINUTE));
        calendar.set(14, result.get(ChronoField.MILLI_OF_SECOND));
        return calendar;
    }

    private static String getString(String value) {
        return value == null ? null : value.substring(1);
    }
}

