/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend;

import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.dam.cfm.headless.commons.StatusPreviewInfo;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.BooleanFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.BooleanModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelIdentifier;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateModelField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeModelField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.JsonFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.Permission;
import com.adobe.cq.dam.cfm.openapi.models.PreviewStatus;
import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import com.adobe.cq.dam.cfm.openapi.models.TagFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextModelField;
import com.adobe.cq.dam.cfm.openapi.models.TimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TimeModelField;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FragmentConverter.class})
public class FragmentConverter {
    private static final Logger log = LoggerFactory.getLogger(FragmentConverter.class);

    private <T> List<T> buildValues(Collection<T> fieldValues, T defaultValue) {
        ArrayList<T> values = new ArrayList<T>();
        if (fieldValues != null) {
            values.addAll(fieldValues);
        }
        if (values.isEmpty() && defaultValue != null) {
            values.add(defaultValue);
        }
        return values;
    }

    public Object getJsonValue(JsonFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        return values.isEmpty() ? null : values.get(0).toString();
    }

    public Boolean getBooleanValue(BooleanFragmentField field, BooleanModelField modelField) {
        List<Boolean> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        return values.isEmpty() ? null : values.get(0);
    }

    public String getDateValue(DateFragmentField field, DateModelField modelField) {
        List<LocalDate> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        return values.isEmpty() ? null : values.get(0).toString();
    }

    public String getTimeValue(TimeFragmentField field, TimeModelField modelField) {
        List<LocalTime> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        return values.isEmpty() ? null : values.get(0).toString();
    }

    public String getDateTimeValue(DateTimeFragmentField field, DateTimeModelField modelField) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        List<OffsetDateTime> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        return values.isEmpty() ? null : dateTimeFormatter.format(values.get(0));
    }

    public Object getLongValue(LongNumberFragmentField field, LongNumberModelField modelField) {
        List<Long> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.stream().mapToLong(l -> l).boxed().toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getDoubleValue(DoubleNumberFragmentField field, DoubleNumberModelField modelField) {
        List<Double> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.stream().mapToDouble(d -> d).boxed().toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getContentReferenceValue(ContentReferenceFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getFragmentReferenceValue(FragmentReferenceFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.toArray();
        }
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Object getEnumerationValue(EnumerationFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getTextValue(TextFragmentField field, TextModelField modelField) {
        List<String> values = this.buildValues(field.getValues(), modelField.getDefaultValue());
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getLongTextValue(LongTextFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        if (Boolean.TRUE.equals(field.getMultiple())) {
            return values.toArray();
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public Object getTagValue(TagFragmentField field) {
        List<Object> values = this.buildValues(field.getValues(), null);
        return values.toArray();
    }

    public Object getValue(ContentFragmentField field, ContentFragmentModelField modelField) {
        switch (modelField.getType()) {
            case TEXT: {
                return this.getTextValue((TextFragmentField)field, (TextModelField)modelField);
            }
            case LONG_TEXT: {
                return this.getLongTextValue((LongTextFragmentField)field);
            }
            case NUMBER: {
                return this.getLongValue((LongNumberFragmentField)field, (LongNumberModelField)modelField);
            }
            case FLOAT_NUMBER: {
                return this.getDoubleValue((DoubleNumberFragmentField)field, (DoubleNumberModelField)modelField);
            }
            case BOOLEAN: {
                return this.getBooleanValue((BooleanFragmentField)field, (BooleanModelField)modelField);
            }
            case DATE: {
                return this.getDateValue((DateFragmentField)field, (DateModelField)modelField);
            }
            case TIME: {
                return this.getTimeValue((TimeFragmentField)field, (TimeModelField)modelField);
            }
            case DATE_TIME: {
                return this.getDateTimeValue((DateTimeFragmentField)field, (DateTimeModelField)modelField);
            }
            case ENUMERATION: {
                return this.getEnumerationValue((EnumerationFragmentField)field);
            }
            case JSON: {
                return this.getJsonValue((JsonFragmentField)field);
            }
            case CONTENT_REFERENCE: {
                return this.getContentReferenceValue((ContentReferenceFragmentField)field);
            }
            case CONTENT_FRAGMENT: {
                return this.getFragmentReferenceValue((FragmentReferenceFragmentField)field);
            }
            case TAG: {
                return this.getTagValue((TagFragmentField)field);
            }
        }
        throw new RuntimeException("Unknown field type: " + field.getType());
    }

    public static ResourceStatus convertStatus(StatusInfo status) {
        try {
            return status == null ? null : ResourceStatus.fromString(status.toString());
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown status: {}", (Object)status);
            return null;
        }
    }

    public static PreviewStatus convertPreviewStatus(StatusPreviewInfo previewStatus) {
        try {
            return previewStatus == null ? null : PreviewStatus.fromString(previewStatus.toString());
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown preview status: {}", (Object)previewStatus);
            return null;
        }
    }

    public static Permission convertPermission(Permission permission) {
        try {
            return permission == null ? null : Permission.fromString(permission.toString());
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown permission: {}", (Object)permission);
            return null;
        }
    }

    public static ContentFragmentModelIdentifier convertModel(ContentFragmentModel model) {
        return new ContentFragmentModelIdentifier().id(Base64URLHelper.toId(model.getPath())).name(model.getName()).path(model.getPath()).title(model.getName()).description(model.getDescription());
    }
}

