/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.ProblemDetails;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.cq.dam.cfm.openapi.models.TagList;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JsonDataProcessor.class})
public class JsonDataProcessor {
    private static final Logger log = LoggerFactory.getLogger(JsonDataProcessor.class);
    private final ObjectMapper cfmMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).addModule((Module)new ParameterNamesModule())).addModule((Module)new JavaTimeModule())).serializationInclusion(JsonInclude.Include.NON_NULL)).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new DeserializationFeature[]{DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE})).build();
    public static final String EXCEPTION_ETAG = "Error while calculating eTag for resource with id '%s'";

    public JsonDataProcessor() {
        this.cfmMapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(this.getClass().getClassLoader()));
    }

    public ObjectMapper getMapper() {
        return this.cfmMapper;
    }

    public <T> T readValue(String json, Class<T> clazz) throws IOException {
        return (T)this.cfmMapper.readValue(json, clazz);
    }

    public <T> T readValue(String json, TypeReference<T> typeReference) throws IOException {
        return (T)this.cfmMapper.readValue(json, typeReference);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException {
        return (T)this.cfmMapper.readValue(inputStream, clazz);
    }

    public <T> T readValue(URL url, Class<T> clazz) throws IOException {
        return (T)this.cfmMapper.readValue(url, clazz);
    }

    public void writeValue(Writer writer, Object result) throws IOException {
        this.cfmMapper.writeValue(writer, result);
    }

    public void writeProblem(Response response, ProblemDetails problemDetails) throws IOException {
        response.setStatus(400);
        response.setContentType(ProblemDetails.MediaType.JSON.getResponseMediaType());
        this.writeValue(response.getWriter(), problemDetails);
    }

    public <T> T convertValue(Object value, Class<T> clazz) {
        return (T)this.cfmMapper.convertValue(value, clazz);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.cfmMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
    }

    @NotNull
    public <T> String getETag(@NotNull T obj) {
        try {
            String json = this.cfmMapper.writeValueAsString(obj);
            return DigestUtils.md5Hex((String)json);
        }
        catch (JsonProcessingException e) {
            log.error(EXCEPTION_ETAG, (Throwable)e);
            throw new ETagException(EXCEPTION_ETAG);
        }
    }

    @NotNull
    public String getETagForTags(TagList tagList) throws ETagException {
        ArrayList<Tag> tags = new ArrayList<Tag>(tagList.getItems());
        tags.sort(Comparator.comparing(Tag::getId));
        StringBuilder builder = new StringBuilder();
        try {
            for (Tag tag : tags) {
                builder.append(this.cfmMapper.writeValueAsString((Object)tag));
            }
            return DigestUtils.md5Hex((String)builder.toString());
        }
        catch (JsonProcessingException e) {
            log.error(EXCEPTION_ETAG, (Throwable)e);
            throw new ETagException(EXCEPTION_ETAG);
        }
    }

    public ContentFragment applyPatch(ContentFragment fragment, JsonPatch patch) throws JsonProcessingException {
        String jsonString = this.cfmMapper.writeValueAsString((Object)fragment);
        try (StringReader stringReader = new StringReader(jsonString);){
            ContentFragment contentFragment;
            block11: {
                JsonReader jsonReader = Json.createReader((Reader)stringReader);
                try {
                    JsonObject jsonBase = jsonReader.readObject();
                    JsonObject result = (JsonObject)patch.apply((JsonStructure)jsonBase);
                    contentFragment = (ContentFragment)this.cfmMapper.readValue(result.toString(), ContentFragment.class);
                    if (jsonReader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return contentFragment;
        }
    }

    public ContentFragmentVariation applyPatch(ContentFragmentVariation variation, JsonPatch patch) throws JsonProcessingException {
        String jsonString = this.cfmMapper.writeValueAsString((Object)variation);
        try (StringReader stringReader = new StringReader(jsonString);){
            ContentFragmentVariation contentFragmentVariation;
            block11: {
                JsonReader jsonReader = Json.createReader((Reader)stringReader);
                try {
                    JsonObject jsonBase = jsonReader.readObject();
                    JsonObject result = (JsonObject)patch.apply((JsonStructure)jsonBase);
                    contentFragmentVariation = (ContentFragmentVariation)this.cfmMapper.readValue(result.toString(), ContentFragmentVariation.class);
                    if (jsonReader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return contentFragmentVariation;
        }
    }

    public boolean compareJson(String expectedJson, Fragment fragment) throws JsonProcessingException {
        JsonNode expected = this.cfmMapper.readTree(expectedJson);
        fragment.getModified().setAt(OffsetDateTime.parse(expected.get("modified").get("at").asText()));
        JsonNode actual = this.cfmMapper.readTree(this.cfmMapper.writeValueAsString((Object)fragment));
        return actual.equals((Object)expected);
    }

    public boolean areEqual(Object first, Object second) throws JsonProcessingException {
        JsonNode firstNode = this.cfmMapper.readTree(this.cfmMapper.writeValueAsString(first));
        JsonNode secondNode = this.cfmMapper.readTree(this.cfmMapper.writeValueAsString(second));
        return firstNode.equals((Object)secondNode);
    }
}

