/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren;

import org.json.JSONException;
import org.json.JSONObject;

public final class Field {
    private String name;
    private FieldType type = FieldType.TEXT;
    private String value;
    private String title;
    private boolean optional = false;
    private boolean multi = false;

    public Field(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public String toString() {
        try {
            JSONObject field = new JSONObject();
            field.put("name", (Object)this.name);
            if (this.type != null) {
                field.put("type", (Object)this.type.toString().toLowerCase());
            }
            if (this.title != null) {
                field.put("title", (Object)this.title);
            }
            if (this.optional) {
                field.put("optional", this.optional);
            }
            if (this.multi) {
                field.put("multi", this.multi);
            }
            if (this.value != null) {
                field.put("value", (Object)this.value);
            }
            return field.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldType {
        BUTTON,
        CHECKBOX,
        COLOR,
        DATE,
        DATETIME,
        DATETIMELOCAL,
        EMAIL,
        FILE,
        HIDDEN,
        IMAGE,
        MONTH,
        NUMBER,
        PASSWORD,
        RADIO,
        RANGE,
        RESET,
        SEARCH,
        SUBMIT,
        TEL,
        TEXT,
        TIME,
        URL,
        WEEK;

    }
}

