/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren;

import com.adobe.reef.siren.Field;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Action {
    private String name;
    private String[] clazz;
    private Method method;
    private String href;
    private String title;
    private String type;
    private List<Field> fields = new LinkedList<Field>();

    public Action(String name, String href) throws IllegalArgumentException {
        if (name == null || name.isEmpty() || href == null || href.isEmpty()) {
            throw new IllegalArgumentException("name and href can not be null or empty.");
        }
        this.name = name;
        this.href = href;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getClazz() {
        return this.clazz;
    }

    public void setClazz(String[] clazz) {
        this.clazz = clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public String toString() {
        try {
            JSONObject action = new JSONObject();
            action.put("name", (Object)this.name);
            action.put("href", (Object)this.href);
            if (this.clazz != null) {
                action.put("class", (Object)this.clazz);
            }
            if (this.method != null) {
                action.put("method", (Object)this.method);
            }
            if (this.type != null) {
                action.put("type", (Object)this.type);
            }
            if (this.title != null) {
                action.put("title", (Object)this.title);
            }
            if (!this.fields.isEmpty()) {
                LinkedList<JSONObject> fieldsJson = new LinkedList<JSONObject>();
                for (Field f : this.fields) {
                    fieldsJson.add(new JSONObject(f.toString()));
                }
                action.put("fields", fieldsJson);
            }
            return action.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        DELETE,
        GET,
        PATCH,
        POST,
        PUT,
        COPY,
        MOVE;

    }
}

