/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.servlet;

import com.adobe.cq.remote.content.renderer.RemoteContentRendererRequestHandler;
import com.adobe.cq.remote.content.renderer.RemoteContentRenderingException;
import com.adobe.cq.remote.content.renderer.RemoteContentRenderingService;
import com.adobe.cq.remote.content.renderer.impl.ServletResponseUtils;
import com.adobe.cq.remote.content.renderer.impl.handler.RemoteContentRendererRequestHandlerRouter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=cq/remote/content/renderer/request/handler", "sling.servlet.methods=GET"})
public class RemoteContentRendererRequestHandlerServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteContentRendererRequestHandlerServlet.class);
    @Reference
    private transient RemoteContentRendererRequestHandlerRouter requestProcessingRouter;
    @Reference
    private transient RemoteContentRenderingService remoteContentRenderingService;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException {
        block9: {
            try {
                CloseableHttpResponse remoteResponse = this.remoteContentRenderingService.getRemoteContentResponse(request);
                int statusCode = remoteResponse.getStatusLine().getStatusCode();
                if (statusCode >= 400) {
                    try {
                        LOGGER.warn("Remote error: code = {} and message = {}", (Object)statusCode, (Object)IOUtils.toString((InputStream)remoteResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Remote error: code = {} and message = {}", (Object)statusCode, (Object)remoteResponse);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        ServletResponseUtils.writeFormattedMessage(response, "<!-- Remote error: %s -->", "An error on the remote endpoint, refer to the logs for more information");
                    }
                    return;
                }
                RemoteContentRendererRequestHandler handler = this.requestProcessingRouter.getRequestHandler(request);
                if (handler == null) {
                    throw new RemoteContentRenderingException("No RemoteContentRendererRequestHandler implementation for this request found");
                }
                String responseMessage = handler.getResponseMessage(remoteResponse);
                if (StringUtils.isBlank((CharSequence)responseMessage)) {
                    LOGGER.warn("Remote response was empty, nothing to inject in original response");
                    if (LOGGER.isDebugEnabled()) {
                        ServletResponseUtils.writeFormattedMessage(response, "<!-- %s -->", "Remote response was empty, nothing to inject in original response");
                    }
                    return;
                }
                response.getWriter().write(responseMessage);
            }
            catch (Exception e) {
                LOGGER.warn("Error while attempting to render content server-side: {}, {}", (Object)e.getMessage(), (Object)e);
                if (!LOGGER.isDebugEnabled()) break block9;
                ServletResponseUtils.writeFormattedMessage(response, "<!-- error message: %s -->", "An exception occurred while requesting data from the remote endpoint, refer to the logs for more information");
            }
        }
    }
}

