/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.service;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.remote.content.renderer.RemoteContentRendererRequestHandler;
import com.adobe.cq.remote.content.renderer.RemoteContentRenderingException;
import com.adobe.cq.remote.content.renderer.RemoteContentRenderingService;
import com.adobe.cq.remote.content.renderer.impl.HierarchyUtils;
import com.adobe.cq.remote.content.renderer.impl.handler.RemoteContentRendererRequestHandlerRouter;
import java.io.IOException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RemoteContentRenderingService.class})
public class RemoteContentRenderingServiceImpl
implements RemoteContentRenderingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteContentRenderingServiceImpl.class);
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;
    @Reference
    private ModelFactory modelFactory;
    @Reference
    private RemoteContentRendererRequestHandlerRouter requestProcessingRouter;

    @Override
    public CloseableHttpResponse getRemoteContentResponse(SlingHttpServletRequest request) throws RemoteContentRenderingException, IOException {
        RemoteContentRendererRequestHandler handler = this.requestProcessingRouter.getRequestHandler(request);
        if (handler == null) {
            throw new RemoteContentRenderingException("No RemoteContentRendererRequestHandler implementation for this request found");
        }
        LOGGER.debug("Used handler {}", (Object)handler.getClass().getCanonicalName());
        ComponentExporter rootPage = HierarchyUtils.getRootModel(request, this.modelFactory, handler);
        if (rootPage == null) {
            throw new RemoteContentRenderingException("No root page model found corresponding to the handler");
        }
        HttpUriRequest remoteRequest = handler.getRequest(request, rootPage);
        RequestConfig requestConfig = handler.getRequestConfig(request);
        CloseableHttpClient client = this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).build();
        LOGGER.debug("RequestConfig {}", (Object)requestConfig);
        return client.execute(remoteRequest);
    }
}

