/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.handler;

import com.adobe.cq.remote.content.renderer.RemoteContentRendererRequestHandler;
import com.adobe.cq.remote.content.renderer.impl.handler.RemoteContentRendererRequestHandlerRouter;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RemoteContentRendererRequestHandlerRouter.class})
public class RemoteContentRendererRequestHandlerRouterImpl
implements RemoteContentRendererRequestHandlerRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteContentRendererRequestHandlerRouterImpl.class);
    private final RankedServices<RemoteContentRendererRequestHandler> handlers = new RankedServices(Order.DESCENDING);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindRemoteContentRendererRequestHandler(RemoteContentRendererRequestHandler handler, Map<String, Object> properties) {
        LOGGER.debug("bindRemoteContentRendererRequestProcessor: {}", (Object)handler);
        this.handlers.bind((Object)handler, properties);
    }

    protected void unbindRemoteContentRendererRequestHandler(RemoteContentRendererRequestHandler handler, Map<String, Object> properties) {
        LOGGER.debug("unbindRemoteContentRendererRequestProcessor: {}", (Object)handler);
        this.handlers.unbind((Object)handler, properties);
    }

    @Override
    @Nullable
    public RemoteContentRendererRequestHandler getRequestHandler(@Nonnull SlingHttpServletRequest servletRequest) {
        for (RemoteContentRendererRequestHandler handler : this.handlers) {
            LOGGER.debug("getRequestHandler: checking {}", (Object)handler);
            if (!handler.canHandle(servletRequest)) continue;
            return handler;
        }
        return null;
    }
}

