/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.handler;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.remote.content.renderer.RemoteContentRendererRequestHandler;
import com.adobe.cq.remote.content.renderer.RemoteContentRenderingException;
import com.adobe.cq.remote.content.renderer.impl.HierarchyUtils;
import com.adobe.cq.remote.content.renderer.impl.factory.ConfigurationFactory;
import com.adobe.cq.remote.content.renderer.impl.factory.ConfigurationFactoryConsumer;
import com.adobe.cq.remote.content.renderer.impl.handler.requestentity.RequestEntity;
import com.adobe.cq.remote.content.renderer.impl.handler.requestentity.RequestEntityBuilder;
import com.adobe.cq.remote.content.renderer.impl.handler.requestentity.RequestEntityBuilderFactory;
import com.day.cq.wcm.api.WCMMode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RemoteContentRendererRequestHandler.class}, property={"service.ranking:Integer=100"})
public class DefaultRemoteContentRendererRequestHandlerImpl
implements RemoteContentRendererRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRemoteContentRendererRequestHandlerImpl.class);
    @Reference
    private transient ConfigurationFactoryConsumer configurationFactoryConsumer;

    @Override
    public boolean canHandle(@Nonnull SlingHttpServletRequest servletRequest) {
        return this.getConfiguration(servletRequest) != null;
    }

    @Override
    public HttpUriRequest getRequest(@Nonnull SlingHttpServletRequest servletRequest, @Nonnull ComponentExporter componentExporter) throws RemoteContentRenderingException {
        ObjectMapper mapper = new ObjectMapper();
        ConfigurationFactory configuration = this.getConfiguration(servletRequest);
        String urlStr = configuration.getRemoteEndpointURL() + servletRequest.getPathInfo();
        try {
            URL url = new URL(urlStr);
            if (!"https".equals(url.getProtocol()) && !DefaultRemoteContentRendererRequestHandlerImpl.isPrivateHost(url.getHost())) {
                LOGGER.warn("Remote URL doesn't use the secured HTTPS protocol and is not localhost: {}", (Object)url);
                throw new RemoteContentRenderingException("Remote Server URL neither contains https protocol nor localhost domain");
            }
            RequestEntityBuilder requestEntityBuilder = RequestEntityBuilderFactory.getRequestEntityBuilder(configuration.getCompression());
            RequestEntity requestEntity = requestEntityBuilder.setData(mapper.writeValueAsString((Object)componentExporter)).build();
            HttpPost postMethod = new HttpPost(url.toString());
            String rootPath = HierarchyUtils.getRootPath(servletRequest);
            postMethod.setEntity(requestEntity.getData());
            postMethod.setHeader("WCM-Mode", WCMMode.fromRequest((ServletRequest)servletRequest).toString());
            postMethod.setHeader("Page-Model-Root-URL", rootPath);
            this.attachHeaders(configuration.getAdditionalRequestHeaders(), postMethod);
            this.attachHeaders(requestEntity.getHeaders(), postMethod);
            return postMethod;
        }
        catch (JsonProcessingException | MalformedURLException exception) {
            throw new RemoteContentRenderingException("Exception while building the Remote HTTP request", exception);
        }
    }

    private void attachHeaders(Map<String, String> headers, HttpPost postMethod) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            postMethod.setHeader(header.getKey(), header.getValue());
        }
    }

    @Override
    public RequestConfig getRequestConfig(@Nonnull SlingHttpServletRequest servletRequest) {
        ConfigurationFactory configuration = this.getConfiguration(servletRequest);
        int requestTimeout = configuration.getRequestTimeout();
        return RequestConfig.custom().setConnectTimeout(requestTimeout).setSocketTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).build();
    }

    @Override
    public String getResponseMessage(@Nonnull CloseableHttpResponse httpResponse) throws IOException {
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    private static boolean isPrivateHost(String host) {
        if ("localhost".equals(host)) {
            return true;
        }
        InetAddress ia = null;
        try {
            InetAddress ad = InetAddress.getByName(host);
            byte[] ip = ad.getAddress();
            ia = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            LOGGER.warn(e.getLocalizedMessage());
            return false;
        }
        return ia.isSiteLocalAddress();
    }

    private ConfigurationFactory getConfiguration(@Nonnull SlingHttpServletRequest servletRequest) {
        return this.configurationFactoryConsumer.getConfiguration(servletRequest.getPathInfo());
    }
}

