/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.factory;

import com.adobe.cq.remote.content.renderer.impl.factory.ConfigurationFactory;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationFactory.class})
@Designate(ocd=Configuration.class, factory=true)
public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactoryImpl.class);
    private static final String DEFAULT_CONTENT_PATH_PATTERN = "/content/(.*)|/conf/(.*)/settings/wcm/templates/(.*)";
    private static final String DEFAULT_REMOTE_ENDPOINT_URL = "http://localhost:3000";
    private static final String DEFAULT_REQUEST_TIMEOUT = "10000";
    private static final String DEFAULT_COMPRESSION_ALGORITHM = "none";
    private String contentPathPattern;
    private String remoteEndpointURL;
    private String compression;
    private Map<String, String> additionalRequestHeaders = new HashMap<String, String>();
    private int requestTimeout;

    @Activate
    @Modified
    public void activate(Configuration config) {
        this.contentPathPattern = config.getContentPathPattern();
        this.remoteEndpointURL = config.getRemoteHTMLRendererUrl();
        this.requestTimeout = config.getRequestTimeout();
        this.compression = config.getCompression();
        for (String rawRequestHeaderField : config.getAdditionalRequestHeaders()) {
            String[] requestHeaderArray = rawRequestHeaderField.trim().split("=");
            if (requestHeaderArray.length != 2) continue;
            this.additionalRequestHeaders.put(requestHeaderArray[0], requestHeaderArray[1]);
        }
        LOGGER.info("Read the content Consumer URL : {}", (Object)this.remoteEndpointURL);
    }

    @Override
    public String getContentPathPattern() {
        return this.contentPathPattern;
    }

    @Override
    public String getRemoteEndpointURL() {
        return this.remoteEndpointURL;
    }

    @Override
    public Map<String, String> getAdditionalRequestHeaders() {
        return this.additionalRequestHeaders;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public String getCompression() {
        return this.compression;
    }

    @ObjectClassDefinition(name="Remote Content Renderer - Configuration Factory")
    public static @interface Configuration {
        @AttributeDefinition(name="Content path pattern", description="Regular expression to match a portion of the content", defaultValue={"/content/(.*)|/conf/(.*)/settings/wcm/templates/(.*)"})
        public String getContentPathPattern();

        @AttributeDefinition(name="Remote endpoint URL", description="URL of the endpoint that is responsible for the generating the content. Use the secured HTTPS protocol if not in local network.", defaultValue={"http://localhost:3000"})
        public String getRemoteHTMLRendererUrl();

        @AttributeDefinition(name="Additional request headers", description="Additional headers to be added to the request sent to the remote endpoint. Pattern: key=value", defaultValue={""})
        public String[] getAdditionalRequestHeaders();

        @AttributeDefinition(name="Request timeout", description="Remote host request timeout in milliseconds, configures connection timeout, socket timeout and connection request timout at the same time", defaultValue={"10000"}, type=AttributeType.INTEGER)
        public int getRequestTimeout();

        @AttributeDefinition(name="Compression algorithm", description="Compression algorithm for requests data. Compressed request is send as an octet-stream, ingesting function has to be aware and inflate the content manually.", defaultValue={"none"}, type=AttributeType.STRING)
        public String getCompression();
    }
}

