/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl.factory;

import com.adobe.cq.remote.content.renderer.impl.factory.ConfigurationFactory;
import com.adobe.cq.remote.content.renderer.impl.factory.ConfigurationFactoryConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationFactoryConsumer.class})
public class ConfigurationFactoryConsumerImpl
implements ConfigurationFactoryConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactoryConsumerImpl.class);
    private List<ConfigurationFactory> configurationList = new ArrayList<ConfigurationFactory>();

    @Reference(name="configurationFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public synchronized void bindConfigurationFactory(@Nonnull ConfigurationFactory config) {
        LOGGER.info("bindConfigurationFactory: {}", (Object)config.getContentPathPattern());
        this.configurationList.add(config);
    }

    public synchronized void unbindConfigurationFactory(@Nonnull ConfigurationFactory config) {
        LOGGER.info("unbindConfigurationFactory: {}", (Object)config.getContentPathPattern());
        this.configurationList.remove(config);
    }

    @Override
    @Nullable
    public ConfigurationFactory getConfiguration(@Nonnull String contentPath) {
        if (StringUtils.isBlank((CharSequence)contentPath)) {
            return null;
        }
        for (ConfigurationFactory configuration : this.configurationList) {
            if (!contentPath.matches(configuration.getContentPathPattern())) continue;
            return configuration;
        }
        return null;
    }
}

