/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.remote.content.renderer.impl;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.remote.content.renderer.RemoteContentRendererRequestHandler;
import com.adobe.cq.remote.content.renderer.impl.HierarchyComponentContextWrapper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.factory.ModelFactory;

public class HierarchyUtils {
    private static final String HIERARCHY_ENTRY_POINT_PAGE_ATTR = "com.adobe.aem.spa.project.core.models.Page.entryPointPage";
    private static final String COMPONENT_CONTEXT_ATTR = "com.day.cq.wcm.componentcontext";
    private static final String CURRENT_PAGE_ATTR = "currentPage";
    private static final String PR_IS_ROOT = "isRoot";
    private static final String URL_MODEL_EXTENSION = ".model.json";
    private static final Class[] DEFAULT_SLING_MODEL_ADAPTER_CLASSES = new Class[]{ContainerExporter.class, ComponentExporter.class};

    private HierarchyUtils() {
    }

    @Nullable
    private static <T extends ComponentExporter> T getModelFromWrappedRequest(@Nonnull SlingHttpServletRequest request, @Nonnull Page page, @Nonnull ModelFactory modelFactory, Class ... adapterClasses) {
        Class[] classes;
        for (Class clazz : classes = (Class[])ArrayUtils.addAll((Object[])adapterClasses, (Object[])DEFAULT_SLING_MODEL_ADAPTER_CLASSES)) {
            ComponentExporter model = (ComponentExporter)modelFactory.getModelFromWrappedRequest(HierarchyUtils.getHierarchyServletRequest(request, page), page.getContentResource(), clazz);
            if (model == null) continue;
            return (T)model;
        }
        return null;
    }

    @Nullable
    public static ComponentExporter getRootModel(@Nonnull SlingHttpServletRequest request, @Nonnull ModelFactory modelFactory) {
        return HierarchyUtils.getRootModel(request, modelFactory, null);
    }

    @Nullable
    public static ComponentExporter getRootModel(@Nonnull SlingHttpServletRequest request, @Nonnull ModelFactory modelFactory, @Nullable RemoteContentRendererRequestHandler handler) {
        Style currentStyle = HierarchyUtils.getStyle(request);
        Resource resource = request.getResource();
        if ("jcr:content".equals(resource.getName())) {
            resource = resource.getParent();
        }
        if (resource == null) {
            return null;
        }
        Page currentPage = (Page)resource.adaptTo(Page.class);
        Class[] adapterClasses = ArrayUtils.EMPTY_CLASS_ARRAY;
        if (handler != null) {
            adapterClasses = handler.getSlingModelAdapterClasses();
        }
        if (currentStyle != null && currentPage != null && currentStyle.containsKey((Object)PR_IS_ROOT)) {
            return HierarchyUtils.getModelFromWrappedRequest(request, currentPage, modelFactory, adapterClasses);
        }
        Page rootPage = HierarchyUtils.getRootPage(request);
        if (rootPage == null) {
            return null;
        }
        return HierarchyUtils.getModelFromWrappedRequest(request, rootPage, modelFactory, adapterClasses);
    }

    @Nullable
    public static String getRootPath(@Nonnull SlingHttpServletRequest request) {
        Page page = HierarchyUtils.getRootPage(request);
        if (page != null) {
            return page.getPath();
        }
        return null;
    }

    @Nullable
    public static String getRootSlingModelUrl(@Nonnull SlingHttpServletRequest request) {
        Page page = HierarchyUtils.getRootPage(request);
        if (page != null) {
            return HierarchyUtils.getModelUrl(request, page);
        }
        return null;
    }

    public static Style getStyle(@Nonnull SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (bindings != null) {
            return (Style)bindings.get((Object)"currentStyle");
        }
        return null;
    }

    @Nonnull
    private static SlingHttpServletRequest getHierarchyServletRequest(@Nonnull SlingHttpServletRequest request, @Nonnull Page page) {
        SlingHttpServletRequestWrapper wrapper = new SlingHttpServletRequestWrapper(request);
        ComponentContext componentContext = (ComponentContext)request.getAttribute(COMPONENT_CONTEXT_ATTR);
        wrapper.setAttribute(COMPONENT_CONTEXT_ATTR, (Object)new HierarchyComponentContextWrapper(componentContext, page));
        wrapper.setAttribute(CURRENT_PAGE_ATTR, (Object)page);
        Resource resource = request.getResource();
        if ("jcr:content".equals(resource.getName())) {
            resource = resource.getParent();
        }
        if (resource != null) {
            Page entryPage = (Page)resource.adaptTo(Page.class);
            wrapper.setAttribute(HIERARCHY_ENTRY_POINT_PAGE_ATTR, (Object)entryPage);
        }
        return wrapper;
    }

    @Nonnull
    public static ValueMap getPageProperties(@Nonnull Page page, @Nonnull ContentPolicyManager contentPolicyManager) {
        Template template = page.getTemplate();
        if (template == null || !template.hasStructureSupport()) {
            return ValueMap.EMPTY;
        }
        Resource pageContentResource = page.getContentResource();
        if (pageContentResource == null) {
            return ValueMap.EMPTY;
        }
        ContentPolicy pageContentPolicy = contentPolicyManager.getPolicy(pageContentResource);
        if (pageContentPolicy == null) {
            return ValueMap.EMPTY;
        }
        return pageContentPolicy.getProperties();
    }

    @Nullable
    public static Page getRootPage(@Nonnull Resource resource) {
        Page page;
        if ("jcr:content".equals(resource.getName())) {
            Resource parentResource = resource.getParent();
            if (parentResource == null) {
                return null;
            }
            resource = parentResource;
        }
        if ((page = (Page)resource.adaptTo(Page.class)) == null) {
            return null;
        }
        ContentPolicyManager contentPolicyManager = (ContentPolicyManager)resource.getResourceResolver().adaptTo(ContentPolicyManager.class);
        if (contentPolicyManager == null) {
            return null;
        }
        Page rootPage = page;
        while ((page = rootPage.getParent()) != null) {
            ValueMap properties = HierarchyUtils.getPageProperties(page, contentPolicyManager);
            boolean isRootModel = properties.containsKey((Object)PR_IS_ROOT);
            rootPage = page;
            if (!isRootModel) continue;
        }
        return rootPage;
    }

    @Nullable
    private static Page getRootPage(@Nonnull SlingHttpServletRequest request) {
        Page page;
        Style currentStyle = HierarchyUtils.getStyle(request);
        Resource resource = request.getResource();
        if (currentStyle != null && currentStyle.containsKey((Object)PR_IS_ROOT) && (page = (Page)resource.adaptTo(Page.class)) != null) {
            return page;
        }
        return HierarchyUtils.getRootPage(resource);
    }

    private static String getPageURL(@Nonnull SlingHttpServletRequest request, @Nonnull Page page) {
        String vanityURL = page.getVanityUrl();
        String contextPath = request.getContextPath();
        return StringUtils.isBlank((CharSequence)vanityURL) ? contextPath + page.getPath() + ".html" : contextPath + vanityURL;
    }

    private static String getModelUrl(@Nonnull SlingHttpServletRequest request, @Nonnull Page page) {
        String url = HierarchyUtils.getPageURL(request, page);
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        int dotIndex = url.indexOf(46);
        if (dotIndex < 0) {
            dotIndex = url.length();
        }
        return url.substring(0, dotIndex) + URL_MODEL_EXTENSION;
    }
}

