/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.PDF2XFDFAnnotationsReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.PDF2XFDFFormsReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF2PDFAnnotationReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF2PDFFormReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XFDFObject {
    PDFAnnotationRotationEnum rotationType = PDFAnnotationRotationEnum.NoRotate;
    public static final String NAMESPACES_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String XMLNS_XHTML = "http://www.w3.org/1999/xhtml";
    public static final String XMLNS_XFA = "http://www.xfa.org/schema/xfa-data/1.0/";

    XFDFObject() {
    }

    public static void exportAnnotations(PDFDocument pdfDocument, OutputStream xmlStream) throws PDFInvalidXMLException {
        ServicesUtil.transformToXML(new PDF2XFDFAnnotationsReader(pdfDocument), null, xmlStream);
    }

    public static void exportAnnotations(PDFDocument pdfDocument, OutputStream xmlStream, PDFAnnotationRotationEnum rotationType) throws PDFInvalidXMLException {
        ServicesUtil.transformToXML(new PDF2XFDFAnnotationsReader(pdfDocument, rotationType), null, xmlStream);
    }

    public static void importAnnotations(InputStream inputXML, PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFIOException, PDFConfigurationException {
        SAXParser saxParser;
        XFDF2PDFAnnotationReader handler = new XFDF2PDFAnnotationReader(pdfDocument);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        try {
            saxParser.getXMLReader().setFeature(NAMESPACES_PREFIXES, true);
        }
        catch (SAXNotRecognizedException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException((Throwable)e);
        }
        try {
            saxParser.parse(inputXML, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("Unable to parse XFDF annotations", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to parse XFDF annotations", (Throwable)e);
        }
        if (!handler.hasXFDFElement()) {
            throw new PDFInvalidXMLException("XFDF does not contain a xfdf element in xml.");
        }
    }

    public static void deleteAnnotations(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage curPage;
        PDFPageTree pages = pdfDocument.requirePages();
        int pageIndex = 0;
        while ((curPage = pages.getPage(pageIndex++)) != null) {
            PDFAnnotationList annotations = curPage.getAnnotationList();
            if (annotations == null) continue;
            int annotInd = 0;
            while (annotInd < annotations.size()) {
                PDFAnnotation annot = annotations.get(annotInd);
                if (annot == null) {
                    ++annotInd;
                    continue;
                }
                if (XFDFAnnotation.createXFDFAnnotation(annot) != null) {
                    if (annot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)annot).hasPopup()) {
                        PDFAnnotationPopup popup = ((PDFAnnotationMarkup)annot).getPopup();
                        int popupInd = annotations.indexOf((PDFAnnotation)popup);
                        annotations.remove((PDFAnnotation)popup);
                        if (popupInd < annotInd) {
                            --annotInd;
                        }
                    }
                    annotations.remove(annotInd);
                    --annotInd;
                }
                ++annotInd;
            }
            if (annotations.size() == 0) {
                curPage.removeAnnotationList();
                continue;
            }
            curPage.setAnnotationList(annotations);
        }
    }

    public static void exportFormData(PDFInteractiveForm forms, OutputStream xmlStream) throws PDFInvalidXMLException {
        ServicesUtil.transformToXML(new PDF2XFDFFormsReader(forms), null, xmlStream);
    }

    public static void importFormData(InputStream inputXML, PDFInteractiveForm forms) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException {
        XFDF2PDFFormReader handler = new XFDF2PDFFormReader(forms);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException((Throwable)e);
        }
        try {
            saxParser.parse(inputXML, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to parse XFDF Acroform", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to parse XFDF Acroform", (Throwable)e);
        }
    }

    public static void importFormData(InputStream inputXML, PDFInteractiveForm forms, PDFFontSet fontSet, Locale locale, boolean importIntoLockedFields) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException {
        XFDF2PDFFormReader handler = new XFDF2PDFFormReader(forms, fontSet, locale, importIntoLockedFields);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException((Throwable)e);
        }
        try {
            saxParser.parse(inputXML, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to parse XFDF Acroform", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to parse XFDF Acroform", (Throwable)e);
        }
    }

    public static void importAnnotations(InputStream inputXML, PDFDocument pdfDocument, PDFAnnotationRotationEnum onlyannotationrotation) throws PDFInvalidXMLException, PDFIOException, PDFConfigurationException {
        SAXParser saxParser;
        XFDF2PDFAnnotationReader handler = new XFDF2PDFAnnotationReader(pdfDocument, onlyannotationrotation);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        try {
            saxParser.getXMLReader().setFeature(NAMESPACES_PREFIXES, true);
        }
        catch (SAXNotRecognizedException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new PDFConfigurationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException((Throwable)e);
        }
        try {
            saxParser.parse(inputXML, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("Unable to parse XFDF annotations", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to parse XFDF annotations", (Throwable)e);
        }
        if (!handler.hasXFDFElement()) {
            throw new PDFInvalidXMLException("XFDF does not contain a xfdf element in xml.");
        }
    }

    void setRotationType(PDFAnnotationRotationEnum rotationType) {
        this.rotationType = rotationType;
    }
}

