/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRichMedia;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DCrossSection;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDStream;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DExData3DM;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DExDataMarkup3D;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DLightingScheme;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DNode;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DNodeArray;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DRenderMode;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DSectionArray;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVBGDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVPDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DViewArray;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFExDataRichMedia;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaContent;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaView;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaViewList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFViewParams;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.Cos2XMLReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF3DMeasurement;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFExData {
    PDFExData exData3D;
    PDF3DVDict view3DDict;
    PDFAnnotation pdfAnnot;
    PDFAnnotationMarkup markup;
    XFDFAnnotation currentXFDF;
    private boolean isExistingView = false;
    private byte[] md5Checksum = null;
    PDF3DVDict newView = null;
    private boolean creatingProjection;
    private boolean creatingBackground;
    private boolean creatingNodePara;
    private boolean creatingRenderingInfo;
    private boolean creatingLightingInfo;
    private PDF3DVBGDict bgView;
    private boolean creatingCrossSection;
    private boolean creatingStateInfo;
    private boolean creatingMeasure;
    private long imageHeight = -1L;
    private long imageWidth = -1L;
    private PDFXObjectImage imageStream = null;
    XFDF3DMeasurement xfdfMeasure;
    private String internalname;
    private PDFViewParams viewParams = null;
    PDF3DCrossSection cs3D;
    private boolean showTrans;
    private double p1;
    private double p2;
    private double[] cor;
    private double[] planecolor;
    private double[] intercolor;
    private boolean intervisisble = false;
    private double planeopacity;
    private String axis;
    private boolean planevisible = false;
    PDF3DRenderMode rM;
    PDF3DNode node;
    boolean visible = false;
    double opacity = 0.0;
    String name = null;
    double[] matrix = null;
    String renderMode = null;
    PDF3DNodeArray na = null;
    PDF3DVPDict pV;
    private String measurementCommentName;
    static final AttributesImpl nullAttrs = new AttributesImpl();
    static final String ELEM_EXDATA3D = "exdata3d";
    static final String ELEM_VIEW3D = "view3d";
    static final String ELEM_ANNOT3DName = "anno3dname";
    static final String ELEM_MD5CHECKSUM = "md5checksum";
    static final String ELEM_EXTRENALNAME = "externalname";
    static final String ELEM_INTERNALNAME = "internalname";
    static final String ELEM_CAMERAXFORM = "cameraxform";
    static final String ELEM_U3DMATSRC = "u3dmatrixsource";
    static final String ELEM_TARGETDISTANCE = "targetdistance";
    static final String ELEM_PROJECTION = "projection";
    static final String ATTR_PROJTYPE = "projtype";
    static final String ELEM_FIELDOFVIEW = "fieldofview";
    static final String ELEM_VIEWPLANESIZE = "viewplanesize";
    static final String ELEM_SCALETYPE = "scaletype";
    static final String ELEM_SCALEVALUE = "scalevalue";
    static final String ELEM_CLIP = "clip";
    static final String ATTR_NEAR = "near";
    static final String ATTR_FAR = "far";
    static final String ELEM_BACKGROUND = "background";
    static final String ATTR_ENTRBKGRD = "entirebackground";
    static final String ELEM_COLOR = "color";
    static final String ELEM_RENDERINGINFO = "renderinginfo";
    static final String ELEM_AUXCOLOR = "auxcolor";
    static final String ELEM_FACECOLOR = "facecolor";
    static final String ELEM_OPACITY = "opacity";
    static final String ELEM_CREASEVAL = "creasevalue";
    static final String ATTR_MODE = "mode";
    static final String ELEM_LIGHTING = "lighting";
    static final String ATTR_SCHEME = "scheme";
    static final String ELEM_CROSSSECTION = "crosssection";
    static final String ELEM_CENTEROFROTATION = "centerofrotation";
    static final String ELEM_PLANETILT1 = "planetilt1";
    static final String ELEM_PLANETILT2 = "planetilt2";
    static final String ELEM_ALIGNMENT = "alignment";
    static final String ATTR_AXIS = "axis";
    static final String ELEM_PLANEVISIBLE = "planevisible";
    static final String ELEM_PLANECOLOR = "planecolor";
    static final String ELEM_PLANEOPACITY = "planeopacity";
    static final String ELEM_INTERVISIBLE = "intersectionsvisible";
    static final String ELEM_INTERCOLOR = "intersectioncolor";
    static final String ATTR_SHOWTRANS = "showtransparent";
    static final String ATTR_PLANEFLIP = "planeflip";
    static final String ELEM_NODEPARA = "nodeparameter";
    static final String ELEM_NODEID = "nodeid";
    static final String ELEM_NODEXFORM = "nodexform";
    static final String ELEM_NODEOPACITY = "opacity";
    static final String ELEM_NORENDERMODE = "noderendermode";
    static final String ATTR_RENDERMODE = "mode";
    static final String ATTR_NODEVISIBLE = "visible";
    static final String ELEM_SHOULDRESETNODES = "shouldresetnodes";
    static final String ELEM_MEASURECOMMEND = "measurementcomment";
    static final String ELEM_MEASURE = "measure";
    static final String ELEM_MEASURENAME = "measurename";
    static final String ELEM_MEASURELIMARKUP = "linearmarkup";
    static final String ELEM_MEASUREPIMARKUP = "perpendicularmarkup";
    static final String ELEM_MEASUREAIMARKUP = "angularmarkup";
    static final String ELEM_MEASURERIMARKUP = "radialmarkup";
    static final String ELEM_MEASURECOMMEND3DMARKUP = "comment3dmarkup";
    static final String ELEM_STATEINFO = "stateinfo";
    static final String ATTR_INSTANCEID = "instanceid";
    static final String ATTR_INSTANCE = "instance";
    static final String ELEM_RMVSNAPSHOT = "snapshot";
    static final String ELEM_RMVWIDTH = "width";
    static final String ELEM_RMVHEIGHT = "height";
    static final String ELEM_RMVIMAGE = "image";
    private static final Map<String, ASName> ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP = new ConcurrentHashMap<String, ASName>();

    public XFDFExData(PDFExData exData) {
        this.exData3D = exData;
    }

    public XFDFExData(XFDFAnnotation xfdfAnnot, PDFAnnotation annot, byte[] md5Checksum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (annot instanceof PDFAnnotation3D) {
            this.pdfAnnot = annot;
            this.view3DDict = (PDF3DVDict)((PDFAnnotation3D)this.pdfAnnot).get3DViewAsDict();
        } else if (annot instanceof PDFAnnotationRichMedia) {
            this.pdfAnnot = annot;
        }
        this.currentXFDF = xfdfAnnot;
        this.markup = (PDFAnnotationMarkup)xfdfAnnot.pdfAnnot;
        this.md5Checksum = md5Checksum;
    }

    void transformToXFDF(ContentHandler handler, PDFAnnotationMarkup pdfAnnot, List annots3D, XFDFAnnotation curXFDF) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException, IOException, PDFConfigurationException {
        this.markup = pdfAnnot;
        this.currentXFDF = curXFDF;
        handler.startElement("", ELEM_EXDATA3D, ELEM_EXDATA3D, nullAttrs);
        this.addExdata3DChildElementss(handler, this.exData3D, pdfAnnot, annots3D);
        handler.endElement("", ELEM_EXDATA3D, ELEM_EXDATA3D);
    }

    private void fixAnnot3DCommentExport(ContentHandler handler, PDFAnnotationMarkup pdfAnnot, List annots3D, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (pdfAnnot.getExData() instanceof PDF3DExData3DM) {
            PDF3DExData3DM exData = (PDF3DExData3DM)pdfAnnot.getExData();
            PDF3DMeasurement measure3D = exData.getM3DREF();
            if (measure3D == null) {
                return;
            }
            for (int i3D = 0; i3D < annots3D.size(); ++i3D) {
                PDFAnnotation3D annot3D = (PDFAnnotation3D)annots3D.get(i3D);
                PDF3DDStream _3ddStream = null;
                if (annot3D.get3DDictOrStreamAsStream() != null) {
                    _3ddStream = (PDF3DDStream)annot3D.get3DDictOrStreamAsStream();
                } else if (annot3D.get3DDictOrStreamAsDict() != null) {
                    PDF3DDDict _3dd = (PDF3DDDict)annot3D.get3DDictOrStreamAsDict();
                    _3ddStream = _3dd.get3DD();
                }
                if (_3ddStream == null || !_3ddStream.hasPresetViewArtwork()) continue;
                PDF3DViewArray va = _3ddStream.getPresetViewArtwork();
                PDF3DVDict _3dv2 = null;
                if (va == null) continue;
                for (PDF3DVDict _3dv2 : va) {
                    PDF3DExData3DM newExData;
                    PDF3DMeasurementList maList;
                    if (!_3dv2.hasMA() || !(maList = _3dv2.getMA()).contains((Object)measure3D)) continue;
                    try {
                        newExData = PDF3DExData3DM.newInstance((PDFDocument)pdfAnnot.getPDFDocument(), (PDF3DMeasurement)measure3D);
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException((Throwable)e);
                    }
                    newExData.removeValue(PDF3DExData3DM.k_M3DREF);
                    if (annot3D.getName() != null && annot3D.getName().length() != 0) {
                        newExData.setDictionaryStringValue(ASName.k_3DA, annot3D.getName(), unicode);
                        this.setAnoot3DNameElement(handler, annot3D.getName());
                    } else {
                        String mD5Checksum = XFDFUtil.getMD5ChecksumString(XFDFUtil.calculateMD5Checksum(annot3D));
                        if (mD5Checksum != null) {
                            this.setAnnot3DMD5DigestElement(handler, mD5Checksum);
                        }
                    }
                    newExData.setDictionaryValue(ASName.k_3DV, (PDFCosObject)_3dv2);
                    if (measure3D.getTRL() != null) {
                        newExData.setDictionaryStringValue(ASName.k_M3N, measure3D.getTRL().stringValue(), unicode);
                    }
                    pdfAnnot.setExData((PDFExData)newExData);
                    this.exData3D = newExData;
                    this.view3DDict = _3dv2;
                    return;
                }
            }
        }
    }

    private void setAnoot3DNameElement(ContentHandler handler, String annot3DName) throws SAXException {
        handler.startElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName, nullAttrs);
        handler.characters(annot3DName.toCharArray(), 0, annot3DName.length());
        handler.endElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName);
    }

    private void setAnnot3DMD5DigestElement(ContentHandler handler, String mD5Checksum) throws SAXException {
        handler.startElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM, nullAttrs);
        handler.characters(mD5Checksum.toCharArray(), 0, mD5Checksum.length());
        handler.endElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM);
    }

    private void addExdata3DChildElementss(ContentHandler handler, PDFExData exData, PDFAnnotationMarkup pdfAnnot, List annots3D) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException, PDFConfigurationException, IOException {
        if (exData instanceof PDFExDataRichMedia) {
            this.view3DDict = ((PDFExDataRichMedia)this.exData3D).getRichMediaViewDict();
            String annotRM3dName = null;
            if (((PDFExDataRichMedia)exData).getRichMediaAnnot() != null) {
                annotRM3dName = ((PDFExDataRichMedia)exData).getRichMediaAnnot().getName();
                if (annotRM3dName != null) {
                    handler.startElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName, nullAttrs);
                    handler.characters(annotRM3dName.toCharArray(), 0, annotRM3dName.length());
                    handler.endElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName);
                } else {
                    ASString md5 = ((PDFExDataRichMedia)this.exData3D).getMD5();
                    if (md5 != null) {
                        String md5Checksum = XFDFUtil.getMD5ChecksumString(md5.getBytes());
                        handler.startElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM, nullAttrs);
                        handler.characters(md5Checksum.toCharArray(), 0, md5Checksum.length());
                        handler.endElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM);
                    }
                }
            }
            handler.startElement("", ELEM_VIEW3D, ELEM_VIEW3D, nullAttrs);
            this.addView3dRelatedElemnts(handler);
            handler.endElement("", ELEM_VIEW3D, ELEM_VIEW3D);
        } else if (exData instanceof PDF3DExDataMarkup3D) {
            this.view3DDict = ((PDF3DExDataMarkup3D)this.exData3D).get3DV();
            if (((PDF3DExDataMarkup3D)this.exData3D).has3DA()) {
                ASString md5;
                String annot3dName = null;
                if (((PDF3DExDataMarkup3D)exData).get3DAAsDict() != null) {
                    annot3dName = ((PDF3DExDataMarkup3D)exData).get3DAAsDict().getName();
                } else if (((PDF3DExDataMarkup3D)exData).get3DAAsTextString() != null) {
                    annot3dName = ((PDF3DExDataMarkup3D)exData).get3DAAsTextString().stringValue();
                }
                if (annot3dName != null) {
                    handler.startElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName, nullAttrs);
                    handler.characters(annot3dName.toCharArray(), 0, annot3dName.length());
                    handler.endElement("", ELEM_ANNOT3DName, ELEM_ANNOT3DName);
                } else if (((PDF3DExDataMarkup3D)this.exData3D).hasMD5() && (md5 = ((PDF3DExDataMarkup3D)this.exData3D).getMD5()) != null) {
                    String md5Checksum = XFDFUtil.getMD5ChecksumString(md5.getBytes());
                    handler.startElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM, nullAttrs);
                    handler.characters(md5Checksum.toCharArray(), 0, md5Checksum.length());
                    handler.endElement("", ELEM_MD5CHECKSUM, ELEM_MD5CHECKSUM);
                }
            }
            handler.startElement("", ELEM_VIEW3D, ELEM_VIEW3D, nullAttrs);
            this.addView3dRelatedElemnts(handler);
            handler.endElement("", ELEM_VIEW3D, ELEM_VIEW3D);
        } else if (exData instanceof PDF3DExData3DM) {
            PDF3DMeasurementList measureList;
            this.fixAnnot3DCommentExport(handler, pdfAnnot, annots3D, null);
            handler.startElement("", ELEM_VIEW3D, ELEM_VIEW3D, nullAttrs);
            this.addView3dRelatedElemnts(handler);
            if (((PDF3DExData3DM)exData).hasM3DREF() && this.view3DDict != null && (measureList = this.view3DDict.getMA()) != null) {
                PDF3DMeasurement pdfMeasure = null;
                for (int i = 0; i < measureList.size(); ++i) {
                    pdfMeasure = (PDF3DMeasurement)measureList.get(i);
                    XFDF3DMeasurement xfdfMeasure = new XFDF3DMeasurement(pdfMeasure);
                    xfdfMeasure.transformToXFDF(handler);
                }
            }
            handler.endElement("", ELEM_VIEW3D, ELEM_VIEW3D);
            if (((PDF3DExData3DM)exData).hasM3DREF()) {
                handler.startElement("", ELEM_MEASURECOMMEND, ELEM_MEASURECOMMEND, nullAttrs);
                String measurementcomment = ((PDF3DExData3DM)exData).getM3DREF().getTRL().stringValue();
                handler.characters(measurementcomment.toCharArray(), 0, measurementcomment.length());
                handler.endElement("", ELEM_MEASURECOMMEND, ELEM_MEASURECOMMEND);
            }
        }
    }

    private void addView3dRelatedElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFConfigurationException, IOException {
        this.addView3dChildElemnts(handler);
        this.addView3dCameraElemnts(handler);
        this.addView3dProjctionElemnts(handler);
        this.addView3dBackgroundElemnts(handler);
        this.addView3dModelRenderingElemnts(handler);
        this.addView3dLightElemnts(handler);
        this.addView3dCrossSectionElemnts(handler);
        this.addView3dSpecificNodeRelatedElemnts(handler);
        this.addRichMediaElemnts(handler);
    }

    private void addView3dChildElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.view3DDict != null) {
            String externalName;
            if (this.view3DDict.hasExternalName()) {
                handler.startElement("", ELEM_EXTRENALNAME, ELEM_EXTRENALNAME, nullAttrs);
                externalName = this.view3DDict.getExternalName().toString();
                handler.characters(externalName.toCharArray(), 0, externalName.length());
                handler.endElement("", ELEM_EXTRENALNAME, ELEM_EXTRENALNAME);
            }
            if (this.view3DDict.hasInternalName()) {
                handler.startElement("", ELEM_INTERNALNAME, ELEM_INTERNALNAME, nullAttrs);
                externalName = this.view3DDict.getInternalName().toString();
                handler.characters(externalName.toCharArray(), 0, externalName.length());
                handler.endElement("", ELEM_INTERNALNAME, ELEM_INTERNALNAME);
            }
        }
    }

    private void addView3dCameraElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.view3DDict != null) {
            if (this.view3DDict.hasMatrixSource()) {
                String u3dmatrixsource = this.view3DDict.getMatrixSource().asString();
                if (u3dmatrixsource.equalsIgnoreCase("M")) {
                    if (this.view3DDict.hasCameraToWorld()) {
                        handler.startElement("", ELEM_CAMERAXFORM, ELEM_CAMERAXFORM, nullAttrs);
                        String cameraxform = XFDFUtil.toStringFromDoubleArray(this.view3DDict.getCameraToWorld());
                        handler.characters(cameraxform.toCharArray(), 0, cameraxform.length());
                        handler.endElement("", ELEM_CAMERAXFORM, ELEM_CAMERAXFORM);
                    }
                } else if (u3dmatrixsource.equalsIgnoreCase("U3D")) {
                    handler.startElement("", ELEM_U3DMATSRC, ELEM_U3DMATSRC, nullAttrs);
                    String u3dpath = this.view3DDict.getU3DPathAsString().asString();
                    handler.characters(u3dpath.toCharArray(), 0, u3dpath.length());
                    handler.endElement("", ELEM_U3DMATSRC, ELEM_U3DMATSRC);
                }
            }
            if (this.view3DDict.hasCenterOfOrbit()) {
                handler.startElement("", ELEM_TARGETDISTANCE, ELEM_TARGETDISTANCE, nullAttrs);
                String targetdistance = String.valueOf(this.view3DDict.getCenterOfOrbit());
                handler.characters(targetdistance.toCharArray(), 0, targetdistance.length());
                handler.endElement("", ELEM_TARGETDISTANCE, ELEM_TARGETDISTANCE);
            }
        }
    }

    private void addView3dProjctionElemnts(ContentHandler handler) throws SAXException, PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.view3DDict != null) {
            String near;
            String projtype = this.view3DDict.getP().getSubtype().asString();
            if (projtype.equalsIgnoreCase("p")) {
                projtype = "perspective";
            } else if (projtype.equalsIgnoreCase("o")) {
                projtype = "parallel";
            }
            AttributesImpl annotsAtts = new AttributesImpl();
            annotsAtts.addAttribute("", ATTR_PROJTYPE, ATTR_PROJTYPE, "CDATA", projtype);
            handler.startElement("", ELEM_PROJECTION, ELEM_PROJECTION, annotsAtts);
            annotsAtts = new AttributesImpl();
            if (this.view3DDict.getP().hasFieldOfView()) {
                handler.startElement("", ELEM_FIELDOFVIEW, ELEM_FIELDOFVIEW, nullAttrs);
                String fieldOfView = String.valueOf(this.view3DDict.getP().getFieldOfView());
                handler.characters(fieldOfView.toCharArray(), 0, fieldOfView.length());
                handler.endElement("", ELEM_FIELDOFVIEW, ELEM_FIELDOFVIEW);
            }
            if (this.view3DDict.getP().hasOrthographicScale()) {
                handler.startElement("", ELEM_VIEWPLANESIZE, ELEM_VIEWPLANESIZE, nullAttrs);
                String viewplanesize = String.valueOf(this.view3DDict.getP().getOrthographicScale());
                handler.characters(viewplanesize.toCharArray(), 0, viewplanesize.length());
                handler.endElement("", ELEM_VIEWPLANESIZE, ELEM_VIEWPLANESIZE);
            }
            if (this.view3DDict.getP().hasOrthographicBinding()) {
                handler.startElement("", ELEM_SCALEVALUE, ELEM_SCALEVALUE, nullAttrs);
                String scaleValue = this.view3DDict.getP().getOrthographicBinding().asString();
                handler.characters(scaleValue.toString().toCharArray(), 0, scaleValue.toString().length());
                handler.endElement("", ELEM_SCALEVALUE, ELEM_SCALEVALUE);
            }
            if (this.view3DDict.getP().hasPerspactiveScale() && projtype.equalsIgnoreCase("perspective")) {
                handler.startElement("", ELEM_SCALETYPE, ELEM_SCALETYPE, nullAttrs);
                String scaletype = null;
                scaletype = this.view3DDict.getP().isPerspactiveASName() ? this.view3DDict.getP().getPerspactiveScaleAsName().asString() : Double.toString(this.view3DDict.getP().getPerspactiveScaleAsFixed());
                handler.characters(scaletype.toCharArray(), 0, scaletype.length());
                handler.endElement("", ELEM_SCALETYPE, ELEM_SCALETYPE);
            }
            if (this.view3DDict.getP().hasNearClipping()) {
                near = String.valueOf(this.view3DDict.getP().getNearClipping());
                annotsAtts.addAttribute("", "Near", "Near", "CDATA", near);
                handler.startElement("", ELEM_CLIP, ELEM_CLIP, annotsAtts);
                handler.endElement("", ELEM_CLIP, ELEM_CLIP);
            } else if (this.view3DDict.getP().hasFarClipping()) {
                annotsAtts = new AttributesImpl();
                near = String.valueOf(this.view3DDict.getP().getFarClipping());
                annotsAtts.addAttribute("", "Far", "Far", "CDATA", near);
                handler.startElement("", ELEM_CLIP, ELEM_CLIP, annotsAtts);
                handler.endElement("", ELEM_CLIP, ELEM_CLIP);
            }
            handler.endElement("", ELEM_PROJECTION, ELEM_PROJECTION);
        }
    }

    private void addView3dBackgroundElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.view3DDict != null && this.view3DDict.hasBG()) {
            if (this.view3DDict.getBG().hasEntireAnnot()) {
                String ebc = String.valueOf(this.view3DDict.getBG().getEntireAnnot());
                AttributesImpl annotsAtts = new AttributesImpl();
                annotsAtts.addAttribute("", ATTR_ENTRBKGRD, ATTR_ENTRBKGRD, "CDATA", ebc);
                handler.startElement("", ELEM_BACKGROUND, ELEM_BACKGROUND, annotsAtts);
            } else {
                handler.startElement("", ELEM_BACKGROUND, ELEM_BACKGROUND, nullAttrs);
            }
            if (this.view3DDict.getBG().hasColor()) {
                handler.startElement("", ELEM_COLOR, ELEM_COLOR, nullAttrs);
                String color = XFDFUtil.toStringFromDoubleArray(this.view3DDict.getBG().getColorAsArray());
                handler.characters(color.toCharArray(), 0, color.length());
                handler.endElement("", ELEM_COLOR, ELEM_COLOR);
            }
            handler.endElement("", ELEM_BACKGROUND, ELEM_BACKGROUND);
        }
    }

    private void addView3dModelRenderingElemnts(ContentHandler handler) throws SAXException, PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.view3DDict != null && this.view3DDict.hasRM()) {
            String color;
            String mode = this.view3DDict.getRM().getSubtype().asString();
            AttributesImpl annotsAtts = new AttributesImpl();
            annotsAtts.addAttribute("", "mode", "mode", "CDATA", mode.toLowerCase());
            handler.startElement("", ELEM_RENDERINGINFO, ELEM_RENDERINGINFO, annotsAtts);
            if (this.view3DDict.getRM().hasAuxiliarColor()) {
                handler.startElement("", ELEM_AUXCOLOR, ELEM_AUXCOLOR, nullAttrs);
                color = XFDFUtil.toStringFromDoubleArray(this.view3DDict.getRM().getAuxiliarColor());
                handler.characters(color.toCharArray(), 0, color.length());
                handler.endElement("", ELEM_AUXCOLOR, ELEM_AUXCOLOR);
            }
            if (this.view3DDict.getRM().hasOpacity()) {
                handler.startElement("", "opacity", "opacity", nullAttrs);
                String opacity = String.valueOf(this.view3DDict.getRM().getOpacity());
                handler.characters(opacity.toCharArray(), 0, opacity.length());
                handler.endElement("", "opacity", "opacity");
            }
            if (this.view3DDict.getRM().hasFaceColor()) {
                handler.startElement("", ELEM_FACECOLOR, ELEM_FACECOLOR, nullAttrs);
                color = XFDFUtil.toStringFromDoubleArray(this.view3DDict.getRM().getFaceColorAsArray());
                handler.characters(color.toCharArray(), 0, color.length());
                handler.endElement("", ELEM_FACECOLOR, ELEM_FACECOLOR);
            }
            if (this.view3DDict.getRM().hasCreaseValue()) {
                handler.startElement("", ELEM_CREASEVAL, ELEM_CREASEVAL, nullAttrs);
                color = String.valueOf(this.view3DDict.getRM().getCreaseValue());
                handler.characters(color.toCharArray(), 0, color.length());
                handler.endElement("", ELEM_CREASEVAL, ELEM_CREASEVAL);
            }
            handler.endElement("", ELEM_RENDERINGINFO, ELEM_RENDERINGINFO);
        }
    }

    private void addView3dLightElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.view3DDict != null && this.view3DDict.hasLS()) {
            String mode = this.view3DDict.getLS().getSubtype().asString();
            AttributesImpl annotsAtts = new AttributesImpl();
            annotsAtts.addAttribute("", ATTR_SCHEME, ATTR_SCHEME, "CDATA", mode.toLowerCase());
            handler.startElement("", ELEM_LIGHTING, ELEM_LIGHTING, annotsAtts);
            handler.endElement("", ELEM_LIGHTING, ELEM_LIGHTING);
        }
    }

    private void addView3dCrossSectionElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.view3DDict != null && this.view3DDict.hasSA()) {
            PDF3DSectionArray csList = this.view3DDict.getSA();
            for (PDF3DCrossSection crossSection : csList) {
                String alignment = "x";
                String pt1 = null;
                String pt2 = null;
                double mPlaneTilt1 = 0.0;
                double mPlaneTilt2 = 0.0;
                Object[] orientation = crossSection.getOrientation();
                if (orientation[0] == null) {
                    alignment = "x";
                    mPlaneTilt1 = (Double)orientation[1];
                    mPlaneTilt2 = (Double)orientation[2];
                    pt1 = ((Double)orientation[1]).toString();
                    pt2 = ((Double)orientation[2]).toString();
                } else if (orientation[1] == null) {
                    alignment = "y";
                    mPlaneTilt1 = (Double)orientation[0];
                    mPlaneTilt2 = (Double)orientation[2];
                    pt1 = ((Double)orientation[0]).toString();
                    pt2 = ((Double)orientation[2]).toString();
                } else if (orientation[2] == null) {
                    alignment = "z";
                    mPlaneTilt1 = (Double)orientation[0];
                    mPlaneTilt2 = (Double)orientation[1];
                    pt1 = ((Double)orientation[0]).toString();
                    pt2 = ((Double)orientation[1]).toString();
                }
                boolean mPlaneFlip = false;
                if (mPlaneTilt1 < 0.0) {
                    while (mPlaneTilt1 < -360.0) {
                        mPlaneTilt1 += 360.0;
                    }
                    if (mPlaneTilt1 < -180.0) {
                        mPlaneTilt1 += 180.0;
                        mPlaneFlip ^= true;
                    }
                } else {
                    while (mPlaneTilt1 > 360.0) {
                        mPlaneTilt1 -= 360.0;
                    }
                    if (mPlaneTilt1 > 180.0) {
                        mPlaneTilt1 -= 180.0;
                        mPlaneFlip ^= true;
                    }
                }
                if (mPlaneTilt2 < 0.0) {
                    while (mPlaneTilt2 < -360.0) {
                        mPlaneTilt2 += 360.0;
                    }
                    if (mPlaneTilt2 < -180.0) {
                        mPlaneTilt2 += 180.0;
                        mPlaneFlip ^= true;
                    }
                } else {
                    while (mPlaneTilt2 > 360.0) {
                        mPlaneTilt2 -= 360.0;
                    }
                    if (mPlaneTilt2 > 180.0) {
                        mPlaneTilt2 -= 180.0;
                        mPlaneFlip ^= true;
                    }
                }
                boolean showTrans = crossSection.getShowTransparent();
                AttributesImpl annotsAtts = new AttributesImpl();
                annotsAtts.addAttribute("", ATTR_SHOWTRANS, ATTR_SHOWTRANS, "CDATA", String.valueOf(showTrans));
                annotsAtts.addAttribute("", ATTR_PLANEFLIP, ATTR_PLANEFLIP, "CDATA", String.valueOf(mPlaneFlip));
                handler.startElement("", ELEM_CROSSSECTION, ELEM_CROSSSECTION, annotsAtts);
                if (crossSection.hasOrientation()) {
                    handler.startElement("", ELEM_PLANETILT1, ELEM_PLANETILT1, nullAttrs);
                    handler.characters(pt1.toCharArray(), 0, pt1.length());
                    handler.endElement("", ELEM_PLANETILT1, ELEM_PLANETILT1);
                    handler.startElement("", ELEM_PLANETILT2, ELEM_PLANETILT2, nullAttrs);
                    handler.characters(pt2.toCharArray(), 0, pt2.length());
                    handler.endElement("", ELEM_PLANETILT2, ELEM_PLANETILT2);
                }
                if (crossSection.hasCenter()) {
                    handler.startElement("", ELEM_CENTEROFROTATION, ELEM_CENTEROFROTATION, nullAttrs);
                    String co = XFDFUtil.toStringFromDoubleArray(crossSection.getCenter());
                    handler.characters(co.toCharArray(), 0, co.length());
                    handler.endElement("", ELEM_CENTEROFROTATION, ELEM_CENTEROFROTATION);
                }
                AttributesImpl annotsAtts1 = new AttributesImpl();
                annotsAtts1.addAttribute("", ATTR_AXIS, ATTR_AXIS, "CDATA", alignment);
                handler.startElement("", ELEM_ALIGNMENT, ELEM_ALIGNMENT, annotsAtts1);
                handler.endElement("", ELEM_ALIGNMENT, ELEM_ALIGNMENT);
                if (crossSection.getPlaneVisible()) {
                    handler.startElement("", ELEM_PLANEVISIBLE, ELEM_PLANEVISIBLE, nullAttrs);
                    if (crossSection.hasPlaneColor()) {
                        handler.startElement("", ELEM_PLANECOLOR, ELEM_PLANECOLOR, nullAttrs);
                        String planecolor = XFDFUtil.toStringFromDoubleArray(crossSection.getPlaneColor());
                        handler.characters(planecolor.toCharArray(), 0, planecolor.length());
                        handler.endElement("", ELEM_PLANECOLOR, ELEM_PLANECOLOR);
                    }
                    if (crossSection.hasPlaneOpacity()) {
                        handler.startElement("", ELEM_PLANEOPACITY, ELEM_PLANEOPACITY, nullAttrs);
                        String planeopacity = String.valueOf(crossSection.getPlaneOpacity());
                        handler.characters(planeopacity.toCharArray(), 0, planeopacity.length());
                        handler.endElement("", ELEM_PLANEOPACITY, ELEM_PLANEOPACITY);
                    }
                    handler.endElement("", ELEM_PLANEVISIBLE, ELEM_PLANEVISIBLE);
                }
                if (crossSection.hasIntersectionVisibility() && crossSection.getIntersectionVisibility()) {
                    handler.startElement("", ELEM_INTERVISIBLE, ELEM_INTERVISIBLE, nullAttrs);
                    if (crossSection.hasInteresectionColor()) {
                        handler.startElement("", ELEM_INTERCOLOR, ELEM_INTERCOLOR, nullAttrs);
                        String intersectioncolor = XFDFUtil.toStringFromDoubleArray(crossSection.getInteresectionColor());
                        handler.characters(intersectioncolor.toCharArray(), 0, intersectioncolor.length());
                        handler.endElement("", ELEM_INTERCOLOR, ELEM_INTERCOLOR);
                    }
                    handler.endElement("", ELEM_INTERVISIBLE, ELEM_INTERVISIBLE);
                }
                handler.endElement("", ELEM_CROSSSECTION, ELEM_CROSSSECTION);
            }
        }
    }

    private void addView3dSpecificNodeRelatedElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.view3DDict != null && this.view3DDict.hasNA()) {
            PDF3DNodeArray csList = this.view3DDict.getNA();
            for (PDF3DNode node : csList) {
                boolean visible = node.getVisibility();
                AttributesImpl annotsAtts = new AttributesImpl();
                annotsAtts.addAttribute("", ATTR_NODEVISIBLE, ATTR_NODEVISIBLE, "CDATA", String.valueOf(visible));
                handler.startElement("", ELEM_NODEPARA, ELEM_NODEPARA, annotsAtts);
                if (node.hasName()) {
                    handler.startElement("", ELEM_NODEID, ELEM_NODEID, nullAttrs);
                    String name = node.getName().asString();
                    handler.characters(name.toCharArray(), 0, name.length());
                    handler.endElement("", ELEM_NODEID, ELEM_NODEID);
                }
                if (node.hasMatrix()) {
                    handler.startElement("", ELEM_NODEXFORM, ELEM_NODEXFORM, nullAttrs);
                    String nodexform = XFDFUtil.toStringFromDoubleArray(node.getMatrix());
                    handler.characters(nodexform.toCharArray(), 0, nodexform.length());
                    handler.endElement("", ELEM_NODEXFORM, ELEM_NODEXFORM);
                }
                if (node.hasOpacity()) {
                    handler.startElement("", "opacity", "opacity", nullAttrs);
                    String opacity = String.valueOf(node.getOpacity());
                    handler.characters(opacity.toCharArray(), 0, opacity.length());
                    handler.endElement("", "opacity", "opacity");
                }
                if (node.hasRM()) {
                    String noderendermode = node.getRM().getSubtype().asString();
                    AttributesImpl annotsAtts1 = new AttributesImpl();
                    annotsAtts1.addAttribute("", "mode", "mode", "CDATA", noderendermode);
                    handler.startElement("", ELEM_NORENDERMODE, ELEM_NORENDERMODE, annotsAtts1);
                    handler.endElement("", ELEM_NORENDERMODE, ELEM_NORENDERMODE);
                }
                handler.endElement("", ELEM_NODEPARA, ELEM_NODEPARA);
                if (!this.view3DDict.getNAReturned()) continue;
                handler.startElement("", ELEM_SHOULDRESETNODES, ELEM_SHOULDRESETNODES, nullAttrs);
                handler.endElement("", ELEM_SHOULDRESETNODES, ELEM_SHOULDRESETNODES);
            }
        }
    }

    private void addRichMediaElemnts(ContentHandler handler) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IOException, PDFConfigurationException {
        if (this.exData3D.getSubtype().asString().equals("RichMedia")) {
            PDFRichMediaView rm3D = PDFRichMediaView.getInstance((CosObject)this.view3DDict.getCosObject());
            Integer instanceID = null;
            String data = null;
            CosArray cosArray = rm3D.getParams();
            if (cosArray != null) {
                for (int i = 0; i < cosArray.size(); ++i) {
                    CosObject cosObject = cosArray.get(i);
                    if (cosObject != null) {
                        PDFViewParams viewParams = PDFViewParams.getInstance((CosObject)cosObject);
                        PDFText dataAsText = viewParams.getDataAsTextString();
                        if (dataAsText != null) {
                            data = dataAsText.stringValue();
                        }
                        instanceID = viewParams.getUID();
                    }
                    AttributesImpl annotsAtts = new AttributesImpl();
                    annotsAtts.addAttribute("", ATTR_INSTANCEID, ATTR_INSTANCEID, "CDATA", instanceID.toString());
                    handler.startElement("", ELEM_STATEINFO, ELEM_STATEINFO, annotsAtts);
                    if (data != null) {
                        handler.characters(data.toCharArray(), 0, data.length());
                    }
                    handler.endElement("", ELEM_STATEINFO, ELEM_STATEINFO);
                }
            }
            if (rm3D.hasSnapshot()) {
                PDFStream imageStream = rm3D.getSnapshot();
                PDFXObjectImage snapshotImage = PDFXObjectImage.getInstance((CosObject)imageStream.getCosObject());
                handler.startElement("", ELEM_RMVSNAPSHOT, ELEM_RMVSNAPSHOT, nullAttrs);
                handler.startElement("", ELEM_RMVHEIGHT, ELEM_RMVHEIGHT, nullAttrs);
                handler.characters(String.valueOf(snapshotImage.getHeight()).toCharArray(), 0, String.valueOf(snapshotImage.getHeight()).length());
                handler.endElement("", ELEM_RMVHEIGHT, ELEM_RMVHEIGHT);
                handler.startElement("", ELEM_RMVWIDTH, ELEM_RMVWIDTH, nullAttrs);
                handler.characters(String.valueOf(snapshotImage.getWidth()).toCharArray(), 0, String.valueOf(snapshotImage.getWidth()).length());
                handler.endElement("", ELEM_RMVWIDTH, ELEM_RMVWIDTH);
                if (snapshotImage.hasImageStreamData()) {
                    int numberOfComponents = snapshotImage.getColorSpace().getNumberOfComponents();
                    StreamManager streamMgr = this.markup.getStreamManager();
                    InputByteStream dataStream = null;
                    try (ByteArrayOutputStream os = null;){
                        os = new ByteArrayOutputStream(snapshotImage.getHeight() * snapshotImage.getWidth() * numberOfComponents);
                        snapshotImage.getImageStreamData((OutputStream)os);
                        byte[] b = os.toByteArray();
                        char[] output = Base64Engine.encode((byte[])b, (int)0, (int)b.length);
                        dataStream = streamMgr.getInputByteStream(new String(output).getBytes());
                        Cos2XMLReader dataParser = new Cos2XMLReader((PDFCosDictionary)rm3D, ASName.create((String)"Snapshot"), this.currentXFDF);
                        ServicesUtil.transformToXML(dataParser, null, os);
                    }
                    this.currentXFDF.createStreamDataElement(handler, dataStream, nullAttrs, ELEM_RMVIMAGE, false);
                }
                handler.endElement("", ELEM_RMVSNAPSHOT, ELEM_RMVSNAPSHOT);
            }
        }
    }

    void createPDFExData(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (value != null && !fromStartEle) {
            if (this.pdfAnnot instanceof PDFAnnotation3D) {
                this.createPDFView3DElements(elemType, value.trim());
            } else if (this.pdfAnnot instanceof PDFAnnotationRichMedia) {
                this.createPDFViewRichMediaElements(elemType, value.trim());
            }
            if (this.newView != null) {
                String arrStr;
                if (elemType.equals(ELEM_CAMERAXFORM)) {
                    arrStr = value.trim();
                    double[] c2w = XFDFExData.stringtoArray(arrStr, " ");
                    this.newView.setCameraToWorld(c2w);
                    this.newView.setMatrixSource(ASName.create((String)"M"));
                } else if (elemType.equals(ELEM_U3DMATSRC)) {
                    if (value != null) {
                        this.newView.setMatrixSource(ASName.create((String)"U3D"));
                    }
                } else if (elemType.equals(ELEM_TARGETDISTANCE) && value != null) {
                    arrStr = value.trim();
                    this.newView.setCenterOfOrbit(new Double(arrStr).doubleValue());
                }
            }
            if (this.creatingProjection) {
                this.create3DProjectionPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingBackground) {
                this.create3DBackgroundPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingLightingInfo) {
                this.create3DLightPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingCrossSection) {
                this.create3DCrossSectionPDFPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingNodePara) {
                this.create3DSpecificNodeRelatedPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingRenderingInfo) {
                this.create3DModeRenderingPDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (this.creatingStateInfo) {
                this.createRichMediaStateInfo(elemType, value, elemAttrs);
            }
            if (this.creatingMeasure) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            }
            if (elemType.equals(ELEM_PROJECTION)) {
                this.creatingProjection = false;
            } else if (elemType.equals(ELEM_BACKGROUND)) {
                this.creatingBackground = false;
            } else if (elemType.equals(ELEM_CROSSSECTION)) {
                this.creatingCrossSection = false;
            } else if (elemType.equals(ELEM_NODEPARA)) {
                this.creatingNodePara = false;
            } else if (elemType.equals(ELEM_SHOULDRESETNODES)) {
                if (this.newView != null) {
                    this.newView.setNAReturned(true);
                }
            } else if (elemType.equals(ELEM_RENDERINGINFO)) {
                this.creatingRenderingInfo = false;
            } else if (elemType.equals(ELEM_LIGHTING)) {
                this.creatingLightingInfo = false;
            } else if (elemType.equals(ELEM_STATEINFO)) {
                this.creatingStateInfo = false;
            } else if (elemType.equals(ELEM_RMVSNAPSHOT)) {
                if (this.imageStream != null && this.newView != null && this.imageWidth > 0L && this.imageHeight > 0L) {
                    ((PDFRichMediaView)this.newView).setSnapshot(PDFStream.getInstance((CosObject)this.imageStream.getCosObject()));
                }
            } else if (elemType.equals(ELEM_RMVWIDTH)) {
                this.imageWidth = Long.parseLong(value.trim());
            } else if (elemType.equals(ELEM_RMVHEIGHT)) {
                this.imageHeight = Long.parseLong(value.trim());
            } else if (elemType.equals(ELEM_RMVIMAGE)) {
                this.imageStream = PDFXObjectImage.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument(), (int)((int)this.imageWidth), (int)((int)this.imageHeight), (PDFColorSpace)PDFColorSpaceDeviceRGB.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument()));
                this.imageStream.setBitsPerComponent(8);
                this.imageStream.setOutputFilter(ASName.k_FlateDecode);
                StreamManager streamManager = this.pdfAnnot.getPDFDocument().getStreamManager();
                byte[] bytes = Base64Engine.decode((String)value.trim());
                InputByteStream ibs = null;
                try {
                    ibs = streamManager.getInputByteStream(bytes);
                }
                catch (IOException e) {
                    throw new PDFIOException((Throwable)e);
                }
                this.imageStream.setImageStreamData(ibs);
            } else if (elemType.equals(ELEM_MEASURE)) {
                this.creatingMeasure = false;
            }
        }
        if (fromStartEle) {
            if (elemType.equals(ELEM_PROJECTION)) {
                this.creatingProjection = true;
                this.create3DProjectionPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_BACKGROUND)) {
                this.creatingBackground = true;
                this.create3DBackgroundPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_CROSSSECTION)) {
                this.creatingCrossSection = true;
                this.create3DCrossSectionPDFPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_ALIGNMENT)) {
                this.creatingCrossSection = true;
                this.create3DCrossSectionPDFPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_NODEPARA)) {
                this.creatingNodePara = true;
                this.create3DSpecificNodeRelatedPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_NORENDERMODE)) {
                this.create3DSpecificNodeRelatedPDFElements(elemType, value, elemAttrs, fromStartEle);
                this.creatingNodePara = true;
            } else if (elemType.equals(ELEM_RENDERINGINFO)) {
                this.creatingRenderingInfo = true;
                this.create3DModeRenderingPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_LIGHTING)) {
                this.creatingLightingInfo = true;
                this.create3DLightPDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_STATEINFO)) {
                this.creatingStateInfo = true;
                this.createRichMediaStateInfo(elemType, value, elemAttrs);
            } else if (elemType.equals(ELEM_MEASURE)) {
                this.creatingMeasure = true;
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_MEASURECOMMEND3DMARKUP)) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_MEASURERIMARKUP)) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_MEASUREAIMARKUP)) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_MEASURELIMARKUP)) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            } else if (elemType.equals(ELEM_MEASUREPIMARKUP)) {
                this.create3DMeasurePDFElements(elemType, value, elemAttrs, fromStartEle);
            }
        }
    }

    private void create3DMeasurePDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fromStartEle && this.xfdfMeasure == null) {
            this.xfdfMeasure = new XFDF3DMeasurement(this.currentXFDF, (PDFAnnotation3D)this.pdfAnnot, this.newView);
            this.xfdfMeasure.createPDF3DMeasurement(elemType, value, elemAttrs, fromStartEle);
        } else if (this.xfdfMeasure != null) {
            this.xfdfMeasure.createPDF3DMeasurement(elemType, value, elemAttrs, fromStartEle);
        }
    }

    private void createPDFView3DElements(String elemType, String newViewName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (elemType.equals(ELEM_EXTRENALNAME)) {
            PDF3DViewArray views = (PDF3DViewArray)this.getViewArray();
            ASString viewExternalName = null;
            for (PDF3DVDict view : views) {
                if (view == null || (viewExternalName = view.getExternalName()) == null || !viewExternalName.asString().equals(newViewName)) continue;
                this.setExistingView(true);
                this.newView = view;
                break;
            }
            if (this.newView == null) {
                try {
                    this.newView = PDF3DVDict.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASString)new ASString(newViewName));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
                if (this.internalname != null) {
                    try {
                        this.newView.setInternalName(new ASString(this.internalname));
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException((Throwable)e);
                    }
                }
                views.add((PDFCosObjectContainer)this.newView);
            }
        } else if (elemType.equals(ELEM_INTERNALNAME)) {
            if (this.newView != null) {
                try {
                    this.newView.setInternalName(new ASString(newViewName));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            } else {
                this.internalname = newViewName;
            }
        }
    }

    private void createPDFViewRichMediaElements(String elemType, String newViewName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (elemType.equals(ELEM_EXTRENALNAME)) {
            PDFRichMediaViewList views = (PDFRichMediaViewList)this.getViewArray();
            if (views == null) {
                return;
            }
            ASString viewExternalName = null;
            for (PDFRichMediaView view : views) {
                if (view == null || (viewExternalName = view.getExternalName()) == null || !viewExternalName.asString().equals(newViewName)) continue;
                this.setExistingView(true);
                this.newView = view;
                break;
            }
            if (this.newView == null) {
                try {
                    this.newView = PDFRichMediaView.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASString)new ASString(newViewName));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
                if (this.internalname != null) {
                    try {
                        this.newView.setInternalName(new ASString(this.internalname));
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException((Throwable)e);
                    }
                }
                views.add((PDFCosObjectContainer)((PDFRichMediaView)this.newView));
                ((PDFRichMediaContent)((PDFAnnotationRichMedia)this.pdfAnnot).getRichMediaContent()).setViews(views);
            }
        } else if (elemType.equals(ELEM_INTERNALNAME)) {
            if (this.newView != null) {
                try {
                    this.newView.setInternalName(new ASString(newViewName));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            } else {
                this.internalname = newViewName;
            }
        }
    }

    private void createRichMediaStateInfo(String elemType, String value, Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFRichMediaView rmView = (PDFRichMediaView)this.newView;
        if (this.viewParams == null) {
            this.viewParams = PDFViewParams.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument());
        }
        if (elemType.equals(ELEM_STATEINFO)) {
            int attrInd;
            if (elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_INSTANCEID, elemAttrs)) != -1) {
                try {
                    this.viewParams.setUID(Integer.parseInt(elemAttrs.getValue(attrInd)));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            CosArray viewParamsArray = null;
            if (value != null && value.length() > 0) {
                PDFText pdfText = PDFText.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument(), (String)value.trim());
                PDFFilterFlate filter = PDFFilterFlate.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument(), null);
                pdfText.setFilter(filter);
                this.viewParams.setDataAsTextString(pdfText);
                viewParamsArray = rmView.getParams();
                if (viewParamsArray == null) {
                    viewParamsArray = this.pdfAnnot.getPDFDocument().getCosDocument().createCosArray();
                }
                viewParamsArray.add(this.viewParams.getCosObject());
            }
            rmView.setParams(viewParamsArray);
        }
    }

    public void create3DBackgroundPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String colorString;
        int attrInd;
        if (this.bgView == null) {
            this.bgView = PDF3DVBGDict.newInstance((PDFDocument)this.markup.getPDFDocument());
        }
        if (fromStartEle && elemAttrs != null && elemType.equals(ELEM_BACKGROUND) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_ENTRBKGRD, elemAttrs)) != -1) {
            this.bgView.setEntireAnnot(Boolean.valueOf(elemAttrs.getValue(attrInd)).booleanValue());
        }
        if (!fromStartEle && value != null && (elemType.equals(ELEM_BACKGROUND) || elemType.equals(ELEM_COLOR)) && this.bgView != null && (colorString = value.trim()).length() != 0) {
            double[] color = XFDFExData.stringtoArray(colorString, " ");
            this.bgView.setColor(color);
        }
        if (this.bgView != null) {
            try {
                this.bgView.setSubtype(ASName.create((String)"SC"));
                if (this.newView != null) {
                    this.newView.setBG(this.bgView);
                }
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
    }

    public void create3DCrossSectionPDFPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (fromStartEle && elemAttrs != null) {
                int attrInd;
                if (elemType.equals(ELEM_CROSSSECTION) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_SHOWTRANS, elemAttrs)) != -1) {
                    String projType = elemAttrs.getValue(attrInd);
                    this.showTrans = Boolean.valueOf(projType);
                }
                if (elemType.equals(ELEM_ALIGNMENT) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_AXIS, elemAttrs)) != -1) {
                    this.axis = elemAttrs.getValue(attrInd);
                }
            }
            if (!fromStartEle && value != null) {
                if (elemType.equals(ELEM_PLANETILT1)) {
                    this.p1 = new Double(value.trim());
                } else if (elemType.equals(ELEM_PLANETILT2)) {
                    this.p2 = new Double(value.trim());
                } else if (elemType.equals(ELEM_CENTEROFROTATION)) {
                    this.cor = XFDFExData.stringtoArray(value.trim(), " ");
                } else if (elemType.equals(ELEM_PLANECOLOR)) {
                    this.planecolor = XFDFExData.stringtoArray(value.trim(), " ");
                } else if (elemType.equals(ELEM_INTERCOLOR)) {
                    this.intercolor = XFDFExData.stringtoArray(value.trim(), " ");
                }
                if (elemType.equals(ELEM_INTERVISIBLE)) {
                    this.intervisisble = true;
                }
                if (elemType.equals(ELEM_PLANEVISIBLE)) {
                    this.planevisible = true;
                } else if (elemType.equals(ELEM_PLANEOPACITY)) {
                    this.planeopacity = new Double(value.trim());
                }
            }
            if (!fromStartEle && elemType.endsWith(ELEM_CROSSSECTION)) {
                Object[] cosObject = new Object[3];
                CosNull cosNull = this.markup.getPDFDocument().getCosDocument().createCosNull();
                if (this.axis.equalsIgnoreCase("x")) {
                    cosObject[0] = cosNull;
                    cosObject[1] = this.p1;
                    cosObject[2] = this.p2;
                }
                if (this.axis.equalsIgnoreCase("y")) {
                    cosObject[1] = cosNull;
                    cosObject[0] = this.p1;
                    cosObject[2] = this.p2;
                }
                if (this.axis.equalsIgnoreCase("z")) {
                    cosObject[2] = cosNull;
                    cosObject[0] = this.p1;
                    cosObject[1] = this.p2;
                }
                this.cs3D = PDF3DCrossSection.newInstance((PDFDocument)this.markup.getPDFDocument(), (Object[])cosObject);
                if (this.planecolor != null) {
                    this.cs3D.setPlaneColor(this.planecolor);
                }
                if (this.intercolor != null) {
                    this.cs3D.setInteresectionColor(this.intercolor);
                }
                if (this.cor != null) {
                    this.cs3D.setCenter(this.cor);
                }
                this.cs3D.setIntersectionVisibility(this.intervisisble);
                this.cs3D.setPlaneVisible(this.planevisible);
                this.cs3D.setPlaneOpacity(this.planeopacity);
                this.cs3D.setgetShowTransparent(this.showTrans);
                PDF3DSectionArray na = PDF3DSectionArray.newInstance((PDFDocument)this.markup.getPDFDocument());
                na.add((PDFCosObjectContainer)this.cs3D);
                if (this.newView != null) {
                    this.newView.setSA(na);
                }
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void create3DLightPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int attrInd;
        if (fromStartEle && elemAttrs != null && elemType.equals(ELEM_LIGHTING) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_SCHEME, elemAttrs)) != -1) {
            ASName scheme = XFDFExData.createASNameFromXFDFAttribute(elemAttrs.getValue(attrInd));
            PDF3DLightingScheme ls = PDF3DLightingScheme.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASName)scheme);
            ls.setType(ASName.create((String)"3DLightingScheme"));
            if (this.newView != null) {
                this.newView.setLS(ls);
            }
        }
    }

    public void create3DModeRenderingPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            int attrInd;
            if (fromStartEle && elemAttrs != null && elemType.equals(ELEM_RENDERINGINFO) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute("mode", elemAttrs)) != -1) {
                String mode = elemAttrs.getValue(attrInd);
                this.rM = PDF3DRenderMode.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASName)XFDFExData.createASNameFromXFDFAttribute(mode));
            }
            if (!fromStartEle && value != null) {
                if (elemType.equals(ELEM_AUXCOLOR)) {
                    this.rM.setAuxiliarColor(XFDFExData.stringtoArray(value.trim(), " "));
                } else if (elemType.equals("opacity")) {
                    this.opacity = new Double(value.trim());
                    this.rM.setOpacity(this.opacity);
                } else if (elemType.equals(ELEM_FACECOLOR)) {
                    this.rM.setFaceColor(XFDFExData.stringtoArray(value.trim(), " "));
                } else if (elemType.equals(ELEM_CREASEVAL)) {
                    this.rM.setCreaseValue(new Double(value.trim()).doubleValue());
                }
            }
            this.rM.setType(ASName.create((String)"3DRenderMode"));
            if (this.newView != null) {
                this.newView.setRM(this.rM);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void create3DSpecificNodeRelatedPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        if (this.na == null) {
            this.na = PDF3DNodeArray.newInstance((PDFDocument)this.markup.getPDFDocument());
        }
        if (fromStartEle && elemAttrs != null) {
            int attrInd;
            if (elemType.equals(ELEM_NODEPARA)) {
                int attrInd2;
                if (elemAttrs != null && (attrInd2 = XFDFAnnotation.findAttribute(ATTR_NODEVISIBLE, elemAttrs)) != -1) {
                    String projType = elemAttrs.getValue(attrInd2);
                    this.visible = Boolean.valueOf(projType);
                }
            } else if (elemType.equals(ELEM_NORENDERMODE) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute("mode", elemAttrs)) != -1) {
                this.renderMode = elemAttrs.getValue(attrInd);
            }
        }
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_NODEID)) {
                this.name = value.trim();
            } else if (elemType.equals("opacity")) {
                this.opacity = new Double(value.trim());
            } else if (elemType.equals(ELEM_NODEXFORM)) {
                this.matrix = XFDFExData.stringtoArray(value.trim(), " ");
            }
        }
        if (!fromStartEle && elemType.endsWith(ELEM_NODEPARA) && this.name != null) {
            this.node = PDF3DNode.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASString)new ASString(this.name), (double)this.opacity, (boolean)this.visible, (double[])this.matrix);
            this.node.setType(ASName.create((String)"3DNode"));
            try {
                if (this.renderMode != null) {
                    this.node.setRM(PDF3DRenderMode.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASName)ASName.create((String)this.renderMode)));
                }
            }
            catch (PDFInvalidParameterException e) {
                // empty catch block
            }
            if (this.name.length() == 0) {
                this.node.removeValue(ASName.k_N);
            }
            this.na.add((PDFCosObjectContainer)this.node);
            if (this.newView != null) {
                this.newView.setNA(this.na);
            }
        }
    }

    public void create3DProjectionPDFElements(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (fromStartEle && elemAttrs != null) {
                if (elemType.equals(ELEM_PROJECTION)) {
                    int attrInd;
                    if (elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_PROJTYPE, elemAttrs)) != -1) {
                        String projType = elemAttrs.getValue(attrInd);
                        if (projType.equalsIgnoreCase("parallel")) {
                            this.pV = PDF3DVPDict.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASName)ASName.create((String)"O"));
                        } else if (projType.equalsIgnoreCase("perspective")) {
                            this.pV = PDF3DVPDict.newInstance((PDFDocument)this.markup.getPDFDocument(), (ASName)ASName.create((String)"P"));
                        }
                        if (this.newView != null) {
                            this.newView.setP(this.pV);
                        }
                    }
                } else if (elemType.equals(ELEM_CLIP)) {
                    // empty if block
                }
            } else if (!fromStartEle && value != null) {
                if (elemType.equals(ELEM_FIELDOFVIEW)) {
                    this.pV.setFieldOfView(new Double(value).doubleValue());
                } else if (elemType.equals(ELEM_VIEWPLANESIZE)) {
                    this.pV.setOrthographicScale(new Double(value).doubleValue());
                } else if (elemType.equals(ELEM_SCALETYPE)) {
                    value = value.trim();
                    if ((value = XFDFExData.upFirst(value)).charAt(0) == '/') {
                        value = value.substring(1);
                    }
                    if (this.pV.getSubtype().asString().equalsIgnoreCase("O")) {
                        this.pV.setOrthographicBinding(ASName.create((String)value));
                    } else {
                        this.pV.setPerspactiveScale(ASName.create((String)value.trim()));
                    }
                } else if (elemType.equals(ELEM_SCALEVALUE)) {
                    if (this.pV.getSubtype().asString().equalsIgnoreCase("O")) {
                        this.pV.setOrthographicBinding(ASName.create((String)value));
                    } else {
                        this.pV.setPerspactiveScale(ASName.create((String)value.trim()));
                    }
                }
                if (this.newView != null) {
                    this.newView.setP(this.pV);
                }
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public static String upFirst(String s) {
        return s.length() > 0 ? Character.toUpperCase(s.charAt(0)) + s.substring(1) : s;
    }

    private PDFCosArrayList getViewArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationRichMedia annotRM;
        PDFRichMediaContent rmContent;
        PDF3DDStream _3ddStream = null;
        PDF3DViewArray views = null;
        if (this.pdfAnnot instanceof PDFAnnotation3D) {
            PDFAnnotation3D annot3D = (PDFAnnotation3D)this.pdfAnnot;
            if (annot3D.get3DDictOrStreamAsStream() != null) {
                _3ddStream = (PDF3DDStream)annot3D.get3DDictOrStreamAsStream();
            } else if (annot3D.get3DDictOrStreamAsDict() != null) {
                PDF3DDDict _3dd = (PDF3DDDict)annot3D.get3DDictOrStreamAsDict();
                _3ddStream = _3dd.get3DD();
            }
            if (_3ddStream == null) {
                throw new PDFInvalidDocumentException("3DD key is missing in the 3D annotation dictionary. It is required.");
            }
            views = _3ddStream.getPresetViewArtwork();
            if (views == null) {
                views = PDF3DViewArray.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument());
                try {
                    _3ddStream.setPresetViewArtwork(views);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            return views;
        }
        if (this.pdfAnnot instanceof PDFAnnotationRichMedia && (rmContent = (PDFRichMediaContent)(annotRM = (PDFAnnotationRichMedia)this.pdfAnnot).getRichMediaContent()) != null) {
            PDFRichMediaViewList rmViewList = rmContent.getViews();
            return rmViewList != null ? rmViewList : PDFRichMediaViewList.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument());
        }
        return null;
    }

    void import3DMarkup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFExData exData = this.markup.getExData();
        if (this.newView != null) {
            if (this.newView.getSA() == null) {
                this.newView.setSA(PDF3DSectionArray.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument()));
            }
            if (this.newView.getNA() != null && !this.newView.getNAReturned()) {
                this.newView.setNAReturned(false);
            }
        } else if (exData != null && !exData.getSubtype().equals((Object)PDFExData.k_3DM)) {
            throw new PDFInvalidParameterException("external name of 3D view is null");
        }
        if (exData != null && exData.getSubtype() != null) {
            if (exData.getSubtype().equals((Object)PDFExData.k_Markup3D)) {
                ((PDF3DExDataMarkup3D)exData).set3DAAsDict((PDFAnnotation3D)this.pdfAnnot);
                ((PDF3DExDataMarkup3D)exData).set3DV(this.newView);
                if (this.md5Checksum != null) {
                    ((PDF3DExDataMarkup3D)exData).setMD5(new ASString(this.md5Checksum));
                }
            } else if (exData.getSubtype().equals((Object)PDFExData.k_RichMedia)) {
                ((PDFExDataRichMedia)exData).setRichMediaAnnot((PDFAnnotationRichMedia)this.pdfAnnot);
                ((PDFExDataRichMedia)exData).setRichMediaViewDict(this.newView);
                if (this.md5Checksum != null) {
                    ((PDFExDataRichMedia)exData).setMD5(new ASString(this.md5Checksum));
                }
            }
        }
    }

    public static double[] stringtoArray(String s, String sep) {
        String[] elementsStr = s.split("\\s+");
        double[] elements = new double[elementsStr.length];
        for (int i = 0; i < elementsStr.length; ++i) {
            elements[i] = new Double(elementsStr[i]);
        }
        return elements;
    }

    public void setExistingView(boolean isExistingView) {
        this.isExistingView = isExistingView;
    }

    private static ASName createASNameFromXFDFAttribute(String attribute) {
        if (attribute == null || attribute.length() == 0) {
            return null;
        }
        ASName name = ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.get(attribute);
        if (name == null) {
            StringBuilder builder = new StringBuilder(attribute);
            char c = builder.charAt(0);
            c = Character.toUpperCase(c);
            builder.setCharAt(0, c);
            name = ASName.create((String)builder.toString());
        }
        return name;
    }

    public boolean isExistingView() {
        return this.isExistingView;
    }

    public void setMeasurementcomment(String measurementcomment) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.measurementCommentName = measurementcomment;
        this.xfdfMeasure.setMeasurementcomment(this.getMeasurementcomment());
    }

    public String getMeasurementcomment() {
        return this.measurementCommentName;
    }

    static {
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("cad", ASName.create((String)"CAD"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("artwork", ASName.create((String)"Artwork"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("none", ASName.create((String)"None"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("white", ASName.create((String)"White"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("day", ASName.create((String)"Day"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("night", ASName.create((String)"Night"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("hard", ASName.create((String)"Hard"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("primary", ASName.create((String)"Primary"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("blue", ASName.create((String)"Blue"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("red", ASName.create((String)"Red"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("cube", ASName.create((String)"Cube"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("headlamp", ASName.create((String)"Headlamp"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("solid", ASName.create((String)"Solid"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("solidwireframe", ASName.create((String)"SolidWireframe"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("transparent", ASName.create((String)"Transparent"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("transparentwireframe", ASName.create((String)"TransparentWireframe"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("boundingbox", ASName.create((String)"BoundingBox"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("transparentboundingbox", ASName.create((String)"TransparentBoundingBox"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("transparentboundingboxoutline", ASName.create((String)"TransparentBoundingBoxOutline"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("wireframe", ASName.create((String)"Wireframe"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("shadedwireframe", ASName.create((String)"ShadedWireframe"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("hiddenwireframe", ASName.create((String)"HiddenWireframe"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("vertices", ASName.create((String)"Vertices"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("shadedvertices", ASName.create((String)"ShadedVertices"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("illustration", ASName.create((String)"Illustration"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("solidoutline", ASName.create((String)"SolidOutline"));
        ELEMENT_NAME_TO_ASNAME_EXCEPTION_MAP.put("shadedillustration", ASName.create((String)"ShadedIllustration"));
    }
}

