/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationUnderline
extends XFDFAnnotation {
    static final String ELEM_UNDERLINE = "underline";

    XFDFAnnotationUnderline(PDFAnnotationUnderline pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationUnderline(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        try {
            AttributesImpl annotsAtts = new AttributesImpl();
            this.addCommonXFDFAttributes(annotsAtts, pageNum);
            this.addMarkupXFDFAttributes(annotsAtts);
            this.addCoordXFDFAttribute(annotsAtts);
            handler.startElement("", ELEM_UNDERLINE, ELEM_UNDERLINE, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_UNDERLINE, ELEM_UNDERLINE);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationUnderline underlineAnnot = PDFAnnotationUnderline.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)underlineAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes((PDFAnnotation)underlineAnnot, elemAttrs);
            this.fillMarkupAttributes((PDFAnnotation)underlineAnnot, elemAttrs);
            this.fillCoordAttribute((PDFAnnotation)underlineAnnot, elemAttrs);
            int attrInd = XFDFAnnotationUnderline.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                underlineAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    underlineAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation((PDFAnnotation)underlineAnnot, gotPage)) {
                this.pdfAnnot = underlineAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

