/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationSound
extends XFDFAnnotation {
    static final String[] pdfEncodings = new String[]{"Raw", "Signed", "muLaw", "ALaw"};
    static final String[] xfdfEncodings = new String[]{"raw", "signed", "mulaw", "alaw"};
    static final String ATTR_ICON = "icon";
    static final String ATTR_BITS = "bits";
    static final String ATTR_RATE = "rate";
    static final String ATTR_CHANNELS = "channels";
    static final String ATTR_ENCODING = "encoding";
    static final String ELEM_SOUND = "sound";

    XFDFAnnotationSound(PDFAnnotationSound pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationSound(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        String encoding;
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        if (((PDFAnnotationSound)this.pdfAnnot).hasIconName()) {
            annotsAtts.addAttribute("", ATTR_ICON, ATTR_ICON, "CDATA", ((PDFAnnotationSound)this.pdfAnnot).getIconName());
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasBits()) {
            annotsAtts.addAttribute("", ATTR_BITS, ATTR_BITS, "CDATA", Integer.toString(((PDFAnnotationSound)this.pdfAnnot).getBits()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasChannels()) {
            annotsAtts.addAttribute("", ATTR_CHANNELS, ATTR_CHANNELS, "CDATA", Integer.toString(((PDFAnnotationSound)this.pdfAnnot).getChannels()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasRate()) {
            annotsAtts.addAttribute("", ATTR_RATE, ATTR_RATE, "CDATA", Double.toString(((PDFAnnotationSound)this.pdfAnnot).getRate()));
        }
        if (((PDFAnnotationSound)this.pdfAnnot).hasEncoding() && (encoding = PDFUtil.substituteStringFromArray((String)((PDFAnnotationSound)this.pdfAnnot).getEncoding(), (String[])pdfEncodings, (String[])xfdfEncodings)) != null) {
            annotsAtts.addAttribute("", ATTR_ENCODING, ATTR_ENCODING, "CDATA", encoding);
        }
        try {
            handler.startElement("", ELEM_SOUND, ELEM_SOUND, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.createXFDFStreamData(handler, ((PDFAnnotationSound)this.pdfAnnot).getDataStream());
            this.addAppearanceToXFDF(handler);
            handler.endElement("", ELEM_SOUND, ELEM_SOUND);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationSound soundAnnot = PDFAnnotationSound.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)soundAnnot, elemAttrs);
        if (gotPage >= 0) {
            this.fillMarkupAttributes((PDFAnnotation)soundAnnot, elemAttrs);
            try {
                String encoding;
                int attrInd = XFDFAnnotationSound.findAttribute(ATTR_BITS, elemAttrs);
                if (attrInd >= 0) {
                    soundAnnot.setBits(Integer.parseInt(elemAttrs.getValue(attrInd)));
                }
                if ((attrInd = XFDFAnnotationSound.findAttribute(ATTR_ICON, elemAttrs)) >= 0) {
                    soundAnnot.setIconName(elemAttrs.getValue(attrInd));
                }
                if ((attrInd = XFDFAnnotationSound.findAttribute(ATTR_CHANNELS, elemAttrs)) >= 0) {
                    soundAnnot.setChannels(Integer.parseInt(elemAttrs.getValue(attrInd)));
                }
                if ((attrInd = XFDFAnnotationSound.findAttribute(ATTR_RATE, elemAttrs)) >= 0) {
                    soundAnnot.setRate(Double.parseDouble(elemAttrs.getValue(attrInd)));
                }
                if ((attrInd = XFDFAnnotationSound.findAttribute(ATTR_ENCODING, elemAttrs)) >= 0 && (encoding = PDFUtil.substituteStringFromArray((String)elemAttrs.getValue(attrInd), (String[])xfdfEncodings, (String[])pdfEncodings)) != null) {
                    soundAnnot.setEncoding(encoding);
                }
                if (this.setAnnotation((PDFAnnotation)soundAnnot, gotPage)) {
                    this.pdfAnnot = soundAnnot;
                    this.curPage = gotPage;
                }
            }
            catch (NumberFormatException e) {
                throw new PDFInvalidParameterException("Unable to create XFDF Sound Annotation", (Throwable)e);
            }
        }
        return this.pdfAnnot;
    }
}

