/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationPopup
extends XFDFAnnotation {
    static final String ELEM_POPUP = "popup";
    static final String ATTR_OPEN = "open";

    XFDFAnnotationPopup(PDFAnnotationPopup pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationPopup(XFDFAnnotation parentAnnot) {
        this.pdfAnnot = parentAnnot.pdfAnnot;
        this.pdfDoc = this.pdfAnnot.getPDFDocument();
        this.curPage = parentAnnot.getCurPage();
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        if (((PDFAnnotationPopup)this.pdfAnnot).hasOpenState()) {
            annotsAtts.addAttribute("", ATTR_OPEN, ATTR_OPEN, "CDATA", ((PDFAnnotationPopup)this.pdfAnnot).getOpenState() ? "yes" : "no");
        }
        try {
            handler.startElement("", ELEM_POPUP, ELEM_POPUP, annotsAtts);
            handler.endElement("", ELEM_POPUP, ELEM_POPUP);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        PDFAnnotationPopup popupAnnot = null;
        if (this.pdfAnnot != null) {
            popupAnnot = PDFAnnotationPopup.newInstance((PDFDocument)this.pdfDoc);
            this.fillCommonAttributes((PDFAnnotation)popupAnnot, elemAttrs);
            int open = XFDFAnnotationPopup.findAttribute(ATTR_OPEN, elemAttrs);
            if (open != -1) {
                popupAnnot.setOpenState(elemAttrs.getValue(open));
            }
            popupAnnot.setParent(this.pdfAnnot);
            this.setAnnotation((PDFAnnotation)popupAnnot, this.curPage);
            ((PDFAnnotationMarkup)this.pdfAnnot).setPopup(popupAnnot);
        }
        return popupAnnot;
    }
}

