/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationPolyline
extends XFDFAnnotation {
    static final String ELEM_POLYLINE = "polyline";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";

    XFDFAnnotationPolyline(PDFAnnotationPolyline pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationPolyline(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFAnnotationLine.LineEnding[] lineCoords;
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, true);
        this.addInteriorColorXFDFAttribute(annotsAtts);
        if (((PDFAnnotationPolyline)this.pdfAnnot).hasLineEnds() && (lineCoords = ((PDFAnnotationPolyline)this.pdfAnnot).getLineEnds()).length == 2) {
            annotsAtts.addAttribute("", ATTR_HEAD, ATTR_HEAD, "CDATA", lineCoords[0].toString());
            annotsAtts.addAttribute("", ATTR_TAIL, ATTR_TAIL, "CDATA", lineCoords[1].toString());
        }
        try {
            handler.startElement("", ELEM_POLYLINE, ELEM_POLYLINE, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            this.createXFDFVertices(handler);
            handler.endElement("", ELEM_POLYLINE, ELEM_POLYLINE);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationPolyline polylineAnnot = PDFAnnotationPolyline.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)polylineAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillMarkupAttributes((PDFAnnotation)polylineAnnot, elemAttrs);
            this.fillBorderStyleAttributes((PDFAnnotation)polylineAnnot, elemAttrs);
            this.fillBorderEffectsAttributes((PDFAnnotation)polylineAnnot, elemAttrs);
            this.fillInteriorColorAttribute((PDFAnnotation)polylineAnnot, elemAttrs);
            this.fillIntentAttribute((PDFAnnotation)polylineAnnot, elemAttrs);
            int attrInd = XFDFAnnotationPolyline.findAttribute(ATTR_HEAD, elemAttrs);
            if (attrInd >= 0) {
                PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[2];
                lineEnds[0] = PDFAnnotationLine.LineEnding.getInstance((String)elemAttrs.getValue(attrInd));
                attrInd = XFDFAnnotationPolyline.findAttribute(ATTR_TAIL, elemAttrs);
                if (attrInd >= 0) {
                    lineEnds[1] = PDFAnnotationLine.LineEnding.getInstance((String)elemAttrs.getValue(attrInd));
                    polylineAnnot.setLineEnds(lineEnds);
                }
            }
            if ((attrInd = XFDFAnnotationPolyline.findAttribute("rotation", elemAttrs)) != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                polylineAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    this.setIsPageRotate(true);
                }
            }
            if (this.setAnnotation((PDFAnnotation)polylineAnnot, gotPage)) {
                this.pdfAnnot = polylineAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

