/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFActions;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFDestination;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import java.io.Serializable;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationLink
extends XFDFAnnotation {
    private boolean inDestination = false;
    private static final String[] pdfHighlight = new String[]{"N", "I", "O", "P"};
    private static final String[] xfdfHighlight = new String[]{"None", "Invert", "Outline", "Push"};
    static final String ATTR_HIGHLIGHT = "Highlight";
    static final String ATTR_COORDS = "coords";
    static final String ATTR_NAME = "Name";
    static final String ATTR_PAGE = "Page";
    static final String ATTR_LEFT = "Left";
    static final String ATTR_TOP = "Top";
    static final String ATTR_ZOOM = "Zoom";
    static final String ATTR_RIGHT = "Right";
    static final String ATTR_BOTTOM = "Bottom";
    static final String ATTR_ISMAP = "IsMap";
    static final String ATTR_NEW_WINDOW = "NewWindow";
    static final String ATTR_ORIG_NAME = "OriginalName";
    static final String ATTR_HCORNER = "HCornerRadius";
    static final String ATTR_VCORNER = "VCornerRadius";
    static final String ATTR_WIDTH = "Width";
    static final String ATTR_DASH_PATTERN = "DashPattern";
    static final String ELEM_LINK = "link";
    static final String ELEM_DESTS = "Dest";
    static final String ELEM_DEST_XYZ = "XYZ";
    static final String ELEM_DEST_Fit = "Fit";
    static final String ELEM_DEST_FitH = "FitH";
    static final String ELEM_DEST_FitV = "FitV";
    static final String ELEM_DEST_FitR = "FitR";
    static final String ELEM_DEST_FitB = "FitB";
    static final String ELEM_DEST_FitBH = "FitBH";
    static final String ELEM_DEST_FitBV = "FitBV";
    static final String ELEM_ACTIONS = "OnActivation";
    static final String ELEM_ACTION = "Action";
    static final String ELEM_URI = "URI";
    static final String ELEM_GOTO = "GoTo";
    static final String ELEM_GOTOR = "GoToR";
    static final String ELEM_NAMED = "Named";
    static final String ELEM_LAUNCH = "Launch";
    static final String ELEM_FILE = "File";
    static final String ELEM_BORDER = "BorderStyleAlt";

    public XFDFAnnotationLink(PDFAnnotationLink pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationLink(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    boolean createXFDFDestination(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (((PDFAnnotationLink)this.pdfAnnot).hasDestination()) {
            XFDFDestination pdfDest = XFDFDestination.getInstance(((PDFAnnotationLink)this.pdfAnnot).getDestination().getCosObject());
            return this.createXFDFDest(handler, pdfDest);
        }
        return false;
    }

    private void addNewWindow(XFDFActions action, AttributesImpl actionAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String newWindow = action.getNewWindow();
        if (newWindow != null) {
            actionAttrs.addAttribute("", ATTR_NEW_WINDOW, ATTR_NEW_WINDOW, "CDATA", newWindow);
        }
    }

    private void createDestinationElement(XFDFActions action, ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        XFDFDestination pdfDest = action.getDestination();
        if (pdfDest != null) {
            this.createXFDFDest(handler, pdfDest);
        }
    }

    private boolean createXFDFDest(ContentHandler handler, XFDFDestination pdfDest) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        String type = null;
        boolean gotIt = false;
        AttributesImpl destAttrs = new AttributesImpl();
        int destType = pdfDest.getType();
        if (destType == 1) {
            type = ELEM_NAMED;
            destAttrs.addAttribute("", ATTR_NAME, ATTR_NAME, "CDATA", pdfDest.getDestName());
            gotIt = true;
        } else if (destType != 0) {
            String page = pdfDest.getPage();
            if (page != null) {
                destAttrs.addAttribute("", ATTR_PAGE, ATTR_PAGE, "CDATA", page);
                gotIt = true;
            }
            if ((type = pdfDest.getTypeAsString()) == null) {
                return false;
            }
            switch (destType) {
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    String left = pdfDest.getLeftOrTop();
                    if (left == null) break;
                    destAttrs.addAttribute("", ATTR_LEFT, ATTR_LEFT, "CDATA", left);
                    gotIt = true;
                    break;
                }
                case 4: 
                case 8: {
                    String top = pdfDest.getLeftOrTop();
                    if (top == null) break;
                    destAttrs.addAttribute("", ATTR_TOP, ATTR_TOP, "CDATA", top);
                    gotIt = true;
                    break;
                }
            }
            if (destType == 2) {
                String zoom;
                String top = pdfDest.getTopOrBottom();
                if (top != null) {
                    destAttrs.addAttribute("", ATTR_TOP, ATTR_TOP, "CDATA", top);
                    gotIt = true;
                }
                if ((zoom = pdfDest.getZoomOrRight()) != null) {
                    destAttrs.addAttribute("", ATTR_ZOOM, ATTR_ZOOM, "CDATA", zoom);
                    gotIt = true;
                }
            }
            if (destType == 6) {
                String top;
                String right;
                String bottom = pdfDest.getTopOrBottom();
                if (bottom != null) {
                    destAttrs.addAttribute("", ATTR_BOTTOM, ATTR_BOTTOM, "CDATA", bottom);
                    gotIt = true;
                }
                if ((right = pdfDest.getZoomOrRight()) != null) {
                    destAttrs.addAttribute("", ATTR_RIGHT, ATTR_RIGHT, "CDATA", right);
                    gotIt = true;
                }
                if ((top = pdfDest.getTop()) != null) {
                    destAttrs.addAttribute("", ATTR_TOP, ATTR_TOP, "CDATA", top);
                    gotIt = true;
                }
            }
        }
        if (gotIt) {
            try {
                handler.startElement("", ELEM_DESTS, ELEM_DESTS, nullAttrs);
                handler.startElement("", type, type, destAttrs);
                handler.endElement("", type, type);
                handler.endElement("", ELEM_DESTS, ELEM_DESTS);
            }
            catch (SAXException e) {
                throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
            }
        }
        return gotIt;
    }

    boolean createXFDFFileName(ContentHandler handler, String fileName) throws PDFUnableToCompleteOperationException {
        if (fileName == null) {
            return false;
        }
        AttributesImpl fileAttrs = new AttributesImpl();
        try {
            fileAttrs.addAttribute("", ATTR_ORIG_NAME, ATTR_ORIG_NAME, "CDATA", fileName);
            handler.startElement("", ELEM_FILE, ELEM_FILE, fileAttrs);
            handler.endElement("", ELEM_FILE, ELEM_FILE);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
        return true;
    }

    boolean createXFDFAction(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        XFDFActions action;
        int actionType;
        PDFAction pdfAction = ((PDFAnnotationLink)this.pdfAnnot).getAction();
        if (pdfAction != null && (actionType = (action = XFDFActions.create(pdfAction.getCosObject())).getType()) != 0) {
            AttributesImpl actionAttrs = new AttributesImpl();
            try {
                handler.startElement("", ELEM_ACTIONS, ELEM_ACTIONS, nullAttrs);
                handler.startElement("", ELEM_ACTION, ELEM_ACTION, nullAttrs);
                switch (actionType) {
                    case 5: {
                        actionAttrs.addAttribute("", ATTR_NAME, ATTR_NAME, "CDATA", action.getURI());
                        if (action.hasIsMap()) {
                            actionAttrs.addAttribute("", ATTR_ISMAP, ATTR_ISMAP, "CDATA", Boolean.toString(action.getIsMap()));
                        }
                        handler.startElement("", ELEM_URI, ELEM_URI, actionAttrs);
                        handler.endElement("", ELEM_URI, ELEM_URI);
                        break;
                    }
                    case 1: {
                        this.addNewWindow(action, actionAttrs);
                        handler.startElement("", ELEM_LAUNCH, ELEM_LAUNCH, actionAttrs);
                        this.createXFDFFileName(handler, action.getFilename());
                        handler.endElement("", ELEM_LAUNCH, ELEM_LAUNCH);
                        break;
                    }
                    case 2: {
                        handler.startElement("", ELEM_GOTO, ELEM_GOTO, nullAttrs);
                        this.createDestinationElement(action, handler);
                        handler.endElement("", ELEM_GOTO, ELEM_GOTO);
                        break;
                    }
                    case 3: {
                        this.addNewWindow(action, actionAttrs);
                        handler.startElement("", ELEM_GOTOR, ELEM_GOTOR, actionAttrs);
                        this.createDestinationElement(action, handler);
                        this.createXFDFFileName(handler, action.getFilename());
                        handler.endElement("", ELEM_GOTOR, ELEM_GOTOR);
                        break;
                    }
                    case 4: {
                        if (!action.hasNamed()) break;
                        actionAttrs.addAttribute("", ATTR_NAME, ATTR_NAME, "CDATA", action.getNamed().asString(true));
                        handler.startElement("", ELEM_NAMED, ELEM_NAMED, actionAttrs);
                        handler.endElement("", ELEM_NAMED, ELEM_NAMED);
                    }
                }
                handler.endElement("", ELEM_ACTION, ELEM_ACTION);
                handler.endElement("", ELEM_ACTIONS, ELEM_ACTIONS);
            }
            catch (SAXException e) {
                throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    boolean createXFDFAltBorder(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFBorder pdfBorder;
        CosArray border;
        if (this.pdfAnnot.hasBorder() && (border = (pdfBorder = ((PDFAnnotationLink)this.pdfAnnot).getBorder()).getCosArray()).size() > 2) {
            AttributesImpl borderAtts = new AttributesImpl();
            borderAtts.addAttribute("", ATTR_HCORNER, ATTR_HCORNER, "CDATA", Double.toString(border.getDouble(0)));
            borderAtts.addAttribute("", ATTR_VCORNER, ATTR_VCORNER, "CDATA", Double.toString(border.getDouble(1)));
            borderAtts.addAttribute("", ATTR_WIDTH, ATTR_WIDTH, "CDATA", Double.toString(border.getDouble(2)));
            if (border.size() == 4) {
                borderAtts.addAttribute("", ATTR_DASH_PATTERN, ATTR_DASH_PATTERN, "CDATA", ServicesUtil.makeNumbersString(border.getCosArray(3).getArrayDouble(), ","));
            }
            try {
                handler.startElement("", ELEM_BORDER, ELEM_BORDER, borderAtts);
                handler.endElement("", ELEM_BORDER, ELEM_BORDER);
            }
            catch (SAXException e) {
                throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        String highlight;
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addBorderStyleXFDFAttributes(annotsAtts, false);
        if (((PDFAnnotationLink)this.pdfAnnot).hasHighlight() && (highlight = PDFUtil.substituteStringFromArray((String)((PDFAnnotationLink)this.pdfAnnot).getHighlight(), (String[])pdfHighlight, (String[])xfdfHighlight)) != null) {
            annotsAtts.addAttribute("", ATTR_HIGHLIGHT, ATTR_HIGHLIGHT, "CDATA", highlight);
        }
        if (((PDFAnnotationLink)this.pdfAnnot).hasQuadPoints()) {
            double[] quadPoints = ((PDFAnnotationLink)this.pdfAnnot).getQuadPoints();
            if (quadPoints.length % 8 == 0) {
                StringBuilder coordStr = new StringBuilder();
                for (int i = 0; i < quadPoints.length / 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        coordStr.append(quadPoints[i * 8 + j]);
                        if (j >= 7) continue;
                        coordStr.append(",");
                    }
                    if (i >= quadPoints.length / 8) continue;
                    coordStr.append(",");
                }
                annotsAtts.addAttribute("", ATTR_COORDS, ATTR_COORDS, "CDATA", coordStr.toString());
            } else {
                throw new PDFInvalidDocumentException("QuadPoints is not array of 8 x n numbers.");
            }
        }
        try {
            handler.startElement("", ELEM_LINK, ELEM_LINK, annotsAtts);
            this.createXFDFContent(handler);
            if (!this.createXFDFAction(handler)) {
                this.createXFDFDestination(handler);
            }
            this.createXFDFAltBorder(handler);
            handler.endElement("", ELEM_LINK, ELEM_LINK);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    static String getPDFHighlight(String xmlHighlight) {
        return PDFUtil.substituteStringFromArray((String)xmlHighlight, (String[])xfdfHighlight, (String[])pdfHighlight);
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationLink linkAnnot = PDFAnnotationLink.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)linkAnnot, elemAttrs);
        if (gotPage >= 0) {
            this.fillBorderStyleAttributes((PDFAnnotation)linkAnnot, elemAttrs);
            this.fillInteriorColorAttribute((PDFAnnotation)linkAnnot, elemAttrs);
            int attrInd = XFDFAnnotationLink.findAttribute(ATTR_HIGHLIGHT, elemAttrs);
            if (attrInd >= 0) {
                linkAnnot.setHighlight(XFDFAnnotationLink.getPDFHighlight(elemAttrs.getValue(attrInd)));
            }
            if ((attrInd = XFDFAnnotationLink.findAttribute(ATTR_COORDS, elemAttrs)) >= 0) {
                linkAnnot.setQuadPoints(elemAttrs.getValue(attrInd), ",");
            }
            if (this.setAnnotation((PDFAnnotation)linkAnnot, gotPage)) {
                this.pdfAnnot = linkAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }

    boolean createAction(String elemType, Attributes elemAttrs, PDFAnnotationLink linkAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (linkAnnot == null || !linkAnnot.hasAction()) {
            return false;
        }
        XFDFActions actions = XFDFActions.create(linkAnnot.getCosDictionary().get(ASName.k_A));
        actions.setType(elemType);
        switch (actions.getType()) {
            case 5: {
                int attrInd = XFDFAnnotationLink.findAttribute(ATTR_NAME, elemAttrs);
                if (attrInd == -1) {
                    return false;
                }
                actions.setURI(elemAttrs.getValue(attrInd));
                attrInd = XFDFAnnotationLink.findAttribute(ATTR_ISMAP, elemAttrs);
                if (attrInd == -1) break;
                actions.setIsMap(elemAttrs.getValue(attrInd));
                break;
            }
            case 1: {
                int attrInd = XFDFAnnotationLink.findAttribute(ATTR_NEW_WINDOW, elemAttrs);
                if (attrInd == -1) break;
                actions.setNewWindow(elemAttrs.getValue(attrInd));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int attrInd = XFDFAnnotationLink.findAttribute(ATTR_NEW_WINDOW, elemAttrs);
                if (attrInd == -1) break;
                actions.setNewWindow(elemAttrs.getValue(attrInd));
                break;
            }
            case 4: {
                int attrInd = XFDFAnnotationLink.findAttribute(ATTR_NAME, elemAttrs);
                if (attrInd == -1) break;
                actions.setNamed(elemAttrs.getValue(attrInd));
            }
        }
        return true;
    }

    private XFDFDestination createDest(String elemType, Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (elemType.equals(ELEM_NAMED)) {
            int attrInd = XFDFAnnotationLink.findAttribute(ATTR_NAME, elemAttrs);
            return attrInd != -1 ? XFDFDestination.newInstance(this.pdfAnnot.getPDFDocument(), XFDFUtil.toByteStringFromXFDFString(elemAttrs.getValue(attrInd))) : null;
        }
        XFDFDestination dest = XFDFDestination.newInstance(this.pdfAnnot.getPDFDocument());
        int attrInd = XFDFAnnotationLink.findAttribute(ATTR_PAGE, elemAttrs);
        if (attrInd == -1) {
            return null;
        }
        dest.setPage(elemAttrs.getValue(attrInd), false);
        dest.setType(elemType);
        attrInd = XFDFAnnotationLink.findAttribute(ATTR_LEFT, elemAttrs);
        if (attrInd != -1) {
            dest.setLeftOrTop(elemAttrs.getValue(attrInd));
        }
        if ((attrInd = XFDFAnnotationLink.findAttribute(ATTR_TOP, elemAttrs)) != -1) {
            switch (dest.getType()) {
                case 4: 
                case 8: {
                    dest.setLeftOrTop(elemAttrs.getValue(attrInd));
                    break;
                }
                case 2: {
                    dest.setTopOrBottom(elemAttrs.getValue(attrInd));
                    break;
                }
                case 6: {
                    dest.setTop(elemAttrs.getValue(attrInd));
                }
            }
        }
        if ((attrInd = XFDFAnnotationLink.findAttribute(ATTR_ZOOM, elemAttrs)) != -1) {
            dest.setZoomOrRight(elemAttrs.getValue(attrInd));
        }
        if ((attrInd = XFDFAnnotationLink.findAttribute(ATTR_BOTTOM, elemAttrs)) != -1) {
            dest.setTopOrBottom(elemAttrs.getValue(attrInd));
        }
        if ((attrInd = XFDFAnnotationLink.findAttribute(ATTR_RIGHT, elemAttrs)) != -1) {
            dest.setZoomOrRight(elemAttrs.getValue(attrInd));
        }
        dest.finalizeArray();
        return dest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean createDestination(String elemType, Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setInDestination(false);
        if (this.pdfAnnot == null || !(this.pdfAnnot instanceof PDFAnnotationLink)) {
            return false;
        }
        XFDFDestination pdfDest = this.createDest(elemType, elemAttrs);
        if (pdfDest == null) {
            return false;
        }
        PDFAnnotationLink linkAnnot = (PDFAnnotationLink)this.pdfAnnot;
        if (linkAnnot.hasAction()) {
            XFDFActions actions = XFDFActions.create(linkAnnot.getAction().getCosObject());
            if (actions.getType() != 2 && actions.getType() != 3) return false;
            actions.setDestination(pdfDest);
            return true;
        } else {
            PDFDestination dest = PDFDestination.getInstance((CosObject)pdfDest.getCosObject());
            linkAnnot.setDestination(dest);
        }
        return true;
    }

    boolean createAltBorder(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        ArrayList<Serializable> borderArray = new ArrayList<Serializable>(3);
        int attrInd = XFDFAnnotationLink.findAttribute(ATTR_HCORNER, elemAttrs);
        if (attrInd == -1) {
            return false;
        }
        borderArray.add(0, new Double(elemAttrs.getValue(attrInd)));
        attrInd = XFDFAnnotationLink.findAttribute(ATTR_VCORNER, elemAttrs);
        if (attrInd == -1) {
            return false;
        }
        borderArray.add(1, new Double(elemAttrs.getValue(attrInd)));
        attrInd = XFDFAnnotationLink.findAttribute(ATTR_WIDTH, elemAttrs);
        if (attrInd == -1) {
            return false;
        }
        borderArray.add(2, new Double(elemAttrs.getValue(attrInd)));
        attrInd = XFDFAnnotationLink.findAttribute(ATTR_DASH_PATTERN, elemAttrs);
        if (attrInd != -1) {
            borderArray.add(3, PDFUtil.parseNumbers((String)elemAttrs.getValue(attrInd), (String)","));
        }
        ((PDFAnnotationLink)this.pdfAnnot).setBorder(borderArray);
        return true;
    }

    protected void setInDestination(boolean inDest) {
        this.inDestination = inDest;
    }

    protected boolean getInDestination() {
        return this.inDestination;
    }
}

