/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationHighlight
extends XFDFAnnotation {
    static final String ELEM_HIGHLIGHT = "highlight";

    XFDFAnnotationHighlight(PDFAnnotationHighlight pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationHighlight(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addCoordXFDFAttribute(annotsAtts);
        try {
            handler.startElement("", ELEM_HIGHLIGHT, ELEM_HIGHLIGHT, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            this.createXFDFPopupElement(handler, pageNum);
            handler.endElement("", ELEM_HIGHLIGHT, ELEM_HIGHLIGHT);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationHighlight highlightAnnot = PDFAnnotationHighlight.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)highlightAnnot, elemAttrs);
        if (gotPage >= 0) {
            String rotation;
            this.fillCommonAttributes((PDFAnnotation)highlightAnnot, elemAttrs);
            this.fillMarkupAttributes((PDFAnnotation)highlightAnnot, elemAttrs);
            this.fillCoordAttribute((PDFAnnotation)highlightAnnot, elemAttrs);
            int attrInd = XFDFAnnotationHighlight.findAttribute("rotation", elemAttrs);
            if (attrInd != 0 && (rotation = elemAttrs.getValue(attrInd)) != null) {
                highlightAnnot.setRotation(Integer.parseInt(rotation));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    highlightAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if (this.setAnnotation((PDFAnnotation)highlightAnnot, gotPage)) {
                this.pdfAnnot = highlightAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

