/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationFreeText
extends XFDFAnnotation {
    static final String[] justStr = new String[]{"left", "centered", "right"};
    static final String ATTR_ROTATION = "rotation";
    static final String ATTR_JUSTIFICATION = "justification";
    static final String ELEM_FREETEXT = "freetext";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";

    XFDFAnnotationFreeText(PDFAnnotationFreeText pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationFreeText(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        int justInd;
        AttributesImpl annotsAtts = new AttributesImpl();
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        this.addBorderStyleXFDFAttributes(annotsAtts, false);
        this.addFringeXFDFAttribute(annotsAtts);
        if (this.pdfAnnot instanceof PDFAnnotationMovie) {
            if (((PDFAnnotationMovie)this.pdfAnnot).hasRotation()) {
                annotsAtts.addAttribute("", ATTR_ROTATION, ATTR_ROTATION, "CDATA", Integer.toString(((PDFAnnotationMovie)this.pdfAnnot).getRotation()));
            }
        } else if (this.pdfAnnot instanceof PDFAnnotationFreeText && ((PDFAnnotationFreeText)this.pdfAnnot).hasRotation()) {
            annotsAtts.addAttribute("", ATTR_ROTATION, ATTR_ROTATION, "CDATA", Integer.toString(((PDFAnnotationFreeText)this.pdfAnnot).getRotation()));
        }
        if (((PDFAnnotationFreeText)this.pdfAnnot).hasJustification() && (justInd = ((PDFAnnotationFreeText)this.pdfAnnot).getJustification()) >= 0 && justInd < justStr.length) {
            annotsAtts.addAttribute("", ATTR_JUSTIFICATION, ATTR_JUSTIFICATION, "CDATA", justStr[justInd]);
        }
        if (((PDFAnnotationFreeText)this.pdfAnnot).hasCallout()) {
            double[] callout = ((PDFAnnotationFreeText)this.pdfAnnot).getCalloutLine();
            if (callout.length > 0) {
                StringBuilder coordStr = new StringBuilder();
                for (int i = 0; i < callout.length; ++i) {
                    coordStr.append(callout[i]);
                    coordStr.append(",");
                }
                int l = coordStr.lastIndexOf(",");
                coordStr.deleteCharAt(l);
                annotsAtts.addAttribute("", "callout", "callout", "CDATA", coordStr.toString());
            }
            if (((PDFAnnotationFreeText)this.pdfAnnot).hasLineEnds()) {
                ASName lineCoords = ((PDFAnnotationFreeText)this.pdfAnnot).getLineEnds();
                annotsAtts.addAttribute("", ATTR_HEAD, ATTR_HEAD, "CDATA", lineCoords.asString(true));
            }
        }
        try {
            handler.startElement("", ELEM_FREETEXT, ELEM_FREETEXT, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFDefaultAppearance(handler);
            this.createXFDFDefaultStyle(handler);
            this.createXFDFExData3DMarkup(handler);
            this.addAppearanceToXFDF(handler);
            handler.endElement("", ELEM_FREETEXT, ELEM_FREETEXT);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationFreeText freeTextAnnot = PDFAnnotationFreeText.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)freeTextAnnot, elemAttrs);
        if (gotPage >= 0) {
            int attrInd;
            int numJust;
            int just;
            this.fillCommonAttributes((PDFAnnotation)freeTextAnnot, elemAttrs);
            this.fillMarkupAttributes((PDFAnnotation)freeTextAnnot, elemAttrs);
            this.fillBorderStyleAttributes((PDFAnnotation)freeTextAnnot, elemAttrs);
            this.fillCalloutAttributes((PDFAnnotation)freeTextAnnot, elemAttrs);
            this.fillFringeAttribute((PDFAnnotation)freeTextAnnot, elemAttrs);
            this.fillIntentAttribute((PDFAnnotation)freeTextAnnot, elemAttrs);
            int rot = XFDFAnnotationFreeText.findAttribute(ATTR_ROTATION, elemAttrs);
            if (rot != -1) {
                freeTextAnnot.setRotation(Integer.parseInt(elemAttrs.getValue(rot)));
                PDFAnnotationRotationEnum rotationType = this.getRotationType();
                if (rotationType == PDFAnnotationRotationEnum.OnlyPageRotation || rotationType == PDFAnnotationRotationEnum.WithPageRotation) {
                    freeTextAnnot.applyRotation(this.pdfDoc.requirePages().getPage(gotPage).getCropBox(), this.pdfDoc.requirePages().getPage(gotPage).getRotation().getValue());
                }
            }
            if ((just = XFDFAnnotationFreeText.findAttribute(ATTR_JUSTIFICATION, elemAttrs)) != -1 && (numJust = PDFUtil.findStringInArray((String)elemAttrs.getValue(just), (String[])justStr)) >= 0) {
                freeTextAnnot.setJustification(numJust);
            }
            if ((attrInd = XFDFAnnotationFreeText.findAttribute(ATTR_HEAD, elemAttrs)) >= 0) {
                PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[]{PDFAnnotationLine.LineEnding.getInstance((String)elemAttrs.getValue(attrInd))};
                freeTextAnnot.setLineEnds(lineEnds);
            }
            if (this.setAnnotation((PDFAnnotation)freeTextAnnot, gotPage)) {
                this.pdfAnnot = freeTextAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

