/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDFAnnotationFileAttachment
extends XFDFAnnotation {
    static final String ATTR_ICON = "icon";
    static final String ATTR_FILE = "file";
    static final String ATTR_MIMETYPE = "mimetype";
    static final String ATTR_MODIFICATION = "modification";
    static final String ATTR_CREATION = "creation";
    static final String ATTR_CHECKSUM = "checksum";
    static final String ATTR_SIZE = "size";
    static final String ELEM_FILEATTACHMENT = "fileattachment";

    XFDFAnnotationFileAttachment(PDFAnnotationFileAttachment pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotationFileAttachment(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    @Override
    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        AttributesImpl annotsAtts = new AttributesImpl();
        PDFEmbeddedFile embeddedFile = null;
        PDFEmbeddedFileInfo fileInfo = null;
        this.addCommonXFDFAttributes(annotsAtts, pageNum);
        this.addMarkupXFDFAttributes(annotsAtts);
        if (((PDFAnnotationFileAttachment)this.pdfAnnot).hasIconName()) {
            annotsAtts.addAttribute("", ATTR_ICON, ATTR_ICON, "CDATA", ((PDFAnnotationFileAttachment)this.pdfAnnot).getIconName());
        }
        if (((PDFAnnotationFileAttachment)this.pdfAnnot).hasFileSpecification()) {
            PDFFileSpecification file = ((PDFAnnotationFileAttachment)this.pdfAnnot).requireFileSpecification();
            if (file.hasFilename()) {
                annotsAtts.addAttribute("", ATTR_FILE, ATTR_FILE, "CDATA", XFDFUtil.toXFDFStringFromByteString(file.getFilename().getBytes()));
            }
            if (file.hasEmbeddedFile()) {
                embeddedFile = file.getEmbeddedFile();
                if (embeddedFile.hasMIMEType()) {
                    annotsAtts.addAttribute("", ATTR_MIMETYPE, ATTR_MIMETYPE, "CDATA", embeddedFile.getMIMEType());
                }
                if ((fileInfo = embeddedFile.getFileInfo()) != null) {
                    if (fileInfo.hasModificationDate()) {
                        annotsAtts.addAttribute("", ATTR_MODIFICATION, ATTR_MODIFICATION, "CDATA", fileInfo.getModificationDate().asString());
                    }
                    if (fileInfo.hasCreationDate()) {
                        annotsAtts.addAttribute("", ATTR_CREATION, ATTR_CREATION, "CDATA", fileInfo.getCreationDate().asString());
                    }
                    if (fileInfo.hasChecksum()) {
                        annotsAtts.addAttribute("", ATTR_CHECKSUM, ATTR_CHECKSUM, "CDATA", ServicesUtil.toHexString(fileInfo.getCheckSum().getBytes()));
                    }
                    if (fileInfo.hasSize()) {
                        annotsAtts.addAttribute("", ATTR_SIZE, ATTR_SIZE, "CDATA", Integer.toString(fileInfo.getSize()));
                    }
                }
            }
        }
        try {
            handler.startElement("", ELEM_FILEATTACHMENT, ELEM_FILEATTACHMENT, annotsAtts);
            if (!this.createXFDFRichContent(handler)) {
                this.createXFDFContent(handler);
            }
            this.createXFDFExData3DMarkup(handler);
            if (embeddedFile != null) {
                this.createXFDFStreamData(handler, embeddedFile.getFileStream());
            }
            handler.endElement("", ELEM_FILEATTACHMENT, ELEM_FILEATTACHMENT);
            handler.characters(END_ELEM, 0, 1);
        }
        catch (SAXException e) {
            throw new PDFUnableToCompleteOperationException("Unable to create XFDF element", (Throwable)e);
        }
    }

    @Override
    PDFAnnotation createPDFAnnotation(Attributes elemAttrs) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.pdfDoc == null) {
            return null;
        }
        int gotPage = -1;
        PDFAnnotationFileAttachment fileAttachmentAnnot = PDFAnnotationFileAttachment.newInstance((PDFDocument)this.pdfDoc);
        this.pdfAnnot = null;
        gotPage = this.fillCommonAttributes((PDFAnnotation)fileAttachmentAnnot, elemAttrs);
        if (gotPage >= 0) {
            PDFEmbeddedFileInfo fileInfo;
            this.fillMarkupAttributes((PDFAnnotation)fileAttachmentAnnot, elemAttrs);
            int attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_ICON, elemAttrs);
            if (attrInd >= 0) {
                fileAttachmentAnnot.setIconName(elemAttrs.getValue(attrInd));
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_FILE, elemAttrs)) >= 0) {
                PDFFileSpecification fileSpec = fileAttachmentAnnot.procureFileSpecification();
                fileSpec.setFileName(XFDFUtil.toByteStringFromXFDFString(elemAttrs.getValue(attrInd)));
                fileAttachmentAnnot.setFileSpecification(fileSpec);
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_MIMETYPE, elemAttrs)) >= 0) {
                PDFEmbeddedFile embeddedFile = fileAttachmentAnnot.procureFileSpecification().procureEmbeddedFile();
                embeddedFile.setMIMEType(ASName.create((String)elemAttrs.getValue(attrInd)));
                fileAttachmentAnnot.setEmbeddedFile(embeddedFile);
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_MODIFICATION, elemAttrs)) >= 0) {
                fileInfo = fileAttachmentAnnot.procureFileInfo();
                try {
                    fileInfo.setModificationDate(new ASDate(elemAttrs.getValue(attrInd)));
                }
                catch (PDFParseException e) {
                    throw new PDFInvalidParameterException("Element attributes are invalid.", (Throwable)e);
                }
                fileAttachmentAnnot.setFileInfo(fileInfo);
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_CREATION, elemAttrs)) >= 0) {
                fileInfo = fileAttachmentAnnot.procureFileInfo();
                try {
                    fileInfo.setCreationDate(new ASDate(elemAttrs.getValue(attrInd)));
                }
                catch (PDFParseException e) {
                    throw new PDFInvalidParameterException("Element attributes are invalid.", (Throwable)e);
                }
                fileAttachmentAnnot.setFileInfo(fileInfo);
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_CHECKSUM, elemAttrs)) >= 0) {
                fileInfo = fileAttachmentAnnot.procureFileInfo();
                fileInfo.setCheckSum(ServicesUtil.fromHexString(elemAttrs.getValue(attrInd)));
                fileAttachmentAnnot.setFileInfo(fileInfo);
            }
            if ((attrInd = XFDFAnnotationFileAttachment.findAttribute(ATTR_SIZE, elemAttrs)) >= 0) {
                fileInfo = fileAttachmentAnnot.procureFileInfo();
                fileInfo.setSize(elemAttrs.getValue(attrInd));
                fileAttachmentAnnot.setFileInfo(fileInfo);
            }
            if (this.setAnnotation((PDFAnnotation)fileAttachmentAnnot, gotPage)) {
                this.pdfAnnot = fileAttachmentAnnot;
                this.curPage = gotPage;
            }
        }
        return this.pdfAnnot;
    }
}

