/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomEncodeFilter;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationTextMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithFringe;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIntent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithQuadPoints;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFVertices;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextBodyAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.Cos2XMLReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF2CosWriter;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFActions;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationInk;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationLine;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationLink;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSound;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationText;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFExData;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFObject;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import com.adobe.internal.pdftoolkit.xml.CopyBlobProcessElement;
import com.adobe.internal.pdftoolkit.xml.SkipXMLPIOutputStream;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XFDFAnnotation
extends XFDFObject {
    private ArrayList annot3D;
    static final int[] flagsBits = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    static final String[] flagsText = new String[]{"invisible", "hidden", "print", "nozoom", "norotate", "noview", "readonly", "locked", "togglenoview"};
    static final String[] acroBorderStyle = new String[]{"S", "D", "B", "I", "U"};
    static final String[] xfdfBorderStyle = new String[]{"solid", "dash", "bevelled", "inset", "underline"};
    static final String flagsSeparator = ",";
    static final AttributesImpl nullAttrs = new AttributesImpl();
    protected PDFAnnotation pdfAnnot = null;
    protected PDFDocument pdfDoc = null;
    protected int curPage = -1;
    private static final int L4K = 4096;
    private static final int STREAMBUFLEN = 512;
    static final String ATTR_PAGE = "page";
    static final String ATTR_COLOR = "color";
    static final String ATTR_MOD_DATE = "date";
    static final String ATTR_TITLE = "title";
    static final String ATTR_NAME = "name";
    static final String ATTR_RECT = "rect";
    static final String ATTR_FLAGS = "flags";
    static final String ATTR_CREATE_DATE = "creationdate";
    static final String ATTR_OPACITY = "opacity";
    static final String ATTR_SUBJ = "subject";
    static final String ATTR_SUBTYPE = "subtype";
    static final String ATTR_WIDTH = "width";
    static final String ATTR_DASHES = "dashes";
    static final String ATTR_STYLE = "style";
    static final String ATTR_INTENSITY = "intensity";
    static final String ATTR_INTERIOR_COLOR = "interior-color";
    static final String ATTR_CAPTION = "caption";
    static final String ATTR_INTENT = "IT";
    static final String ATTR_FRINGE = "fringe";
    static final String ATTR_QUADPOINTS = "coords";
    static final String ATTR_LENGTH = "length";
    static final String ATTR_FILTER = "filter";
    static final String ATTR_RAW = "raw";
    static final String ATTR_FILTERED = "filtered";
    static final String ATTR_ASCII = "ascii";
    static final String ATTR_HEX = "hex";
    static final String ATTR_MODE = "mode";
    static final String ATTR_ENCODING = "encoding";
    static final String ATTR_C = "cloudy";
    static final String ATTR_S = "solid";
    static final String ATTR_BODY_XFA = "xmlns:xfa";
    static final String ATTR_BODY_XHTML = "xmlns";
    static final String STRING_TYPE = "string";
    static final String ELEM_CONTENTS = "contents";
    static final String ELEM_DEFAULT_STYLE = "defaultstyle";
    static final String ELEM_DEFAULT_APPEARANCE = "defaultappearance";
    static final String ELEM_RICH_CONTENTS = "contents-richtext";
    static final String ELEM_EXDATA = "ex_data";
    static final String ELEM_DATA = "data";
    static final String ELEM_CALLOUT = "callout";
    static final String ATTR_HEAD = "head";
    static final String ATTR_TAIL = "tail";
    static final char[] END_ELEM = "\n".toCharArray();
    static final String ATTR_ROTATION = "rotation";
    private boolean isPageRotate;
    static final String ELEM_APPEARANCE = "appearance";
    static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String DEFAULT_STYLE = "font: Helvetica,sans-serif 12.0pt; text-align:left; color:#000000 ";
    static final String DEFAULT_APPEARACE = "/Helv 12 Tf 0 g";

    XFDFAnnotation() {
    }

    XFDFAnnotation(PDFAnnotation pdfAnnotation) {
        this.pdfAnnot = pdfAnnotation;
        this.pdfDoc = null;
    }

    XFDFAnnotation(PDFDocument pdfDocument) {
        this.pdfDoc = pdfDocument;
        this.pdfAnnot = null;
    }

    abstract PDFAnnotation createPDFAnnotation(Attributes var1) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException;

    public ArrayList getAnnot3DList() {
        return this.annot3D;
    }

    public void setAnnot3DList(List annots3D) {
        this.annot3D = annots3D instanceof ArrayList ? (ArrayList)annots3D : new ArrayList(annots3D);
    }

    static XFDFAnnotation createXFDFAnnotation(PDFAnnotation annot) {
        if (annot instanceof PDFAnnotationCircle) {
            return new XFDFAnnotationCircle((PDFAnnotationCircle)annot);
        }
        if (annot instanceof PDFAnnotationCaret) {
            return new XFDFAnnotationCaret((PDFAnnotationCaret)annot);
        }
        if (annot instanceof PDFAnnotationFileAttachment) {
            return new XFDFAnnotationFileAttachment((PDFAnnotationFileAttachment)annot);
        }
        if (annot instanceof PDFAnnotationFreeText) {
            return new XFDFAnnotationFreeText((PDFAnnotationFreeText)annot);
        }
        if (annot instanceof PDFAnnotationHighlight) {
            return new XFDFAnnotationHighlight((PDFAnnotationHighlight)annot);
        }
        if (annot instanceof PDFAnnotationInk) {
            return new XFDFAnnotationInk((PDFAnnotationInk)annot);
        }
        if (annot instanceof PDFAnnotationLine) {
            return new XFDFAnnotationLine((PDFAnnotationLine)annot);
        }
        if (annot instanceof PDFAnnotationLink) {
            return new XFDFAnnotationLink((PDFAnnotationLink)annot);
        }
        if (annot instanceof PDFAnnotationPolygon) {
            return new XFDFAnnotationPolygon((PDFAnnotationPolygon)annot);
        }
        if (annot instanceof PDFAnnotationProjection) {
            return new XFDFAnnotationProjection((PDFAnnotationProjection)annot);
        }
        if (annot instanceof PDFAnnotationPolyline) {
            return new XFDFAnnotationPolyline((PDFAnnotationPolyline)annot);
        }
        if (annot instanceof PDFAnnotationSound) {
            return new XFDFAnnotationSound((PDFAnnotationSound)annot);
        }
        if (annot instanceof PDFAnnotationSquare) {
            return new XFDFAnnotationSquare((PDFAnnotationSquare)annot);
        }
        if (annot instanceof PDFAnnotationSquiggly) {
            return new XFDFAnnotationSquiggly((PDFAnnotationSquiggly)annot);
        }
        if (annot instanceof PDFAnnotationStamp) {
            return new XFDFAnnotationStamp((PDFAnnotationStamp)annot);
        }
        if (annot instanceof PDFAnnotationStrikeOut) {
            return new XFDFAnnotationStrikeOut((PDFAnnotationStrikeOut)annot);
        }
        if (annot instanceof PDFAnnotationText) {
            return new XFDFAnnotationText((PDFAnnotationText)annot);
        }
        if (annot instanceof PDFAnnotationUnderline) {
            return new XFDFAnnotationUnderline((PDFAnnotationUnderline)annot);
        }
        if (annot instanceof PDFAnnotationRedaction) {
            return new XFDFAnnotationRedaction((PDFAnnotationRedaction)annot);
        }
        return null;
    }

    protected String getInReplyTo(Attributes elemAttrs) {
        return null;
    }

    protected boolean setAnnotation(PDFAnnotation annot, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage page = this.pdfDoc.requirePages().getPage(pageNum);
        if (page != null) {
            page.addAnnotation(annot);
            return true;
        }
        return false;
    }

    int getCurPage() {
        return this.curPage;
    }

    static double[] getRectangle(String rectStr) {
        String oneCoord;
        double[] rect = new double[4];
        StringBuilder coordBuf = new StringBuilder(rectStr);
        int coordInd = 0;
        while ((oneCoord = XFDFAnnotation.getCommaToken(coordBuf)) != null) {
            if (coordInd > 3) {
                return null;
            }
            rect[coordInd] = Double.parseDouble(oneCoord);
            ++coordInd;
        }
        if (coordInd != 4) {
            return null;
        }
        return rect;
    }

    private String encodeStream(byte[] streamData, boolean rawMode) {
        if (rawMode) {
            return ServicesUtil.toHexString(streamData);
        }
        return PDFUtil.toString((byte[])streamData);
    }

    private static String getCommaToken(StringBuilder inStr) {
        int end = inStr.indexOf(flagsSeparator);
        if (end == -1 && (end = inStr.length()) == 0) {
            return null;
        }
        String outStr = XFDFAnnotation.skipSpaces(inStr.substring(0, end));
        inStr.delete(0, end + 1);
        return outStr;
    }

    private static String skipSpaces(String inStr) {
        int start = 0;
        while (inStr.charAt(start) == ' ') {
            ++start;
        }
        return inStr.substring(start);
    }

    static int makeFlags(String flagsStr) {
        String oneFlag;
        StringBuilder flagsBuf = new StringBuilder(flagsStr);
        int flags = 0;
        int flagsIndex = 0;
        while ((oneFlag = XFDFAnnotation.getCommaToken(flagsBuf)) != null) {
            flagsIndex = PDFUtil.findStringInArray((String)oneFlag, (String[])flagsText);
            if (flagsIndex < 0) continue;
            flags |= flagsBits[flagsIndex];
        }
        return flags;
    }

    static String getAcroBorderStyle(String xfdfStyle) {
        if (xfdfStyle == null) {
            return null;
        }
        String acroStyle = null;
        StringTokenizer styles = new StringTokenizer(xfdfStyle, flagsSeparator);
        while (styles.hasMoreTokens() && (acroStyle = PDFUtil.substituteStringFromArray((String)styles.nextToken(), (String[])xfdfBorderStyle, (String[])acroBorderStyle)) == null) {
        }
        return acroStyle;
    }

    static ASName getAcroEffectsStyle(String xfdfStyle) {
        ASName styleName = null;
        if (xfdfStyle == null) {
            return null;
        }
        StringTokenizer styles = new StringTokenizer(xfdfStyle, flagsSeparator);
        while (styles.hasMoreTokens()) {
            if (!styles.nextToken().equals(ATTR_C)) continue;
            styleName = ASName.k_C;
            break;
        }
        return styleName;
    }

    XFDFAnnotationPopup getXFDFAnnotationPopup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationPopup popupAnnot = ((PDFAnnotationMarkup)this.pdfAnnot).getPopup();
        if (popupAnnot == null) {
            return null;
        }
        return new XFDFAnnotationPopup(popupAnnot);
    }

    String getBorderEffectsStyle(PDFBorderEffects effects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName style = effects.getStyle();
        if (style == ASName.k_C) {
            return ATTR_C;
        }
        return null;
    }

    String getColorsForXFDF(ASName colorKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.pdfAnnot.dictionaryContains(colorKey)) {
            return null;
        }
        CosArray annotColor = this.pdfAnnot.getDictionaryArrayValue(colorKey);
        int numEntries = annotColor.size();
        if (numEntries != 1 && numEntries != 3 && numEntries != 4) {
            return null;
        }
        StringBuilder xfdfColor = new StringBuilder(7);
        xfdfColor.append('#');
        for (int colorIndex = 0; colorIndex < numEntries; ++colorIndex) {
            BigDecimal bigColor = new BigDecimal(annotColor.getDouble(colorIndex) * 255.0);
            int intColor = bigColor.setScale(0, 4).intValue();
            String hexColor = Integer.toHexString(intColor).toUpperCase();
            if (hexColor.length() == 1) {
                xfdfColor.append('0');
            }
            xfdfColor.append(hexColor);
        }
        return xfdfColor.toString();
    }

    void transformToXFDF(ContentHandler handler, int pageNum) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
    }

    void addCommonXFDFAttributes(AttributesImpl attributes, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String color;
        if (pageNum >= 0) {
            attributes.addAttribute("", ATTR_PAGE, ATTR_PAGE, "CDATA", Integer.toString(pageNum));
        }
        if ((color = this.getColorsForXFDF(ASName.k_C)) != null) {
            attributes.addAttribute("", ATTR_COLOR, ATTR_COLOR, "CDATA", color);
        }
        if (this.pdfAnnot.hasModificationDate()) {
            attributes.addAttribute("", ATTR_MOD_DATE, ATTR_MOD_DATE, "CDATA", this.pdfAnnot.getModificationDate().asString());
        }
        String annotTitle = null;
        String annotName = null;
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            annotTitle = ((PDFAnnotationMarkup)this.pdfAnnot).getTitle();
            if (annotTitle != null) {
                attributes.addAttribute("", ATTR_TITLE, ATTR_TITLE, "CDATA", annotTitle);
            }
            if ((annotName = ((PDFAnnotationMarkup)this.pdfAnnot).getName()) != null) {
                attributes.addAttribute("", ATTR_NAME, ATTR_NAME, "CDATA", annotName);
            }
        }
        if (this.pdfAnnot.hasRect()) {
            PDFRectangle rect = this.pdfAnnot.getRect();
            attributes.addAttribute("", ATTR_RECT, ATTR_RECT, "CDATA", Double.toString(rect.llx()) + ", " + Double.toString(rect.lly()) + ", " + Double.toString(rect.urx()) + ", " + Double.toString(rect.ury()));
        }
        int flags = 0;
        flags = this.pdfAnnot.getFlags();
        if (flags != 0) {
            StringBuilder flagsBuf = new StringBuilder();
            String separator = "";
            for (int flagsCount = 0; flagsCount < flagsText.length; ++flagsCount) {
                if ((flags & flagsBits[flagsCount]) == 0) continue;
                flagsBuf.append(separator);
                flagsBuf.append(flagsText[flagsCount]);
                separator = flagsSeparator;
            }
            attributes.addAttribute("", ATTR_FLAGS, ATTR_FLAGS, "CDATA", flagsBuf.toString());
        }
        if (this.pdfAnnot.hasRotation()) {
            attributes.addAttribute("", ATTR_ROTATION, ATTR_ROTATION, "CDATA", Integer.toString(this.pdfAnnot.getRotation()));
        }
    }

    void addMarkupXFDFAttributes(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.pdfAnnot instanceof PDFAnnotationWithIntent) {
            if (((PDFAnnotationMarkup)this.pdfAnnot).hasCreationDate()) {
                attributes.addAttribute("", ATTR_CREATE_DATE, ATTR_CREATE_DATE, "CDATA", ((PDFAnnotationMarkup)this.pdfAnnot).getCreationDateAsString());
            }
            if (((PDFAnnotationMarkup)this.pdfAnnot).hasOpacity()) {
                attributes.addAttribute("", ATTR_OPACITY, ATTR_OPACITY, "CDATA", String.valueOf(((PDFAnnotationMarkup)this.pdfAnnot).getOpacity()));
            }
            if (((PDFAnnotationMarkup)this.pdfAnnot).hasSubject()) {
                attributes.addAttribute("", ATTR_SUBJ, ATTR_SUBJ, "CDATA", ((PDFAnnotationMarkup)this.pdfAnnot).getSubject());
            }
            if (((PDFAnnotationMarkup)this.pdfAnnot).hasIntent()) {
                attributes.addAttribute("", ATTR_INTENT, ATTR_INTENT, "CDATA", ((PDFAnnotationMarkup)this.pdfAnnot).getIntent());
            }
        }
    }

    protected void createXFDFExData3DMarkup(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException, PDFUnableToCompleteOperationException, PDFConfigurationException {
        PDFExData exData;
        if (this.pdfAnnot instanceof PDFAnnotationMarkup && (exData = ((PDFAnnotationMarkup)this.pdfAnnot).getExData()) != null) {
            AttributesImpl dataAtts = new AttributesImpl();
            this.addExdataAttributes(dataAtts);
            handler.startElement("", ELEM_EXDATA, ELEM_EXDATA, dataAtts);
            XFDFExData xfdfExData3D = new XFDFExData(exData);
            try {
                xfdfExData3D.transformToXFDF(handler, (PDFAnnotationMarkup)this.pdfAnnot, this.annot3D, this);
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (PDFConfigurationException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
            handler.endElement("", ELEM_EXDATA, ELEM_EXDATA);
        }
    }

    private void addExdataAttributes(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (((PDFAnnotationMarkup)this.pdfAnnot).hasExData()) {
            attributes.addAttribute("", ATTR_SUBTYPE, ATTR_SUBTYPE, "CDATA", ((PDFAnnotationMarkup)this.pdfAnnot).getExData().getSubtype().asString());
        }
    }

    void addCaptionXFDFAttribute(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean caption;
        if (((PDFAnnotationLine)this.pdfAnnot).hasCaption() && (caption = ((PDFAnnotationLine)this.pdfAnnot).getCaption())) {
            attributes.addAttribute("", ATTR_CAPTION, ATTR_CAPTION, "CDATA", caption ? "yes" : "");
        }
    }

    void addBorderStyleXFDFAttributes(AttributesImpl attributes, boolean withEffects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderEffects effects;
        String style = null;
        PDFBorderStyle borderStyle = this.pdfAnnot.getBorderStyle();
        if (borderStyle != null) {
            boolean hasDash = false;
            if (borderStyle.hasWidth()) {
                attributes.addAttribute("", ATTR_WIDTH, ATTR_WIDTH, "CDATA", Double.toString(borderStyle.getWidth()));
            }
            String styleName = null;
            if (borderStyle.hasStyle()) {
                styleName = borderStyle.getStyle().toString();
                style = PDFUtil.substituteStringFromArray((String)styleName, (String[])acroBorderStyle, (String[])xfdfBorderStyle);
            }
            if (borderStyle.hasDash() && styleName != null && styleName.equals("D")) {
                attributes.addAttribute("", ATTR_DASHES, ATTR_DASHES, "CDATA", ServicesUtil.makeNumbersString(borderStyle.getDash(), flagsSeparator));
                hasDash = true;
            }
            if (!hasDash && style != null && style.equals("dash")) {
                style = null;
            }
        }
        if (withEffects && this.pdfAnnot instanceof PDFAnnotationWithBorderEffects && (effects = ((PDFAnnotationWithBorderEffects)this.pdfAnnot).getBorderEffects()) != null) {
            String newStyle;
            if (effects.hasStyle() && (newStyle = this.getBorderEffectsStyle(effects)) != null) {
                if (style == null) {
                    style = newStyle;
                } else {
                    StringBuilder combinedStyle = new StringBuilder(style.length() + newStyle.length() + 1);
                    combinedStyle.append(style);
                    combinedStyle.append(flagsSeparator);
                    combinedStyle.append(newStyle);
                    style = combinedStyle.toString();
                }
            }
            if (effects.hasIntensity()) {
                attributes.addAttribute("", ATTR_INTENSITY, ATTR_INTENSITY, "CDATA", effects.getIntensityAsString());
            }
        }
        if (style != null) {
            attributes.addAttribute("", ATTR_STYLE, ATTR_STYLE, "CDATA", style);
        }
    }

    private boolean addStreamXFDFAttributes(AttributesImpl attributes, CosStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int filterType;
        String filters = null;
        CosObject filterObj = stream.get(ASName.k_Filter);
        int n = filterType = filterObj != null ? filterObj.getType() : 0;
        if (filterType == 3) {
            filters = stream.getName(ASName.k_Filter).asString(true);
        } else if (filterType == 5) {
            CosArray names = stream.getCosArray(ASName.k_Filter);
            String separator = "";
            StringBuilder namesStr = new StringBuilder(names.size() * 10);
            for (int namesInd = 0; namesInd < names.size(); ++namesInd) {
                namesStr.append(separator);
                namesStr.append(names.getName(namesInd).asString(true));
                separator = flagsSeparator;
            }
            filters = namesStr.toString();
        }
        if (filters != null) {
            attributes.addAttribute("", ATTR_FILTER, ATTR_FILTER, "CDATA", filters);
        }
        int len = stream.getInt(ASName.k_Length);
        attributes.addAttribute("", ATTR_LENGTH, ATTR_LENGTH, "CDATA", Integer.toString(len));
        String mode = len < 4096 && this.isASCIIEncoded(stream) ? ATTR_FILTERED : ATTR_RAW;
        String encoding = mode.equals(ATTR_RAW) ? ATTR_HEX : ATTR_ASCII;
        attributes.addAttribute("", ATTR_MODE, ATTR_MODE, "CDATA", mode);
        attributes.addAttribute("", ATTR_ENCODING, ATTR_ENCODING, "CDATA", encoding);
        return mode.equals(ATTR_RAW);
    }

    private boolean isASCIIEncoded(CosStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            InputByteStream ibs = stream.getStreamEncoded();
            boolean isAscii = this.isASCII(ibs);
            ibs.close();
            ibs = null;
            return isAscii;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private boolean isASCII(InputByteStream bytes) throws PDFIOException {
        try {
            while (bytes.bytesAvailable() > 0L) {
                int oneByte = bytes.read();
                if (oneByte >= 32 || ByteOps.isWhitespace((char)((char)oneByte))) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    void addInteriorColorXFDFAttribute(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String color = this.getColorsForXFDF(ASName.k_IC);
        if (color != null) {
            attributes.addAttribute("", ATTR_INTERIOR_COLOR, ATTR_INTERIOR_COLOR, "CDATA", color);
        }
    }

    void addFringeXFDFAttribute(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] fringe;
        if (this.pdfAnnot instanceof PDFAnnotationWithFringe && ((PDFAnnotationWithFringe)this.pdfAnnot).hasFringe() && (fringe = ((PDFAnnotationWithFringe)this.pdfAnnot).getFringe()).length == 4) {
            attributes.addAttribute("", ATTR_FRINGE, ATTR_FRINGE, "CDATA", ServicesUtil.makeNumbersString(((PDFAnnotationWithFringe)this.pdfAnnot).getFringe(), flagsSeparator));
        }
    }

    boolean addCoordXFDFAttribute(AttributesImpl attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationWithQuadPoints && ((PDFAnnotationWithQuadPoints)this.pdfAnnot).hasQuadPoints()) {
            attributes.addAttribute("", ATTR_QUADPOINTS, ATTR_QUADPOINTS, "CDATA", ServicesUtil.makeNumbersString(((PDFAnnotationWithQuadPoints)this.pdfAnnot).getQuadPoints(), flagsSeparator));
        }
        return false;
    }

    static String getAttributeName(Attributes elemAttrs, int attrInd) {
        String elemName = elemAttrs.getLocalName(attrInd);
        if (elemName == null || elemName.length() == 0) {
            elemName = elemAttrs.getQName(attrInd);
        }
        if (elemName == null || elemName.length() == 0) {
            return null;
        }
        return elemName;
    }

    protected static int findAttribute(String name, Attributes attributes) {
        for (int attrInd = 0; attrInd < attributes.getLength(); ++attrInd) {
            if (!name.equalsIgnoreCase(XFDFAnnotation.getAttributeName(attributes, attrInd))) continue;
            return attrInd;
        }
        return -1;
    }

    protected void createFileSpec(Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot == null || !(this.pdfAnnot instanceof PDFAnnotationLink)) {
            return;
        }
        int attrInd = XFDFAnnotation.findAttribute("OriginalName", elemAttrs);
        if (attrInd != -1) {
            String file = elemAttrs.getValue(attrInd);
            PDFAnnotationLink linkAnnot = (PDFAnnotationLink)this.pdfAnnot;
            XFDFActions actions = XFDFActions.create(linkAnnot.getAction().getCosObject());
            PDFFileSpecification fileSpec = PDFFileSpecification.newInstance((PDFDocument)linkAnnot.getPDFDocument(), (byte[])XFDFUtil.toByteStringFromXFDFString(file), null);
            actions.setFileSpecification(fileSpec);
        }
    }

    protected boolean startDataStream(Attributes elemAttrs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream stream;
        boolean rawMode = false;
        Object object = this.pdfAnnot instanceof PDFAnnotationSound ? ((PDFAnnotationSound)this.pdfAnnot).getDataStream() : (stream = this.pdfAnnot instanceof PDFAnnotationFileAttachment ? XFDFAnnotation.getDataStream((PDFAnnotationFileAttachment)this.pdfAnnot) : null);
        if (stream == null) {
            return false;
        }
        int attrInd = XFDFAnnotation.findAttribute(ATTR_FILTER, elemAttrs);
        if (attrInd >= 0) {
            String filter = elemAttrs.getValue(attrInd);
            if (filter.indexOf(flagsSeparator) == -1) {
                PDFFilter pdfFilter = this.checkExistingFilters(filter);
                if (pdfFilter == null) {
                    pdfFilter = PDFFilterFlate.newInstance((PDFDocument)this.pdfDoc, null);
                }
                this.setOutputFilter(this.getPDFCosStream(this.pdfAnnot), pdfFilter);
            } else {
                StringTokenizer filters = new StringTokenizer(filter, flagsSeparator);
                boolean defaultFilterAdded = false;
                while (filters.hasMoreTokens()) {
                    PDFFilter pdfFilter = this.checkExistingFilters(filters.nextToken());
                    if (pdfFilter == null && !defaultFilterAdded) {
                        pdfFilter = PDFFilterFlate.newInstance((PDFDocument)this.pdfDoc, null);
                        defaultFilterAdded = true;
                    }
                    if (pdfFilter == null) continue;
                    this.setOutputFilter(this.getPDFCosStream(this.pdfAnnot), pdfFilter);
                }
            }
        }
        if ((attrInd = XFDFAnnotation.findAttribute(ATTR_LENGTH, elemAttrs)) >= 0) {
            PDFCosStream.setStreamLength((CosStream)stream, (int)Integer.parseInt(elemAttrs.getValue(attrInd)));
        }
        if ((attrInd = XFDFAnnotation.findAttribute(ATTR_MODE, elemAttrs)) >= 0) {
            rawMode = elemAttrs.getValue(attrInd).equals(ATTR_RAW);
        }
        return rawMode;
    }

    private static CosStream getDataStream(PDFAnnotationFileAttachment pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification fileSpec;
        if (pdfAnnot.hasFileSpecification() && (fileSpec = pdfAnnot.getFileSpecification()).hasEmbeddedFile()) {
            return fileSpec.getEmbeddedFile().getFileStream();
        }
        return null;
    }

    private PDFCosStream getPDFCosStream(PDFAnnotation pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEmbeddedFile pdfCosStream = null;
        if (pdfAnnot instanceof PDFAnnotationFileAttachment) {
            pdfCosStream = ((PDFAnnotationFileAttachment)pdfAnnot).procureFileSpecification().procureEmbeddedFile();
        } else if (pdfAnnot instanceof PDFAnnotationSound) {
            pdfCosStream = ((PDFAnnotationSound)pdfAnnot).getSoundFromAnnotation();
        }
        return pdfCosStream;
    }

    private void setOutputFilter(PDFCosStream pdfCosStream, PDFFilter pdfFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList pdfFilterList = pdfCosStream.procureOutputFilters();
        pdfFilterList.add(pdfFilter);
        pdfCosStream.setOutputFilters(pdfFilterList);
    }

    private PDFFilter checkExistingFilters(String filterName) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFDocument pdfDocument;
        Iterator itr = CustomFilterRegistry.getDefaultEncodeFilters().iterator();
        boolean contains = false;
        ASName listEntry = null;
        PDFDocument pDFDocument = pdfDocument = this.pdfDoc != null ? this.pdfDoc : this.pdfAnnot.getPDFDocument();
        while (itr.hasNext()) {
            listEntry = (ASName)itr.next();
            if (!listEntry.asString().equals(filterName)) continue;
            contains = true;
            break;
        }
        if (contains) {
            return PDFFilter.newInstance((PDFDocument)this.pdfDoc, (ASName)listEntry, null);
        }
        CustomFilterRegistry custFilterRegistry = pdfDocument.getCosDocument().getOptions().getCustomFilterRegistry();
        CustomEncodeFilter custFilter = null;
        if (custFilterRegistry != null) {
            custFilter = custFilterRegistry.getRegisteredEncodeFilterByName(ASName.create((String)filterName));
        }
        if (custFilter != null) {
            return PDFFilter.newInstance((PDFDocument)pdfDocument, (ASName)custFilter.getName(), null);
        }
        return null;
    }

    protected void endDataStream(OutputByteStream data, boolean rawMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            CosStream stream;
            Object object = this.pdfAnnot instanceof PDFAnnotationSound ? ((PDFAnnotationSound)this.pdfAnnot).getDataStream() : (stream = this.pdfAnnot instanceof PDFAnnotationFileAttachment ? XFDFAnnotation.getDataStream((PDFAnnotationFileAttachment)this.pdfAnnot) : null);
            if (stream == null) {
                data.close();
                data = null;
                return;
            }
            stream.newDataEncoded(data.closeAndConvert());
            data = null;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    void setColorFromXML(PDFAnnotation annot, ASName colorName, String color) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (color.length() != 3 && color.length() != 7 && color.length() != 9) {
            return;
        }
        ArrayList<Double> colorArray = new ArrayList<Double>(4);
        Integer firstComponent = Integer.parseInt(color.substring(1, 3), 16);
        colorArray.add(0, new Double(firstComponent.doubleValue() / 255.0));
        if (color.length() > 3) {
            Integer secondComponent = Integer.parseInt(color.substring(3, 5), 16);
            colorArray.add(1, new Double(secondComponent.doubleValue() / 255.0));
            if (color.length() > 5) {
                Integer thirdComponent = Integer.parseInt(color.substring(5, 7), 16);
                colorArray.add(2, new Double(thirdComponent.doubleValue() / 255.0));
                if (color.length() > 7) {
                    Integer forthComponent = Integer.parseInt(color.substring(7, 9), 16);
                    colorArray.add(3, new Double(forthComponent.doubleValue() / 255.0));
                }
            }
        }
        annot.setDictionaryArrayValue(colorName, colorArray);
    }

    protected int fillCommonAttributes(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int pageNum = -1;
        int numAttrs = attributes.getLength();
        for (int attrInd = 0; attrInd < numAttrs; ++attrInd) {
            String attrName = XFDFAnnotation.getAttributeName(attributes, attrInd);
            if (attrName == null) continue;
            if (attrName.equalsIgnoreCase(ATTR_PAGE)) {
                Integer intPage = Integer.parseInt(attributes.getValue(attrInd));
                pageNum = intPage;
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_COLOR)) {
                this.setColorFromXML(annot, ASName.k_C, attributes.getValue(attrInd));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_MOD_DATE)) {
                annot.setModificationDate(attributes.getValue(attrInd));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_TITLE)) {
                if (!(annot instanceof PDFAnnotationMarkup)) continue;
                ((PDFAnnotationMarkup)annot).setTitle(attributes.getValue(attrInd));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_NAME)) {
                annot.setName(attributes.getValue(attrInd));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_RECT)) {
                double[] rect = XFDFAnnotation.getRectangle(attributes.getValue(attrInd));
                if (rect == null) continue;
                annot.setRect(rect[0], rect[1], rect[2], rect[3]);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_FLAGS)) continue;
            int flags = XFDFAnnotation.makeFlags(attributes.getValue(attrInd));
            annot.setFlags(flags);
        }
        return pageNum;
    }

    static ASName createPDFExDataObject(PDFAnnotation annot, Attributes attributes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_SUBTYPE, attributes);
        ASName subType = null;
        if (annot instanceof PDFAnnotationMarkup && attrInd != -1) {
            subType = ASName.create((String)attributes.getValue(attrInd));
            PDFExData exdata = (PDFExData)PDFExData.newInstance((PDFDocument)annot.getPDFDocument(), (ASName)subType);
            ((PDFAnnotationMarkup)annot).setExData(exdata);
        }
        return subType;
    }

    protected void fillMarkupAttributes(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int numAttrs = attributes.getLength();
        for (int attrInd = 0; attrInd < numAttrs; ++attrInd) {
            String attrName = XFDFAnnotation.getAttributeName(attributes, attrInd);
            if (attrName == null) continue;
            if (attrName.equalsIgnoreCase(ATTR_CREATE_DATE)) {
                if (!(annot instanceof PDFAnnotationMarkup)) continue;
                ((PDFAnnotationMarkup)annot).setCreationDate(attributes.getValue(attrInd));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_OPACITY)) {
                if (!(annot instanceof PDFAnnotationMarkup)) continue;
                ((PDFAnnotationMarkup)annot).setOpacity((Number)Double.valueOf(attributes.getValue(attrInd)));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SUBJ)) {
                if (!(annot instanceof PDFAnnotationMarkup)) continue;
                ((PDFAnnotationMarkup)annot).setSubject(attributes.getValue(attrInd));
                continue;
            }
            if (!((PDFAnnotationMarkup)annot).hasExData()) continue;
            ((PDFAnnotationMarkup)annot).getExData();
        }
    }

    protected void fillBorderStyleAttributes(PDFAnnotation annot, Attributes attributes) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int numAttrs = attributes.getLength();
        boolean gotIt = false;
        PDFBorderStyle borderStyle = annot.procureBorderStyle();
        for (int attrInd = 0; attrInd < numAttrs; ++attrInd) {
            String attrName = XFDFAnnotation.getAttributeName(attributes, attrInd);
            if (attrName == null) continue;
            if (attrName.equalsIgnoreCase(ATTR_WIDTH)) {
                borderStyle.setWidth(attributes.getValue(attrInd));
                gotIt = true;
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_STYLE)) {
                String acroStyle = XFDFAnnotation.getAcroBorderStyle(attributes.getValue(attrInd));
                if (acroStyle == null) continue;
                borderStyle.setStyle(PDFBorderStyle.Style.getInstance((String)acroStyle));
                gotIt = true;
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_DASHES)) continue;
            borderStyle.setDash(attributes.getValue(attrInd), flagsSeparator);
            gotIt = true;
        }
        if (gotIt) {
            annot.setBorderStyle(borderStyle);
        }
    }

    protected void fillBorderEffectsAttributes(PDFAnnotation annot, Attributes attributes) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int numAttrs = attributes.getLength();
        boolean gotIt = false;
        if (annot instanceof PDFAnnotationWithBorderEffects) {
            PDFBorderEffects borderEffects = ((PDFAnnotationWithBorderEffects)annot).procureBorderEffects();
            for (int attrInd = 0; attrInd < numAttrs; ++attrInd) {
                String attrName = XFDFAnnotation.getAttributeName(attributes, attrInd);
                if (attrName == null) continue;
                if (attrName.equalsIgnoreCase(ATTR_STYLE)) {
                    ASName acroStyle = XFDFAnnotation.getAcroEffectsStyle(attributes.getValue(attrInd));
                    if (acroStyle == null) continue;
                    borderEffects.setStyle(acroStyle);
                    gotIt = true;
                    continue;
                }
                if (!attrName.equalsIgnoreCase(ATTR_INTENSITY)) continue;
                borderEffects.setIntensity(attributes.getValue(attrInd));
                gotIt = true;
            }
            if (gotIt) {
                ((PDFAnnotationWithBorderEffects)annot).setBorderEffects(borderEffects);
            }
        }
    }

    protected void fillInteriorColorAttribute(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_INTERIOR_COLOR, attributes);
        if (attrInd != -1) {
            this.setColorFromXML(annot, ASName.k_IC, attributes.getValue(attrInd));
        }
    }

    protected void fillFringeAttribute(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_FRINGE, attributes);
        if (annot instanceof PDFAnnotationWithFringe && attrInd != -1) {
            ((PDFAnnotationWithFringe)annot).setFringe(attributes.getValue(attrInd), flagsSeparator);
        }
    }

    protected void fillIntentAttribute(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_INTENT, attributes);
        if (annot instanceof PDFAnnotationWithIntent && attrInd != -1) {
            ((PDFAnnotationWithIntent)annot).setIntent(attributes.getValue(attrInd));
        }
    }

    protected void fillCaptionAttribute(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_CAPTION, attributes);
        if (annot instanceof PDFAnnotationLine && attrInd != -1) {
            ((PDFAnnotationLine)annot).setCaption(attributes.getValue(attrInd));
        }
    }

    protected void fillCalloutAttributes(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ELEM_CALLOUT, attributes);
        if (annot instanceof PDFAnnotationFreeText && attrInd != -1) {
            ((PDFAnnotationFreeText)annot).setCalloutLine(attributes.getValue(attrInd), flagsSeparator);
        }
    }

    protected void fillCoordAttribute(PDFAnnotation annot, Attributes attributes) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        int attrInd = XFDFAnnotation.findAttribute(ATTR_QUADPOINTS, attributes);
        if (attrInd != -1) {
            if (annot instanceof PDFAnnotationLink) {
                ((PDFAnnotationLink)annot).setQuadPoints(attributes.getValue(attrInd), flagsSeparator);
            } else if (annot instanceof PDFAnnotationTextMarkup) {
                ((PDFAnnotationTextMarkup)annot).setQuadPoints(attributes.getValue(attrInd), flagsSeparator);
            } else if (annot instanceof PDFAnnotationRedaction) {
                ((PDFAnnotationRedaction)annot).setQuadPoints(attributes.getValue(attrInd), flagsSeparator);
            }
        }
    }

    boolean createXFDFContent(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String content = this.pdfAnnot.getContents();
        if (content != null) {
            try {
                handler.startElement("", ELEM_CONTENTS, ELEM_CONTENTS, nullAttrs);
                handler.characters(content.toCharArray(), 0, content.length());
                handler.endElement("", ELEM_CONTENTS, ELEM_CONTENTS);
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create XFDF element", e);
            }
            return true;
        }
        return false;
    }

    boolean createXFDFVertices(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFVertices vertices;
        Object object = this.pdfAnnot instanceof PDFAnnotationPolygon ? ((PDFAnnotationPolygon)this.pdfAnnot).getVertices() : (vertices = this.pdfAnnot instanceof PDFAnnotationPolyline ? ((PDFAnnotationPolyline)this.pdfAnnot).getVertices() : null);
        if (vertices != null) {
            try {
                String content = this.createPairedList((PDFCosArrayList)vertices, flagsSeparator, ";");
                handler.startElement("", "vertices", "vertices", nullAttrs);
                handler.characters(content.toCharArray(), 0, content.length());
                handler.endElement("", "vertices", "vertices");
                return true;
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create XFDF element", e);
            }
        }
        throw new PDFInvalidDocumentException("Polygon/Polyline annotation does not have required /Vertices entry");
    }

    boolean createXFDFRichContent(ContentHandler handler) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFConfigurationException {
        String content = null;
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            content = ((PDFAnnotationMarkup)this.pdfAnnot).getRichContents();
        }
        if (content != null) {
            try {
                XMLUtils.CopyString2Blob richContent = new XMLUtils.CopyString2Blob(handler, (CopyBlobProcessElement)new RichTextBodyAttributes());
                handler.startElement("", ELEM_RICH_CONTENTS, ELEM_RICH_CONTENTS, nullAttrs);
                richContent.copyBlob(content);
                handler.endElement("", ELEM_RICH_CONTENTS, ELEM_RICH_CONTENTS);
                return true;
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create XFDF element", e);
            }
            catch (PDFInvalidXMLException e) {
                try {
                    ArrayList<String> arr = new ArrayList<String>();
                    arr.add(content);
                    content = RichTextHandler.convertString2RichText(arr);
                    XMLUtils.CopyString2Blob richContent = new XMLUtils.CopyString2Blob(handler, (CopyBlobProcessElement)new RichTextBodyAttributes());
                    richContent.copyBlob(content);
                    handler.endElement("", ELEM_RICH_CONTENTS, ELEM_RICH_CONTENTS);
                    return true;
                }
                catch (PDFInvalidParameterException e1) {
                    throw new RuntimeException("Unable to create XFDF element", e1);
                }
                catch (PDFInvalidXMLException e2) {
                    throw new RuntimeException("Unable to create XFDF element", e2);
                }
                catch (SAXException e3) {
                    throw new RuntimeException("Unable to create XFDF element", e3);
                }
            }
        }
        return false;
    }

    boolean createXFDFDefaultStyle(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String content = null;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            content = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultStyle();
        }
        if (content != null) {
            try {
                handler.startElement("", ELEM_DEFAULT_STYLE, ELEM_DEFAULT_STYLE, nullAttrs);
                handler.characters(content.toCharArray(), 0, content.length());
                handler.endElement("", ELEM_DEFAULT_STYLE, ELEM_DEFAULT_STYLE);
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create XFDF element", e);
            }
            return true;
        }
        return false;
    }

    boolean createXFDFDefaultAppearance(ContentHandler handler) throws PDFIOException, PDFInvalidDocumentException, PDFInvalidXMLException, PDFSecurityException {
        String content = null;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            content = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultAppearance();
        }
        if (this.pdfAnnot instanceof PDFAnnotationCaret) {
            content = ((PDFAnnotationCaret)this.pdfAnnot).getDefaultAppearance();
        } else if (this.pdfAnnot instanceof PDFAnnotationRedaction) {
            content = ((PDFAnnotationRedaction)this.pdfAnnot).getDA();
        }
        if (content != null) {
            try {
                handler.startElement("", ELEM_DEFAULT_APPEARANCE, ELEM_DEFAULT_APPEARANCE, nullAttrs);
                handler.characters(content.toCharArray(), 0, content.length());
                handler.endElement("", ELEM_DEFAULT_APPEARANCE, ELEM_DEFAULT_APPEARANCE);
            }
            catch (SAXException e) {
                throw new PDFInvalidXMLException("Unable to create XFDF element", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    boolean createStreamDataElement(ContentHandler handler, InputByteStream streamData, AttributesImpl dataAtts, String tag, boolean raw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            long leftInStream;
            streamData.seek(0L);
            handler.characters(END_ELEM, 0, 1);
            handler.startElement("", tag, tag, dataAtts);
            while ((leftInStream = streamData.bytesAvailable()) > 0L) {
                int chunkLen = (int)StrictMath.min(leftInStream, 512L);
                byte[] bytes = new byte[chunkLen];
                streamData.read(bytes, 0, chunkLen);
                String dataStr = this.encodeStream(bytes, raw);
                handler.characters(dataStr.toCharArray(), 0, dataStr.length());
            }
            handler.characters(END_ELEM, 0, 1);
            handler.endElement("", tag, tag);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to create XFDF element", e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                if (streamData != null) {
                    streamData.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            streamData = null;
        }
        return true;
    }

    boolean createXFDFStreamData(ContentHandler handler, CosStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (stream == null) {
            return false;
        }
        AttributesImpl dataAtts = new AttributesImpl();
        boolean raw = this.addStreamXFDFAttributes(dataAtts, stream);
        return this.createStreamDataElement(handler, stream.getStreamEncoded(), dataAtts, ELEM_DATA, raw);
    }

    boolean createXFDFPopupElement(ContentHandler handler, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.pdfAnnot).hasPopup()) {
            XFDFAnnotationPopup popup = this.getXFDFAnnotationPopup();
            popup.transformToXFDF(handler, pageNum);
        }
        return false;
    }

    List parsePairedList(String arrayText, String inDelim, String outDelim, boolean pairsAsList) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        StringTokenizer pairs = new StringTokenizer(arrayText, outDelim);
        ArrayList pairsArray = new ArrayList(pairs.countTokens() * 2);
        while (pairs.hasMoreTokens()) {
            ArrayList pair = PDFUtil.parseNumbers((String)pairs.nextToken(), (String)inDelim);
            if (pair.size() != 2) continue;
            if (pairsAsList) {
                pairsArray.add(pair);
                continue;
            }
            pairsArray.add(pair.get(0));
            pairsArray.add(pair.get(1));
        }
        return pairsArray;
    }

    String createPairedList(PDFCosArrayList pairedList, String firstDelim, String pairDelim) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String separator = "";
        String nextSeparator = pairDelim;
        String curSeparator = firstDelim;
        int curInd = 0;
        StringBuilder pairedStr = new StringBuilder(pairedList.size());
        while (curInd < pairedList.size()) {
            CosNumeric curNumber = (CosNumeric)pairedList.getCosArray().get(curInd++);
            pairedStr.append(separator);
            pairedStr.append(curNumber.doubleValue());
            separator = curSeparator;
            curSeparator = nextSeparator;
            nextSeparator = separator;
        }
        return pairedStr.toString();
    }

    void addPDFVertices(String vertices) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (vertices == null) {
            return;
        }
        List pairs = this.parsePairedList(vertices, flagsSeparator, ";", false);
        PDFVertices verticesList = PDFVertices.newInstance((PDFDocument)this.pdfAnnot.getPDFDocument(), (List)pairs);
        if (this.pdfAnnot instanceof PDFAnnotationPolygon) {
            ((PDFAnnotationPolygon)this.pdfAnnot).setVertices(verticesList);
            if (this.isPageRotate) {
                ((PDFAnnotationPolygon)this.pdfAnnot).applyRotation(this.pdfAnnot.getPage().getCropBox(), this.pdfAnnot.getPage().getRotation().getValue());
            }
        } else if (this.pdfAnnot instanceof PDFAnnotationPolyline) {
            ((PDFAnnotationPolyline)this.pdfAnnot).setVertices(verticesList);
            if (this.isPageRotate) {
                ((PDFAnnotationPolyline)this.pdfAnnot).applyRotation(this.pdfAnnot.getPage().getCropBox(), this.pdfAnnot.getPage().getRotation().getValue());
            }
        } else {
            return;
        }
    }

    PDFAnnotationRotationEnum getRotationType() {
        return this.rotationType;
    }

    void setIsPageRotate(boolean isPageRotate) {
        this.isPageRotate = isPageRotate;
    }

    void createAppearance(String base64Appearance, DefaultHandler previousHandler) throws PDFInvalidXMLException {
        if (this.pdfAnnot == null) {
            throw new PDFInvalidXMLException("Unable to create appearance");
        }
        if (!(this.pdfAnnot instanceof PDFAnnotationStamp) && this.rotationType == PDFAnnotationRotationEnum.NoRotate) {
            return;
        }
        StreamManager streamManager = this.pdfAnnot.getPDFDocument().getStreamManager();
        try {
            SAXParser saxParser;
            DefaultHandler handler = previousHandler != null ? new XFDF2CosWriter(this, (XFDF2CosWriter)previousHandler) : previousHandler;
            try {
                saxParser = XMLUtils.getNonValidatingNameSpaceAwareSaxParser();
            }
            catch (ParserConfigurationException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            try {
                saxParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXNotSupportedException e) {
                throw new PDFConfigurationException((Throwable)e);
            }
            catch (SAXException e) {
                throw new PDFInvalidXMLException((Throwable)e);
            }
            try {
                byte[] decodedData = new byte[base64Appearance.length()];
                int decodedLen = Base64Engine.decode((byte[])base64Appearance.getBytes("UTF-8"), (int)0, (int)base64Appearance.length(), (byte[])decodedData, (int)0);
                byte[] appearanceData = new byte[decodedLen];
                ByteBuffer.wrap(decodedData, 0, decodedLen).get(appearanceData);
                InputByteStream appearanceDataStream = streamManager.getInputByteStream(appearanceData);
                InputByteStream xmlPrefix = this.pdfDoc.getStreamManager().getInputByteStream(XML_PREFIX.getBytes("UTF-8"));
                InputByteStream[] appearanceStreams = new InputByteStream[]{xmlPrefix, appearanceDataStream};
                InputByteStream appearanceStream = streamManager.getInputByteStream(appearanceStreams);
                saxParser.parse(appearanceStream.toInputStream(), handler);
                appearanceStream.close();
            }
            catch (SAXException e) {
                throw new PDFInvalidXMLException("Unable to parse XFDF annotations", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF8 encoding is not supported.", e);
            }
            catch (IOException e) {
                throw new PDFIOException("Unable to parse XFDF annotations", (Throwable)e);
            }
        }
        catch (PDFException e) {
            throw new PDFInvalidXMLException("Unable to create appearance", (Throwable)e);
        }
    }

    void addAppearanceToXFDF(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block8: {
            if (!(this.pdfAnnot instanceof PDFAnnotationStamp) && this.rotationType == PDFAnnotationRotationEnum.NoRotate) {
                return;
            }
            try {
                SkipXMLPIOutputStream skipPIStream;
                if (this.pdfAnnot.getAppearance() == null) break block8;
                StreamManager streamMgr = this.pdfAnnot.getStreamManager();
                OutputByteStream appearanceStream = streamMgr.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 10000L);
                Base64Engine.EncodedOutputStream base64Stream = new Base64Engine.EncodedOutputStream((OutputStream)appearanceStream.toOutputStream());
                try {
                    skipPIStream = new SkipXMLPIOutputStream((OutputStream)base64Stream);
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException("encoding not supported", e1);
                }
                Cos2XMLReader dataParser = new Cos2XMLReader((PDFCosDictionary)this.pdfAnnot, ASName.k_AP, this);
                try {
                    ServicesUtil.transformToXML(dataParser, null, (OutputStream)skipPIStream);
                    skipPIStream.close();
                }
                catch (PDFInvalidXMLException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
                InputByteStream dataStream = appearanceStream.closeAndConvert();
                this.createStreamDataElement(handler, dataStream, nullAttrs, ELEM_APPEARANCE, false);
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (Exception e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }
}

