/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DExData3DM;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement3DC;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementAD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementLD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementPD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementRD3;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFExData;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class XFDF3DMeasurement {
    PDF3DMeasurement measurement3D;
    PDF3DVDict newView;
    PDFAnnotationMarkup markup;
    private boolean creatingComment3D;
    PDF3DMeasurementList ml;
    private boolean creatingAngularMarkup;
    private boolean creatingLinearMarkup;
    private double[] markupColorLI;
    private PDFText userTextLI;
    private boolean creatingRadialMarkup;
    private boolean creatingPerpendicularMarkup;
    private String measurementCommentName;
    private ArrayList arr3DC = new ArrayList();
    private double[] markupColorPI;
    private PDFText unitsLI;
    private PDFText userTextPI;
    private double[] textPosPI;
    private double[] textPosLI;
    private boolean sc;
    private boolean rad;
    private double[] a3;
    private double[] a4;
    private PDFText units;
    private double[] markupColorRI;
    private PDFText userTextRI;
    private double el;
    private double[] textPosRI;
    private boolean dr;
    private double[] ap;
    private double[] a2;
    private PDFText partName2;
    private double[] d1;
    private double[] d2;
    private double textSz;
    private double[] markupColorAI;
    private double measureVal;
    private int precision;
    private double[] tx;
    private double[] ty;
    private PDFText partName1;
    private int precisionAI;
    private PDFText userTextAI;
    private double[] textPosAI;
    String measureCommentName;
    double[] a1;
    double[] tp;
    PDFText partName;
    private double[] markupColor;
    private double textboxX;
    private double textboxY;
    private double textSize;
    private String userText;
    static final AttributesImpl nullAttrs = new AttributesImpl();
    static final String ELEM_MEASURE = "measure";
    static final String ELEM_MEASURENAME = "measurename";
    static final String ELEM_MEASURELIMARKUP = "linearmarkup";
    static final String ELEM_MEASUREANNOPLANE = "annoplane";
    static final String ELEM_MEASUREANCHOR1 = "anchor1";
    static final String ELEM_MEASUREANCHOR1PARTNAME = "anchor1partname";
    static final String ELEM_MEASUREANCHOR2 = "anchor2";
    static final String ELEM_MEASUREANCHOR2PARTNAME = "anchor2partname";
    static final String ELEM_MEASURETEXTPOSITION = "textposition";
    static final String ELEM_MEASURETEXTYDIRECTION = "textydirection";
    static final String ELEM_MEASURETEXTSIZE = "textsize";
    static final String ELEM_MEASUREMARKCOLOR = "markupcolor";
    static final String ELEM_MEASURELVALUE = "value";
    static final String ELEM_MEASUREUNITS = "units";
    static final String ELEM_MEASUREPRECISION = "precision";
    static final String ELEM_MEASUREUSERTEXT = "usertext";
    static final String ELEM_MEASUREPIMARKUP = "perpendicularmarkup";
    static final String ELEM_MEASUREUPIDIR = "leaderdirection";
    static final String ELEM_MEASUREUPLIDIR1 = "leaderdirection1";
    static final String ELEM_MEASUREUPLIDIR2 = "leaderdirection2";
    static final String ELEM_MEASUREAIMARKUP = "angularmarkup";
    static final String ELEM_MEASUREUPIDIR2 = "leaderdirection2";
    static final String ELEM_MEASURETEXTXDIRECTION = "textxdirection";
    static final String ATTR_MEASURERADIANS = "radians";
    static final String ELEM_MEASURERIMARKUP = "radialmarkup";
    static final String ELEM_MEASUREEXTENSIONLEN = "extensionlength";
    static final String ELEM_MEASURECIRCLECENTER = "circlecenter";
    static final String ELEM_MEASUREPOINTCIRCLE = "pointoncircle";
    static final String ELEM_MEASUREARCSTART = "arcstart";
    static final String ELEM_MEASUREARCEND = "arcend";
    static final String ELEM_MEASUREANCHORPARTNAME = "anchorpartname";
    static final String ATTR_SHOWCIRCLE = "showcircle";
    static final String ATTR_DIAMETER = "diameter";
    static final String ELEM_MEASURECOMMEND3DMARKUP = "comment3dmarkup";
    static final String ELEM_COMMENT3DANCHOR = "anchor";
    static final String ELEM_COMMENT3DANCHORPARTNAME = "anchorpartname";
    static final String ELEM_COMMENT3DTEXTPOSITION = "textposition";
    static final String ELEM_COMMENT3DTEXTSIZE = "textsize";
    static final String ELEM_COMMENT3DTEXTBOXX = "textboxx";
    static final String ELEM_COMMENT3DTEXTBOXY = "textboxy";
    static final String ELEM_COMMENT3DMARKCOLOR = "markupcolor";
    static final String ELEM_COMMENT3DUSERTEXT = "usertext";

    public XFDF3DMeasurement(XFDFAnnotation xfdfAnnot, PDFAnnotation3D annot3D, PDF3DVDict newV) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.markup = (PDFAnnotationMarkup)xfdfAnnot.pdfAnnot;
        this.newView = newV;
    }

    public XFDF3DMeasurement(PDF3DMeasurement measurement) {
        this.measurement3D = measurement;
    }

    public void transformToXFDF(ContentHandler handler) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        this.createMeasurement3DElement(handler);
    }

    protected void createMeasurement3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        handler.startElement("", ELEM_MEASURE, ELEM_MEASURE, nullAttrs);
        if (this.measurement3D != null && this.measurement3D.hasTRL()) {
            handler.startElement("", ELEM_MEASURENAME, ELEM_MEASURENAME, nullAttrs);
            String measureName = this.measurement3D.getTRL().stringValue();
            handler.characters(measureName.toCharArray(), 0, measureName.length());
            handler.endElement("", ELEM_MEASURENAME, ELEM_MEASURENAME);
        }
        this.createLinearMeasurement3DElement(handler);
        this.createPerpendicularMeasurement3DElement(handler);
        this.createAngularMeasurement3DElement(handler);
        this.createRadialMeasurement3DElement(handler);
        this.createComment3DElement(handler);
        handler.endElement("", ELEM_MEASURE, ELEM_MEASURE);
    }

    protected void createLinearMeasurement3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (this.measurement3D instanceof PDF3DMeasurementLD3) {
            PDF3DMeasurementLD3 lid = (PDF3DMeasurementLD3)this.measurement3D;
            handler.startElement("", ELEM_MEASURELIMARKUP, ELEM_MEASURELIMARKUP, nullAttrs);
            if (lid.hasAP()) {
                handler.startElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE, nullAttrs);
                String annotplane = XFDFUtil.toStringFromDoubleArray(lid.getAP());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE);
            }
            if (lid.hasA1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1, nullAttrs);
                String anchor1 = XFDFUtil.toStringFromDoubleArray(lid.getA1());
                handler.characters(anchor1.toCharArray(), 0, anchor1.length());
                handler.endElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1);
            }
            if (lid.hasN1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME, nullAttrs);
                String anchor1partname = lid.getN1().stringValue();
                handler.characters(anchor1partname.toCharArray(), 0, anchor1partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME);
            }
            if (lid.hasA2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2, nullAttrs);
                String anchor2 = XFDFUtil.toStringFromDoubleArray(lid.getA2());
                handler.characters(anchor2.toCharArray(), 0, anchor2.length());
                handler.endElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2);
            }
            if (lid.hasN2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME, nullAttrs);
                String anchor2partname = lid.getN2().stringValue();
                handler.characters(anchor2partname.toCharArray(), 0, anchor2partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME);
            }
            if (lid.hasTP()) {
                handler.startElement("", "textposition", "textposition", nullAttrs);
                String textposition = XFDFUtil.toStringFromDoubleArray(lid.getTP());
                handler.characters(textposition.toCharArray(), 0, textposition.length());
                handler.endElement("", "textposition", "textposition");
            }
            if (lid.hasTY()) {
                handler.startElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION, nullAttrs);
                String textydirection = XFDFUtil.toStringFromDoubleArray(lid.getTY());
                handler.characters(textydirection.toCharArray(), 0, textydirection.length());
                handler.endElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION);
            }
            if (lid.hasTS()) {
                handler.startElement("", "textsize", "textsize", nullAttrs);
                String textsize = String.valueOf(lid.getTS());
                handler.characters(textsize.toCharArray(), 0, textsize.length());
                handler.endElement("", "textsize", "textsize");
            }
            if (lid.hasC()) {
                handler.startElement("", "markupcolor", "markupcolor", nullAttrs);
                String markupcolor = XFDFUtil.toStringFromDoubleArray(lid.getC());
                handler.characters(markupcolor.toCharArray(), 0, markupcolor.length());
                handler.endElement("", "markupcolor", "markupcolor");
            }
            if (lid.hasV()) {
                handler.startElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE, nullAttrs);
                String value = String.valueOf(lid.getV());
                handler.characters(value.toCharArray(), 0, value.length());
                handler.endElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE);
            }
            if (lid.hasU()) {
                handler.startElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS, nullAttrs);
                String units = lid.getU().stringValue();
                handler.characters(units.toCharArray(), 0, units.length());
                handler.endElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS);
            }
            if (lid.hasP()) {
                handler.startElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION, nullAttrs);
                String precision = String.valueOf(lid.getP());
                handler.characters(precision.toCharArray(), 0, precision.length());
                handler.endElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION);
            }
            if (lid.hasUT()) {
                handler.startElement("", "usertext", "usertext", nullAttrs);
                String usertext = lid.getUT().stringValue();
                handler.characters(usertext.toCharArray(), 0, usertext.length());
                handler.endElement("", "usertext", "usertext");
            }
            handler.endElement("", ELEM_MEASURELIMARKUP, ELEM_MEASURELIMARKUP);
        }
    }

    protected void createPerpendicularMeasurement3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (this.measurement3D instanceof PDF3DMeasurementPD3) {
            String annotplane;
            PDF3DMeasurementPD3 lid = (PDF3DMeasurementPD3)this.measurement3D;
            handler.startElement("", ELEM_MEASUREPIMARKUP, ELEM_MEASUREPIMARKUP, nullAttrs);
            if (lid.hasAP()) {
                handler.startElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getAP());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE);
            }
            if (lid.hasA1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1, nullAttrs);
                String anchor1 = XFDFUtil.toStringFromDoubleArray(lid.getA1());
                handler.characters(anchor1.toCharArray(), 0, anchor1.length());
                handler.endElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1);
            }
            if (lid.hasN1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME, nullAttrs);
                String anchor1partname = lid.getN1().stringValue();
                handler.characters(anchor1partname.toCharArray(), 0, anchor1partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME);
            }
            if (lid.hasA2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2, nullAttrs);
                String anchor2 = XFDFUtil.toStringFromDoubleArray(lid.getA2());
                handler.characters(anchor2.toCharArray(), 0, anchor2.length());
                handler.endElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2);
            }
            if (lid.hasN2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME, nullAttrs);
                String anchor2partname = lid.getN2().stringValue();
                handler.characters(anchor2partname.toCharArray(), 0, anchor2partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME);
            }
            if (lid.hasTP()) {
                handler.startElement("", "textposition", "textposition", nullAttrs);
                String textposition = XFDFUtil.toStringFromDoubleArray(lid.getTP());
                handler.characters(textposition.toCharArray(), 0, textposition.length());
                handler.endElement("", "textposition", "textposition");
            }
            if (lid.hasD1()) {
                handler.startElement("", ELEM_MEASUREUPIDIR, ELEM_MEASUREUPIDIR, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getD1());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREUPIDIR, ELEM_MEASUREUPIDIR);
            }
            if (lid.hasTY()) {
                handler.startElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION, nullAttrs);
                String textydirection = XFDFUtil.toStringFromDoubleArray(lid.getTY());
                handler.characters(textydirection.toCharArray(), 0, textydirection.length());
                handler.endElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION);
            }
            if (lid.hasTS()) {
                handler.startElement("", "textsize", "textsize", nullAttrs);
                String textsize = String.valueOf(lid.getTS());
                handler.characters(textsize.toCharArray(), 0, textsize.length());
                handler.endElement("", "textsize", "textsize");
            }
            if (lid.hasC()) {
                handler.startElement("", "markupcolor", "markupcolor", nullAttrs);
                String markupcolor = XFDFUtil.toStringFromDoubleArray(lid.getC());
                handler.characters(markupcolor.toCharArray(), 0, markupcolor.length());
                handler.endElement("", "markupcolor", "markupcolor");
            }
            if (lid.hasV()) {
                handler.startElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE, nullAttrs);
                String value = String.valueOf(lid.getV());
                handler.characters(value.toCharArray(), 0, value.length());
                handler.endElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE);
            }
            if (lid.hasU()) {
                handler.startElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS, nullAttrs);
                String units = lid.getU().stringValue();
                handler.characters(units.toCharArray(), 0, units.length());
                handler.endElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS);
            }
            if (lid.hasP()) {
                handler.startElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION, nullAttrs);
                String precision = String.valueOf(lid.getP());
                handler.characters(precision.toCharArray(), 0, precision.length());
                handler.endElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION);
            }
            if (lid.hasUT()) {
                handler.startElement("", "usertext", "usertext", nullAttrs);
                String usertext = lid.getUT().stringValue();
                handler.characters(usertext.toCharArray(), 0, usertext.length());
                handler.endElement("", "usertext", "usertext");
            }
            handler.endElement("", ELEM_MEASUREPIMARKUP, ELEM_MEASUREPIMARKUP);
        }
    }

    protected void createAngularMeasurement3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (this.measurement3D instanceof PDF3DMeasurementAD3) {
            String annotplane;
            PDF3DMeasurementAD3 lid = (PDF3DMeasurementAD3)this.measurement3D;
            if (lid.hasDR()) {
                AttributesImpl annotsAtts = new AttributesImpl();
                annotsAtts.addAttribute("", ATTR_MEASURERADIANS, ATTR_MEASURERADIANS, "CDATA", String.valueOf(lid.getDR()));
                handler.startElement("", ELEM_MEASUREAIMARKUP, ELEM_MEASUREAIMARKUP, annotsAtts);
            } else {
                handler.startElement("", ELEM_MEASUREAIMARKUP, ELEM_MEASUREAIMARKUP, nullAttrs);
            }
            if (lid.hasAP()) {
                handler.startElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getAP());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE);
            }
            if (lid.hasA1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1, nullAttrs);
                String anchor1 = XFDFUtil.toStringFromDoubleArray(lid.getA1());
                handler.characters(anchor1.toCharArray(), 0, anchor1.length());
                handler.endElement("", ELEM_MEASUREANCHOR1, ELEM_MEASUREANCHOR1);
            }
            if (lid.hasN1()) {
                handler.startElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME, nullAttrs);
                String anchor1partname = lid.getN1().stringValue();
                handler.characters(anchor1partname.toCharArray(), 0, anchor1partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR1PARTNAME, ELEM_MEASUREANCHOR1PARTNAME);
            }
            if (lid.hasA2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2, nullAttrs);
                String anchor2 = XFDFUtil.toStringFromDoubleArray(lid.getA2());
                handler.characters(anchor2.toCharArray(), 0, anchor2.length());
                handler.endElement("", ELEM_MEASUREANCHOR2, ELEM_MEASUREANCHOR2);
            }
            if (lid.hasN2()) {
                handler.startElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME, nullAttrs);
                String anchor2partname = lid.getN2().stringValue();
                handler.characters(anchor2partname.toCharArray(), 0, anchor2partname.length());
                handler.endElement("", ELEM_MEASUREANCHOR2PARTNAME, ELEM_MEASUREANCHOR2PARTNAME);
            }
            if (lid.hasTP()) {
                handler.startElement("", "textposition", "textposition", nullAttrs);
                String textposition = XFDFUtil.toStringFromDoubleArray(lid.getTP());
                handler.characters(textposition.toCharArray(), 0, textposition.length());
                handler.endElement("", "textposition", "textposition");
            }
            if (lid.hasD1()) {
                handler.startElement("", ELEM_MEASUREUPLIDIR1, ELEM_MEASUREUPLIDIR1, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getD1());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREUPLIDIR1, ELEM_MEASUREUPLIDIR1);
            }
            if (lid.hasD2()) {
                handler.startElement("", "leaderdirection2", "leaderdirection2", nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getD2());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", "leaderdirection2", "leaderdirection2");
            }
            if (lid.hasTX()) {
                handler.startElement("", ELEM_MEASURETEXTXDIRECTION, ELEM_MEASURETEXTXDIRECTION, nullAttrs);
                String textxdirection = XFDFUtil.toStringFromDoubleArray(lid.getTX());
                handler.characters(textxdirection.toCharArray(), 0, textxdirection.length());
                handler.endElement("", ELEM_MEASURETEXTXDIRECTION, ELEM_MEASURETEXTXDIRECTION);
            }
            if (lid.hasTY()) {
                handler.startElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION, nullAttrs);
                String textydirection = XFDFUtil.toStringFromDoubleArray(lid.getTY());
                handler.characters(textydirection.toCharArray(), 0, textydirection.length());
                handler.endElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION);
            }
            if (lid.hasTS()) {
                handler.startElement("", "textsize", "textsize", nullAttrs);
                String textsize = String.valueOf(lid.getTS());
                handler.characters(textsize.toCharArray(), 0, textsize.length());
                handler.endElement("", "textsize", "textsize");
            }
            if (lid.hasC()) {
                handler.startElement("", "markupcolor", "markupcolor", nullAttrs);
                String markupcolor = XFDFUtil.toStringFromDoubleArray(lid.getC());
                handler.characters(markupcolor.toCharArray(), 0, markupcolor.length());
                handler.endElement("", "markupcolor", "markupcolor");
            }
            if (lid.hasV()) {
                handler.startElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE, nullAttrs);
                String value = String.valueOf(lid.getV());
                handler.characters(value.toCharArray(), 0, value.length());
                handler.endElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE);
            }
            if (lid.hasP()) {
                handler.startElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION, nullAttrs);
                String precision = String.valueOf(lid.getP());
                handler.characters(precision.toCharArray(), 0, precision.length());
                handler.endElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION);
            }
            if (lid.hasUT()) {
                handler.startElement("", "usertext", "usertext", nullAttrs);
                String usertext = lid.getUT().stringValue();
                handler.characters(usertext.toCharArray(), 0, usertext.length());
                handler.endElement("", "usertext", "usertext");
            }
            handler.endElement("", ELEM_MEASUREAIMARKUP, ELEM_MEASUREAIMARKUP);
        }
    }

    protected void createRadialMeasurement3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (this.measurement3D instanceof PDF3DMeasurementRD3) {
            String annotplane;
            PDF3DMeasurementRD3 lid = (PDF3DMeasurementRD3)this.measurement3D;
            AttributesImpl annotsAtts = new AttributesImpl();
            boolean hasAttr = false;
            if (lid.hasSC()) {
                annotsAtts.addAttribute("", ATTR_SHOWCIRCLE, ATTR_SHOWCIRCLE, "CDATA", String.valueOf(lid.getSC()));
                hasAttr = true;
            }
            if (lid.hasR()) {
                annotsAtts.addAttribute("", ATTR_DIAMETER, ATTR_DIAMETER, "CDATA", String.valueOf(!lid.getR()));
                hasAttr = true;
            }
            if (hasAttr) {
                handler.startElement("", ELEM_MEASURERIMARKUP, ELEM_MEASURERIMARKUP, annotsAtts);
            } else {
                handler.startElement("", ELEM_MEASURERIMARKUP, ELEM_MEASURERIMARKUP, nullAttrs);
            }
            if (lid.hasAP()) {
                handler.startElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getAP());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASUREANNOPLANE, ELEM_MEASUREANNOPLANE);
            }
            if (lid.hasA1()) {
                handler.startElement("", ELEM_MEASURECIRCLECENTER, ELEM_MEASURECIRCLECENTER, nullAttrs);
                annotplane = XFDFUtil.toStringFromDoubleArray(lid.getA1());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_MEASURECIRCLECENTER, ELEM_MEASURECIRCLECENTER);
            }
            if (lid.hasA2()) {
                handler.startElement("", ELEM_MEASUREPOINTCIRCLE, ELEM_MEASUREPOINTCIRCLE, nullAttrs);
                String anchor2 = XFDFUtil.toStringFromDoubleArray(lid.getA2());
                handler.characters(anchor2.toCharArray(), 0, anchor2.length());
                handler.endElement("", ELEM_MEASUREPOINTCIRCLE, ELEM_MEASUREPOINTCIRCLE);
            }
            if (lid.hasN2()) {
                handler.startElement("", "anchorpartname", "anchorpartname", nullAttrs);
                String anchor2partname = lid.getN2().stringValue();
                handler.characters(anchor2partname.toCharArray(), 0, anchor2partname.length());
                handler.endElement("", "anchorpartname", "anchorpartname");
            }
            if (lid.hasA3()) {
                handler.startElement("", ELEM_MEASUREARCSTART, ELEM_MEASUREARCSTART, nullAttrs);
                String anchor1 = XFDFUtil.toStringFromDoubleArray(lid.getA3());
                handler.characters(anchor1.toCharArray(), 0, anchor1.length());
                handler.endElement("", ELEM_MEASUREARCSTART, ELEM_MEASUREARCSTART);
            }
            if (lid.hasA4()) {
                handler.startElement("", ELEM_MEASUREARCEND, ELEM_MEASUREARCEND, nullAttrs);
                String anchor1partname = XFDFUtil.toStringFromDoubleArray(lid.getA4());
                handler.characters(anchor1partname.toCharArray(), 0, anchor1partname.length());
                handler.endElement("", ELEM_MEASUREARCEND, ELEM_MEASUREARCEND);
            }
            if (lid.hasTP()) {
                handler.startElement("", "textposition", "textposition", nullAttrs);
                String textposition = XFDFUtil.toStringFromDoubleArray(lid.getTP());
                handler.characters(textposition.toCharArray(), 0, textposition.length());
                handler.endElement("", "textposition", "textposition");
            }
            if (lid.hasTX()) {
                handler.startElement("", ELEM_MEASURETEXTXDIRECTION, ELEM_MEASURETEXTXDIRECTION, nullAttrs);
                String textxdirection = XFDFUtil.toStringFromDoubleArray(lid.getTX());
                handler.characters(textxdirection.toCharArray(), 0, textxdirection.length());
                handler.endElement("", ELEM_MEASURETEXTXDIRECTION, ELEM_MEASURETEXTXDIRECTION);
            }
            if (lid.hasTY()) {
                handler.startElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION, nullAttrs);
                String textydirection = XFDFUtil.toStringFromDoubleArray(lid.getTY());
                handler.characters(textydirection.toCharArray(), 0, textydirection.length());
                handler.endElement("", ELEM_MEASURETEXTYDIRECTION, ELEM_MEASURETEXTYDIRECTION);
            }
            if (lid.hasTS()) {
                handler.startElement("", "textsize", "textsize", nullAttrs);
                String textsize = String.valueOf(lid.getTS());
                handler.characters(textsize.toCharArray(), 0, textsize.length());
                handler.endElement("", "textsize", "textsize");
            }
            if (lid.hasC()) {
                handler.startElement("", "markupcolor", "markupcolor", nullAttrs);
                String markupcolor = XFDFUtil.toStringFromDoubleArray(lid.getC());
                handler.characters(markupcolor.toCharArray(), 0, markupcolor.length());
                handler.endElement("", "markupcolor", "markupcolor");
            }
            if (lid.hasV()) {
                handler.startElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE, nullAttrs);
                String value = String.valueOf(lid.getV());
                handler.characters(value.toCharArray(), 0, value.length());
                handler.endElement("", ELEM_MEASURELVALUE, ELEM_MEASURELVALUE);
            }
            if (lid.hasU()) {
                handler.startElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS, nullAttrs);
                String units = lid.getU().stringValue();
                handler.characters(units.toCharArray(), 0, units.length());
                handler.endElement("", ELEM_MEASUREUNITS, ELEM_MEASUREUNITS);
            }
            if (lid.hasP()) {
                handler.startElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION, nullAttrs);
                String precision = String.valueOf(lid.getP());
                handler.characters(precision.toCharArray(), 0, precision.length());
                handler.endElement("", ELEM_MEASUREPRECISION, ELEM_MEASUREPRECISION);
            }
            if (lid.hasUT()) {
                handler.startElement("", "usertext", "usertext", nullAttrs);
                String usertext = lid.getUT().stringValue();
                handler.characters(usertext.toCharArray(), 0, usertext.length());
                handler.endElement("", "usertext", "usertext");
            }
            if (lid.hasEL()) {
                handler.startElement("", ELEM_MEASUREEXTENSIONLEN, ELEM_MEASUREEXTENSIONLEN, nullAttrs);
                String extlen = String.valueOf(lid.getEL());
                handler.characters(extlen.toCharArray(), 0, extlen.length());
                handler.endElement("", ELEM_MEASUREEXTENSIONLEN, ELEM_MEASUREEXTENSIONLEN);
            }
            handler.endElement("", ELEM_MEASURERIMARKUP, ELEM_MEASURERIMARKUP);
        }
    }

    protected void createComment3DElement(ContentHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, SAXException {
        if (this.measurement3D instanceof PDF3DMeasurement3DC) {
            PDF3DMeasurement3DC lid = (PDF3DMeasurement3DC)this.measurement3D;
            handler.startElement("", ELEM_MEASURECOMMEND3DMARKUP, ELEM_MEASURECOMMEND3DMARKUP, nullAttrs);
            if (lid.hasA1()) {
                handler.startElement("", ELEM_COMMENT3DANCHOR, ELEM_COMMENT3DANCHOR, nullAttrs);
                String annotplane = XFDFUtil.toStringFromDoubleArray(lid.getA1());
                handler.characters(annotplane.toCharArray(), 0, annotplane.length());
                handler.endElement("", ELEM_COMMENT3DANCHOR, ELEM_COMMENT3DANCHOR);
            }
            if (lid.hasN1()) {
                handler.startElement("", "anchorpartname", "anchorpartname", nullAttrs);
                String anchor2partname = lid.getN1().stringValue();
                handler.characters(anchor2partname.toCharArray(), 0, anchor2partname.length());
                handler.endElement("", "anchorpartname", "anchorpartname");
            }
            if (lid.hasTP()) {
                handler.startElement("", "textposition", "textposition", nullAttrs);
                String textposition = XFDFUtil.toStringFromDoubleArray(lid.getTP());
                handler.characters(textposition.toCharArray(), 0, textposition.length());
                handler.endElement("", "textposition", "textposition");
            }
            if (lid.hasTB()) {
                handler.startElement("", ELEM_COMMENT3DTEXTBOXX, ELEM_COMMENT3DTEXTBOXX, nullAttrs);
                String textxdirection = String.valueOf(lid.getTB()[0]);
                handler.characters(textxdirection.toCharArray(), 0, textxdirection.length());
                handler.endElement("", ELEM_COMMENT3DTEXTBOXX, ELEM_COMMENT3DTEXTBOXX);
            }
            if (lid.hasTB()) {
                handler.startElement("", ELEM_COMMENT3DTEXTBOXY, ELEM_COMMENT3DTEXTBOXY, nullAttrs);
                String textydirection = String.valueOf(lid.getTB()[1]);
                handler.characters(textydirection.toCharArray(), 0, textydirection.length());
                handler.endElement("", ELEM_COMMENT3DTEXTBOXY, ELEM_COMMENT3DTEXTBOXY);
            }
            if (lid.hasTS()) {
                handler.startElement("", "textsize", "textsize", nullAttrs);
                String textsize = String.valueOf(lid.getTS());
                handler.characters(textsize.toCharArray(), 0, textsize.length());
                handler.endElement("", "textsize", "textsize");
            }
            if (lid.hasC()) {
                handler.startElement("", "markupcolor", "markupcolor", nullAttrs);
                String markupcolor = XFDFUtil.toStringFromDoubleArray(lid.getC());
                handler.characters(markupcolor.toCharArray(), 0, markupcolor.length());
                handler.endElement("", "markupcolor", "markupcolor");
            }
            if (lid.hasUT()) {
                handler.startElement("", "usertext", "usertext", nullAttrs);
                String usertext = lid.getUT().stringValue();
                handler.characters(usertext.toCharArray(), 0, usertext.length());
                handler.endElement("", "usertext", "usertext");
            }
            handler.endElement("", ELEM_MEASURECOMMEND3DMARKUP, ELEM_MEASURECOMMEND3DMARKUP);
        }
    }

    public void setMeasurementcomment(String measurementcomment) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.measurementCommentName = measurementcomment;
        for (int i = 0; i < this.arr3DC.size(); ++i) {
            PDFExData exdata;
            if (!((PDF3DMeasurement)this.arr3DC.get(i)).getTRL().stringValue().equals(this.measurementCommentName) || !((exdata = this.markup.getExData()) instanceof PDF3DExData3DM)) continue;
            ((PDF3DExData3DM)exdata).setM3DREF((PDF3DMeasurement)this.arr3DC.get(i));
        }
    }

    public String getMeasurementcomment() {
        return this.measurementCommentName;
    }

    void createPDF3DMeasurement(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (!fromStartEle && elemType.equals(ELEM_MEASURENAME) && value != null) {
            this.measureCommentName = value.trim();
        }
        if (fromStartEle && elemType.equals(ELEM_MEASURECOMMEND3DMARKUP)) {
            this.createPDFComment3D(elemType, value, elemAttrs, fromStartEle);
            this.creatingComment3D = true;
        }
        if (this.creatingComment3D) {
            this.createPDFComment3D(elemType, value, elemAttrs, fromStartEle);
        }
        if (!fromStartEle && elemType.equals(ELEM_MEASURECOMMEND3DMARKUP)) {
            if (this.ml == null) {
                this.ml = PDF3DMeasurementList.newInstance((PDFDocument)this.markup.getPDFDocument());
            }
            PDF3DMeasurement3DC m3DC = PDF3DMeasurement3DC.newInstance((PDFDocument)this.markup.getPDFDocument(), (double[])this.a1, (double[])this.tp);
            if (this.markupColor != null) {
                m3DC.setC(this.markupColor);
            }
            m3DC.setTB(new double[]{this.textboxX, this.textboxY});
            m3DC.setTS(this.textSize);
            if (this.userText != null) {
                m3DC.setUT(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.userText));
            }
            if (this.measureCommentName != null) {
                m3DC.setTRL(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.measureCommentName));
            }
            if (this.partName != null) {
                m3DC.setN1(this.partName);
            }
            m3DC.setType();
            m3DC.setC(this.markupColor);
            m3DC.setS(this.markup.getCosDictionary());
            this.arr3DC.add(m3DC);
            this.ml.add((PDFCosObjectContainer)m3DC);
            if (this.newView != null) {
                this.newView.setMA(this.ml);
            }
            this.creatingComment3D = false;
        }
        if (fromStartEle && elemType.equals(ELEM_MEASUREAIMARKUP)) {
            this.createPDFAngularMarkup(elemType, value, elemAttrs, fromStartEle);
            this.creatingAngularMarkup = true;
        }
        if (this.creatingAngularMarkup) {
            this.createPDFAngularMarkup(elemType, value, elemAttrs, fromStartEle);
        }
        if (!fromStartEle && elemType.equals(ELEM_MEASUREAIMARKUP)) {
            if (this.ml == null) {
                this.ml = PDF3DMeasurementList.newInstance((PDFDocument)this.markup.getPDFDocument());
            }
            PDF3DMeasurementAD3 ai3DC = PDF3DMeasurementAD3.newInstance((PDFDocument)this.markup.getPDFDocument(), (double[])this.ap, (double[])this.a1, (double[])this.d1, (double[])this.a2, (double[])this.d2, (double[])this.textPosAI, (double[])this.tx, (double[])this.ty, (double)this.measureVal);
            if (this.markupColorAI != null) {
                ai3DC.setC(this.markupColorAI);
            }
            ai3DC.setDR(this.dr);
            ai3DC.setTS(this.textSz);
            this.ml.add((PDFCosObjectContainer)ai3DC);
            if (this.userText != null) {
                ai3DC.setUT(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.userText));
            }
            if (this.measureCommentName != null) {
                ai3DC.setTRL(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.measureCommentName));
            }
            if (this.partName1 != null) {
                ai3DC.setN1(this.partName1);
            }
            if (this.partName2 != null) {
                ai3DC.setN2(this.partName2);
            }
            ai3DC.setP(this.precisionAI);
            ai3DC.setUT(this.userTextAI);
            ai3DC.setType();
            ai3DC.setS(this.markup.getCosDictionary());
            this.newView.setMA(this.ml);
            this.arr3DC.add(ai3DC);
            this.creatingAngularMarkup = false;
        }
        if (fromStartEle && elemType.equals(ELEM_MEASURELIMARKUP)) {
            this.createPDFLinearMarkup(elemType, value, fromStartEle);
            this.creatingLinearMarkup = true;
        }
        if (this.creatingLinearMarkup) {
            this.createPDFLinearMarkup(elemType, value, fromStartEle);
        }
        if (!fromStartEle && elemType.equals(ELEM_MEASURELIMARKUP)) {
            if (this.ml == null) {
                this.ml = PDF3DMeasurementList.newInstance((PDFDocument)this.markup.getPDFDocument());
            }
            PDF3DMeasurementLD3 li3DC = PDF3DMeasurementLD3.newInstance((PDFDocument)this.markup.getPDFDocument(), (double[])this.ap, (double[])this.a1, (double[])this.a2, (double[])this.textPosLI, (double[])this.ty, (double)this.measureVal, (PDFText)this.unitsLI);
            if (this.markupColorLI != null) {
                li3DC.setC(this.markupColorLI);
            }
            li3DC.setTS(this.textSize);
            this.ml.add((PDFCosObjectContainer)li3DC);
            if (this.measureCommentName != null) {
                li3DC.setTRL(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.measureCommentName));
            }
            if (this.partName1 != null) {
                li3DC.setN1(this.partName1);
            }
            if (this.partName2 != null) {
                li3DC.setN2(this.partName2);
            }
            li3DC.setType();
            li3DC.setP(this.precision);
            li3DC.setUT(this.userTextLI);
            li3DC.setS(this.markup.getCosDictionary());
            this.newView.setMA(this.ml);
            this.arr3DC.add(li3DC);
            this.creatingLinearMarkup = false;
        }
        if (fromStartEle && elemType.equals(ELEM_MEASURERIMARKUP)) {
            this.createPDFRadialMarkup(elemType, value, elemAttrs, fromStartEle);
            this.creatingRadialMarkup = true;
        }
        if (this.creatingRadialMarkup) {
            this.createPDFRadialMarkup(elemType, value, elemAttrs, fromStartEle);
        }
        if (!fromStartEle && elemType.equals(ELEM_MEASURERIMARKUP)) {
            if (this.ml == null) {
                this.ml = PDF3DMeasurementList.newInstance((PDFDocument)this.markup.getPDFDocument());
            }
            PDF3DMeasurementRD3 ri3DC = PDF3DMeasurementRD3.newInstance((PDFDocument)this.markup.getPDFDocument(), (double[])this.ap, (double[])this.a1, (double[])this.a2, (double[])this.textPosRI, (double[])this.tx, (double[])this.ty, (double)this.measureVal);
            if (this.markupColorLI != null) {
                ri3DC.setC(this.markupColorLI);
            }
            ri3DC.setTS(this.textSize);
            this.ml.add((PDFCosObjectContainer)ri3DC);
            if (this.measureCommentName != null) {
                ri3DC.setTRL(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.measureCommentName));
            }
            if (this.a3 != null) {
                ri3DC.setA3(this.a3);
            }
            if (this.a4 != null) {
                ri3DC.setA4(this.a4);
            }
            if (this.partName2 != null) {
                ri3DC.setN2(this.partName2);
            }
            if (this.units != null) {
                ri3DC.setU(this.units);
            }
            if (this.userTextRI != null) {
                ri3DC.setUT(this.userTextRI);
            }
            if (this.markupColorRI != null) {
                ri3DC.setC(this.markupColorRI);
            }
            ri3DC.setSC(this.sc);
            ri3DC.setR(!this.rad);
            ri3DC.setP(this.precision);
            ri3DC.setEL(this.el);
            ri3DC.setTS(this.textSz);
            ri3DC.setType();
            ri3DC.setS(this.markup.getCosDictionary());
            this.newView.setMA(this.ml);
            this.arr3DC.add(ri3DC);
            this.creatingRadialMarkup = false;
        }
        if (fromStartEle && elemType.equals(ELEM_MEASUREPIMARKUP)) {
            this.createPDFPerpendicularMarkup(elemType, value, fromStartEle);
            this.creatingPerpendicularMarkup = true;
        }
        if (this.creatingPerpendicularMarkup) {
            this.createPDFPerpendicularMarkup(elemType, value, fromStartEle);
        }
        if (!fromStartEle && elemType.equals(ELEM_MEASUREPIMARKUP)) {
            if (this.ml == null) {
                this.ml = PDF3DMeasurementList.newInstance((PDFDocument)this.markup.getPDFDocument());
            }
            PDF3DMeasurementPD3 pi3DC = PDF3DMeasurementPD3.newInstance((PDFDocument)this.markup.getPDFDocument(), (double[])this.ap, (double[])this.a1, (double[])this.a2, (double[])this.d1, (double[])this.textPosPI, (double[])this.ty, (double)this.measureVal, (PDFText)this.units);
            if (this.markupColorPI != null) {
                pi3DC.setC(this.markupColorPI);
            }
            pi3DC.setTS(this.textSize);
            this.ml.add((PDFCosObjectContainer)pi3DC);
            if (this.measureCommentName != null) {
                pi3DC.setTRL(PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)this.measureCommentName));
            }
            if (this.partName1 != null) {
                pi3DC.setN1(this.partName1);
            }
            if (this.partName2 != null) {
                pi3DC.setN2(this.partName2);
            }
            if (this.userTextPI != null) {
                pi3DC.setUT(this.userTextPI);
            }
            if (this.markupColorRI != null) {
                pi3DC.setC(this.markupColorRI);
            }
            pi3DC.setTS(this.textSz);
            pi3DC.setP(this.precision);
            pi3DC.setType();
            pi3DC.setS(this.markup.getCosDictionary());
            this.newView.setMA(this.ml);
            this.arr3DC.add(pi3DC);
            this.creatingPerpendicularMarkup = false;
        }
    }

    private void createPDFPerpendicularMarkup(String elemType, String value, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_MEASUREANNOPLANE)) {
                this.ap = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1)) {
                this.a1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1PARTNAME)) {
                this.partName1 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals(ELEM_MEASUREANCHOR2)) {
                this.a2 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR2PARTNAME)) {
                this.partName2 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("textposition")) {
                this.textPosPI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREUPIDIR)) {
                this.d1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTYDIRECTION)) {
                this.ty = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("textsize")) {
                this.textSz = new Double(value.trim());
            } else if (elemType.equals("markupcolor")) {
                this.markupColorPI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURELVALUE)) {
                this.measureVal = new Double(value.trim());
            } else if (elemType.equals(ELEM_MEASUREPRECISION)) {
                this.precision = Integer.parseInt(value.trim());
            } else if (elemType.equals("usertext")) {
                this.userTextPI = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals(ELEM_MEASUREUNITS)) {
                this.units = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            }
        }
    }

    private void createPDFLinearMarkup(String elemType, String value, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_MEASUREANNOPLANE)) {
                this.ap = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1)) {
                this.a1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1PARTNAME)) {
                this.partName1 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals(ELEM_MEASUREANCHOR2)) {
                this.a2 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR2PARTNAME)) {
                this.partName2 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("textposition")) {
                this.textPosLI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTYDIRECTION)) {
                this.ty = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("textsize")) {
                this.textSz = new Double(value.trim());
            } else if (elemType.equals("markupcolor")) {
                this.markupColorLI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURELVALUE)) {
                this.measureVal = new Double(value.trim());
            } else if (elemType.equals(ELEM_MEASUREPRECISION)) {
                this.precision = Integer.parseInt(value.trim());
            } else if (elemType.equals("usertext")) {
                this.userTextLI = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals(ELEM_MEASUREUNITS)) {
                this.unitsLI = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            }
        }
    }

    private void createPDFRadialMarkup(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fromStartEle && elemAttrs != null && elemType.equals(ELEM_MEASURERIMARKUP)) {
            int attrInd;
            if (elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_SHOWCIRCLE, elemAttrs)) != -1) {
                this.sc = Boolean.valueOf(elemAttrs.getValue(attrInd));
            }
            if ((attrInd = XFDFAnnotation.findAttribute(ATTR_DIAMETER, elemAttrs)) != -1) {
                this.rad = Boolean.valueOf(elemAttrs.getValue(attrInd));
            }
        }
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_MEASUREANNOPLANE)) {
                this.ap = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURECIRCLECENTER)) {
                this.a1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREPOINTCIRCLE)) {
                this.a2 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREARCSTART)) {
                this.a3 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREARCEND)) {
                this.a4 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("anchorpartname")) {
                this.partName2 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("textposition")) {
                this.textPosRI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTXDIRECTION)) {
                this.tx = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTYDIRECTION)) {
                this.ty = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("textsize")) {
                this.textSz = new Double(value.trim());
            } else if (elemType.equals("markupcolor")) {
                this.markupColorRI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURELVALUE)) {
                this.measureVal = new Double(value.trim());
            } else if (elemType.equals(ELEM_MEASUREPRECISION)) {
                this.precision = Integer.parseInt(value.trim());
            } else if (elemType.equals(ELEM_MEASUREEXTENSIONLEN)) {
                this.el = new Double(value.trim());
            } else if (elemType.equals("textsize")) {
                this.textSz = new Double(value.trim());
            } else if (elemType.equals(ELEM_MEASUREUNITS)) {
                this.units = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("usertext")) {
                this.userTextRI = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            }
        }
    }

    private void createPDFAngularMarkup(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int attrInd;
        if (fromStartEle && elemAttrs != null && elemType.equals(ELEM_MEASUREAIMARKUP) && elemAttrs != null && (attrInd = XFDFAnnotation.findAttribute(ATTR_MEASURERADIANS, elemAttrs)) != -1) {
            this.dr = Boolean.valueOf(elemAttrs.getValue(attrInd));
        }
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_MEASUREANNOPLANE)) {
                this.ap = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1)) {
                this.a1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR1PARTNAME)) {
                this.partName1 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals(ELEM_MEASUREANCHOR2)) {
                this.a2 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREANCHOR2PARTNAME)) {
                this.partName2 = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("textposition")) {
                this.textPosAI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASUREUPLIDIR1)) {
                this.d1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("leaderdirection2")) {
                this.d2 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTXDIRECTION)) {
                this.tx = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURETEXTYDIRECTION)) {
                this.ty = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("textsize")) {
                this.textSz = new Double(value.trim());
            } else if (elemType.equals("markupcolor")) {
                this.markupColorAI = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_MEASURELVALUE)) {
                this.measureVal = new Double(value.trim());
            } else if (elemType.equals(ELEM_MEASUREPRECISION)) {
                this.precisionAI = Integer.parseInt(value.trim());
            } else if (elemType.equals("usertext")) {
                this.userTextAI = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            }
        }
    }

    void createPDFComment3D(String elemType, String value, Attributes elemAttrs, boolean fromStartEle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!fromStartEle && value != null) {
            if (elemType.equals(ELEM_COMMENT3DANCHOR)) {
                this.a1 = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("textposition")) {
                this.tp = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals("anchorpartname")) {
                this.partName = PDFText.createString((PDFDocument)this.markup.getPDFDocument(), (String)value.trim());
            } else if (elemType.equals("markupcolor")) {
                this.markupColor = XFDFExData.stringtoArray(value.trim(), " ");
            } else if (elemType.equals(ELEM_COMMENT3DTEXTBOXX)) {
                this.textboxX = new Double(value.trim());
            } else if (elemType.equals(ELEM_COMMENT3DTEXTBOXY)) {
                this.textboxY = new Double(value.trim());
            } else if (elemType.equals("textsize")) {
                this.textSize = new Double(value.trim());
            } else if (elemType.equals("usertext")) {
                this.userText = value.trim();
            }
        }
    }
}

