/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF2PDFAnnotationReader;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.util.ArrayListStack;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XFDF2CosWriter
extends DefaultHandler {
    static final String DICT_ELEM = "DICT";
    static final String ARRAY_ELEM = "ARRAY";
    static final String STREAM_ELEM = "STREAM";
    static final String DATA_ELEM = "DATA";
    static final String FIXED_ELEM = "FIXED";
    static final String INT_ELEM = "INT";
    static final String NAME_ELEM = "NAME";
    static final String STRING_ELEM = "STRING";
    static final String BOOL_ELEM = "BOOL";
    static final String XREFINDIRECT_ATTR = "XFDFINDIRECTREF_";
    static final String KEY_ATTR = "KEY";
    static final String VAL_ATTR = "VAL";
    static final String REF_ATTR = "REF";
    static final String MODE_ATTR = "MODE";
    static final String RAW_ATTR = "RAW";
    static final String HEX_ATTR = "HEX";
    static final String ASCII_ATTR = "ASCII";
    static final String ENCODING_ATTR = "ENCODING";
    static final String FILTER_ATTR = "FILTER";
    private ArrayListStack mParents = new ArrayListStack();
    private boolean mTopElement;
    private CosDocument mDoc;
    private Map mAllXRefs;
    private OutputByteStream mData;
    private StringBuilder mString;
    private ASName mStringKey;
    private boolean mRawMode;
    private boolean mHexMode;
    private boolean mHaveLeftOverHexDigit;
    private char mLeftOverHexDigit;

    public XFDF2CosWriter(XFDFAnnotation stampAnnot) throws PDFInvalidParameterException {
        this.mAllXRefs = new HashMap(1000);
        PDFAnnotation pdfAnnot = stampAnnot.pdfAnnot;
        if (pdfAnnot == null) {
            throw new PDFInvalidParameterException("Stamp Annotation does not have a parent");
        }
        this.mParents.push((Object)pdfAnnot.getCosObject());
        this.mDoc = pdfAnnot.getPDFDocument().getCosDocument();
        this.mData = null;
        this.mString = null;
        this.mStringKey = null;
    }

    public XFDF2CosWriter(XFDFAnnotation stampAnnot, XFDF2CosWriter previousHandler) throws PDFInvalidParameterException {
        this.mAllXRefs = previousHandler.mAllXRefs;
        PDFAnnotation pdfAnnot = stampAnnot.pdfAnnot;
        if (pdfAnnot == null) {
            throw new PDFInvalidParameterException("Stamp Annotation does not have a parent");
        }
        this.mParents.push((Object)pdfAnnot.getCosObject());
        this.mDoc = pdfAnnot.getPDFDocument().getCosDocument();
        this.mData = null;
        this.mString = null;
        this.mStringKey = null;
    }

    private String getXReferenceNumber(Attributes attributes) {
        for (int attrInd = 0; attrInd < attributes.getLength(); ++attrInd) {
            int xrefInd = -1;
            xrefInd = attributes.getLocalName(attrInd).indexOf(XREFINDIRECT_ATTR);
            if (xrefInd < 0 || xrefInd >= XREFINDIRECT_ATTR.length()) continue;
            return attributes.getLocalName(attrInd).substring(XREFINDIRECT_ATTR.length());
        }
        return null;
    }

    private ASName getKey(Attributes attributes) {
        int keyInd = XFDFAnnotation.findAttribute(KEY_ATTR, attributes);
        return keyInd < 0 ? null : ASName.create((String)attributes.getValue(keyInd));
    }

    private String getVal(Attributes attributes) {
        int keyInd = XFDFAnnotation.findAttribute(VAL_ATTR, attributes);
        return keyInd < 0 ? null : attributes.getValue(keyInd);
    }

    private void populate(ASName key, CosObject cosObj) throws SAXException {
        block5: {
            Object topObj = this.mParents.peek();
            try {
                if (topObj instanceof CosDictionary) {
                    if (key == null) {
                        throw new SAXException("Key for the parent dictionary is not defined");
                    }
                    ((CosDictionary)topObj).put(key, cosObj);
                    break block5;
                }
                if (topObj instanceof CosArray) {
                    ((CosArray)topObj).add(cosObj);
                    break block5;
                }
                throw new SAXException("Cannot add Cos object to the parent element");
            }
            catch (PDFException e) {
                throw new SAXException("Cannot add Cos object to the parent element", (Exception)((Object)e));
            }
        }
    }

    private void container2Cos(ContainerOperations operations, Attributes elemAttrs) throws SAXException {
        CosObject curContainer = null;
        boolean isRef = false;
        String xRef = this.getXReferenceNumber(elemAttrs);
        if (xRef != null) {
            Object curRef = this.mAllXRefs.get(xRef);
            if (curRef != null) {
                if (!operations.isCorrectType(curRef)) {
                    throw new SAXException("Indirectly referenced object is not of an expected type");
                }
                curContainer = (CosObject)curRef;
            }
            isRef = true;
        } else {
            int refInd = XFDFAnnotation.findAttribute(REF_ATTR, elemAttrs);
            if (refInd >= 0) {
                xRef = elemAttrs.getValue(refInd);
                Object refObj = this.mAllXRefs.get(xRef);
                if (refObj != null) {
                    if (operations.getSize(refObj) < 0) {
                        throw new SAXException("Referenced element is of wrong type");
                    }
                    curContainer = (CosObject)refObj;
                }
                isRef = true;
            }
        }
        if (curContainer == null) {
            curContainer = operations.makeContainer();
        }
        if (isRef) {
            this.mAllXRefs.put(xRef, curContainer);
        }
        if (curContainer != null) {
            ASName key = this.getKey(elemAttrs);
            this.populate(key, curContainer);
            this.mParents.push((Object)curContainer);
        }
    }

    private void number2Cos(Attributes elemAttrs) throws SAXException {
        ASName key = this.getKey(elemAttrs);
        String numberStr = this.getVal(elemAttrs);
        if (numberStr != null) {
            Number number = numberStr.indexOf(46) < 0 ? (Number)Integer.valueOf(numberStr) : (Number)Double.valueOf(numberStr);
            CosNumeric cosNum = this.mDoc.createCosNumeric(number);
            this.populate(key, (CosObject)cosNum);
        }
    }

    private void name2Cos(Attributes elemAttrs) throws SAXException {
        ASName key = this.getKey(elemAttrs);
        String nameStr = this.getVal(elemAttrs);
        if (nameStr != null) {
            CosName cosName = this.mDoc.createCosName(ASName.create((String)nameStr));
            this.populate(key, (CosObject)cosName);
        }
    }

    private void bool2Cos(Attributes elemAttrs) throws SAXException {
        ASName key = this.getKey(elemAttrs);
        String str = this.getVal(elemAttrs);
        if (str != null) {
            CosBoolean cosBool = this.mDoc.createCosBoolean(Boolean.valueOf(str));
            this.populate(key, (CosObject)cosBool);
        }
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.mTopElement = true;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.mData != null) {
            try {
                if (this.mHexMode) {
                    if (XFDF2PDFAnnotationReader.copyHexString(this.mHaveLeftOverHexDigit, this.mLeftOverHexDigit, buf, offset, len, this.mData)) {
                        this.mLeftOverHexDigit = buf[offset + len - 1];
                        this.mHaveLeftOverHexDigit = true;
                    }
                    this.mHaveLeftOverHexDigit = false;
                }
                try {
                    byte[] dataChunk = PDFDocEncoding.encode((String)new String(buf, offset, len));
                    this.mData.write(dataChunk);
                }
                catch (CharacterCodingException e) {
                    throw new SAXException("Illegal DATA content", e);
                }
                catch (IOException e) {
                    throw new SAXException("IO error writing data", e);
                }
            }
            catch (PDFException e) {
                throw new SAXException("Cannot create data stream", (Exception)((Object)e));
            }
        } else if (this.mStringKey != null) {
            this.mString.append(buf, offset, len);
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
        if (this.mTopElement && !sName.equals(DICT_ELEM)) {
            throw new SAXException("Top element is not <DICT>");
        }
        this.mTopElement = false;
        if (this.mData != null) {
            throw new SAXException("Element in the middle of the stream data");
        }
        if (DICT_ELEM.equals(sName)) {
            this.container2Cos(new DictionaryOperations(), elemAttrs);
        } else if (STREAM_ELEM.equals(sName)) {
            this.container2Cos(new StreamOperations(), elemAttrs);
        } else if (ARRAY_ELEM.equals(sName)) {
            this.container2Cos(new ArrayOperations(), elemAttrs);
        } else if (INT_ELEM.equals(sName) || FIXED_ELEM.equals(sName)) {
            this.number2Cos(elemAttrs);
        } else if (NAME_ELEM.equals(sName)) {
            this.name2Cos(elemAttrs);
        } else if (STRING_ELEM.equals(sName)) {
            int modeInd = XFDFAnnotation.findAttribute(ENCODING_ATTR, elemAttrs);
            if (modeInd >= 0) {
                this.mHexMode = HEX_ATTR.equals(elemAttrs.getValue(modeInd));
            }
            this.mStringKey = this.getKey(elemAttrs);
            if (this.mString == null) {
                this.mString = new StringBuilder(10000);
            }
        } else if (BOOL_ELEM.equals(sName)) {
            this.bool2Cos(elemAttrs);
        } else if (DATA_ELEM.equals(sName)) {
            Object parent = this.mParents.peek();
            if (!(parent instanceof CosStream)) {
                throw new SAXException("stream data element does not have a stream as its parent");
            }
            try {
                this.mData = this.mDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 10000L);
            }
            catch (IOException e) {
                throw new SAXException("Cannot create data stream", e);
            }
            int modeInd = XFDFAnnotation.findAttribute(MODE_ATTR, elemAttrs);
            this.mRawMode = modeInd < 0 ? false : RAW_ATTR.equals(elemAttrs.getValue(modeInd));
            modeInd = XFDFAnnotation.findAttribute(ENCODING_ATTR, elemAttrs);
            this.mHexMode = modeInd < 0 ? false : HEX_ATTR.equals(elemAttrs.getValue(modeInd));
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        Object parent = this.mParents.peek();
        if (DATA_ELEM.equals(sName)) {
            if (!(parent instanceof CosStream)) {
                throw new SAXException("stream data element does not have a stream as its parent");
            }
            try {
                if (this.mRawMode) {
                    ((CosStream)parent).newDataEncoded(this.mData.closeAndConvert());
                } else {
                    ((CosStream)parent).newDataDecoded(this.mData.closeAndConvert());
                }
                this.mData = null;
            }
            catch (IOException e) {
                throw new SAXException("IO erro when creating data stream", e);
            }
            catch (PDFException e) {
                throw new SAXException("Cannot create data stream", (Exception)((Object)e));
            }
        } else if (STRING_ELEM.equals(sName)) {
            if (this.mStringKey != null && this.mString.length() != 0) {
                CosString cosStr = null;
                String str = this.mString.toString();
                if (this.mHexMode) {
                    byte[] hexStr = StringOps.convertFromHex((String)str);
                    if (hexStr != null) {
                        cosStr = this.mDoc.createCosString(hexStr);
                    }
                } else {
                    cosStr = this.mDoc.createCosString(str);
                }
                if (cosStr != null) {
                    this.populate(this.mStringKey, (CosObject)cosStr);
                }
                this.mString.setLength(0);
                this.mStringKey = null;
            }
        } else if (DICT_ELEM.equals(sName) || STREAM_ELEM.equals(sName) || ARRAY_ELEM.equals(sName)) {
            this.mParents.pop();
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException err) throws SAXParseException {
        throw err;
    }

    private class ArrayOperations
    implements ContainerOperations {
        private ArrayOperations() {
        }

        @Override
        public int getSize(Object container) {
            return this.isCorrectType(container) ? ((CosArray)container).size() : -1;
        }

        @Override
        public boolean isCorrectType(Object cosObj) {
            return cosObj instanceof CosArray;
        }

        @Override
        public CosObject makeContainer() throws SAXException {
            try {
                return XFDF2CosWriter.this.mDoc.createCosArray();
            }
            catch (PDFException e) {
                throw new SAXException("Cannot create Cos array", (Exception)((Object)e));
            }
        }
    }

    private class StreamOperations
    implements ContainerOperations {
        private StreamOperations() {
        }

        @Override
        public int getSize(Object container) {
            return this.isCorrectType(container) ? ((CosStream)container).size() : -1;
        }

        @Override
        public boolean isCorrectType(Object cosObj) {
            return cosObj instanceof CosStream;
        }

        @Override
        public CosObject makeContainer() throws SAXException {
            try {
                return XFDF2CosWriter.this.mDoc.createCosStream();
            }
            catch (PDFException e) {
                throw new SAXException("Cannot create Cos dictionary", (Exception)((Object)e));
            }
        }
    }

    private class DictionaryOperations
    implements ContainerOperations {
        private DictionaryOperations() {
        }

        @Override
        public int getSize(Object container) {
            return this.isCorrectType(container) ? ((CosDictionary)container).size() : -1;
        }

        @Override
        public boolean isCorrectType(Object cosObj) {
            return cosObj instanceof CosDictionary;
        }

        @Override
        public CosObject makeContainer() throws SAXException {
            try {
                return XFDF2CosWriter.this.mDoc.createCosDictionary();
            }
            catch (PDFException e) {
                throw new SAXException("Cannot create Cos dictionary", (Exception)((Object)e));
            }
        }
    }

    private static interface ContainerOperations {
        public CosObject makeContainer() throws SAXException;

        public boolean isCorrectType(Object var1);

        public int getSize(Object var1);
    }
}

