/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFFieldList;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import java.io.IOException;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

final class PDF2XFDFFormsReader
implements XMLReader {
    ContentHandler handler;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String rootElement = "xfdf";
    static final String secondRoot = "fields";
    static final String ELEM_IDS = "ids";
    private PDFInteractiveForm iform;
    private String ATTR_NAME = "name";
    private String ELEM_FIELD = "field";

    public PDF2XFDFFormsReader(PDFInteractiveForm iform) {
        this.iform = iform;
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        XFDFFieldList forms;
        if (this.handler == null) {
            throw new SAXException("No content handler");
        }
        try {
            forms = this.iform != null ? new XFDFFieldList((List)this.iform.getChildren()) : null;
        }
        catch (PDFIOException e) {
            IOException newException = new IOException("Invalid Acroform");
            newException.initCause(e);
            throw newException;
        }
        catch (PDFException e) {
            throw new SAXException("Invalid Acroform", (Exception)((Object)e));
        }
        this.handler.startDocument();
        this.handler.startElement("http://ns.adobe.com/xfdf/", rootElement, rootElement, XFDFUtil.createXFDFAttributes());
        this.handler.startElement("http://ns.adobe.com/xfdf/", secondRoot, secondRoot, nullAtts);
        if (forms != null && !forms.isEmpty()) {
            this.outputIForm(forms);
        }
        this.handler.endElement("http://ns.adobe.com/xfdf/", secondRoot, secondRoot);
        if (this.iform != null) {
            try {
                this.handler.startElement("http://ns.adobe.com/xfdf/", ELEM_IDS, ELEM_IDS, XFDFUtil.createTrailerAttributes(this.iform.getPDFDocument()));
                this.handler.endElement("http://ns.adobe.com/xfdf/", ELEM_IDS, ELEM_IDS);
            }
            catch (PDFException e) {
                throw new SAXException("parsing error", (Exception)((Object)e));
            }
        }
        this.handler.endElement("http://ns.adobe.com/xfdf/", rootElement, rootElement);
        this.handler.endDocument();
    }

    private void outputIForm(XFDFFieldList forms) throws IOException, SAXException {
        try {
            for (Object nextForm : forms) {
                if (nextForm instanceof PDFFieldSignature) continue;
                String fieldName = null;
                if (nextForm instanceof XFDFFieldList) {
                    fieldName = ((XFDFFieldList)nextForm).getName();
                } else if (nextForm instanceof PDFField) {
                    if (!((PDFField)nextForm).noExport()) {
                        fieldName = ((PDFField)nextForm).getPartialName();
                    }
                } else {
                    throw new RuntimeException("Invalid Acroform");
                }
                if (fieldName == null) continue;
                AttributesImpl nameAtts = new AttributesImpl();
                nameAtts.addAttribute(nsu, this.ATTR_NAME, this.ATTR_NAME, "CDATA", XFDFFieldList.getBaseFieldName(fieldName));
                this.handler.startElement(nsu, this.ELEM_FIELD, this.ELEM_FIELD, nameAtts);
                boolean gotValue = false;
                if (nextForm instanceof PDFField) {
                    PDFField formField = (PDFField)nextForm;
                    gotValue |= this.outputValues(formField);
                    gotValue |= this.outputValue("value_richtext", formField.getValueRichText());
                }
                if (!gotValue && nextForm instanceof XFDFFieldList) {
                    this.outputIForm((XFDFFieldList)nextForm);
                }
                this.handler.endElement(nsu, this.ELEM_FIELD, this.ELEM_FIELD);
            }
        }
        catch (PDFIOException e) {
            throw new SAXException("Invalid Acroform", (Exception)((Object)e));
        }
        catch (PDFException e) {
            IOException newException = new IOException("Invalid Acroform");
            newException.initCause(e);
            throw newException;
        }
    }

    private boolean outputValues(PDFField formField) throws IOException, SAXException {
        try {
            boolean gotValue = false;
            List formValueList = formField.getValueList();
            if (formValueList == null) {
                return false;
            }
            for (String curValue : formValueList) {
                if (!(formField instanceof PDFFieldButton) || !((PDFFieldButton)formField).hasOptionList()) {
                    gotValue |= this.outputValue("value", curValue);
                    continue;
                }
                List formOptList = ((PDFFieldButton)formField).getOptionList();
                int valueIndex = this.getIndexFromString(curValue);
                if (valueIndex < 0 || valueIndex >= formOptList.size()) continue;
                gotValue |= this.outputValue("value", formOptList.get(valueIndex));
            }
            return gotValue;
        }
        catch (PDFIOException e) {
            throw new SAXException("Invalid Acroform", (Exception)((Object)e));
        }
        catch (PDFException e) {
            IOException newException = new IOException("Invalid Acroform");
            newException.initCause(e);
            throw newException;
        }
    }

    private boolean outputValue(String name, Object value) throws IOException, SAXException {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new RuntimeException("Invalid Acroform");
            }
            this.handler.startElement(nsu, name, name, nullAtts);
            this.handler.characters(((String)value).toCharArray(), 0, ((String)value).length());
            this.handler.endElement(nsu, name, name);
            return true;
        }
        return false;
    }

    private int getIndexFromString(String strIndex) {
        int intIndex;
        try {
            intIndex = Integer.parseInt(strIndex);
        }
        catch (NumberFormatException notInt) {
            intIndex = -1;
        }
        return intIndex;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }
}

