/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PDF2XFDFAnnotationsReader
implements XMLReader {
    ContentHandler handler;
    private PDFDocument mPDFDoc;
    private ArrayList<?> mAnnotsList;
    private PDFAnnotationRotationEnum rotationType = PDFAnnotationRotationEnum.NoRotate;
    static final String nsu = "";
    static final Attributes nullAtts = new AttributesImpl();
    static final String rootElement = "xfdf";
    static final String secondRoot = "annots";
    static final String ELEM_IDS = "ids";

    public PDF2XFDFAnnotationsReader(PDFDocument pdfDoc) {
        this.mPDFDoc = pdfDoc;
        this.mAnnotsList = null;
    }

    public PDF2XFDFAnnotationsReader(PDFDocument pdfDoc, PDFAnnotationRotationEnum rotationType) {
        this.mPDFDoc = pdfDoc;
        this.mAnnotsList = null;
        this.rotationType = rotationType;
    }

    public PDF2XFDFAnnotationsReader(PDFAnnotationList exportedAnnots) {
        this.mPDFDoc = exportedAnnots.getPDFDocument();
        this.mAnnotsList = new ArrayList(exportedAnnots.getArrayList());
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        if (this.handler == null) {
            throw new SAXException("No content handler");
        }
        this.handler.startDocument();
        try {
            this.HandleAnnotations(true);
        }
        catch (PDFIOException e) {
            IOException newException = new IOException("Annotations parsing error");
            newException.initCause(e);
            throw newException;
        }
        catch (PDFException e) {
            throw new SAXException("Annotations parsing error", (Exception)((Object)e));
        }
        this.handler.endDocument();
    }

    private void startAnnotations() throws PDFInvalidXMLException {
        try {
            this.handler.startElement("http://ns.adobe.com/xfdf/", rootElement, rootElement, XFDFUtil.createXFDFAttributes());
            this.handler.startElement("http://ns.adobe.com/xfdf/", secondRoot, secondRoot, nullAtts);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("Annotations parsing error", (Throwable)e);
        }
    }

    private void endAnnotations() throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        try {
            this.handler.endElement("http://ns.adobe.com/xfdf/", secondRoot, secondRoot);
            this.handler.startElement("http://ns.adobe.com/xfdf/", ELEM_IDS, ELEM_IDS, XFDFUtil.createTrailerAttributes(this.mPDFDoc));
            this.handler.endElement("http://ns.adobe.com/xfdf/", ELEM_IDS, ELEM_IDS);
            this.handler.endElement("http://ns.adobe.com/xfdf/", rootElement, rootElement);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException("Annotations parsing error", (Throwable)e);
        }
    }

    public void HandleAnnotations(boolean always) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (this.outputAnnotations(this.mPDFDoc, always)) {
            this.endAnnotations();
        }
    }

    private boolean outputAnnotations(PDFDocument doc, boolean always) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        boolean gotAnnots;
        block9: {
            gotAnnots = false;
            try {
                PDFPage curPage;
                PDFPageTree pages = doc.requirePages();
                int pageIndex = 0;
                if (always) {
                    this.startAnnotations();
                    gotAnnots = true;
                }
                while ((curPage = pages.getPage(pageIndex++)) != null) {
                    PDFAnnotationList annotations = curPage.getAnnotationList();
                    ArrayList<PDFAnnotation> annots3D = new ArrayList<PDFAnnotation>();
                    if (annotations == null) continue;
                    if (!gotAnnots) {
                        this.startAnnotations();
                        gotAnnots = true;
                    }
                    for (int annotInd = 0; annotInd < annotations.size(); ++annotInd) {
                        XFDFAnnotation curAnnot;
                        PDFAnnotation pdfAnnot = annotations.get(annotInd);
                        if (pdfAnnot == null || this.mAnnotsList != null && !this.mAnnotsList.contains(pdfAnnot)) continue;
                        if (pdfAnnot instanceof PDFAnnotation3D) {
                            annots3D.add(pdfAnnot);
                        }
                        if ((curAnnot = XFDFAnnotation.createXFDFAnnotation(pdfAnnot)) != null) {
                            curAnnot.setRotationType(this.rotationType);
                            curAnnot.setAnnot3DList(annots3D);
                            curAnnot.transformToXFDF(this.handler, pageIndex - 1);
                        }
                        if (this.mAnnotsList == null) continue;
                        this.mAnnotsList.remove(pdfAnnot);
                        if (!this.mAnnotsList.isEmpty()) {
                            continue;
                        }
                        break block9;
                    }
                }
            }
            catch (PDFInvalidXMLException e) {
                throw new RuntimeException("Unable to get annotations.", e);
            }
        }
        return gotAnnots;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }
}

