/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.template;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.ut.ExFull;

public abstract class XFAElement {
    Element element;

    public XFAElement() {
    }

    protected XFAElement(Element element) {
        this.element = element;
    }

    public Attribute getAttribute(String namespace, String name) {
        Attribute attribute = null;
        for (int i = 0; i < this.element.getNumAttrs(); ++i) {
            Attribute current = this.element.getAttr(i);
            if (!this.compareNamespaceAndName(namespace, name, current.getNS(), current.getName())) continue;
            attribute = current;
            break;
        }
        return attribute;
    }

    protected boolean compareNamespaceAndName(String soughtNamespace, String soughtName, String elementNamespace, String elementName) {
        if (!soughtName.equals(elementName)) {
            return false;
        }
        if (soughtNamespace == null) {
            return true;
        }
        return soughtNamespace.equals(elementNamespace);
    }

    public Element find(String subElementSOM, String somExpression) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            boolean lastTime = false;
            Element foundElement = null;
            Element subElement = (Element)this.element.resolveNode(subElementSOM, true, false, false);
            if (subElement == null) {
                return null;
            }
            while (!lastTime) {
                if (subElement == this.element) {
                    lastTime = true;
                }
                if ((foundElement = (Element)subElement.resolveNode(somExpression)) != null) break;
                subElement = subElement.getXMLParent();
            }
            return foundElement;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    public Element find(String subElementSOM, int[] tags) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            boolean lastTime = false;
            Element foundElement = null;
            Element subElement = (Element)this.element.resolveNode(subElementSOM, true, false, false);
            if (subElement == null) {
                return null;
            }
            while (!lastTime) {
                if (subElement == this.element) {
                    lastTime = true;
                }
                if ((foundElement = this.find(subElement, tags)) != null) break;
                subElement = subElement.getXMLParent();
            }
            return foundElement;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    public Element find(Element startElement, int[] tags) {
        Element foundElement = startElement;
        for (int i = 0; foundElement != null && i < tags.length; foundElement = foundElement.getElement(tags[i], true, 0, false, false), ++i) {
        }
        return foundElement;
    }
}

