/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class PDFXFAInput
implements XMLReader {
    final String requestedPacketInXML;
    ContentHandler mOutputHandler;
    InputStream mNewData;

    private void InsertNewData() throws PDFIOException, PDFConfigurationException {
        SAXParser saxParser;
        XFANewDataCopier ndCopier = new XFANewDataCopier();
        try {
            saxParser = XMLUtils.getNonValidatingSaxParser();
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("xfa: SAX Parser Configuration exception", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("xfa: SAX Parser Configuration exception", (Throwable)e);
        }
        try {
            saxParser.parse(this.mNewData, (DefaultHandler)ndCopier);
        }
        catch (IOException e) {
            throw new PDFIOException(" IO exception with XFA input", (Throwable)e);
        }
        catch (SAXException ex) {
            throw new PDFConfigurationException(" Sax Parse exception in InsertNewData", (Throwable)ex);
        }
    }

    public PDFXFAInput(PDFInteractiveForm form, String requestedPacketInXML, InputStream newData) {
        this.mNewData = newData;
        this.requestedPacketInXML = requestedPacketInXML;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.mOutputHandler.startDocument();
        InputStream xfaStream = input.getByteStream();
        if (xfaStream != null) {
            SAXParser saxParser;
            XFABoilerplateCopier outerdata = new XFABoilerplateCopier();
            try {
                saxParser = XMLUtils.getNonValidatingSaxParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(" SAX Parser configuration exception" + e.getMessage(), e);
            }
            saxParser.parse(xfaStream, (DefaultHandler)outerdata);
        } else {
            try {
                this.InsertNewData();
            }
            catch (PDFConfigurationException e) {
                throw new SAXException(" Configuration exception when creating new data sets" + e.getMessage(), (Exception)((Object)e));
            }
            catch (PDFIOException ex) {
                throw new SAXException(" IO exception when creating new data sets" + ex.getMessage(), (Exception)((Object)ex));
            }
        }
        this.mOutputHandler.endDocument();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.mOutputHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    class XFANewDataCopier
    extends XFAStreamCopier {
        boolean haveBP;
        boolean alreadyCopied;
        int mBPIndex;
        int targetLevel;
        int copyLevel;

        XFANewDataCopier() {
            this.mCopying = false;
            this.alreadyCopied = false;
            this.mBPIndex = 0;
        }

        @Override
        void NoteEnding(String elemName) throws SAXException {
        }

        @Override
        int StartCopyingAfterStart(String elemName) throws SAXException {
            if (this.alreadyCopied) {
                return 0;
            }
            if (this.mNestingLevel == 1) {
                if ("xdp:xdp".equals(elemName)) {
                    this.haveBP = true;
                    this.mBPIndex = 1;
                    this.targetLevel = this.mNestingLevel + 1;
                } else {
                    this.copyLevel = 0;
                    return 1;
                }
            }
            if (this.haveBP && this.mNestingLevel == this.targetLevel && elemName.equals(PDFXFAInput.this.requestedPacketInXML)) {
                ++this.mBPIndex;
                this.copyLevel = this.mNestingLevel;
                return 1;
            }
            return 0;
        }

        @Override
        boolean StartCopyingAfterEnd(String elemName) throws SAXException {
            return false;
        }

        @Override
        boolean StopCopyingBeforeStart(String elemName) throws SAXException {
            return false;
        }

        @Override
        int StopCopyingBeforeEnd(String elemName) throws SAXException {
            if (this.mNestingLevel == this.copyLevel) {
                this.alreadyCopied = true;
                return 2;
            }
            return 0;
        }
    }

    class XFABoilerplateCopier
    extends XFAStreamCopier {
        boolean dataInserted;

        XFABoilerplateCopier() {
            this.mCopying = true;
            this.dataInserted = false;
        }

        @Override
        int StartCopyingAfterStart(String elemName) throws SAXException {
            return 0;
        }

        @Override
        boolean StartCopyingAfterEnd(String elemName) throws SAXException {
            return elemName.equals(PDFXFAInput.this.requestedPacketInXML);
        }

        @Override
        int StopCopyingBeforeEnd(String elemName) throws SAXException {
            return 0;
        }

        @Override
        boolean StopCopyingBeforeStart(String elemName) throws SAXException {
            if (elemName.equals(PDFXFAInput.this.requestedPacketInXML)) {
                try {
                    PDFXFAInput.this.InsertNewData();
                }
                catch (PDFConfigurationException e) {
                    throw new SAXException(" Configuration exception when creating new data sets" + e.getMessage(), (Exception)((Object)e));
                }
                catch (PDFIOException ex) {
                    throw new SAXException(" IO exception when creating new data sets" + ex.getMessage(), (Exception)((Object)ex));
                }
                this.dataInserted = true;
                return true;
            }
            return false;
        }

        @Override
        void NoteEnding(String elemName) throws SAXException {
            if ("xdp:xdp".equals(elemName) && !this.dataInserted) {
                try {
                    PDFXFAInput.this.InsertNewData();
                }
                catch (PDFConfigurationException e) {
                    throw new SAXException(" Configuration exception when creating new data sets" + e.getMessage(), (Exception)((Object)e));
                }
                catch (PDFIOException ex) {
                    throw new SAXException(" IO exception when creating new data sets" + ex.getMessage(), (Exception)((Object)ex));
                }
                this.dataInserted = true;
            }
        }
    }

    abstract class XFAStreamCopier
    extends DefaultHandler {
        static final int s_noChange = 0;
        static final int s_changeFromThis = 1;
        static final int s_changeAfterThis = 2;
        int mNestingLevel;
        boolean mCopying;

        XFAStreamCopier() {
        }

        abstract int StartCopyingAfterStart(String var1) throws SAXException;

        abstract boolean StopCopyingBeforeStart(String var1) throws SAXException;

        abstract boolean StartCopyingAfterEnd(String var1) throws SAXException;

        abstract int StopCopyingBeforeEnd(String var1) throws SAXException;

        abstract void NoteEnding(String var1) throws SAXException;

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void setDocumentLocator(Locator l) {
        }

        @Override
        public void startDocument() throws SAXException {
            this.mNestingLevel = 0;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
            ++this.mNestingLevel;
            int copyState = 0;
            String elemName = sName;
            if (elemName == null || elemName.length() == 0) {
                elemName = qName;
            }
            if (elemName == null || elemName.length() == 0) {
                throw new SAXException(" Wrong XML structure");
            }
            if (this.mNestingLevel <= 2) {
                if (!this.mCopying) {
                    copyState = this.StartCopyingAfterStart(elemName);
                    if (copyState == 1) {
                        this.mCopying = true;
                    }
                } else if (this.StopCopyingBeforeStart(elemName)) {
                    this.mCopying = false;
                }
            }
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.startElement(namespaceURI, sName, qName, elemAttrs);
            }
            if (copyState == 2) {
                this.mCopying = true;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            int copyState = 0;
            String elemName = sName;
            if (elemName == null || elemName.length() == 0) {
                elemName = qName;
            }
            if (elemName == null || elemName.length() == 0) {
                throw new SAXException(" Wrong XML structure");
            }
            this.NoteEnding(elemName);
            if (this.mNestingLevel == 2) {
                if (this.mCopying) {
                    copyState = this.StopCopyingBeforeEnd(elemName);
                    if (copyState == 1) {
                        this.mCopying = false;
                    }
                } else if (this.StartCopyingAfterEnd(elemName)) {
                    copyState = 2;
                }
            }
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.endElement(namespaceURI, sName, qName);
            }
            if (copyState == 2) {
                this.mCopying = !this.mCopying;
            }
            --this.mNestingLevel;
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.characters(buf, offset, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.ignorableWhitespace(buf, offset, len);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.mCopying) {
                PDFXFAInput.this.mOutputHandler.processingInstruction(target, data);
            }
        }
    }
}

