/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProtocolContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProxyAuthenticationHandler;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProxyProtocolHandler;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.HostPseudoModel;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Resolver;

public class XFAPlugin {
    public static Protocol getProtocol(PDFDocument pdfDoc) {
        XFADOMServiceListener xfaDomServiceListener = (XFADOMServiceListener)pdfDoc.getListenerRegistry().getListener(XFADOMServiceListener.class);
        Protocol protocol = xfaDomServiceListener.getProtocol();
        if (protocol != null) {
            return protocol;
        }
        XFAProcessingOptions xfaProcessingOptions = xfaDomServiceListener.getXFAProcessingOptions();
        protocol = xfaProcessingOptions != null && xfaProcessingOptions.getCustomProtocol() != null ? new ProxyProtocolHandler(xfaProcessingOptions.getCustomProtocol()) : new Protocol(new ProxyAuthenticationHandler(xfaProcessingOptions != null ? xfaProcessingOptions.getCustomAuthenticationHandler() : null));
        xfaDomServiceListener.setProtocol(protocol);
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean loadXFA(DocumentContext oContext) {
        if (oContext.isRollbackDoc()) {
            oContext.getProcessingOptions().disableScriptExecution();
        }
        boolean bNotify = false;
        if (oContext.getDocReady() && oContext.getPermsReady() && !oContext.isReady() && !oContext.getXFALoading()) {
            oContext.setXFALoading(true);
            Protocol oProtocol = XFAPlugin.getProtocol(oContext.mpdDoc);
            Resolver.setProtocol((com.adobe.xfa.protocol.Protocol)oProtocol);
            ProtocolContext oProtocolContext = new ProtocolContext(oProtocol, oContext.mpdDoc);
            try {
                if (!oContext.loadAppModelFromDoc()) {
                    DocumentContext.add(oContext.mpdDoc, null);
                    boolean bl = false;
                    return bl;
                }
                oContext.setFirstTimeLoad(true);
                oContext.postLoad(true);
                oContext.setFirstTimeLoad(false);
                bNotify = true;
                FormModel oFormModel = FormModel.getFormModel((AppModel)oContext.moAppModel, (boolean)false);
                if (oFormModel != null) {
                    HostPseudoModel oHost = oFormModel.getHost();
                    oContext.eventOccurred(4915212, (Obj)oHost, oContext.getCurrentEventInfo());
                }
                oContext.setXFALoading(false);
            }
            finally {
                oProtocolContext.destroy();
            }
        }
        if (bNotify) {
            oContext.contentChanged(false);
        }
        return true;
    }

    public static void processXFA(PDFDocument pdDoc) {
        BooleanHolder bAlreadySeen = new BooleanHolder(false);
        DocumentContext oContext = DocumentContext.find(pdDoc, false, bAlreadySeen);
        if (oContext != null) {
            if (oContext.isDocDynamic(true)) {
                try {
                    PermissionsManager mgr = PermissionsManager.newInstance((PDFDocument)pdDoc);
                    mgr.isPermitted(ObjectOperations.FORM_FILLIN);
                }
                catch (PDFException e) {
                    throw new ExFull((Exception)((Object)e));
                }
            }
            XFAPlugin.loadXFA(oContext);
        }
    }

    public static void docPermsReady(PDFDocument pdd) {
        BooleanHolder bAlreadySeen = new BooleanHolder(false);
        DocumentContext oContext = DocumentContext.find(pdd, false, bAlreadySeen);
        if (oContext == null) {
            if (bAlreadySeen.value) {
                return;
            }
            oContext = DocumentContext.isXFADoc(pdd);
            if (oContext == null) {
                return;
            }
        }
        oContext.setPermsReady();
        oContext.setDocReady();
    }

    public static void docClose(PDFDocument pdd) {
        BooleanHolder bAlreadySeen = new BooleanHolder(false);
        DocumentContext oContext = DocumentContext.find(pdd, false, bAlreadySeen);
        if (oContext != null) {
            oContext.destroy();
        }
    }

    public static void PDDocWillSaveExProc(PDFDocument pdDoc) {
        DocumentContext poContext = DocumentContext.find(pdDoc, true, null);
        if (poContext == null || poContext.mbSavePDFOnly) {
            return;
        }
        FormModel oFormModel = FormModel.getFormModel((AppModel)poContext.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return;
        }
        HostPseudoModel poHost = oFormModel.getHost();
        poContext.eventOccurred(4915207, (Obj)poHost, poContext.getCurrentEventInfo());
    }

    public static void PDDocDidSaveProc(PDFDocument pdd) {
        DocumentContext poContext = DocumentContext.find(pdd, true, null);
        if (poContext == null || poContext.mbSavePDFOnly) {
            return;
        }
        poContext.setPermsReady();
        FormModel oFormModel = FormModel.getFormModel((AppModel)poContext.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return;
        }
        HostPseudoModel poHost = oFormModel.getHost();
        poContext.eventOccurred(4915208, (Obj)poHost, poContext.getCurrentEventInfo());
        if (oFormModel.isDirty()) {
            oFormModel.hasChanged(false);
        }
    }

    public static boolean setNeedAppearancesToExplicitFalse_EmptyVKeyHack(PDFDocument pdDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode firstNode;
        PDFFieldList fieldsList;
        boolean bRetval = false;
        PDFInteractiveForm iForm = pdDoc.getInteractiveForm();
        if (iForm != null && (fieldsList = iForm.getChildren(true)) != null && fieldsList.size() > 0 && (firstNode = (PDFFieldNode)fieldsList.get(0)) != null && !firstNode.getCosDictionary().containsKey((Object)ASName.k_V)) {
            firstNode.setStringValue("");
            bRetval = true;
        }
        return bRetval;
    }

    public static String getSOMExpressionForFormFieldImplementation(PDFDocument pdd, String astName) {
        DocumentContext poContext = DocumentContext.find(pdd, true, null);
        if (poContext == null) {
            return null;
        }
        if (astName == null || astName.length() == 0) {
            return null;
        }
        FormModel oFormModel = FormModel.getFormModel((AppModel)poContext.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return null;
        }
        String sFormSOM = "$form.." + astName;
        Node oTreeNode = poContext.moAppModel.resolveNode(sFormSOM);
        if (oTreeNode != null && oTreeNode instanceof FormField) {
            String sSOM = oTreeNode.getSOMExpression((Node)oFormModel, false);
            return sSOM;
        }
        return null;
    }
}

