/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProtocolContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.UnsupportedEncodingException;

public class ServerExchange
extends FormModel.ServerExchange {
    private DocumentContext moDocContext;

    public ServerExchange(DocumentContext oDocContext) {
        this.moDocContext = oDocContext;
    }

    public byte[] sendToServer(byte[] sXDPString) {
        String sUrl;
        String string = sUrl = this.moDocContext == null ? "" : this.moDocContext.getSubmitUrl();
        if (StringUtils.isEmpty((CharSequence)sUrl)) {
            MsgFormatPos oErr = new MsgFormatPos(ResId.PROTOCOL_ERR_POST);
            oErr.format(sUrl);
            throw new ExFull(oErr.resId(), oErr.toString());
        }
        String sContentType = "text/xml";
        String sEnc = "UTF-8";
        String sHeader = null;
        String sData = null;
        try {
            sData = new String(sXDPString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported.", e);
        }
        Protocol oProtocol = XFAPlugin.getProtocol(this.moDocContext.mpdDoc);
        ProtocolContext oProtocolContext = new ProtocolContext(oProtocol, this.moDocContext.mpdDoc);
        try {
            String sResp = oProtocol.postHelper(sUrl, sHeader, sData, "text/xml", "UTF-8");
            try {
                byte[] byArray = sResp.getBytes("UTF-8");
                return byArray;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("encoding not supported", e);
            }
        }
        finally {
            if (oProtocolContext != null) {
                oProtocolContext.destroy();
            }
        }
    }

    public void remerge() {
        this.moDocContext.doMerge(true);
        this.moDocContext.doLayout(true, true);
    }

    public FormModel.ServerExchange clone() {
        return new ServerExchange(this.moDocContext);
    }
}

