/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.CustomProtocolInterface;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProxyAuthenticationHandler;
import com.adobe.xfa.protocol.AuthenticationHandler;
import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.ut.ExFull;

class ProxyProtocolHandler
extends Protocol {
    private CustomProtocolInterface customProtocol = null;

    public ProxyProtocolHandler(CustomProtocolInterface customProtocol) {
        this.customProtocol = customProtocol;
    }

    @Override
    public AuthenticationHandler getAuthenticationHandler() {
        return new ProxyAuthenticationHandler(this.customProtocol.getAuthenticationHandler());
    }

    @Override
    public boolean isTrusted(String sURL, Protocol.TrustType eTrustType, boolean bThrow) {
        return this.customProtocol.isTrusted(sURL, this.getCustomProtocolTrustType(eTrustType), bThrow);
    }

    @Override
    public Protocol.PostRsvp post(Protocol.SimplePostData data, String sUrl) {
        CustomProtocolInterface.CustomProtocolPostResponse result = this.customProtocol.post(new CustomProtocolInterface.CustomProtocolPostData(data.data, data.headerMap), sUrl);
        return new Protocol.PostRsvp(result.nCode, result.sType, result.data, result.exception != null ? new ExFull(result.exception) : null);
    }

    private CustomProtocolInterface.CustomProtocolTrustType getCustomProtocolTrustType(Protocol.TrustType trustType) {
        switch (trustType) {
            case URL: {
                return CustomProtocolInterface.CustomProtocolTrustType.URL;
            }
            case CROSS_DOMAIN: {
                return CustomProtocolInterface.CustomProtocolTrustType.CROSS_DOMAIN;
            }
            case DATA_INJECTION: {
                return CustomProtocolInterface.CustomProtocolTrustType.DATA_INJECTION;
            }
            case SCRIPT_INJECTION: {
                return CustomProtocolInterface.CustomProtocolTrustType.SCRIPT_INJECTION;
            }
        }
        return null;
    }
}

