/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CTextField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.TextAppearance_t;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldValueExchange;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Int;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.formatting.Border;
import com.adobe.xfa.template.formatting.Fill;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PeerImpl;
import java.util.StringTokenizer;

public class FormListener
implements Peer {
    private CPDField moCPDFld;
    private Node moFormField;
    private TemplateModel moTemplate;
    private PeerImpl mPeers;

    public FormListener(CPDField oCPDFld, Node oFormField, TemplateModel oTemplate) {
        this.moFormField = oFormField;
        this.moCPDFld = oCPDFld;
        this.moTemplate = oTemplate;
    }

    public void updateFromPeer(Object oPeerNode, int eventType, String arg1, Object arg2) {
        try {
            boolean bArg1;
            int eArg1 = XFA.SCHEMA_DEFAULTTAG;
            eArg1 = XFA.getTag((String)arg1);
            boolean bl = bArg1 = eArg1 >= 0;
            if (oPeerNode instanceof Subform) {
                if (eventType == 1 && (eArg1 == XFA.ACCESSTAG || this.moTemplate != null && !this.moTemplate.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING) && eArg1 == XFA.PRESENCETAG)) {
                    this.processAttributeChange((Node)oPeerNode, eventType, arg1, arg2);
                }
            } else if (oPeerNode instanceof Node) {
                if (eventType == 1) {
                    if (eArg1 == XFA.PRESENCETAG) {
                        if (this.moFormField instanceof Container) {
                            Container oContainer = (Container)this.moFormField;
                            int ePresence = oContainer.getRuntimePresence(0);
                            if (ePresence == 1076494336) {
                                int flagsToClear = 2;
                                if (this.moTemplate != null && !this.moTemplate.getLegacySetting(AppModel.XFA_LEGACY_V29_FIELDPRESENCE)) {
                                    flagsToClear |= 0x20;
                                }
                                this.moCPDFld.setFlags(3, flagsToClear);
                            } else if (ePresence == 1076494337) {
                                this.moCPDFld.setFlags(2, 2);
                            }
                        }
                    } else if (eArg1 == XFA.HALIGNTAG) {
                        if (this.moFormField instanceof Element) {
                            int oAttrValue = ((Element)this.moFormField).getEnum(eArg1);
                            TextAppearance_t textAP = new TextAppearance_t();
                            textAP.quadding = TextAppearance_t.LeftQ;
                            if (oAttrValue == 0x160001) {
                                textAP.quadding = TextAppearance_t.CenterQ;
                            } else if (oAttrValue == 1441794) {
                                textAP.quadding = TextAppearance_t.RightQ;
                            }
                            this.moCPDFld.setDefaultTextAppearances(textAP, 1024);
                            this.moCPDFld.generateAppearances(null, false);
                        }
                    } else if (eArg1 == XFA.ACCESSTAG) {
                        int eAccess = 0;
                        if (this.moFormField instanceof Container && ((Container)this.moFormField).isPropertyValid(XFA.ACCESSTAG)) {
                            Container oContainer = (Container)this.moFormField;
                            eAccess = oContainer.getRuntimeAccess(0);
                        }
                        if (eAccess == 65537) {
                            this.moCPDFld.setFlags(5, 1);
                        } else if (eAccess == 65538 || eAccess == 65536) {
                            this.moCPDFld.setFlags(4, 1);
                        }
                    }
                } else if (eventType == 6) {
                    if (eArg1 == XFA.STROKETAG) {
                        Node oEdgeNode = (Node)arg2;
                        Element oBorder = oEdgeNode.getXFAParent();
                        int ePresence = 1076494336;
                        if (oBorder.isPropertySpecified(XFA.PRESENCETAG, true, 0)) {
                            ePresence = oBorder.getEnum(XFA.PRESENCETAG);
                        }
                        int eHand = oBorder.getEnum(XFA.HANDTAG);
                        if (ePresence == 1076494336 && eHand == 0x170001 && bArg1) {
                            int oAttrVal = ((Element)oEdgeNode).getEnum(eArg1);
                            AFUtils.AFPDWidgetBorderRec pdwb = new AFUtils.AFPDWidgetBorderRec();
                            pdwb.nStyle = PDFBorderStyle.Style.Solid;
                            pdwb.nWidth = -1;
                            if (oAttrVal == 0x330001) {
                                pdwb.nStyle = PDFBorderStyle.Style.Dashed;
                            } else if (oAttrVal == 0x330004) {
                                pdwb.nStyle = PDFBorderStyle.Style.Beveled;
                            } else if (oAttrVal == 0x330003) {
                                pdwb.nStyle = PDFBorderStyle.Style.Inset;
                            }
                            this.moCPDFld.setBorders(pdwb);
                            this.moCPDFld.generateAppearances(null, false);
                        }
                    } else if (eArg1 == XFA.MAXCHARSTAG || eArg1 == XFA.MAXLENGTHTAG) {
                        if (this.moCPDFld instanceof CTextField) {
                            CTextField pCTextFld = (CTextField)this.moCPDFld;
                            Int oAttrVal = (Int)((Element)arg2).getAttribute(eArg1);
                            pCTextFld.setMaxLen(oAttrVal.getValue());
                            pCTextFld.generateAppearances(null, false);
                        }
                    } else if (eArg1 == XFA.TEXTENTRYTAG) {
                        if (this.moCPDFld.getType() == CPDField.k_ComboBox) {
                            int oAttrVal = ((Element)arg2).getEnum(eArg1);
                            this.moCPDFld.setFlags(oAttrVal == 0x40040001 ? 4 : 5, 262144);
                        }
                    } else if (eArg1 == XFA.VALUETAG) {
                        Element oColor = (Element)arg2;
                        StringAttr oVal = (StringAttr)oColor.getAttribute(eArg1);
                        String sVal = oVal.toString();
                        TextAppearance_t.PDColorValueRec pdColor = new TextAppearance_t.PDColorValueRec();
                        pdColor.colorSpace = 1;
                        String sComma = ",";
                        StringTokenizer sToker = new StringTokenizer(sVal, sComma);
                        int iColor = 0;
                        while (sToker.hasMoreTokens() && iColor < 3) {
                            String sNumeric = sToker.nextToken();
                            double d = Double.valueOf(sNumeric);
                            pdColor.value[iColor++] = Math.round(d * 1.0 / 255.0);
                        }
                        Element oParent = oColor.getXFAParent();
                        if (oParent instanceof Fill) {
                            if (oParent.getXFAParent() instanceof Border) {
                                this.moCPDFld.setBackgroundColors(pdColor);
                            } else {
                                TextAppearance_t textAP = new TextAppearance_t();
                                textAP.fillColor = pdColor;
                                this.moCPDFld.setDefaultTextAppearances(textAP, 256);
                            }
                        } else {
                            this.moCPDFld.setBorderColors(pdColor);
                        }
                        this.moCPDFld.generateAppearances(null, false);
                    } else if (eArg1 == XFA.THICKNESSTAG) {
                        Measurement oAttrVal;
                        double dVal;
                        Node oNode = (Node)arg2;
                        Element oParent = oNode.getXFAParent();
                        int ePresence = oParent.getEnum(XFA.PRESENCETAG);
                        AFUtils.AFPDWidgetBorderRec pdwb = new AFUtils.AFPDWidgetBorderRec();
                        pdwb.nStyle = null;
                        pdwb.nWidth = ePresence != 1076494336 ? 0 : ((dVal = (oAttrVal = new Measurement(((Element)oNode).getAttribute(eArg1))).getValue()) <= 0.0 ? 0 : (dVal <= 1.5 ? 1 : (dVal <= 2.5 ? 2 : 3)));
                        this.moCPDFld.setBorders(pdwb);
                        this.moCPDFld.generateAppearances(null, false);
                    } else if (eArg1 == XFA.MULTILINETAG) {
                        if (this.moCPDFld.getType() == ASName.k_Tx) {
                            int oAttrVal = ((Element)arg2).getEnum(eArg1);
                            this.moCPDFld.setFlags(oAttrVal == 0x40040001 ? 4 : 5, 4096);
                            this.moCPDFld.generateAppearances(null, false);
                        }
                    } else if (eArg1 == XFA.HREFTAG && this.moCPDFld.getType() == CPDField.k_Button) {
                        DocumentContext oContext = DocumentContext.find(this.moCPDFld.getCPDFields().getPDDoc(), false, null);
                        FieldValueExchange piExchange = new FieldValueExchange(oContext, this.moCPDFld, this.moFormField);
                        piExchange.updateAcroField();
                    }
                } else if (eventType != 2) {
                    if (eventType == 9 || eventType == 5) {
                        if (eArg1 == XFA.TEXTTAG || eArg1 == XFA.ITEMSTAG) {
                            DocumentContext oContext = DocumentContext.find(this.moCPDFld.getCPDFields().getPDDoc(), false, null);
                            FormField oField = (FormField)oPeerNode;
                            if (oContext != null) {
                                oContext.syncChoiceList(oField, true);
                            }
                        }
                    } else if (eventType == 7) {
                        TextNode oText;
                        Element oItems;
                        DocumentContext oContext = DocumentContext.find(this.moCPDFld.getCPDFields().getPDDoc(), false, null);
                        if (((Node)arg2).isSameClass(XFA.TOOLTIPTAG)) {
                            this.moCPDFld.setUserName(arg1);
                        } else if ((eArg1 == XFA.TEXTTAG || arg2 instanceof TextNode) && (oItems = (oText = (TextNode)arg2).getXFAParent()) instanceof Items) {
                            FormField oField = (FormField)oItems.getXFAParent();
                            if (oContext != null) {
                                oContext.syncChoiceList(oField, true);
                            }
                        }
                        if (oContext != null && !oContext.isDocDynamic(true)) {
                            FieldValueExchange oExchange = new FieldValueExchange(oContext, this.moCPDFld, this.moFormField);
                            oExchange.updateAcroField();
                        }
                    }
                }
            }
        }
        catch (PDFException e) {
            throw new ExFull((Exception)((Object)e));
        }
    }

    void processAttributeChange(Node oNode, int eventType, String sArg1, Object oArg2) {
        int nChildCount = oNode.getNodes().length();
        for (int nIndex = 0; nIndex < nChildCount; ++nIndex) {
            Node oChild = (Node)oNode.getNodes().item(nIndex);
            if (oChild == null) continue;
            if (oChild instanceof Subform || oChild instanceof ExclGroup || oChild instanceof Field) {
                FormListener poListener = null;
                int nPeerIndex = 0;
                Peer poPeer = oChild.getPeer(nPeerIndex);
                while (poPeer != null) {
                    if (poPeer instanceof FormListener) {
                        poListener = (FormListener)poPeer;
                        break;
                    }
                    poPeer = oChild.getPeer(++nPeerIndex);
                }
                if (poListener == null) continue;
                poListener.updateFromPeer(oChild, eventType, sArg1, oArg2);
                continue;
            }
            this.processAttributeChange(oChild, eventType, sArg1, oArg2);
        }
    }

    public void addPeer(Peer poPeerNode) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.addPeer(poPeerNode);
    }

    public void addPeeredNode(Peer poPeer) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.addPeeredNode(poPeer);
    }

    public void clearPeers() {
        if (this.mPeers != null) {
            this.mPeers.clearPeers();
        }
    }

    public void deafen() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.deafen();
    }

    public Peer getPeer(int nPeer) {
        if (this.mPeers == null) {
            return null;
        }
        return this.mPeers.getPeer(nPeer);
    }

    public boolean isDeaf() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isDeaf();
    }

    public boolean isMute() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isMute();
    }

    public void mute() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.mute();
    }

    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.notifyPeers(eventType, arg1, arg2);
    }

    public void removePeer(Peer peerNode) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeer(peerNode);
    }

    public void removePeeredNode(Peer peer) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeeredNode(peer);
    }

    public void unDeafen() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unDeafen();
    }

    public void unMute() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unMute();
    }

    public void peerRemoved(Peer peer) {
    }
}

