/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProviderStandard;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderDocMDP;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderUR;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderXFA_D;
import com.adobe.internal.pdftoolkit.services.permissions.impl.PermissionProviderXFA_S;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChoiceBasedField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFieldEnumProc;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.PDDoc2CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.form.CosDocument;
import com.adobe.internal.pdftoolkit.services.xfa.form.EventPseudoModel;
import com.adobe.internal.pdftoolkit.services.xfa.form.Execute;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldMDP;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldValueExchange;
import com.adobe.internal.pdftoolkit.services.xfa.form.FormCalcScriptHandler;
import com.adobe.internal.pdftoolkit.services.xfa.form.FormListener;
import com.adobe.internal.pdftoolkit.services.xfa.form.ServerExchange;
import com.adobe.internal.pdftoolkit.services.xfa.form.Submit;
import com.adobe.internal.pdftoolkit.services.xfa.form.Utils;
import com.adobe.internal.pdftoolkit.services.xfa.form.Validate;
import com.adobe.internal.pdftoolkit.services.xfa.form.WSDLConnectionSetProxy;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAHostPseudoModel;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EventPseudoModel;
import com.adobe.xfa.HostPseudoModel;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.TagnameFilter;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.connectionset.ConnectionSetModel;
import com.adobe.xfa.connectionset.ConnectionSetModelFactory;
import com.adobe.xfa.connectionset.proxies.ConnectionSetProxy;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataWindow;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.layout.AcroFormLayout;
import com.adobe.xfa.localeset.LocaleSetModel;
import com.adobe.xfa.localeset.LocaleSetModelFactory;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.TemplateModelFactory;
import com.adobe.xfa.template.binding.BindItems;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PeerImpl;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DocumentContext
extends CosDocument
implements Peer,
FormModel.PostMergeHandler {
    private static final boolean ALWAYS_AGM_RENDER = false;
    private static final boolean PDPermReqGranted = true;
    private static final boolean PDPermReqDenied = false;
    private boolean mbAnnotCreateStatus;
    private boolean mbBindWithAcrobat;
    private boolean mbCalcOccuring;
    private boolean mbEnumRequired;
    private boolean mbFirstAppearancesGenerated;
    private boolean mbFormCreateStatus;
    private boolean mbFormFillStatus;
    private boolean mbIsDocAGMRendered;
    private boolean mbIsDocDynamic;
    private boolean mbIsDocInteractive;
    private boolean mbIsFirstTimeLoad;
    private boolean mbIsRollbackDoc;
    private boolean mbIsXFAF;
    private boolean mbNeedsRendering;
    private boolean mbNeedToValidate;
    private boolean mbPDDocReady;
    private boolean mbPDPermsReady;
    private boolean mbRecalcRequired;
    private boolean mbRemergeRequired;
    private boolean mbRenderEnabled;
    private boolean mbSetNeedAppearancesToExplicitFalseAfterLoad;
    private boolean mbSyncBindItemsChoiceLists;
    private boolean mbTemplateLoaded;
    private boolean mbXFAFlagsSet;
    private boolean mbXFAIsLoading;
    private int meCurrentReason;
    private EnumFieldsCode meEnumFieldsContext;
    private DocModAnalyzerParams.DocModAnalysisMode mMDPSetting;
    private int mnPDFExtensionLevel;
    private int mnTemplateVersion;
    private AcroFormLayout moAcroFormLayout;
    private Storage<String> moChoiceListsToSync;
    private ScriptDebugger moDebugger;
    private EventPseudoModel moEventPseudoModel;
    private Storage<FormListener> moFormListeners;
    private SortedMap<String, Boolean> moValidateEvents = new TreeMap<String, Boolean>();
    public PDFDocument mpdDoc;
    private String msPDFVersion;
    private PeerImpl mPeers;
    private PermissionsManager moPermsMgr;
    private XFAProcessingOptions moProcessingOptions;
    private Node mpPacketToIgnoreWhileComparisonDuringSubmit;

    static void add(PDFDocument pdfDoc, DocumentContext oContext) {
        DocumentListenerRegistry registry = pdfDoc.getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        if (serviceListener == null) {
            serviceListener = oContext != null ? new XFADOMServiceListener(pdfDoc, null, oContext.moProcessingOptions) : new XFADOMServiceListener(pdfDoc, null, null);
            registry.registerListener(XFADOMServiceListener.class, (DocumentListener)serviceListener);
        }
        serviceListener.setDocumentContext(oContext);
    }

    public static boolean AFPDDocFillerIsOK(PDFDocument doc) {
        boolean bRet = false;
        DocumentContext documentContext = DocumentContext.find(doc, true, null);
        try {
            bRet = documentContext.getPermissionsManager().isPermitted(ObjectOperations.FORM_FILLIN);
        }
        catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {
            // empty catch block
        }
        return bRet;
    }

    public static DocumentContext find(PDFDocument pdfDoc, boolean bIfReady, BooleanHolder oAlreadySeen) {
        DocumentListenerRegistry registry = pdfDoc.getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        DocumentContext oRet = null;
        if (serviceListener != null) {
            oRet = serviceListener.getDocumentContext();
        }
        if (oAlreadySeen != null) {
            boolean bl = oAlreadySeen.value = oRet != null;
        }
        if (!bIfReady || oRet == null || oRet.isReady()) {
            return oRet;
        }
        return null;
    }

    static void getXFAFlags(AppModel oAppModel, BooleanHolder bIsDocDynamic, BooleanHolder bIsDocInteractive, BooleanHolder bIsDocAGMRendered, BooleanHolder bIsXFAF, StringHolder sPDFVersion, IntegerHolder nPDFExtensionLevel) {
        bIsDocDynamic.value = false;
        bIsDocInteractive.value = false;
        bIsDocAGMRendered.value = false;
        bIsXFAF.value = false;
        sPDFVersion.value = "";
        nPDFExtensionLevel.value = -1;
        double nPDFVersion = 0.0;
        if (oAppModel != null) {
            TemplateModel oTemplateModel;
            ConfigurationModel oConfigModel = ConfigurationModel.getConfigurationModel((AppModel)oAppModel, (boolean)false);
            if (oConfigModel != null) {
                String sDynamicSOM = "acrobat.acrobat7.dynamicRender";
                Node oValue = oConfigModel.resolveNode(sDynamicSOM);
                if (oValue instanceof ConfigurationValue) {
                    String sArg = ((ConfigurationValue)oValue).getValue().toString();
                    bIsDocDynamic.value = sArg.equals(EnumAttr.getString((int)1080426497));
                } else {
                    bIsDocDynamic.value = false;
                }
                Element oPresent = oConfigModel.getElement(XFA.PRESENTTAG, 0);
                if (oPresent != null) {
                    String sDestName;
                    Node oPDF = null;
                    Element oDestName = oPresent.getElement(XFA.DESTINATIONTAG, 0);
                    if (oDestName instanceof ConfigurationValue && !StringUtils.isEmpty((CharSequence)(sDestName = ((ConfigurationValue)oDestName).getValue().toString()))) {
                        oPDF = oPresent.resolveNode(sDestName);
                    }
                    if (oPDF == null || !oPDF.isSameClass(XFA.PDFTAG)) {
                        oPDF = oPresent.resolveNode("$.pdf");
                    }
                    if (oPDF instanceof Element) {
                        Element oVersion;
                        String sValue;
                        Element oInterative = ((Element)oPDF).getElement(XFA.INTERACTIVETAG, 0);
                        if (oInterative instanceof ConfigurationValue && "1".equals(sValue = ((ConfigurationValue)oInterative).getValue().toString())) {
                            bIsDocInteractive.value = true;
                        }
                        if ((oVersion = ((Element)oPDF).getElement(XFA.VERSIONTAG, 0)) instanceof ConfigurationValue) {
                            Element oExtLev;
                            sPDFVersion.value = ((ConfigurationValue)oVersion).getValue().toString();
                            if (!StringUtils.isEmpty((CharSequence)sPDFVersion.value) && (nPDFVersion = Numeric.stringToDouble((String)sPDFVersion.value, (boolean)false)) < 1.6) {
                                bIsDocDynamic.value = false;
                            }
                            if ((oExtLev = ((Element)oPDF).peekElement(XFA.ADOBEEXTENSIONLEVELTAG, false, 0)) instanceof ConfigurationValue) {
                                String sExtensionLevel = ((ConfigurationValue)oExtLev).getValue().toString();
                                nPDFExtensionLevel.value = StringUtils.safeNumber((String)sExtensionLevel);
                            }
                        }
                    }
                }
            }
            if ((oTemplateModel = TemplateModel.getTemplateModel((AppModel)oAppModel, (boolean)false)) != null) {
                if (oTemplateModel.getEnum(XFA.BASEPROFILETAG) == 7602177) {
                    bIsDocDynamic.value = false;
                    bIsXFAF.value = true;
                } else if (oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_POSITIONING)) {
                    bIsDocAGMRendered.value = false;
                } else if (!(!bIsDocDynamic.value || DocumentContext.RegistryUseLegacyRender() && oTemplateModel.getCurrentVersion() < 33 || oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_RENDERING))) {
                    bIsDocAGMRendered.value = true;
                }
            }
        }
    }

    static boolean hasResIDInExceptionList(List<ExFull> errs, int resID) {
        for (int i = 0; i < errs.size(); ++i) {
            if (errs.get(i).getResId(0) != resID) continue;
            return true;
        }
        return false;
    }

    static boolean isDocCertified(PDFDocument pdDoc) {
        try {
            SignatureManager sigMgr = SignatureManager.newInstance(pdDoc);
            return sigMgr.isDocCertified();
        }
        catch (PDFException e) {
            return false;
        }
    }

    public static boolean isLegacyXFADoc(PDFDocument pdDoc) {
        DocumentContext oContext = DocumentContext.find(pdDoc, false, null);
        if (oContext != null && oContext.moAppModel != null) {
            return oContext.moAppModel.getLegacySetting(AppModel.XFA_LEGACY_POSITIONING);
        }
        return false;
    }

    public static DocumentContext isXFADoc(PDFDocument pdDoc) {
        DocumentContext oContext = null;
        BooleanHolder bAlreadySeen = new BooleanHolder(false);
        oContext = DocumentContext.find(pdDoc, false, bAlreadySeen);
        if (oContext == null) {
            if (bAlreadySeen.value) {
                return null;
            }
            oContext = new DocumentContext(pdDoc, true);
            oContext.setPermsReady();
            oContext.initialize();
            Document oNewDoc = new Document(oContext.moAppModel);
            if (CosDocument.isXFADoc(pdDoc, oNewDoc, null, false, false, XFADOMService.isXFADOMCreated(pdDoc))) {
                DocumentContext.add(pdDoc, oContext);
                oContext.setDocument(oNewDoc);
            }
        }
        return oContext;
    }

    static boolean RegistryUseLegacyRender() {
        boolean bUseXFALegacyRendering = false;
        if (bUseXFALegacyRendering) {
            return true;
        }
        boolean bPrivateDoDirectRender = true;
        return !bPrivateDoDirectRender;
    }

    static boolean removeResIDFromExceptionList(List<ExFull> errs, int resID, boolean bOnlyEmptyMessage, boolean bOnlyWarnings) {
        boolean bFound = false;
        Storage oCleanedErrs = new Storage();
        for (int i = 0; i < errs.size(); ++i) {
            if (errs.get(i).getResId(0) != resID || bOnlyWarnings && !errs.get(i).wasReported() || bOnlyEmptyMessage && errs.get(i).toString().length() > 1) {
                oCleanedErrs.add((Object)errs.get(i));
                continue;
            }
            bFound = true;
        }
        if (bFound) {
            errs.addAll((Collection<ExFull>)oCleanedErrs);
        }
        return bFound;
    }

    DocumentContext(PDFDocument pdDoc, boolean bBindWithAcrobat) {
        super(pdDoc);
        this.mpdDoc = pdDoc;
        this.mbRemergeRequired = false;
        this.mbRecalcRequired = false;
        this.mbEnumRequired = true;
        this.mbCalcOccuring = false;
        this.mpdDoc = pdDoc;
        this.mbTemplateLoaded = false;
        this.mbBindWithAcrobat = bBindWithAcrobat;
        this.mbPDDocReady = false;
        this.mbPDPermsReady = false;
        this.moEventPseudoModel = null;
        this.moAcroFormLayout = null;
        this.mbNeedToValidate = true;
        this.mbIsDocDynamic = true;
        this.mbIsXFAF = false;
        this.mbIsDocAGMRendered = false;
        this.mbNeedsRendering = false;
        this.mbXFAFlagsSet = false;
        this.mbIsDocInteractive = true;
        this.mnPDFExtensionLevel = -1;
        this.mbFirstAppearancesGenerated = false;
        this.meEnumFieldsContext = EnumFieldsCode.UPDATE_ACROFORM;
        this.mbRenderEnabled = false;
        this.mbXFAIsLoading = false;
        this.mbSyncBindItemsChoiceLists = false;
        this.moDebugger = null;
        this.meCurrentReason = 0;
        this.mbSetNeedAppearancesToExplicitFalseAfterLoad = false;
        this.mnTemplateVersion = 0;
        this.mbFormCreateStatus = true;
        this.mbFormFillStatus = true;
        this.mbAnnotCreateStatus = true;
        this.mbIsFirstTimeLoad = false;
        this.moFormListeners = new Storage();
        this.moChoiceListsToSync = new Storage();
        this.moPermsMgr = DocumentContext.makePermissionsManager(this.mpdDoc);
    }

    private static PermissionsManager makePermissionsManager(PDFDocument pdfDoc) {
        PermissionsManager mgr = null;
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(pdfDoc);
        if (jsHandler != null) {
            mgr = jsHandler.getPermissionsManager();
        }
        if (mgr == null) {
            try {
                mgr = PermissionsManager.newInstance((PDFDocument)pdfDoc);
            }
            catch (PDFException pDFException) {
                // empty catch block
            }
        }
        return mgr;
    }

    public void destroy() {
        this.clearPeers();
        this.releaseFormListeners();
        this.moAppModel.clearScriptingContexts();
    }

    void addFormListener(FormListener oFormListener) {
        this.moFormListeners.add((Object)oFormListener);
    }

    boolean calcOccurring(boolean bOccurring) {
        boolean bOldCalcOccuring = this.mbCalcOccuring;
        this.mbCalcOccuring = bOccurring;
        return bOldCalcOccuring;
    }

    void clearChoiceListSyncState() {
        this.moChoiceListsToSync.setSize(0);
        this.mbSyncBindItemsChoiceLists = false;
    }

    public void contentChanged(boolean bIncremental) {
        if (this.mpdDoc != null && !this.getXFALoading() && bIncremental) {
            boolean bContinue = false;
            for (Node oChild = this.moAppModel.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                if (oChild instanceof FormModel || oChild instanceof Model || !oChild.isDirty()) continue;
                bContinue = true;
                break;
            }
            if (!bContinue) {
                return;
            }
        }
    }

    public boolean dispatchEvents(SignEventInfo poParams) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (poParams == null) {
            throw new PDFInvalidParameterException("Information object can not be null.");
        }
        DocumentContext poDocumentContext = this;
        if (poDocumentContext.getXFADocVersion() >= 28) {
            Field oEventSource = null;
            SignatureFieldXFA xfaField = poParams.sigField.getXFAField();
            if (xfaField != null) {
                oEventSource = xfaField.getXFAFieldSignature();
            }
            EventPseudoModel.EventInfo oEventInfo = new EventPseudoModel.EventInfo();
            oEventInfo.setTarget((Obj)oEventSource);
            if (oEventSource == null) {
                oEventSource = poDocumentContext.getHostModel();
            }
            if (poParams.notificationID == DSNotificationType.DSWillSign) {
                poDocumentContext.eventOccurred(4915222, (Obj)oEventSource, oEventInfo);
                EventPseudoModel poEventPseudoModel = poDocumentContext.getEventPseudoModel();
                if (poEventPseudoModel != null && poEventPseudoModel.getCancelAction() && poEventPseudoModel != null && poEventPseudoModel.cancelAction("sign")) {
                    return false;
                }
            } else if (poParams.notificationID == DSNotificationType.DSDidSign || poParams.notificationID == DSNotificationType.DSFailSign) {
                poDocumentContext.eventOccurred(4915223, (Obj)oEventSource, oEventInfo);
            }
        }
        return true;
    }

    void doLayout(boolean bFullLayout, boolean bRestBatchPageCount) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMerge(boolean bRecalc) {
        Boolean oBool;
        String sSubmitUrl;
        this.releaseFormListeners();
        this.mbRemergeRequired = false;
        FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)true);
        if (oFormModel.getServerExchange() == null) {
            ServerExchange oServerExchange = new ServerExchange(this);
            oFormModel.setServerExchange((FormModel.ServerExchange)oServerExchange);
            oFormModel.setRunScripts(1080754176);
        }
        if (oFormModel.getSubmit() == null) {
            Submit oSubmit = new Submit(this);
            oFormModel.setSubmit((FormModel.Submit)oSubmit);
        }
        if (oFormModel.getDefaultValidate() == null) {
            Validate oValidate = new Validate(this);
            oFormModel.setDefaultValidate((FormModel.Validate)oValidate);
        }
        if (oFormModel.getExecute() == null) {
            Execute oExecute = new Execute(this);
            oFormModel.setExecute((FormModel.Execute)oExecute);
        }
        if (oFormModel.getPostMergeHandler() == null) {
            oFormModel.setPostMergeHandler((FormModel.PostMergeHandler)this, (Object)this);
        }
        if (!StringUtils.isEmpty((CharSequence)this.msConfigLocale)) {
            oFormModel.setAmbientLocale(this.msConfigLocale);
        }
        if (!StringUtils.isEmpty((CharSequence)(sSubmitUrl = this.getSubmitUrl()))) {
            oFormModel.setSubmitURL(sSubmitUrl);
        }
        oFormModel.setValidateBeforeSubmit((oBool = (Boolean)this.moValidateEvents.get("preSubmit")) == null ? false : oBool);
        oBool = (Boolean)this.moValidateEvents.get("preExecute");
        oFormModel.setValidateBeforeExecute(oBool == null ? false : oBool);
        Peer oFormModelImpl = oFormModel.getPeer(0);
        if (oFormModelImpl != null) {
            oFormModelImpl.removePeer((Peer)this);
        }
        DataModel oDataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)false, (boolean)false);
        boolean bEmptyData = true;
        if (oDataModel != null) {
            bEmptyData = false;
            Peer oDataWindowImpl = oDataModel.getDataWindow().getPeer(0);
            if (oDataWindowImpl != null) {
                oDataWindowImpl.removePeer((Peer)this);
            }
        }
        if (!bEmptyData) {
            boolean bDoPatch = this.moAppModel.getLegacySetting(AppModel.XFA_PATCH_B_02518);
            oDataModel.disableSchemaValidation(bDoPatch);
        }
        if (bEmptyData && this.mbModifyData) {
            oDataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)true, (boolean)true);
        }
        boolean bReMerge = false;
        try {
            this.setChoiceListSyncState();
            boolean bRestoreState = true;
            boolean bForceRestore = false;
            if (this.isRollbackDoc()) {
                bForceRestore = true;
            } else if (DocumentContext.isDocCertified(this.mpdDoc)) {
                if (this.getMDPSetting() == DocModAnalyzerParams.DocModAnalysisMode.MDPAllowNone) {
                    bForceRestore = true;
                } else {
                    bRestoreState = false;
                }
            }
            oFormModel.merge(bEmptyData, this.mbModifyData, false, bRestoreState, bForceRestore);
            if (this.moAcroFormLayout != null) {
                this.enumFields(EnumFieldsCode.UPDATE_NONE);
            } else if (this.mbTemplateLoaded) {
                this.enumFields(EnumFieldsCode.UPDATE_BOTH);
            } else {
                this.enumFields(EnumFieldsCode.UPDATE_ACROFORM);
            }
            oFormModel.initialize();
        }
        catch (ExFull oEx) {
            bReMerge = true;
            throw oEx;
        }
        this.clearChoiceListSyncState();
        if (bReMerge) {
            DataNode oStartNode;
            DataWindow oDataWindow = oDataModel.getDataWindow();
            if (oDataWindow != null && oDataWindow.isDefined() && (oStartNode = oDataWindow.record(0)) != null) {
                NodeList oChildren = oStartNode.getNodes();
                while (oChildren.length() > 0) {
                    Obj oChild = oChildren.item(0);
                    if (!(oChild instanceof Node)) continue;
                    oChildren.remove(oChild);
                }
            }
            oFormModel.merge(true, this.mbModifyData, !this.mbTemplateLoaded, false, false);
        }
        oFormModel.addPeer((Peer)this);
        oDataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)true, (boolean)false);
        Peer oDataWindowImpl = oDataModel.getDataWindow().getPeer(0);
        if (oDataWindowImpl != null) {
            oDataWindowImpl.addPeer((Peer)this);
        }
        if (bRecalc) {
            this.mbCalcOccuring = true;
            if (this.getValidationsEnabled()) {
                FormModel.Validate poDefaultValidate = oFormModel.getDefaultValidate();
                assert (poDefaultValidate != null);
                if (poDefaultValidate != null) {
                    boolean bSaveScriptTest = poDefaultValidate.isScriptTestEnabled();
                    boolean bSaveNullTest = poDefaultValidate.isNullTestEnabled();
                    boolean bSaveFormatTest = poDefaultValidate.isFormatTestEnabled();
                    boolean bSaveBarcodeTest = poDefaultValidate.isBarcodeTestEnabled();
                    try {
                        poDefaultValidate.setScriptTestEnabled(true);
                        poDefaultValidate.setNullTestEnabled(false);
                        poDefaultValidate.setFormatTestEnabled(false);
                        poDefaultValidate.setBarcodeTestEnabled(false);
                        oFormModel.recalculate(bRecalc, poDefaultValidate, false);
                    }
                    finally {
                        poDefaultValidate.setScriptTestEnabled(bSaveScriptTest);
                        poDefaultValidate.setNullTestEnabled(bSaveNullTest);
                        poDefaultValidate.setFormatTestEnabled(bSaveFormatTest);
                        poDefaultValidate.setBarcodeTestEnabled(bSaveBarcodeTest);
                    }
                }
            } else {
                oFormModel.recalculate(bRecalc, null, false);
            }
            this.mbCalcOccuring = false;
        }
        this.reportErrors();
    }

    private void setChoiceListSyncState() {
        this.mbSyncBindItemsChoiceLists = true;
        Node formState = this.moAppModel.locateChildByName("formState", 0);
        if (formState == null) {
            return;
        }
        FormModel formModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)true);
        for (Node stateChild = formState.getFirstXMLChild(); stateChild != null; stateChild = stateChild.getNextXMLSibling()) {
            if (!(stateChild instanceof Element) || !stateChild.getName().equals("state")) continue;
            Element stateChildElement = (Element)stateChild;
            String sContextNodeSOM = "";
            Node oContextNode = null;
            int index = stateChildElement.findAttr("", "ref");
            if (index != -1) {
                sContextNodeSOM = stateChildElement.getAttrVal(index);
                oContextNode = formModel.resolveNode(sContextNodeSOM);
            }
            if (oContextNode == null) continue;
            this.moChoiceListsToSync.add((Object)oContextNode.getSOMExpression());
        }
    }

    public void enforcePermissions() {
        int nOldTemplateVersion = this.mnTemplateVersion;
        boolean bLegacyDoc = false;
        TemplateModel oTemplateModel = TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false);
        if (oTemplateModel != null) {
            this.mnTemplateVersion = oTemplateModel.getOriginalXFAVersion();
            bLegacyDoc = oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_PERMISSIONS);
        }
        boolean bOldFormCreateStatus = this.mbFormCreateStatus;
        this.mbFormCreateStatus = this.queryPermission(ObjectOperations.FORM_CREATE);
        boolean bOldFormFillStatus = this.mbFormFillStatus;
        this.mbFormFillStatus = this.queryPermission(ObjectOperations.FORM_FILLIN);
        boolean bOldAnnotCreateStatus = this.mbAnnotCreateStatus;
        this.mbAnnotCreateStatus = this.queryPermission(ObjectOperations.ANNOT_CREATE);
        if (this.mnTemplateVersion != nOldTemplateVersion) {
            this.processDefaultPackets(!bLegacyDoc);
        }
        if (bLegacyDoc && this.mbFormCreateStatus != bOldFormCreateStatus) {
            this.processDefaultPackets(!this.mbFormCreateStatus);
        }
        if (this.mbFormFillStatus != bOldFormFillStatus) {
            this.processDatasetsPacket(!this.mbFormFillStatus);
        }
        if (this.mbAnnotCreateStatus != bOldAnnotCreateStatus) {
            this.processXFDFPacket(!this.mbAnnotCreateStatus);
        }
    }

    void enumFields(EnumFieldsCode eUpdate) {
        if (!this.mbEnumRequired || !this.mbBindWithAcrobat) {
            return;
        }
        this.releaseFormListeners();
        if (eUpdate != EnumFieldsCode.UPDATE_NONE) {
            this.mbEnumRequired = false;
        }
        if (this.isDocDynamic(true) || !this.moProcessingOptions.xfaCosSyncEnabled()) {
            return;
        }
        this.meEnumFieldsContext = eUpdate;
        try {
            CPDFields pCPDFlds = PDDoc2CPDFields.GetCPDFieldsFromPDDoc(this.mpdDoc, true);
            pCPDFlds.enumCPDFields(true, new CPDFieldEnumProc(){

                @Override
                public boolean invoke(CPDField pCPDField, Object clientData) throws PDFSecurityException {
                    return DocumentContext.this.fieldEnumProc(pCPDField, clientData);
                }
            }, this);
        }
        catch (PDFException e) {
            throw new ExFull((Exception)((Object)e));
        }
        TagnameFilter oFilter = new TagnameFilter(XFA.SUBFORMTAG);
        List oList = oFilter.filterNodes((Node)this.getFormModel(), 0);
        for (int nListIndex = 0; nListIndex < oList.size(); ++nListIndex) {
            FormListener oFormListener;
            Node oListItem = (Node)oList.get(nListIndex);
            if (!(oListItem instanceof Subform) || (oFormListener = new FormListener(null, oListItem, TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false))) == null) continue;
            this.addFormListener(oFormListener);
            oListItem.addPeer((Peer)oFormListener);
        }
    }

    private boolean fieldEnumProc(CPDField fldP, Object clientData) {
        block12: {
            DocumentContext poContext = (DocumentContext)clientData;
            try {
                if (fldP == null) break block12;
                EnumFieldsCode eEnumFieldsContext = poContext.getEnumFieldsContext();
                CPDField pCPDField = fldP;
                try {
                    if (eEnumFieldsContext == EnumFieldsCode.LOCK) {
                        pCPDField.setFlags(4, 1);
                        int numWidgets = pCPDField.getNumWidgets();
                        for (int i = 0; i < numWidgets; ++i) {
                            CWidget pCWidget = pCPDField.getWidget(i);
                            PDFAnnotationWidget pdan = pCWidget.getPDAnnot();
                            pdan.setFlags(64);
                        }
                        return true;
                    }
                    Node oFormNode = poContext.getFieldXFANode(fldP);
                    pCPDField.setXFALink(oFormNode);
                    if (oFormNode == null) {
                        return true;
                    }
                    boolean bXFAtoAcro = false;
                    if (oFormNode instanceof FormField) {
                        if (fldP.getType() != ASName.k_Sig && !bXFAtoAcro && eEnumFieldsContext != EnumFieldsCode.UPDATE_NONE) {
                            FieldValueExchange piExchange = new FieldValueExchange(poContext, fldP, oFormNode);
                            piExchange.updateAcroField();
                        }
                        FormField oField = (FormField)oFormNode;
                        FormListener poListener = new FormListener(fldP, (Node)oField, poContext.getTemplateModel());
                        poContext.addFormListener(poListener);
                        oField.addPeer((Peer)poListener);
                        poContext.syncChoiceList(oField, false);
                        break block12;
                    }
                    if (oFormNode instanceof FormExclGroup) {
                        if (!bXFAtoAcro && eEnumFieldsContext != EnumFieldsCode.UPDATE_NONE) {
                            FieldValueExchange piExchange = new FieldValueExchange(poContext, fldP, oFormNode);
                            piExchange.updateAcroField();
                        }
                        NodeList oChildren = oFormNode.getNodes();
                        for (int i = 0; i < oChildren.length(); ++i) {
                            if (!(oChildren.item(i) instanceof FormField)) continue;
                            FormField oRadioBttnField = (FormField)oChildren.item(i);
                            FormListener poListener = new FormListener(fldP, (Node)oRadioBttnField, poContext.getTemplateModel());
                            poContext.addFormListener(poListener);
                            oRadioBttnField.addPeer((Peer)poListener);
                        }
                        FormListener poListener = new FormListener(fldP, oFormNode, poContext.getTemplateModel());
                        poContext.addFormListener(poListener);
                        oFormNode.addPeer((Peer)poListener);
                        break block12;
                    }
                    return true;
                }
                catch (PDFException e) {
                    throw new ExFull((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public void syncChoiceList(FormField oFormField, boolean bForce) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        UI oUI = (UI)oFormField.peekElement(XFA.UITAG, true, 0);
        Element oCurrentUI = oUI.getUIElement(false);
        if (!oCurrentUI.isSameClass(XFA.CHOICELISTTAG)) {
            return;
        }
        boolean bPerformSync = bForce;
        if (!bPerformSync && this.moChoiceListsToSync.size() > 0) {
            FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)true);
            String sSOM = oFormField.getSOMExpression();
            for (int i = 0; i < this.moChoiceListsToSync.size(); ++i) {
                if (!((String)this.moChoiceListsToSync.get(i)).equals(sSOM)) continue;
                bPerformSync = true;
                break;
            }
        }
        if (!bPerformSync && this.mbSyncBindItemsChoiceLists) {
            NodeList nodeList = oFormField.getNodes();
            for (int j = 0; nodeList != null && j < nodeList.length(); ++j) {
                Attribute oAttr;
                Node oChild = (Node)nodeList.item(j);
                if (!oChild.isSameClass(XFA.BINDITEMSTAG) || (oAttr = ((BindItems)oChild).getAttribute(XFA.CONNECTIONTAG, true, false)) != null && oAttr.toString().length() != 0) continue;
                bPerformSync = true;
                break;
            }
        }
        if (!bPerformSync) {
            return;
        }
        CPDField pFld = (CPDField)oFormField.getCPDField();
        if (pFld instanceof CChoiceBasedField) {
            CChoiceBasedField pCChoiceFld = (CChoiceBasedField)pFld;
            Field.ItemPair itemPair = new Field.ItemPair();
            oFormField.getItemLists(true, itemPair, false);
            Items oBound = itemPair.mSaveItems;
            Items oDisplay = itemPair.mDisplayItems;
            if (oDisplay != null && oDisplay.getNodes().length() > 0) {
                String sValue = oFormField.getRawValue();
                int nSelection = -1;
                if (oBound == oDisplay || oBound == null || oBound.getNodes().length() != oDisplay.getNodes().length()) {
                    oBound = oDisplay;
                }
                CChoiceBasedField.AFChoicesRec arrChoices = new CChoiceBasedField.AFChoicesRec();
                arrChoices.nChoices = oDisplay.getNodes().length();
                arrChoices.esValues = new ArrayList<String>(arrChoices.nChoices);
                arrChoices.esExports = new ArrayList<String>(arrChoices.nChoices);
                for (int i = 0; i < arrChoices.nChoices; ++i) {
                    TextNode oDisplayChild = (TextNode)oDisplay.getNodes().item(i);
                    arrChoices.esValues.add(i, oDisplayChild.getValue());
                    if (oBound == null) continue;
                    TextNode oBoundChild = (TextNode)oBound.getNodes().item(i);
                    String sBoundValue = oBoundChild.getValue();
                    if (sBoundValue.equals(sValue)) {
                        nSelection = i;
                    }
                    arrChoices.esExports.add(i, sBoundValue);
                }
                pCChoiceFld.setOptions(arrChoices);
                if (nSelection != -1) {
                    pCChoiceFld.setValueFromEStr(arrChoices.esExports.get(nSelection));
                    pCChoiceFld.generateAppearances(null, false);
                } else if (oCurrentUI.getEnum(XFA.OPENTAG) == 0x230002) {
                    pCChoiceFld.generateAppearances(null, false);
                }
            } else {
                pCChoiceFld.setOptions((CosObject)pCChoiceFld.getCPDFields().getPDDoc().getCosDocument().createCosNull());
                pCChoiceFld.generateAppearances(null, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventPseudoModel.EventInfo eventOccurred(int eActivity, Obj oContainer, EventPseudoModel.EventInfo oEventInfo) {
        EventPseudoModel.EventInfo eventInfo;
        block14: {
            EventPseudoModel.EventInfo eventInfo2;
            block12: {
                EventPseudoModel.EventInfo eventInfo3;
                block13: {
                    boolean bIsCalcOccurring;
                    block10: {
                        EventPseudoModel.EventInfo eventInfo4;
                        block11: {
                            String sActivity;
                            block8: {
                                EventPseudoModel.EventInfo eventInfo5;
                                block9: {
                                    sActivity = EnumAttr.getString((int)eActivity);
                                    eventInfo2 = null;
                                    try {
                                        if (oContainer != null) break block8;
                                        eventInfo5 = this.moEventPseudoModel.getEventInfo();
                                        if (this.moEventPseudoModel == null) break block9;
                                    }
                                    catch (Throwable throwable) {
                                        if (this.moEventPseudoModel != null) {
                                            this.moEventPseudoModel.setEventInfo(eventInfo2);
                                        }
                                        throw throwable;
                                    }
                                    this.moEventPseudoModel.setEventInfo(eventInfo2);
                                }
                                return eventInfo5;
                            }
                            bIsCalcOccurring = this.calcOccurring(true);
                            if (this.moEventPseudoModel != null) {
                                eventInfo2 = this.moEventPseudoModel.getEventInfo();
                            }
                            this.meCurrentReason = ScriptHandler.stringToExecuteReason((String)sActivity);
                            if (this.moEventPseudoModel != null) {
                                this.moEventPseudoModel.setEventInfo(oEventInfo);
                            }
                            this.getFormModel().eventOccurred(sActivity, oContainer);
                            if (this.mpdDoc != null) break block10;
                            eventInfo4 = this.moEventPseudoModel.getEventInfo();
                            if (this.moEventPseudoModel == null) break block11;
                            this.moEventPseudoModel.setEventInfo(eventInfo2);
                        }
                        return eventInfo4;
                    }
                    this.meCurrentReason = 0;
                    this.reportErrors();
                    this.calcOccurring(bIsCalcOccurring);
                    this.recalculate(false, false, null);
                    if (this.moEventPseudoModel == null) break block12;
                    eventInfo3 = this.moEventPseudoModel.getEventInfo();
                    if (this.moEventPseudoModel == null) break block13;
                    this.moEventPseudoModel.setEventInfo(eventInfo2);
                }
                return eventInfo3;
            }
            eventInfo = null;
            if (this.moEventPseudoModel == null) break block14;
            this.moEventPseudoModel.setEventInfo(eventInfo2);
        }
        return eventInfo;
    }

    public AcroFormLayout getAcroFormLayout() {
        return null;
    }

    public boolean getAllowFormUpdate() {
        try {
            if (!this.moPermsMgr.isPermitted(ObjectOperations.FORM_FILLIN) && !this.moPermsMgr.isPermitted(ObjectOperations.FORM_MODIFY)) {
                return false;
            }
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        return true;
    }

    EventPseudoModel.EventInfo getCurrentEventInfo() {
        AppModel oAppModel = this.getFormModel().getAppModel();
        EventPseudoModel oEvent = (EventPseudoModel)oAppModel.lookupPseudoModel("$event");
        EventPseudoModel.EventInfo oEventInfo = null;
        if (oEvent != null) {
            oEventInfo = oEvent.getEventInfo();
        }
        return oEventInfo;
    }

    public boolean getDocReady() {
        return this.mbPDDocReady;
    }

    public Validate getDefaultValidate() {
        FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return null;
        }
        return (Validate)oFormModel.getDefaultValidate();
    }

    EventPseudoModel getEventPseudoModel() {
        return this.moEventPseudoModel;
    }

    public Node getFieldXFANode(String sFieldName) {
        Node oNode = null;
        try {
            FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)false);
            if (oFormModel != null) {
                oNode = oFormModel.resolveNode(sFieldName);
            }
        }
        catch (ExFull exFull) {
            // empty catch block
        }
        return oNode;
    }

    public Node getFieldXFANode(CPDField pCPDFld) {
        String sFieldName = pCPDFld.getName();
        Node oNode = this.getFieldXFANode(sFieldName);
        if (oNode != null && !(oNode instanceof FormField) && !(oNode instanceof FormExclGroup)) assert (false);
        return oNode;
    }

    FormListener getFormListener(Node oField) {
        assert (oField instanceof FormField || oField instanceof FormExclGroup);
        Peer oPeerImpl = oField.getPeer(0);
        if (oPeerImpl != null) {
            int i = 0;
            Peer oListener = oPeerImpl.getPeer(i);
            while (oListener != null) {
                if (oListener instanceof FormListener) {
                    return (FormListener)oListener;
                }
                oListener = oPeerImpl.getPeer(++i);
            }
        }
        return null;
    }

    FormModel getFormModel() {
        return FormModel.getFormModel((AppModel)this.moAppModel, (boolean)false);
    }

    HostPseudoModel getHostModel() {
        Obj oModel;
        HostPseudoModel oHostModel = null;
        AppModel oAppModel = this.moAppModel;
        if (oAppModel != null && (oModel = oAppModel.lookupPseudoModel("$host")) instanceof HostPseudoModel) {
            oHostModel = (HostPseudoModel)oModel;
        }
        return oHostModel;
    }

    public DocModAnalyzerParams.DocModAnalysisMode getMDPSetting() {
        return this.mMDPSetting;
    }

    public boolean getNeedAppearances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean retVal = true;
        PDFInteractiveForm form = this.mpdDoc.getInteractiveForm();
        if (form != null) {
            CosArray coFieldsArray = form.getDictionaryArrayValue(ASName.k_Fields);
            if (coFieldsArray != null && coFieldsArray.size() > 0) {
                CosObject coFirstField = coFieldsArray.get(0);
                assert (coFirstField instanceof CosDictionary && ((CosDictionary)coFirstField).get(ASName.k_Kids) != null);
                if (((CosDictionary)coFirstField).get(ASName.k_V) != null) {
                    retVal = false;
                }
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean getNeedToValidate() {
        return this.mbNeedToValidate;
    }

    Node getPacket(String aPacketName) {
        Node oPacket = null;
        boolean bGetDataDescription = false;
        if ("dataDescription".equals(aPacketName)) {
            aPacketName = "datasets";
            bGetDataDescription = true;
        }
        block0: for (Node oChild = this.moAppModel.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            assert (oChild != null);
            if (!(oChild instanceof Packet) && !(oChild instanceof Model) || !aPacketName.equals(oChild.getName())) continue;
            if (bGetDataDescription) {
                for (Node oDataSetsChild = oChild.getFirstXFAChild(); oDataSetsChild != null; oDataSetsChild = oDataSetsChild.getNextXFASibling()) {
                    assert (oDataSetsChild != null);
                    if (oDataSetsChild.getClassTag() != XFA.DATAGROUPTAG || !"dataDescription".equals(oDataSetsChild.getName())) continue;
                    oPacket = oDataSetsChild;
                    break block0;
                }
                break;
            }
            oPacket = oChild;
            break;
        }
        return oPacket;
    }

    public int getPDFExtensionLevel() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mnPDFExtensionLevel;
    }

    public String getPDFVersion() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.msPDFVersion;
    }

    public boolean getPermsReady() {
        return this.mbPDPermsReady;
    }

    public PermissionsManager getPermissionsManager() {
        return this.moPermsMgr;
    }

    public XFAProcessingOptions getProcessingOptions() {
        return this.moProcessingOptions;
    }

    public String getSubmitUrl() {
        boolean bCertified = DocumentContext.isDocCertified(this.mpdDoc);
        return super.getSubmitUrl(bCertified);
    }

    TemplateModel getTemplateModel() {
        return TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false);
    }

    boolean getValidationsEnabled() {
        FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return false;
        }
        return oFormModel.getValidationsEnabled();
    }

    public int getXFADocVersion() {
        TemplateModel oTemplateModel = TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false);
        if (oTemplateModel != null) {
            return oTemplateModel.getCurrentVersion();
        }
        return 0;
    }

    boolean getXFALoading() {
        return this.mbXFAIsLoading;
    }

    public void handlePostMerge(Object oClientData) {
        assert (oClientData != null);
        if (oClientData instanceof DocumentContext) {
            try {
                ((DocumentContext)oClientData).enforcePermissions();
                if (!this.isDocDynamic(true)) {
                    this.iterateAndProtectFieldMDPFields();
                }
            }
            catch (PDFException e) {
                throw new ExFull((Exception)((Object)e));
            }
        }
    }

    public static DataModelFactory addModelFactoriesToAppModel(AppModel appModel, PDFDocument pdfDoc, DocumentContext docContext) {
        appModel.addFactory((ModelFactory)new TemplateModelFactory());
        appModel.addFactory((ModelFactory)new ConfigurationModelFactory());
        appModel.addFactory((ModelFactory)new LocaleSetModelFactory());
        DataModelFactory dataModelFactory = new DataModelFactory();
        appModel.addFactory((ModelFactory)dataModelFactory);
        try {
            PermissionsManager moPermsMgr = null;
            WSDLConnectionSetProxy wsdlConnectionSetProxy = null;
            if (docContext != null) {
                moPermsMgr = docContext.getPermissionsManager();
                wsdlConnectionSetProxy = new WSDLConnectionSetProxy(docContext, new Execute(docContext), docContext);
            } else {
                moPermsMgr = DocumentContext.makePermissionsManager(pdfDoc);
            }
            if (moPermsMgr.isPermitted(ObjectOperations.FORM_EXPORT) || moPermsMgr.isPermitted(ObjectOperations.FORM_ONLINE)) {
                ConnectionSetModelFactory oConnectionSetModelFactory = new ConnectionSetModelFactory();
                if (wsdlConnectionSetProxy != null) {
                    oConnectionSetModelFactory.registerProxy((ConnectionSetProxy)wsdlConnectionSetProxy);
                }
                appModel.addFactory((ModelFactory)oConnectionSetModelFactory);
            }
        }
        catch (PDFException e) {
            throw new ExFull((Exception)((Object)e));
        }
        return dataModelFactory;
    }

    private DataModelFactory getDataModelFactory() {
        List factories = this.moAppModel.factories();
        Iterator itr = factories.iterator();
        ModelFactory modelFactory = null;
        while (itr.hasNext()) {
            modelFactory = (ModelFactory)itr.next();
            if (!(modelFactory instanceof DataModelFactory)) continue;
            return (DataModelFactory)modelFactory;
        }
        return null;
    }

    @Override
    boolean initialize() {
        if (!this.mbPDPermsReady) {
            return false;
        }
        if (!super.initialize()) {
            return false;
        }
        AppModel oImpl = this.moAppModel;
        oImpl.addPseudoModel("$host", (Obj)new XFAHostPseudoModel(this));
        Obj oEvent = oImpl.lookupPseudoModel("$event");
        if (oEvent != null) {
            oImpl.removePseudoModel("$event");
        }
        EventPseudoModel oEventPseudoModel = new EventPseudoModel(this);
        assert (oEventPseudoModel != null);
        if (oEventPseudoModel != null) {
            oImpl.addPseudoModel("$event", (Obj)oEventPseudoModel);
            this.moEventPseudoModel = oEventPseudoModel;
        }
        FormCalcScriptHandler fc_scripthandler = new FormCalcScriptHandler(this);
        fc_scripthandler.setDebugger(this.moDebugger);
        this.moAppModel.addScriptHandler((ScriptHandler)fc_scripthandler);
        com.adobe.internal.pdftoolkit.services.xfa.impl.JavaScriptHandler es_scripthandler = new com.adobe.internal.pdftoolkit.services.xfa.impl.JavaScriptHandler(this);
        es_scripthandler.setDebugger(this.moDebugger);
        this.moAppModel.addScriptHandler((ScriptHandler)es_scripthandler);
        if (XFADOMService.isXFADOMCreated(this.mpdDoc)) {
            this.moDataModelFactory = this.getDataModelFactory();
            ConnectionSetModel connectionSetModel = ConnectionSetModel.getConnectionSetModel((AppModel)this.moAppModel, (boolean)false);
            if (connectionSetModel != null) {
                WSDLConnectionSetProxy wsdlConnectionSetProxy = new WSDLConnectionSetProxy(this, new Execute(this), this);
                connectionSetModel.registerProxy((ConnectionSetProxy)wsdlConnectionSetProxy);
            }
        } else {
            this.moDataModelFactory = DocumentContext.addModelFactoriesToAppModel(this.moAppModel, this.mpdDoc, this);
        }
        assert (this.moAcroFormLayout == null);
        return true;
    }

    void initXFAFlags() {
        this.mbIsDocDynamic = false;
        this.mbIsDocInteractive = false;
        this.mbIsDocAGMRendered = false;
        this.mbNeedsRendering = false;
        this.mbIsXFAF = false;
        this.mnPDFExtensionLevel = -1;
        AppModel oAppModel = null;
        if (this.moAppModel != null) {
            oAppModel = this.moAppModel;
        }
        try {
            CosDictionary coCosDocRoot = this.getCosDocument().getRoot();
            CosObject coNeedsRendering = coCosDocRoot.get(ASName.k_NeedsRendering);
            this.mbNeedsRendering = coNeedsRendering instanceof CosBoolean && ((CosBoolean)coNeedsRendering).booleanValue();
        }
        catch (PDFException e1) {
            // empty catch block
        }
        BooleanHolder bIsDocDynamic = new BooleanHolder(this.mbIsDocDynamic);
        BooleanHolder bIsDocInteractive = new BooleanHolder(this.mbIsDocInteractive);
        BooleanHolder bIsDocAGMRendered = new BooleanHolder(this.mbIsDocAGMRendered);
        BooleanHolder bIsXFAF = new BooleanHolder(this.mbIsXFAF);
        StringHolder sPDFVersion = new StringHolder(this.msPDFVersion);
        IntegerHolder nPDFExtensionLevel = new IntegerHolder(this.mnPDFExtensionLevel);
        DocumentContext.getXFAFlags(oAppModel, bIsDocDynamic, bIsDocInteractive, bIsDocAGMRendered, bIsXFAF, sPDFVersion, nPDFExtensionLevel);
        this.mbIsDocDynamic = bIsDocDynamic.value;
        this.mbIsDocInteractive = bIsDocInteractive.value;
        this.mbIsDocAGMRendered = bIsDocAGMRendered.value;
        this.mbIsXFAF = bIsXFAF.value;
        this.msPDFVersion = sPDFVersion.value;
        this.mnPDFExtensionLevel = nPDFExtensionLevel.value;
        try {
            double dPDFVersion = Double.valueOf(this.msPDFVersion);
            if (this.mbNeedsRendering && dPDFVersion < 1.6) {
                this.mbNeedsRendering = false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.mbNeedsRendering && !this.mbIsDocDynamic) {
            this.mbRenderEnabled = true;
        }
        this.mbXFAFlagsSet = true;
    }

    public boolean isAGMRenderEnabled() {
        return false;
    }

    public boolean isDocAGMRendered() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mbIsDocAGMRendered;
    }

    public boolean isDocDynamic(boolean bUseNeedsRender) {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mbIsDocDynamic || bUseNeedsRender && this.mbNeedsRendering;
    }

    public boolean isDocInteractive() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mbIsDocInteractive;
    }

    public boolean isDocShell() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mbNeedsRendering;
    }

    public boolean isDocXFAF() {
        if (!this.mbXFAFlagsSet) {
            this.initXFAFlags();
        }
        return this.mbIsXFAF;
    }

    boolean isFirstTimeLoad() {
        return this.mbIsFirstTimeLoad;
    }

    public boolean isRollbackDoc() {
        return this.mbIsRollbackDoc;
    }

    public void isRollbackDoc(boolean isRollbackDoc) {
        this.mbIsRollbackDoc = isRollbackDoc;
    }

    @Override
    boolean loadAppModelFromDoc() {
        TemplateModel oTemplateModel;
        boolean bRet = false;
        if (!this.mbPDPermsReady || !this.mbPDDocReady) {
            return bRet;
        }
        bRet = super.loadAppModelFromDoc();
        if (bRet && (oTemplateModel = TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false)) != null) {
            int nVersion = oTemplateModel.getCurrentVersion();
            if (this.moAppModel.getSourceBelow() == 8192001) {
                this.moAppModel.setVersionRestriction(nVersion, 8323074);
            }
        }
        return bRet;
    }

    boolean loadNextRecord() {
        DataWindow dw = null;
        DataModel dataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)false, (boolean)false);
        if (dataModel != null) {
            dw = dataModel.getDataWindow();
        }
        if (dw != null && dw.isDefined()) {
            dw.moveCurrentRecord(1);
            return dw.isDefined();
        }
        return false;
    }

    public void setFirstAppearancesGenerated(boolean bValue) {
        this.mbFirstAppearancesGenerated = bValue;
    }

    public boolean getNeedAppearancesToExplicitFalseAfterLoad() {
        return this.mbSetNeedAppearancesToExplicitFalseAfterLoad;
    }

    public void setNeedAppearancesToExplicitFalseAfterLoad(boolean bValue) {
        this.mbSetNeedAppearancesToExplicitFalseAfterLoad = bValue;
    }

    void postLoad(boolean bDontDirtyDoc) {
        this.mbIsReady = false;
        if (!this.mbPDDocReady || !this.mbPDPermsReady) {
            return;
        }
        TemplateModel oTemplateModel = TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false);
        if (oTemplateModel == null) {
            return;
        }
        if (this.isDocInteractive() || this.isDocDynamic(true)) {
            this.setupValidateEvents();
            do {
                this.doMerge(true);
            } while (!this.isDocInteractive() && this.loadNextRecord());
        }
        if (bDontDirtyDoc) {
            for (Node oChild = this.moAppModel.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
                String aNS;
                if (oChild instanceof Model) {
                    Model oModel = (Model)oChild;
                    if (!(oChild instanceof FormModel)) {
                        oModel.addPeer((Peer)this);
                    }
                    oModel.cleanDirtyFlags();
                    continue;
                }
                if (!(oChild instanceof Packet) || "http://ns.adobe.com/xfdf/".equals(aNS = ((Packet)oChild).getNS()) || "adobe:ns:meta/".equals(aNS)) continue;
                Packet oPacket = (Packet)oChild;
                oPacket.addPeer((Peer)this);
            }
        }
        this.mbTemplateLoaded = true;
        this.mbIsReady = true;
    }

    void processDatasetsPacket(boolean bLock) {
        DataModel oDataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)false, (boolean)false);
        if (oDataModel != null) {
            oDataModel.setPermsLock(bLock);
        }
    }

    void processDefaultPackets(boolean bLock) {
        DataModel oDataModel;
        LocaleSetModel oLocaleSetModel;
        Node oStyleSheetPacket;
        ConnectionSetModel oConnectionSetModel;
        ConfigurationModel oConfigModel;
        TemplateModel oTemplateModel = TemplateModel.getTemplateModel((AppModel)this.moAppModel, (boolean)false);
        if (oTemplateModel != null) {
            oTemplateModel.setPermsLock(bLock);
        }
        if ((oConfigModel = ConfigurationModel.getConfigurationModel((AppModel)this.moAppModel, (boolean)false)) != null) {
            oConfigModel.setPermsLock(bLock);
        }
        if ((oConnectionSetModel = ConnectionSetModel.getConnectionSetModel((AppModel)this.moAppModel, (boolean)false)) != null) {
            oConnectionSetModel.setPermsLock(bLock);
        }
        if ((oStyleSheetPacket = this.getPacket("stylesheet")) != null) {
            oStyleSheetPacket.setPermsLock(bLock);
        }
        if ((oLocaleSetModel = LocaleSetModel.getLocaleSetModel((AppModel)this.moAppModel, (boolean)false)) != null) {
            oLocaleSetModel.setPermsLock(bLock);
        }
        if ((oDataModel = DataModel.getDataModel((AppModel)this.moAppModel, (boolean)false, (boolean)false)) != null) {
            for (Node oDataSetsChild = oDataModel.getFirstXFAChild(); oDataSetsChild != null; oDataSetsChild = oDataSetsChild.getNextXFASibling()) {
                assert (oDataSetsChild != null);
                if (oDataSetsChild.getClassTag() != XFA.DATAGROUPTAG || !"dataDescription".equals(oDataSetsChild.getName())) continue;
                oDataSetsChild.setPermsLock(bLock);
            }
        }
    }

    void processXFDFPacket(boolean bLock) {
        Node oXFDFPacket = this.getPacket("xfdf");
        if (oXFDFPacket != null) {
            oXFDFPacket.setPermsLock(bLock);
        }
    }

    boolean queryPermission(ObjectOperations oObjOperation) {
        boolean status = false;
        try {
            if (this.moPermsMgr.isPermitted(oObjOperation)) {
                return true;
            }
            List denyingHandlerList = this.moPermsMgr.getDenyingHandlers(oObjOperation);
            Iterator handlerIterator = denyingHandlerList.iterator();
            if (handlerIterator != null) {
                while (handlerIterator.hasNext()) {
                    PermissionProvider provider = (PermissionProvider)handlerIterator.next();
                    if (provider instanceof PermissionProviderDocMDP || provider instanceof PermissionProviderUR || provider instanceof PermissionProviderStandard) {
                        return false;
                    }
                    if (!(provider instanceof PermissionProviderXFA_S) && !(provider instanceof PermissionProviderXFA_D)) continue;
                    status = true;
                }
            }
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        return status;
    }

    void postResetFormData() {
        boolean bOldCalcOccurring = this.calcOccurring(true);
        FormModel oFormModel = this.getFormModel();
        if (oFormModel.getValidationsEnabled()) {
            Validate oValidate = new Validate(this, true, false, false, false);
            oFormModel.recalculate(true, (FormModel.Validate)oValidate, false);
        } else {
            oFormModel.recalculate(true, null, false);
        }
        this.calcOccurring(bOldCalcOccurring);
    }

    void recalculate(boolean bFullRecalc, boolean bIgnoreCalcEnabledFlag, FormModel.Validate oValidate) {
        if (this.mbCalcOccuring) {
            this.mbRecalcRequired = true;
            return;
        }
        FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)false);
        if (oFormModel == null) {
            return;
        }
        do {
            this.mbCalcOccuring = true;
            this.mbRecalcRequired = false;
            if (oValidate != null) {
                oFormModel.recalculate(bFullRecalc, oValidate, bIgnoreCalcEnabledFlag);
            } else {
                Validate validate = new Validate(this);
                oFormModel.recalculate(bFullRecalc, (FormModel.Validate)validate, bIgnoreCalcEnabledFlag);
            }
            this.mbCalcOccuring = false;
        } while (this.mbRecalcRequired);
        if (this.mbRemergeRequired) {
            this.doMerge(true);
            this.doLayout(true, true);
        }
        if (this.mbEnumRequired) {
            this.enumFields(EnumFieldsCode.UPDATE_ACROFORM);
        }
        this.reportErrors();
    }

    void releaseFormListeners() {
        while (this.moFormListeners.size() > 0) {
            FormListener oLast = (FormListener)this.moFormListeners.last();
            this.moFormListeners.removeLast();
        }
        this.mbEnumRequired = true;
    }

    void reportErrors() {
        List oErrs = this.moAppModel.getErrorList();
        boolean bNullTestFailed = false;
        boolean bSubmitAttempt = false;
        int ERR_QUOTA = 5;
        int MSG_QUOTA = 30;
        if (!oErrs.isEmpty() && (DocumentContext.hasResIDInExceptionList(oErrs, ResId.FormSubmitCancelled) || DocumentContext.hasResIDInExceptionList(oErrs, ResId.FormPrintCancelled) || DocumentContext.hasResIDInExceptionList(oErrs, ResId.FormValidationForSaveFailed) || DocumentContext.hasResIDInExceptionList(oErrs, ResId.FormExecuteCancelled))) {
            bSubmitAttempt = true;
            DocumentContext.removeResIDFromExceptionList(oErrs, ResId.VALIDATE_NULLTEST_FAILED, false, true);
            if (DocumentContext.hasResIDInExceptionList(oErrs, ResId.VALIDATE_NULLTEST_FAILED)) {
                DocumentContext.removeResIDFromExceptionList(oErrs, ResId.FormSubmitCancelled, false, false);
                DocumentContext.removeResIDFromExceptionList(oErrs, ResId.FormPrintCancelled, false, false);
                DocumentContext.removeResIDFromExceptionList(oErrs, ResId.FormValidationForSaveFailed, false, false);
                DocumentContext.removeResIDFromExceptionList(oErrs, ResId.FormExecuteCancelled, false, false);
                DocumentContext.removeResIDFromExceptionList(oErrs, ResId.VALIDATE_NULLTEST_FAILED, false, false);
                bNullTestFailed = true;
            }
        }
        DocumentContext.removeResIDFromExceptionList(oErrs, ResId.VALIDATE_NULLTEST_FAILED, true, false);
        if (oErrs.isEmpty() || bNullTestFailed) {
            this.moAppModel.clearErrorList();
        }
        if (!oErrs.isEmpty()) {
            StringBuilder sMessage = new StringBuilder();
            int nLines = 0;
            int n = oErrs.size();
            for (int i = 0; i < n; ++i) {
                ExFull oEx = (ExFull)((Object)oErrs.get(i));
                oEx.resolve();
                String sMsg = oEx.toString();
                if (sMsg != null && nLines < 30) {
                    int m = sMsg.length();
                    for (int j = 0; j < m; ++j) {
                        if (sMsg.charAt(j) != '\n') continue;
                        ++nLines;
                    }
                    if (nLines < 30) {
                        sMessage.append(sMsg);
                    }
                }
                if (nLines <= 30 && i <= 5) continue;
                MsgFormatPos oErrLimit = new MsgFormatPos(ResId.MessageLimitExceeded);
                oErrLimit.format(n - i);
                sMessage.append('\n');
                sMessage.append(oErrLimit.toString());
                break;
            }
            this.moAppModel.clearErrorList();
            Utils.AlertNote(sMessage.toString(), 3670018, this.mpdDoc);
        }
    }

    public void setDocReady() {
        this.mbPDDocReady = true;
    }

    void setFirstTimeLoad(boolean bVal) {
        this.mbIsFirstTimeLoad = bVal;
    }

    public void setMDPSetting(DocModAnalyzerParams.DocModAnalysisMode nMDPSetting) {
        this.mMDPSetting = nMDPSetting;
    }

    public void setNeedToValidate(boolean bNeedToValidate) {
        this.mbNeedToValidate = bNeedToValidate;
    }

    public void setPermsReady() {
        this.mbPDPermsReady = true;
    }

    public void setProcessingOptions(XFAProcessingOptions oOptions) {
        this.moProcessingOptions = oOptions;
    }

    void setTargetFocusSOM(String sSOMExp) {
    }

    void setupValidateEvents() {
        ConfigurationModel oConfigModel = ConfigurationModel.getConfigurationModel((AppModel)this.moAppModel, (boolean)false);
        if (oConfigModel != null) {
            Element oPresent;
            boolean bExplicit = false;
            String sValue = null;
            Element oValidate = null;
            Element oAcrobat = oConfigModel.peekElement(XFA.ACROBATTAG, false, 0);
            if (oAcrobat != null) {
                oValidate = oAcrobat.peekElement(XFA.VALIDATETAG, false, 0);
            }
            if (oValidate == null && (oPresent = oConfigModel.peekElement(XFA.PRESENTTAG, false, 0)) != null) {
                oValidate = oPresent.peekElement(XFA.VALIDATETAG, false, 0);
            }
            if (oValidate != null) {
                Object oChild = oValidate.getProperty(XFA.TEXTNODETAG, 0);
                if (oChild instanceof TextNode) {
                    TextNode oTextNode = (TextNode)oChild;
                    sValue = oTextNode.getValue();
                }
                bExplicit = true;
            }
            if (!bExplicit) {
                Schema oSchema = oConfigModel.getSchema();
                sValue = oSchema.defaultAttribute(XFA.VALIDATETAG, XFA.ACROBATTAG).toString();
            }
            if (!StringUtils.isEmpty(sValue)) {
                StringTokenizer sToker = new StringTokenizer(sValue, " ");
                while (sToker.hasMoreTokens()) {
                    String sToken = sToker.nextToken();
                    if ("preSubmit".equals(sToken)) {
                        this.moValidateEvents.put("preSubmit", true);
                        continue;
                    }
                    if ("prePrint".equals(sToken)) {
                        this.moValidateEvents.put("prePrint", true);
                        continue;
                    }
                    if ("preSave".equals(sToken)) {
                        this.moValidateEvents.put("preSave", true);
                        continue;
                    }
                    if (!"preExecute".equals(sToken)) continue;
                    this.moValidateEvents.put("preExecute", true);
                }
            }
        }
    }

    void setXFALoading(boolean bLoading) {
        this.mbXFAIsLoading = bLoading;
    }

    public boolean useLegacy27XFAEventModel() {
        return this.moAppModel.getLegacySetting(AppModel.XFA_LEGACY_V27_EVENTMODEL);
    }

    public boolean useLegacyXFAEventModel(PDFDocument pdDoc) {
        DocumentContext oContext = DocumentContext.find(pdDoc, false, null);
        if (oContext != null && oContext.moAppModel != null) {
            return oContext.moAppModel.getLegacySetting(AppModel.XFA_LEGACY_EVENTMODEL);
        }
        return false;
    }

    EnumFieldsCode getEnumFieldsContext() {
        return this.meEnumFieldsContext;
    }

    public void addPeer(Peer poPeerNode) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.addPeer(poPeerNode);
    }

    public void addPeeredNode(Peer poPeer) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.addPeeredNode(poPeer);
    }

    public void clearPeers() {
        if (this.mPeers != null) {
            this.mPeers.clearPeers();
        }
    }

    public void deafen() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.deafen();
    }

    public Peer getPeer(int nPeer) {
        if (this.mPeers == null) {
            return null;
        }
        return this.mPeers.getPeer(nPeer);
    }

    public boolean isDeaf() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isDeaf();
    }

    public boolean isMute() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isMute();
    }

    public void mute() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl((Peer)this);
        }
        this.mPeers.mute();
    }

    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.notifyPeers(eventType, arg1, arg2);
    }

    public void removePeer(Peer peerNode) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeer(peerNode);
    }

    public void removePeeredNode(Peer peer) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeeredNode(peer);
    }

    public void unDeafen() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unDeafen();
    }

    public void unMute() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unMute();
    }

    public void peerRemoved(Peer peer) {
    }

    public void updateFromPeer(Object oPeerNode, int eventType, String arg1, Object arg2) {
        if (eventType == 0 && "Dirtied".equals(arg1)) {
            this.mpdDoc.getCosDocument().markDirty();
            this.contentChanged(true);
            return;
        }
        if (oPeerNode instanceof DataWindow) {
            this.mbRemergeRequired = true;
        }
        if (eventType == 0 && oPeerNode instanceof FormModel) {
            this.mbRemergeRequired = false;
            this.mbEnumRequired = true;
            this.enumFields(EnumFieldsCode.UPDATE_ACROFORM);
            FormModel oFormModel = FormModel.getFormModel((AppModel)this.moAppModel, (boolean)true);
            this.mbCalcOccuring = true;
            if (this.getValidationsEnabled()) {
                Validate oValidate = new Validate(this, true, false, false, false);
                oFormModel.recalculate(true, (FormModel.Validate)oValidate, false);
            } else {
                oFormModel.recalculate(true, null, false);
            }
            this.mbCalcOccuring = false;
            this.reportErrors();
            this.contentChanged(false);
        }
    }

    public void performRendering() {
        if (this.moAcroFormLayout == null || !this.isDocDynamic(true)) {
            return;
        }
    }

    public Node getPacketToIgnoreWhileComparisonDuringSubmit() {
        return this.mpPacketToIgnoreWhileComparisonDuringSubmit;
    }

    void setPacketToIgnoreWhileComparisonDuringSubmit(Node pPacket) {
        this.mpPacketToIgnoreWhileComparisonDuringSubmit = pPacket;
    }

    public void iterateAndProtectFieldMDPFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureManager sigMgr = SignatureManager.newInstance(this.mpdDoc);
        Iterator<SignatureFieldInterface> sigIter = sigMgr.getPDFSignatureFieldIterator();
        while (sigIter.hasNext()) {
            Node field;
            SignatureFieldInterface sigField = sigIter.next();
            if (!sigField.isSigned() || !((field = this.getFieldXFANode(sigField.getQualifiedName())) instanceof Field)) continue;
            FieldMDP fieldMDP = new FieldMDP(this.mpdDoc, (Field)field);
            fieldMDP.protectXFAFieldMDPFields(new FieldMDP.ProtectOperationType(5));
        }
    }

    public static enum DSNotificationType {
        DSWillSign,
        DSDidSign,
        DSFailSign;

    }

    public class SignEventInfo {
        public SignatureFieldInterface sigField;
        public DSNotificationType notificationID;
    }

    static enum EnumFieldsCode {
        UPDATE_XFA,
        UPDATE_ACROFORM,
        UPDATE_BOTH,
        LOCK,
        UPDATE_NONE;

    }
}

