/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;

public final class PDDoc2CPDFields {
    public static void DeleteCPDFieldsOnDidCloseProc(PDFDocument pdd) {
        PDDoc2CPDFields.DeleteCPDFields(pdd);
    }

    static void DeleteCPDFields(PDFDocument pdfDoc) {
        CPDFields pCPDFlds;
        DocumentListenerRegistry registry = pdfDoc.getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        if (serviceListener != null && (pCPDFlds = serviceListener.getCPDFields()) != null) {
            assert (pCPDFlds.isDead());
            serviceListener.setCPDFields(null);
        }
    }

    public static final CPDFields GetCPDFieldsFromPDDoc(PDFDocument pdfDoc, boolean bCreate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CPDFields pCPDFlds = null;
        DocumentListenerRegistry registry = pdfDoc.getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        if (serviceListener == null) {
            if (bCreate) {
                serviceListener = new XFADOMServiceListener(pdfDoc, null, null);
                pCPDFlds = new CPDFields(pdfDoc);
                serviceListener.setCPDFields(pCPDFlds);
                registry.registerListener(XFADOMServiceListener.class, (DocumentListener)serviceListener);
            }
        } else {
            pCPDFlds = serviceListener.getCPDFields();
            if (pCPDFlds == null && bCreate) {
                pCPDFlds = new CPDFields(pdfDoc);
                serviceListener.setCPDFields(pCPDFlds);
            }
            if (pCPDFlds != null && pCPDFlds.isDead()) {
                pCPDFlds = null;
            }
        }
        return pCPDFlds;
    }
}

