/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.TextAppearance_t;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class AFUtils {
    static final int MaxStringLen = 65535;
    static final double fixedZero = 0.0;
    static final double fixedOne = 65536.0;

    static final CosObject AFCosObjInheritedValue(CosDictionary dict, ASName key, boolean bLookInAF) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (dict != null) {
            CosObject coWanted = dict.get(key);
            CosDocument cd = dict.getDocument();
            while (coWanted == null || coWanted.getType() == 0) {
                if ((dict = dict.getCosDictionary(ASName.k_Parent)) == null || dict.getType() == 0) {
                    if (bLookInAF) {
                        return cd.getRoot().get(key);
                    }
                    return coWanted;
                }
                coWanted = dict.get(key);
            }
            return coWanted;
        }
        return null;
    }

    static final String EStrNewFromCosObj(CosObject co) {
        String es = null;
        int cosType = co == null ? 0 : co.getType();
        switch (cosType) {
            case 4: {
                try {
                    es = ((CosString)co).textValue();
                }
                catch (PDFSecurityException pDFSecurityException) {}
                break;
            }
            case 3: {
                es = ((CosName)co).nameValue().asString(true);
                break;
            }
            case 0: {
                es = null;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return es;
    }

    static final boolean EStrIsNull(String es) {
        if (es == null) {
            return true;
        }
        return es.length() == 0;
    }

    static final CosObject AFCosObjStringOrStream(PDFDocument doc, byte[] data, int len) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (len == 0) {
            return doc.getCosDocument().createCosNull();
        }
        CosNull retVal = doc.getCosDocument().createCosNull();
        if (len > 65535) {
            PDFFilterList filters = PDFFilterList.newInstance((PDFDocument)doc);
            PDFFilter filter = PDFFilter.newInstance((PDFDocument)doc, (String)"FlateDecode", null);
            filters.add(filter);
            PDFStream str = PDFStream.newInstance((PDFDocument)doc);
            str.setStreamData((InputStream)new ByteArrayInputStream(data, 0, len));
            str.setOutputFilters(filters);
            retVal = str.getCosObject();
        } else {
            retVal = doc.getCosDocument().createCosString(data);
        }
        return retVal;
    }

    static final CosDictionary AFCosDictEnsure(CosDictionary coParent, ASName asaKey) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return AFUtils.AFCosDictEnsureEx(coParent, asaKey, false);
    }

    static final CosDictionary AFCosDictEnsureEx(CosDictionary coParent, ASName asaKey, boolean bIndirect) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject co = coParent.get(asaKey);
        if (co == null || co.getType() != 6) {
            co = coParent.getDocument().createCosDictionary(bIndirect ? 1 : 0);
            coParent.put(asaKey, co);
        }
        return (CosDictionary)co;
    }

    static final boolean AFPDColorValueEqual(TextAppearance_t.PDColorValueRec pdcvOne, TextAppearance_t.PDColorValueRec pdcvTwo) {
        if (pdcvOne == pdcvTwo) {
            return true;
        }
        if (pdcvOne == null || pdcvTwo == null) {
            return false;
        }
        if (pdcvOne.colorSpace != pdcvTwo.colorSpace) {
            return false;
        }
        switch (pdcvOne.colorSpace) {
            case 127: {
                return true;
            }
            case 0: {
                return pdcvOne.value[0] == pdcvTwo.value[0];
            }
            case 1: {
                return pdcvOne.value[0] == pdcvTwo.value[0] && pdcvOne.value[1] == pdcvTwo.value[1] && pdcvOne.value[2] == pdcvTwo.value[2];
            }
            case 2: {
                return pdcvOne.value[0] == pdcvTwo.value[0] && pdcvOne.value[1] == pdcvTwo.value[1] && pdcvOne.value[2] == pdcvTwo.value[2] && pdcvOne.value[2] == pdcvTwo.value[3];
            }
        }
        return false;
    }

    static final boolean AFPDColorValueIs(TextAppearance_t.PDColorValueRec pdcv, int space) {
        return pdcv.colorSpace == space;
    }

    static final boolean AFPDColorValueIsTransparent(TextAppearance_t.PDColorValueRec pdcv) {
        return AFUtils.AFPDColorValueIs(pdcv, 127);
    }

    static final void AFPDColorStore(CosObject dict, ASName key, TextAppearance_t.PDColorValueRec colP) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (dict != null && dict.getType() == 6 && AFUtils.ValidPDColorValue(colP)) {
            CosDocument dP = dict.getDocument();
            CosArray Arr = dP.createCosArray();
            switch (colP.colorSpace) {
                case 2: {
                    Arr.add((CosObject)dP.createCosNumeric(colP.value[3]));
                }
                case 1: {
                    Arr.add((CosObject)dP.createCosNumeric(colP.value[2]));
                    Arr.add((CosObject)dP.createCosNumeric(colP.value[1]));
                }
                case 0: {
                    Arr.add((CosObject)dP.createCosNumeric(colP.value[0]));
                }
            }
            if (((CosDictionary)dict).containsKey((Object)key)) {
                ((CosDictionary)dict).remove(key);
            }
            ((CosDictionary)dict).put(key, (CosObject)Arr);
        }
    }

    static final boolean ValidColorVal(double c) {
        return c >= 0.0 && c <= 65536.0;
    }

    static boolean ValidPDColorValue(TextAppearance_t.PDColorValueRec c) {
        boolean isValid = true;
        if (c.colorSpace < 0 || c.colorSpace > 2 && c.colorSpace != 127) {
            return false;
        }
        switch (c.colorSpace) {
            case 2: {
                isValid = isValid && AFUtils.ValidColorVal(c.value[3]);
            }
            case 1: {
                isValid = isValid && AFUtils.ValidColorVal(c.value[2]);
                isValid = isValid && AFUtils.ValidColorVal(c.value[1]);
            }
            case 0: {
                isValid = isValid && AFUtils.ValidColorVal(c.value[0]);
                break;
            }
        }
        return isValid;
    }

    static final void AFPDColorValueSet(TextAppearance_t.PDColorValueRec pdcv, int space, double v1, double v2, double v3, double v4) {
        pdcv.colorSpace = space;
        pdcv.value[0] = v1;
        pdcv.value[1] = v2;
        pdcv.value[2] = v3;
        pdcv.value[3] = v4;
    }

    static final void AFPDColorValueSetTransparent(TextAppearance_t.PDColorValueRec pdcv) {
        AFUtils.AFPDColorValueSet(pdcv, 127, 0.0, 0.0, 0.0, 0.0);
    }

    static final void AFPDColorLoad(CosObject values, TextAppearance_t.PDColorValueRec colP) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (values != null && values.getType() == 5) {
            if (4 == ((CosArray)values).size()) {
                colP.colorSpace = 2;
            } else if (3 == ((CosArray)values).size()) {
                colP.colorSpace = 1;
            } else if (1 == ((CosArray)values).size()) {
                colP.colorSpace = 0;
            } else {
                AFUtils.AFPDColorValueSetTransparent(colP);
            }
            switch (colP.colorSpace) {
                case 2: {
                    CosObject x = ((CosArray)values).get(3);
                    colP.value[3] = ((CosNumeric)x).doubleValue();
                }
                case 1: {
                    CosObject x = ((CosArray)values).get(2);
                    colP.value[2] = ((CosNumeric)x).doubleValue();
                    x = ((CosArray)values).get(1);
                    colP.value[1] = ((CosNumeric)x).doubleValue();
                }
                case 0: {
                    CosObject x = ((CosArray)values).get(0);
                    colP.value[0] = ((CosNumeric)x).doubleValue();
                }
            }
            return;
        }
        AFUtils.AFPDColorValueSetTransparent(colP);
    }

    public static class AFPDWidgetBorderRec {
        public PDFBorderStyle.Style nStyle;
        public int nWidth = -1;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AFPDWidgetBorderRec) {
                AFPDWidgetBorderRec borderObj = (AFPDWidgetBorderRec)obj;
                return borderObj.nStyle == this.nStyle && borderObj.nWidth == this.nWidth;
            }
            return false;
        }
    }
}

