/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xdp;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.TagSearchingOutputStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.impl.SimpleText;
import com.adobe.internal.pdftoolkit.services.xdp.PDF2XDPWriter;
import com.adobe.internal.pdftoolkit.services.xdp.XDP2PDFProcessor;
import com.adobe.internal.pdftoolkit.services.xdp.XDPOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public final class XDPService {
    private static final String[] warningText = new String[]{"Warning: This form is not supported at all with the current version of Acrobat or Adobe Reader.", "Upgrade to the latest version for full support."};
    public static final ASName k_Draw = ASName.create((String)"Draw");
    public static final ASName k_Field = ASName.create((String)"Field");
    public static final ASName k_Page = ASName.create((String)"Page");
    public static final ASName k_Subform = ASName.create((String)"Subform");

    private XDPService() {
    }

    public static PDFDocument convert(ByteReader inputXDP, ByteWriter pdfStream, PDFOpenOptions options) throws PDFIOException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFSecurityException, PDFConfigurationException {
        return XDP2PDFProcessor.processXDP2PDF(inputXDP, pdfStream, options, true);
    }

    public static void convert(PDFDocument document, XDPOptions options, ByteWriter xdpBW, PDFSaveOptions saveOptions) throws PDFIOException, PDFInvalidXMLException {
        try {
            OutputByteStream obs = document.getStreamManager().getOutputByteStream(xdpBW);
            SkippingOutputStream xdpStream = obs.toOutputStream();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer xmlTransformer = tFactory.newTransformer();
            String encoding = xmlTransformer.getOutputProperty("encoding");
            PDF2XDPWriter xdpWriter = new PDF2XDPWriter(document, xdpBW, xdpStream, options, saveOptions);
            String tagString = new String(PDF2XDPWriter.XDP_TAG);
            byte[] tag = tagString.getBytes(encoding);
            TagSearchingOutputStream tagStream = null;
            tagStream = new TagSearchingOutputStream((OutputStream)xdpStream, tag, (TagSearchingOutputStream.Callback)xdpWriter);
            InputSource inputSource = new InputSource();
            Source source = XMLUtils.createSource((InputSource)inputSource, (XMLFilter)xdpWriter);
            StreamResult result = new StreamResult((OutputStream)tagStream);
            xmlTransformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new PDFIOException("Unable to get the encoding for the XML output.", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException((Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to create needed stream.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to set required XML features.", e);
        }
    }

    public static void importXFA(PDFDocument pdfDocument, ByteReader xdpByteReader) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException {
        InputByteStream xdpIBS = null;
        try {
            xdpIBS = pdfDocument.getStreamManager().getInputByteStream(xdpByteReader);
            XDP2PDFProcessor.importXDP2PDF(pdfDocument, xdpIBS, true);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                if (xdpIBS != null) {
                    xdpIBS.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }

    public static PDFDocument createShellPDF(ByteReader inputXDP, PDFOpenOptions openOptions) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        PDFDocument shellPDF = null;
        InputByteStream xfaInput = null;
        try {
            shellPDF = PDFDocument.newInstance((PDFOpenOptions)openOptions);
            xfaInput = shellPDF.getStreamManager().getInputByteStream(inputXDP);
            if (!XFAService.isShellXFA(xfaInput)) {
                throw new PDFInvalidXMLException("XFA is not a shell XFA");
            }
            if (XFAService.hasPDFChunk(xfaInput)) {
                throw new PDFInvalidXMLException("Shell XFA contains PDF chunk");
            }
            HashMap<ASName, ASName> roles = new HashMap<ASName, ASName>();
            roles.put(k_Draw, PDFStructureRole.k_Div);
            roles.put(k_Field, PDFStructureRole.k_Div);
            roles.put(k_Page, PDFStructureRole.k_Part);
            roles.put(k_Subform, PDFStructureRole.k_Sect);
            PDFPage emptyPage = SimpleText.createBoilerplatePage(shellPDF, warningText, 0, roles);
            PDFPageTree.newInstance((PDFDocument)shellPDF, (PDFPage)emptyPage);
            XDP2PDFProcessor.importXDP2PDF(shellPDF, xfaInput, true);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            if (xfaInput != null) {
                try {
                    xfaInput.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to close ByteReader", (Throwable)e);
                }
            }
            try {
                inputXDP.close();
            }
            catch (IOException e) {
                throw new PDFIOException("Unable to close ByteReader", (Throwable)e);
            }
        }
        return shellPDF;
    }
}

