/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.util.LinkedHashMap;
import java.util.Map;

class SanitizationGState
extends GState {
    private ASMatrix currentConcatMatrix = null;
    private Map<GraphicsOperator, Instruction> pendingInstructions = new LinkedHashMap<GraphicsOperator, Instruction>();

    SanitizationGState(SanitizationGState gState) {
        super((GState)gState);
        this.pendingInstructions.putAll(gState.pendingInstructions);
        this.currentConcatMatrix = gState.currentConcatMatrix;
    }

    SanitizationGState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    void removePendingOperatorInstruction(GraphicsOperator operator) {
        if (this.pendingInstructions != null) {
            this.pendingInstructions.remove((Object)operator);
        }
    }

    void handleInstruction(GraphicsOperator operator, Instruction instruction) {
        this.pendingInstructions.remove((Object)operator);
        this.pendingInstructions.put(operator, instruction);
    }

    void handleCMInstruction(GraphicsOperator operator, Instruction instruction, ASMatrix matrix) {
        if (this.currentConcatMatrix != null) {
            this.currentConcatMatrix = matrix.concat(this.currentConcatMatrix);
            instruction = InstructionFactory.newConcatMatrix((double)this.currentConcatMatrix.geta(), (double)this.currentConcatMatrix.getb(), (double)this.currentConcatMatrix.getc(), (double)this.currentConcatMatrix.getd(), (double)this.currentConcatMatrix.getx(), (double)this.currentConcatMatrix.gety());
        } else {
            this.currentConcatMatrix = matrix;
        }
        this.pendingInstructions.put(operator, instruction);
    }

    ASMatrix getPendingMatrix() {
        return this.currentConcatMatrix;
    }

    /*
     * Unable to fully structure code
     */
    void write(Instruction instruction, ContentWriter writer, SanitizationContext context, PDFResources resources, boolean ignoreCM) throws PDFIOException, PDFInvalidContentException {
        operator = instruction.getOperator();
        itr = this.pendingInstructions.entrySet().iterator();
        entry = null;
        value = null;
        key = null;
        while (itr.hasNext()) {
            entry = itr.next();
            key = entry.getKey();
            value = entry.getValue();
            switch (1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[GraphicsOperator.access$000(key).ordinal()]) {
                case 1: {
                    if (operator == ASName.k_BI || operator == ASName.k_W || operator == ASName.k_WStar) break;
                }
                case 2: {
                    if (operator == ASName.k_W || operator == ASName.k_WStar) break;
                    if (GraphicsOperator.access$100(key) != ASName.k_cs && GraphicsOperator.access$100(key) != ASName.k_CS) ** GOTO lbl18
                    context.addResource(resources.getCosObject(), ASName.k_ColorSpace, value.getOperands().peekName());
                    ** GOTO lbl20
lbl18:
                    // 1 sources

                    if ((GraphicsOperator.access$100(key) == ASName.k_SCN || GraphicsOperator.access$100(key) == ASName.k_scn) && value.getOperands().peekTypeIsName()) {
                        context.addResource(resources.getCosObject(), ASName.k_Pattern, value.getOperands().peekName());
                    }
                }
lbl20:
                // 5 sources

                case 3: {
                    if (ignoreCM) break;
                }
                case 4: {
                    if (GraphicsOperator.access$100(key) == ASName.k_gs) {
                        context.addResource(resources.getCosObject(), ASName.k_ExtGState, value.getOperands().peekName());
                    }
                    writer.write(value);
                    itr.remove();
                    break;
                }
                case 5: {
                    if (operator != ASName.k_TJ && operator != ASName.k_Tj && operator != ASName.k_DoubleQuote && operator != ASName.k_SingleQuote) break;
                    writer.write(value);
                    itr.remove();
                    if (GraphicsOperator.access$100(key) != ASName.k_Tf) break;
                    operands = value.getReadonlyOperands();
                    operands.pop();
                    context.addResource(resources.getCosObject(), ASName.k_Font, operands.popName());
                }
            }
        }
        if (!ignoreCM) {
            this.currentConcatMatrix = null;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType;

        static {
            $SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType = new int[OperatorType.values().length];
            try {
                1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[OperatorType.LineAttrs.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[OperatorType.Color.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[OperatorType.Transformation.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[OperatorType.General.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$adobe$internal$pdftoolkit$services$sanitization$impl$SanitizationGState$OperatorType[OperatorType.Text.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum GraphicsOperator {
        w(ASName.k_w, OperatorType.LineAttrs),
        J(ASName.k_J, OperatorType.LineAttrs),
        j(ASName.k_j, OperatorType.LineAttrs),
        M(ASName.k_M, OperatorType.LineAttrs),
        d(ASName.k_d, OperatorType.LineAttrs),
        cm(ASName.k_cm, OperatorType.Transformation),
        gs(ASName.k_gs, OperatorType.General),
        Tc(ASName.k_Tc, OperatorType.Text),
        Tw(ASName.k_Tw, OperatorType.Text),
        Tz(ASName.k_Tz, OperatorType.Text),
        TL(ASName.k_TL, OperatorType.Text),
        Tf(ASName.k_Tf, OperatorType.Text),
        Tr(ASName.k_Tr, OperatorType.Text),
        Ts(ASName.k_Ts, OperatorType.Text),
        Td(ASName.k_Td, OperatorType.Text),
        TD(ASName.k_TD, OperatorType.Text),
        Tm(ASName.k_Tm, OperatorType.Text),
        TStar(ASName.k_TStar, OperatorType.Text),
        cs(ASName.k_cs, OperatorType.Color),
        CS(ASName.k_CS, OperatorType.Color),
        scn(ASName.k_scn, OperatorType.Color),
        SCN(ASName.k_SCN, OperatorType.Color),
        sc(ASName.k_sc, OperatorType.Color),
        SC(ASName.k_SC, OperatorType.Color),
        g(ASName.k_g, OperatorType.Color),
        G(ASName.k_G, OperatorType.Color),
        rg(ASName.k_rg, OperatorType.Color),
        RG(ASName.k_RG, OperatorType.Color),
        k(ASName.k_k, OperatorType.Color),
        K(ASName.k_K, OperatorType.Color),
        ri(ASName.k_ri, OperatorType.Color),
        i(ASName.k_i, OperatorType.Color);

        private ASName operator;
        private OperatorType type;

        private GraphicsOperator(ASName operator, OperatorType type) {
            this.operator = operator;
            this.type = type;
        }

        static /* synthetic */ OperatorType access$000(GraphicsOperator x0) {
            return x0.type;
        }

        static /* synthetic */ ASName access$100(GraphicsOperator x0) {
            return x0.operator;
        }
    }

    private static enum OperatorType {
        LineAttrs,
        Color,
        Text,
        Transformation,
        General;

    }
}

