/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PostSanitizer {
    private PostSanitizer() {
    }

    public static void sanitize(PDFDocument pdfDoc, SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOptimizer.doPostOptimization(pdfDoc);
        PostSanitizer.cleanUpResources(context);
        context.getImageOptimizer().optimizeImages(context.getUserOptions().getHandler());
    }

    private static void cleanUpResources(SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Map<CosObject, Map<ASName, Set<ASName>>> referredResources = context.getReferredResources();
        if (referredResources == null) {
            return;
        }
        Set<Map.Entry<CosObject, Map<ASName, Set<ASName>>>> resourcesSet = referredResources.entrySet();
        Iterator<Map.Entry<CosObject, Map<ASName, Set<ASName>>>> resourcesItr = resourcesSet.iterator();
        Map.Entry<CosObject, Map<ASName, Set<ASName>>> entry = null;
        Map<ASName, Set<ASName>> currentResourceMap = null;
        PDFResources currentResource = null;
        Iterator keysItr = null;
        ASName resourceType = null;
        Set<ASName> currentReferredResources = null;
        while (resourcesItr.hasNext()) {
            entry = resourcesItr.next();
            currentResource = PDFResources.getInstance((CosObject)entry.getKey());
            currentResourceMap = entry.getValue();
            keysItr = currentResource.getCosDictionary().keyIterator();
            while (keysItr.hasNext()) {
                resourceType = (ASName)keysItr.next();
                if (resourceType == ASName.k_ProcSet) continue;
                currentReferredResources = currentResourceMap.get(resourceType);
                if (resourceType != ASName.k_ColorSpace && currentReferredResources == null) {
                    keysItr.remove();
                    continue;
                }
                CosDictionary resources = currentResource.getCosDictionary().getCosDictionary(resourceType);
                Iterator resourcesNamesItr = resources.keyIterator();
                ASName resourceName = null;
                boolean allKeysRemoved = true;
                while (resourcesNamesItr.hasNext()) {
                    resourceName = (ASName)resourcesNamesItr.next();
                    if (!(resourceName == ASName.k_DefaultCMYK || resourceName == ASName.k_DefaultRGB || resourceName == ASName.k_DefaultGray || currentReferredResources != null && currentReferredResources.contains(resourceName))) {
                        resourcesNamesItr.remove();
                        continue;
                    }
                    allKeysRemoved = false;
                }
                if (!allKeysRemoved) continue;
                keysItr.remove();
            }
        }
    }
}

