/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.io.stream.CroppedImageInputByteStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GStateStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamFilterImpl;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCUsageAppHandler;
import com.adobe.internal.pdftoolkit.services.pdfParser.ParserUtils;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.HiddenContentManager;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationGState;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationUtils;
import com.adobe.internal.util.ArrayListStack;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class InstructionModifier
extends ContentStreamFilterImpl {
    static final int overlappedObjectVisibility = -1;
    private List<ASCoordinate> currentPath;
    private ASCoordinate currentPoint = null;
    private PDFResources pdfResources;
    private OCManager ocManager = null;
    private ArrayListStack<Boolean> markedContentTagStack = null;
    private SanitizationContext context = null;
    private double[] contentItemPixelsVisibility = null;
    private int currentContentIndex = 0;
    static final double contentVisibilityThreshold = 0.6;
    private ContentItemsList<GraphicsState, ContentItem<GraphicsState>> graphicsDOM;
    private GStateStack<SanitizationGState> gStateStack;
    private HiddenContentManager hiddenContentMgr;
    private PDFPage pdfPage = null;
    private List<Instruction> pathInstructions = new ArrayList<Instruction>();
    private static final ASRectangle unitSquare = new ASRectangle(0.0, 0.0, 1.0, 1.0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstructionModifier(ContentStreamWriter contentStreamWriter, ContentStreamReader parent, PDFResources pdfResources, SanitizationContext context, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.setContentStreamHandler((IOperatorHandler)contentStreamWriter);
        super.setParent((IContentStreamReader)parent);
        this.pdfPage = pdfPage;
        this.pdfResources = pdfResources;
        this.context = context;
        this.gStateStack = new GStateStack((GState)new SanitizationGState());
        this.hiddenContentMgr = context.getHiddenContentManager();
        if (this.hiddenContentMgr != null) {
            try {
                Map<HashSet<Integer>, Rectangle2D> overlappingBounds;
                this.contentItemPixelsVisibility = context.getHiddenContentManager().getContentItemsVisibility();
                if (this.contentItemPixelsVisibility == null) {
                    this.contentItemPixelsVisibility = new double[this.hiddenContentMgr.getLastID() + 1];
                }
                if ((overlappingBounds = context.getHiddenContentManager().getOverlappingObjectsDetector().getOverlappingBoundingBoxes()) != null) {
                    Iterator<Map.Entry<HashSet<Integer>, Rectangle2D>> itr = overlappingBounds.entrySet().iterator();
                    Map.Entry<HashSet<Integer>, Rectangle2D> entry = null;
                    Iterator<Integer> keysItr = null;
                    while (itr.hasNext()) {
                        entry = itr.next();
                        keysItr = entry.getKey().iterator();
                        while (keysItr.hasNext()) {
                            this.contentItemPixelsVisibility[keysItr.next().intValue()] = -1.0;
                        }
                    }
                }
                this.graphicsDOM = this.hiddenContentMgr.getGraphicsDOM().getContentItems();
            }
            finally {
                this.hiddenContentMgr.destroy();
            }
        }
    }

    InstructionModifier(InstructionModifier modifier, PDFResources resources, ContentStreamWriter writer, ContentStreamReader parent, ContentItemsList<GraphicsState, ContentItem<GraphicsState>> graphicsDOM) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super.setContentStreamHandler((IOperatorHandler)writer);
        super.setParent((IContentStreamReader)parent);
        this.graphicsDOM = graphicsDOM;
        this.pdfResources = resources;
        this.context = modifier.context;
        this.contentItemPixelsVisibility = modifier.contentItemPixelsVisibility;
        this.gStateStack = modifier.gStateStack;
        this.hiddenContentMgr = modifier.hiddenContentMgr;
        this.pdfPage = modifier.pdfPage;
    }

    private void initializeOC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCProperties ocProps;
        if (this.ocManager == null && (ocProps = this.pdfResources.getPDFDocument().requireCatalog().getOCProperties()) != null && ocProps.getOCGs() != null && ocProps.getDefaultOCConfigDict() != null) {
            this.ocManager = OCManager.newInstance((PDFOCProperties)this.pdfResources.getPDFDocument().requireCatalog().getOCProperties(), (OCUsageAppHandler)new OCUsageAppHandler(){

                public Locale getLocale() {
                    return ocProps.getPDFDocument().getCosDocument().getOptions().getDocLocale();
                }

                public ASName getAppEvent() {
                    return InstructionModifier.this.context.getUserOptions().getHandler().getOCUsageAppEvent();
                }
            });
        }
        if (this.markedContentTagStack == null) {
            this.markedContentTagStack = new ArrayListStack();
            this.markedContentTagStack.push((Object)true);
        }
    }

    public void DP(ASName tag, ASName propertyName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    public void BMC(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        this.markedContentTagStack.push(this.markedContentTagStack.peek());
    }

    public void BDC(ASName tag, ASDictionary properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        this.markedContentTagStack.push(this.markedContentTagStack.peek());
    }

    public void BDC(ASName tag, ASName propertyName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.initializeOC();
        if (tag == ASName.k_OC) {
            PDFMCProperty property = null;
            if (this.pdfResources != null && (property = this.pdfResources.getMCProperty(propertyName)) != null) {
                PDFOCObject ocObj = PDFOCObject.getInstance((CosObject)property.getCosObject());
                this.markedContentTagStack.push((Object)((Boolean)this.markedContentTagStack.peek() & (this.ocManager == null || this.ocManager.isVisible(ocObj))));
                return;
            }
        }
        this.markedContentTagStack.push(this.markedContentTagStack.peek());
    }

    public void EMC(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.markedContentTagStack.pop();
    }

    public void MP(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentTagStack == null || this.markedContentTagStack.size() == 0) {
            return;
        }
        if (this.operatorHandler != null) {
            this.operatorHandler.MP(tag, instruction);
        }
    }

    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.gStateStack.push((GState)new SanitizationGState((SanitizationGState)this.gStateStack.peek()));
        super.q(instruction);
    }

    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.gStateStack.pop();
        super.Q(instruction);
    }

    public void cm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix ctm = new ASMatrix(a, b, c, d, e, f);
        GState gState = this.gStateStack.peek();
        ASMatrix newCTM = ctm.concat(gState.getCTM());
        gState.setCTM(newCTM);
        this.getGState().handleCMInstruction(SanitizationGState.GraphicsOperator.cm, instruction, ctm);
    }

    private ASRectangle getTransformedImageRect(ASMatrix matrix, ASRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate coord1 = new ASCoordinate(rect.left(), rect.bottom()).transform(matrix);
        ASCoordinate coord2 = new ASCoordinate(rect.left(), rect.top()).transform(matrix);
        ASCoordinate coord3 = new ASCoordinate(rect.right(), rect.bottom()).transform(matrix);
        ASCoordinate coord4 = new ASCoordinate(rect.right(), rect.top()).transform(matrix);
        rect = new ASRectangle(Math.min(Math.min(coord1.x(), coord2.x()), Math.min(coord3.x(), coord4.x())), Math.min(Math.min(coord1.y(), coord2.y()), Math.min(coord3.y(), coord4.y())), Math.max(Math.max(coord1.x(), coord2.x()), Math.max(coord3.x(), coord4.x())), Math.max(Math.max(coord1.y(), coord2.y()), Math.max(coord3.y(), coord4.y())));
        return rect.normalized();
    }

    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCObject ocObject;
        if (this.markedContentTagStack != null && !((Boolean)this.markedContentTagStack.peek()).booleanValue()) {
            return;
        }
        PDFXObject xObject = this.pdfResources.getXObject(name);
        if (xObject != null && (ocObject = PDFOCObject.getOC((PDFXObject)xObject)) != null) {
            this.initializeOC();
            if (this.ocManager != null && !this.ocManager.isVisible(ocObject)) {
                return;
            }
            xObject.removeValue(ASName.k_OC);
        }
        try {
            PDFXObject xObj = null;
            if (this.graphicsDOM != null) {
                xObj = this.pdfResources.getXObject(name);
            }
            boolean isHidden = false;
            SanitizationUtils.ImageVisibility cropping = null;
            if (this.graphicsDOM != null && xObj instanceof PDFXObjectForm && (isHidden = SanitizationUtils.isXObjectHidden(this.pdfPage, (XObject)this.graphicsDOM.get(this.currentContentIndex), this.contentItemPixelsVisibility, (PDFXObjectForm)xObj, this.context))) {
                PDFXObjectForm xObjForm = (PDFXObjectForm)this.pdfResources.getXObject(name);
                this.q(InstructionFactory.newGSave());
                double[] matrix = xObjForm.getMatrix();
                this.cm(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5], InstructionFactory.newConcatMatrix((double)matrix[0], (double)matrix[1], (double)matrix[2], (double)matrix[3], (double)matrix[4], (double)matrix[5]));
                this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, true);
                PDFXObjectForm newxObj = SanitizationUtils.removeHiddenInfoFromXObject(this.context, xObjForm, this.currentContentIndex, this.graphicsDOM, this, this.pdfPage);
                if (newxObj != null) {
                    int newXObjCount = 0;
                    ASName xObjName = null;
                    do {
                        xObjName = ASName.create((String)("Fm" + newXObjCount++));
                    } while (this.pdfResources.getXObjectMap().containsKey((Object)xObjName));
                    this.pdfResources.getXObjectMap().put(xObjName, (PDFCosObjectContainer)newxObj);
                    this.context.addResource(this.pdfResources.getCosObject(), ASName.k_XObject, xObjName);
                    super.Do(xObjName, InstructionFactory.newInvokeNamedXObject((ASName)xObjName));
                }
                this.Q(InstructionFactory.newGRestore());
                return;
            }
            if (this.graphicsDOM != null && xObj instanceof PDFXObjectImage) {
                if (this.contentItemPixelsVisibility != null && this.contentItemPixelsVisibility[this.graphicsDOM.get(this.currentContentIndex).getID()] == -1.0) {
                    return;
                }
                ContentImageItem imageItem = (ContentImageItem)this.graphicsDOM.get(this.currentContentIndex);
                PDFXObjectImage xObjImage = (PDFXObjectImage)this.pdfResources.getXObject(name);
                int height = xObjImage.getHeight();
                int width = xObjImage.getWidth();
                double[] box = SanitizationUtils.getImageCropBox(this.pdfPage, imageItem);
                cropping = SanitizationUtils.getImageCroppingStatus(imageItem, box);
                if (cropping == SanitizationUtils.ImageVisibility.completelyHidden) {
                    return;
                }
                if (cropping == SanitizationUtils.ImageVisibility.partiallyCropped) {
                    ASMatrix ctm = ((SanitizationGState)this.gStateStack.peek()).getCTM();
                    ASRectangle newImageDimensions = this.getTransformedImageRect(ctm.getInverse(), new ASRectangle(box[0], box[1], box[0] + box[2], box[1] + box[3])).transform(new ASMatrix((double)width, 0.0, 0.0, (double)height, 0.0, 0.0));
                    int x1 = (int)Math.max(Math.floor(newImageDimensions.left()), 0.0);
                    int y1 = (int)Math.max(Math.floor(newImageDimensions.bottom()), 0.0);
                    int x2 = (int)Math.min(Math.ceil(newImageDimensions.right()), (double)width);
                    int y2 = (int)Math.min(Math.ceil(newImageDimensions.top()), (double)height);
                    int bpc = xObjImage.getBitsPerComponent();
                    PDFColorSpace cs = xObjImage.getColorSpace();
                    if (cs == null && xObjImage.getIsImageMask()) {
                        cs = PDFColorSpaceDeviceGray.newInstance((PDFDocument)xObjImage.getPDFDocument());
                    }
                    int noc = cs.getName() == ASName.k_Indexed ? 1 : cs.getNumberOfComponents();
                    InputStream decodedImage = xObjImage.getImageStreamData();
                    CroppedImageInputByteStream newImageData = new CroppedImageInputByteStream(bpc, noc, decodedImage, width, height, x1, y1, x2, y2);
                    CosCloneMgr cloneMgr = new CosCloneMgr(xObjImage.getPDFDocument().getCosDocument());
                    PDFXObjectImage newImage = PDFXObjectImage.getInstance((CosObject)cloneMgr.clone(xObjImage.getCosObject()));
                    newImage.setImageStreamData((InputByteStream)newImageData);
                    newImage.setWidth(x2 - x1);
                    newImage.setHeight(y2 - y1);
                    ASMatrix inverse = ctm.getInverse();
                    ASMatrix croppedMatrix = SanitizationUtils.getCroppedImageMatrix(ctm, width, height, new ASRectangle((double)x1, (double)y1, (double)(width - x2), (double)(height - y2)));
                    inverse = croppedMatrix.concat(inverse);
                    this.q(InstructionFactory.newGSave());
                    this.cm(inverse.geta(), inverse.getb(), inverse.getc(), inverse.getd(), inverse.getx(), inverse.gety(), InstructionFactory.newConcatMatrix((double)inverse.geta(), (double)inverse.getb(), (double)inverse.getc(), (double)inverse.getd(), (double)inverse.getx(), (double)inverse.gety()));
                    this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
                    ASName newImageName = ((ContentStreamWriter)this.operatorHandler).getContentWriter().write((PDFXObject)newImage);
                    this.context.addResource(this.pdfResources.getCosObject(), ASName.k_XObject, newImageName);
                    this.context.getImageOptimizer().gatherImageOptimizationInfo(newImage, this.pdfPage, this.getTransformedImageRect(this.getGState().getCTM(), unitSquare), true);
                    this.Q(InstructionFactory.newGRestore());
                    return;
                }
            }
            if (this.graphicsDOM == null || xObj instanceof PDFXObjectForm && !isHidden || xObj instanceof PDFXObjectImage && cropping == SanitizationUtils.ImageVisibility.completelyVisible) {
                this.context.addResource(this.pdfResources.getCosObject(), ASName.k_XObject, name);
                this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
                super.Do(name, instruction);
                if (xObject instanceof PDFXObjectImage) {
                    this.context.getImageOptimizer().gatherImageOptimizationInfo((PDFXObjectImage)xObject, this.pdfPage, this.getTransformedImageRect(this.getGState().getCTM(), unitSquare), this.graphicsDOM != null);
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        finally {
            if (xObject instanceof PDFXObjectPostScript) {
                this.context.addResource(this.pdfResources.getCosObject(), ASName.k_XObject, name);
                this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
                super.Do(name, instruction);
            } else {
                ++this.currentContentIndex;
            }
        }
    }

    public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().getTextState().setFontName(fontName);
        this.getGState().getTextState().setFont(this.pdfResources.getFont(fontName));
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tf, instruction);
    }

    public void CS(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.CS, instruction);
    }

    public void cs(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.cs, instruction);
    }

    public void SCN(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.SCN, instruction);
    }

    public void scn(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.scn, instruction);
    }

    public void sh(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentTagStack != null && !((Boolean)this.markedContentTagStack.peek()).booleanValue() || this.isObjectOverlapped()) {
            return;
        }
        this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
        this.context.addResource(this.pdfResources.getCosObject(), ASName.k_Shading, name);
        super.sh(name, instruction);
        ++this.currentContentIndex;
    }

    public void gs(ASName extGStateName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.gs, instruction);
        ((SanitizationGState)this.gStateStack.peek()).loadExtGState(this.pdfResources.getExtGState(extGStateName));
    }

    public void m(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.createNewPath();
        this.currentPoint = new ASCoordinate(x, y);
        this.currentPath.add(this.currentPoint);
        this.pathInstructions.add(instruction);
    }

    public void l(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.currentPath == null) {
            this.createNewPath();
            this.currentPath.add(this.currentPoint);
        }
        this.currentPoint = new ASCoordinate(x, y);
        this.currentPath.add(this.currentPoint);
    }

    public void c(double x1, double y1, double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.currentPoint = new ASCoordinate(x3, y3);
        this.pathInstructions.add(instruction);
        this.endPath();
    }

    public void v(double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.currentPoint = new ASCoordinate(x3, y3);
        this.pathInstructions.add(instruction);
        this.endPath();
    }

    public void y(double x1, double y1, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.currentPoint = new ASCoordinate(x3, y3);
        this.pathInstructions.add(instruction);
        this.endPath();
    }

    public void h(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.pathInstructions.add(instruction);
        this.endPath();
    }

    public void re(double x, double y, double width, double height, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.currentPoint = new ASCoordinate(x, y);
        this.pathInstructions.add(instruction);
        this.endPath();
    }

    private void createNewPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = new ArrayList<ASCoordinate>();
    }

    private void endPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = null;
    }

    private void writePathInstructions() throws PDFIOException {
        if (this.pathInstructions == null) {
            return;
        }
        Iterator<Instruction> itr = this.pathInstructions.iterator();
        while (itr.hasNext()) {
            ((ContentStreamWriter)this.operatorHandler).getContentWriter().write(itr.next());
        }
        this.pathInstructions.clear();
    }

    private boolean isObjectOverlapped() {
        boolean isOverlapped;
        if (this.graphicsDOM == null) {
            return false;
        }
        ContentItem item = this.graphicsDOM.get(this.currentContentIndex);
        boolean bl = isOverlapped = this.contentItemPixelsVisibility != null && this.contentItemPixelsVisibility[item.getID()] == -1.0;
        if (isOverlapped) {
            ++this.currentContentIndex;
        }
        return isOverlapped;
    }

    public void S(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.S(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void s(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.s(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void f(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!(this.pathInstructions == null || this.pathInstructions.isEmpty() || this.markedContentTagStack != null && !((Boolean)this.markedContentTagStack.peek()).booleanValue() || this.isObjectOverlapped())) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.f(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void F(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.F(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void fStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.fStar(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void B(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.B(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void BStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.BStar(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void b(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.b(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void bStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) && !this.isObjectOverlapped()) {
            this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
            PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
            this.writePathInstructions();
            super.bStar(instruction);
            ++this.currentContentIndex;
        }
        this.endPath();
        this.pathInstructions.clear();
    }

    public void n(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super.n(instruction);
        this.endPath();
    }

    public void W(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.writePathInstructions();
        super.W(instruction);
        this.endPath();
    }

    public void WStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
        PDFOptimizer.fitLinesToBezierCurves(this.currentPath, this.pathInstructions);
        this.writePathInstructions();
        super.WStar(instruction);
        this.endPath();
    }

    public void BI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    public void EI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentTagStack == null || ((Boolean)this.markedContentTagStack.peek()).booleanValue()) {
            ++this.currentContentIndex;
        }
    }

    private void addInlineImageCSReference(ASDictionary imageParams, SanitizationContext context) {
        ASObject cs = imageParams.get((Object)ASName.k_CS);
        if (cs == null) {
            cs = imageParams.get((Object)ASName.k_ColorSpace);
        }
        if (cs != null && cs instanceof ASName && cs != ASName.k_DeviceRGB && cs != ASName.k_RGB && cs != ASName.k_DeviceGray && cs != ASName.k_G && cs != ASName.k_DeviceCMYK && cs != ASName.k_CMYK) {
            context.addResource(this.pdfResources.getCosObject(), ASName.k_ColorSpace, (ASName)cs);
        }
    }

    public void ID(ASDictionary imageParams, InputByteStream imageStream, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.markedContentTagStack != null && !((Boolean)this.markedContentTagStack.peek()).booleanValue()) {
            return;
        }
        try {
            SanitizationUtils.ImageVisibility cropping = SanitizationUtils.ImageVisibility.completelyVisible;
            if (this.graphicsDOM != null) {
                int id = this.graphicsDOM.get(this.currentContentIndex).getID();
                if (this.contentItemPixelsVisibility != null && this.contentItemPixelsVisibility[id] == -1.0) {
                    return;
                }
                ContentImageItem imageItem = (ContentImageItem)this.graphicsDOM.get(this.currentContentIndex);
                InlineImage inlineImage = InlineImage.newInstance(null, (ASDictionary)imageParams, (InputByteStream)imageStream);
                int height = inlineImage.getHeight();
                int width = inlineImage.getWidth();
                double[] box = SanitizationUtils.getImageCropBox(this.pdfPage, imageItem);
                cropping = SanitizationUtils.getImageCroppingStatus(imageItem, box);
                if (cropping == SanitizationUtils.ImageVisibility.completelyHidden) {
                    return;
                }
                if (cropping == SanitizationUtils.ImageVisibility.partiallyCropped) {
                    PDFColorSpace cs;
                    ASMatrix ctm = ((SanitizationGState)this.gStateStack.peek()).getCTM();
                    ASRectangle newImageDimensions = this.getTransformedImageRect(ctm.getInverse(), new ASRectangle(box[0], box[1], box[0] + box[2], box[1] + box[3])).transform(new ASMatrix((double)width, 0.0, 0.0, (double)height, 0.0, 0.0));
                    int x1 = (int)Math.max(Math.floor(newImageDimensions.left()), 0.0);
                    int y1 = (int)Math.max(Math.floor(newImageDimensions.bottom()), 0.0);
                    int x2 = (int)Math.min(Math.ceil(newImageDimensions.right()), (double)width);
                    int y2 = (int)Math.min(Math.ceil(newImageDimensions.top()), (double)height);
                    int bpc = inlineImage.getBitsPerComponent();
                    boolean isImageMask = false;
                    if (imageParams.containsKey((Object)ASName.k_IM) && imageParams.getBoolean(ASName.k_IM).isTrue() || imageParams.containsKey((Object)ASName.k_ImageMask) && imageParams.getBoolean(ASName.k_ImageMask).isTrue()) {
                        isImageMask = true;
                    }
                    int noc = (cs = (PDFColorSpace)ParserUtils.createPDFColorSpaceForInlineImage((ASDictionary)imageParams, (PDFResources)this.pdfResources, null, (boolean)isImageMask, (double[])inlineImage.getImageDecodeArray()).getUnderlyingColorspace()).getName() == ASName.k_Indexed ? 1 : cs.getNumberOfComponents();
                    InputStream decodedImage = inlineImage.getImageData();
                    CroppedImageInputByteStream newImageData = new CroppedImageInputByteStream(bpc, noc, decodedImage, width, height, x1, y1, x2, y2);
                    imageParams.remove(ASName.k_Filter);
                    imageParams.remove(ASName.k_F);
                    imageParams.remove(ASName.k_Width);
                    imageParams.remove(ASName.k_Height);
                    imageParams.put(ASName.k_W, (ASObject)new ASNumber(x2 - x1));
                    imageParams.put(ASName.k_H, (ASObject)new ASNumber(y2 - y1));
                    InlineImage newImage = InlineImage.newInstance(null, (ASDictionary)imageParams, (InputByteStream)newImageData);
                    newImage.setStreamFilters(ASName.k_FlateDecode, null);
                    imageParams.put(ASName.k_F, (ASObject)ASName.k_FlateDecode);
                    ASMatrix inverse = ctm.getInverse();
                    ASMatrix croppedMatrix = SanitizationUtils.getCroppedImageMatrix(ctm, width, height, new ASRectangle((double)x1, (double)y1, (double)(width - x2), (double)(height - y2)));
                    inverse = croppedMatrix.concat(inverse);
                    this.q(InstructionFactory.newGSave());
                    this.cm(inverse.geta(), inverse.getb(), inverse.getc(), inverse.getd(), inverse.getx(), inverse.gety(), InstructionFactory.newConcatMatrix((double)inverse.geta(), (double)inverse.getb(), (double)inverse.getc(), (double)inverse.getd(), (double)inverse.getx(), (double)inverse.gety()));
                    this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
                    ((ContentStreamWriter)this.operatorHandler).getContentWriter().write(newImage);
                    this.Q(InstructionFactory.newGRestore());
                    this.addInlineImageCSReference(imageParams, this.context);
                    return;
                }
            }
            if (cropping == SanitizationUtils.ImageVisibility.completelyVisible) {
                Instruction biInstruction = InstructionFactory.newInlineImageBegin();
                this.getGState().write(biInstruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
                this.addInlineImageCSReference(imageParams, this.context);
                super.BI(biInstruction);
                super.ID(imageParams, imageStream, instruction);
                super.EI(InstructionFactory.newInlineImageEnd());
            }
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASArray text = new ASArray();
        text.add((ASObject)string);
        this.TJ(text, instruction);
    }

    public void TJ(ASArray tjArray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.markedContentTagStack != null && !((Boolean)this.markedContentTagStack.peek()).booleanValue() || this.isObjectOverlapped()) {
            return;
        }
        PDFFont font = ((SanitizationGState)this.gStateStack.peek()).getTextState().getFont();
        if (font == null) {
            throw new PDFInvalidDocumentException("Could not find font " + ((SanitizationGState)this.gStateStack.peek()).getTextState().getFontName() + " while writing text instruction.");
        }
        if (this.hiddenContentMgr != null) {
            this.getGState().removePendingOperatorInstruction(SanitizationGState.GraphicsOperator.Tm);
        }
        this.getGState().write(instruction, ((ContentStreamWriter)this.operatorHandler).getContentWriter(), this.context, this.pdfResources, false);
        try {
            if (this.hiddenContentMgr != null) {
                int i;
                byte[] text;
                ContentTextItem textItem = (ContentTextItem)this.graphicsDOM.get(this.currentContentIndex);
                List glyphs = textItem.getText();
                Iterator itr = tjArray.iterator();
                Glyph glyph = null;
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                double[] tm = textItem.getTState().getMatrix();
                boolean lastGlyphRemoved = true;
                ASObject obj = null;
                int totalGlyphsProcessed = 0;
                ASMatrix inverseCTM = ((SanitizationGState)this.gStateStack.peek()).getCTM().getInverse();
                ASMatrix textMatrix = null;
                while (itr.hasNext()) {
                    obj = (ASObject)itr.next();
                    if (obj instanceof ASNumber) {
                        text = new byte[bytes.size()];
                        for (i = 0; i < bytes.size(); ++i) {
                            text[i] = (Byte)bytes.get(i);
                        }
                        bytes.clear();
                        super.Tj(null, InstructionFactory.newShowText((ASHexString)new ASHexString(text)));
                        lastGlyphRemoved = true;
                        continue;
                    }
                    if (!(obj instanceof ASString)) continue;
                    List charCodes = null;
                    charCodes = font.getCharCodes(((ASString)obj).getBytes(), false);
                    int numGlyphs = charCodes.size();
                    for (int n = totalGlyphsProcessed; n < totalGlyphsProcessed + numGlyphs; ++n) {
                        int i2;
                        glyph = (Glyph)glyphs.get(n);
                        if (glyph.getCharCode() == 32 || textItem.isFontType3() && !SanitizationUtils.isFontType3GlyphHidden(this.pdfPage, (Type3Glyph)glyph, this.contentItemPixelsVisibility) || this.contentItemPixelsVisibility[glyph.getID()] >= 0.6) {
                            if (lastGlyphRemoved) {
                                textMatrix = new ASMatrix(tm[0], tm[1], tm[2], tm[3], glyph.getXPos(), glyph.getYPos()).concat(inverseCTM);
                                super.Tm(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, InstructionFactory.newTextMatrix((double)textMatrix.geta(), (double)textMatrix.getb(), (double)textMatrix.getc(), (double)textMatrix.getd(), (double)textMatrix.getx(), (double)textMatrix.gety()));
                            }
                            byte[] charCodeBytes = (byte[])((List)charCodes.get(n - totalGlyphsProcessed)).get(0);
                            for (i2 = 0; i2 < charCodeBytes.length; ++i2) {
                                bytes.add(charCodeBytes[i2]);
                            }
                            lastGlyphRemoved = false;
                            continue;
                        }
                        if (bytes.size() <= 0) continue;
                        byte[] text2 = new byte[bytes.size()];
                        for (i2 = 0; i2 < bytes.size(); ++i2) {
                            text2[i2] = (Byte)bytes.get(i2);
                        }
                        bytes.clear();
                        super.Tj(null, InstructionFactory.newShowText((ASHexString)new ASHexString(text2)));
                        lastGlyphRemoved = true;
                    }
                    totalGlyphsProcessed += numGlyphs;
                }
                text = new byte[bytes.size()];
                for (i = 0; i < bytes.size(); ++i) {
                    text[i] = (Byte)bytes.get(i);
                }
                bytes.clear();
                if (text.length != 0) {
                    super.Tj(null, InstructionFactory.newShowText((ASHexString)new ASHexString(text)));
                }
            } else {
                super.TJ(tjArray, instruction);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        finally {
            ++this.currentContentIndex;
        }
    }

    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.Tj(string, instruction);
    }

    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.Tj(string, instruction);
    }

    public void w(double lineWidth, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.w, instruction);
    }

    public void J(PDFLineCap lineCap, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.J, instruction);
    }

    public void j(PDFLineJoin lineJoin, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.j, instruction);
    }

    public void M(double miterLimit, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.M, instruction);
    }

    public void d(PDFDashPattern dashPattern, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.d, instruction);
    }

    public void ri(PDFRenderingIntent intent, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.ri, instruction);
    }

    public void i(double flatness, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.i, instruction);
    }

    public void Tc(double charSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tc, instruction);
    }

    public void Tw(double wordSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tw, instruction);
    }

    public void Tz(double scaling, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tz, instruction);
    }

    public void TL(double leading, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.TL, instruction);
    }

    public void Tr(int renderMode, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tr, instruction);
    }

    public void Ts(double textRise, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Ts, instruction);
    }

    public void Td(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Td, instruction);
    }

    public void TD(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.TD, instruction);
    }

    public void Tm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.Tm, instruction);
    }

    public void TStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.TStar, instruction);
    }

    public void SC(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.SC, instruction);
    }

    public void SCN(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.SCN, instruction);
    }

    public void sc(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.sc, instruction);
    }

    public void scn(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.scn, instruction);
    }

    public void G(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.G, instruction);
    }

    public void g(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.g, instruction);
    }

    public void RG(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.RG, instruction);
    }

    public void rg(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.rg, instruction);
    }

    public void K(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.K, instruction);
    }

    public void k(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().handleInstruction(SanitizationGState.GraphicsOperator.k, instruction);
    }

    SanitizationGState getGState() {
        return (SanitizationGState)this.gStateStack.peek();
    }
}

