/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCharProcs;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontListener;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractor;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class RedactionUtils {
    static final Instruction STROKE_INSTRUCTION = InstructionFactory.newStrokePath();
    static final Instruction FILL_INSTRUCTION = InstructionFactory.newFillPath();
    static final Instruction FILL_AND_STROKE_INSTRUCTION = InstructionFactory.newFillAndStrokePath();
    static final Instruction CLIP_PATH_STAR_INSTRUCTION = InstructionFactory.newClipPathStar();
    static final Instruction CLIP_PATH_INSTRUCTION = InstructionFactory.newClipPath();
    static final Instruction END_PATH_NO_OP_INSTRUCTION = InstructionFactory.newEndPathNoOp();
    static final Instruction GSAVE_INSTRUCTION = InstructionFactory.newGSave();
    static final Instruction GRESTORE_INSTRUCTION = InstructionFactory.newGRestore();
    private static final double MAX_RELATIVE_ERROR = 1.0000000000065512E-5;
    private static final double MAX_ABSOLUTE_ERROR = 0.001;

    RedactionUtils() {
    }

    static boolean intersects(PDFDocument pdfDoc, PDFRectangle rectangle, Area redactionArea) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return redactionArea.intersects(rectangle.llx(), rectangle.lly(), rectangle.width(), rectangle.height());
    }

    private static void writeSegmentAfterRedaction(ASMatrix ctm, Point2D.Double fromPoint, Point2D.Double lineToPoint, Area redactionArea, List<Instruction> instrList) throws PDFIOException, PDFInvalidParameterException, PDFInvalidContentException {
        Line2D.Double originalSegment = new Line2D.Double(fromPoint, lineToPoint);
        if (RedactionUtils.equalPoints(fromPoint, lineToPoint)) {
            return;
        }
        GeneralPath segmentPath = RedactionUtils.createNonEmptyAreaForSegment(fromPoint, lineToPoint);
        Rectangle2D pathBounds = segmentPath.getBounds2D();
        if (redactionArea.contains(pathBounds)) {
            return;
        }
        if (!redactionArea.intersects(pathBounds)) {
            Point2D.Double p1 = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), p1, fromPoint.x, fromPoint.y);
            RedactionUtils.addInstructionToList(instrList, p1.x, p1.y);
            Point2D.Double p2 = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), p2, lineToPoint.x, lineToPoint.y);
            instrList.add(InstructionFactory.newLineTo((double)p2.x, (double)p2.y));
            return;
        }
        Area redactedSegmentRegion = RedactionUtils.getRedactedArea(segmentPath, redactionArea);
        PathIterator iterator = redactedSegmentRegion.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        Point2D.Double tempPoint = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentPoint.setLocation(coords[0], coords[1]);
                    startPoint.setLocation(currentPoint.x, currentPoint.y);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), tempPoint, (float)currentPoint.x, (float)currentPoint.y);
                    RedactionUtils.addInstructionToList(instrList, tempPoint.x, tempPoint.y);
                    break;
                }
                case 1: {
                    Point2D.Double toPoint = new Point2D.Double(coords[0], coords[1]);
                    RedactionUtils.writeSegment(instrList, ctm, originalSegment, currentPoint, toPoint);
                    currentPoint.setLocation(toPoint.x, toPoint.y);
                    break;
                }
                case 4: {
                    RedactionUtils.writeSegment(instrList, ctm, originalSegment, currentPoint, startPoint);
                    currentPoint.setLocation(startPoint.x, startPoint.y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
    }

    private static void writeSegment(List<Instruction> instrList, ASMatrix ctm, Line2D.Double originalSegment, Point2D.Double currentPoint, Point2D.Double toPoint) throws PDFInvalidParameterException, PDFIOException, PDFInvalidContentException {
        Line2D.Double segmentFormed = new Line2D.Double(currentPoint, toPoint);
        Point2D.Double transformedLineToPoint = new Point2D.Double();
        RedactionUtils.getTransformedCoordinates(ctm.getInverse(), transformedLineToPoint, (float)toPoint.x, (float)toPoint.y);
        if (RedactionUtils.segmentsCoincide(segmentFormed, originalSegment)) {
            instrList.add(InstructionFactory.newLineTo((double)transformedLineToPoint.x, (double)transformedLineToPoint.y));
        } else {
            RedactionUtils.addInstructionToList(instrList, transformedLineToPoint.x, transformedLineToPoint.y);
        }
    }

    private static void writeCurveAfterRedaction(ASMatrix ctm, Point2D.Double fromPoint, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Area redactionArea, List<Instruction> instrList) throws PDFInvalidParameterException, PDFIOException, PDFInvalidContentException {
        GeneralPath curvePath = new GeneralPath();
        curvePath.moveTo((float)fromPoint.x, (float)fromPoint.y);
        curvePath.curveTo((float)p1.x, (float)p1.y, (float)p2.x, (float)p2.y, (float)p3.x, (float)p3.y);
        Rectangle2D pathBounds = curvePath.getBounds2D();
        if (redactionArea.contains(pathBounds)) {
            return;
        }
        if (!redactionArea.intersects(pathBounds)) {
            Point2D.Double transformedFromPoint = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), transformedFromPoint, fromPoint.x, fromPoint.y);
            RedactionUtils.addInstructionToList(instrList, transformedFromPoint.x, transformedFromPoint.y);
            Point2D.Double point1 = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point1, p1.x, p1.y);
            Point2D.Double point2 = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point2, p2.x, p2.y);
            Point2D.Double point3 = new Point2D.Double();
            RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point3, p3.x, p3.y);
            instrList.add(InstructionFactory.newCurveTo((double)point1.x, (double)point1.y, (double)point2.x, (double)point2.y, (double)point3.x, (double)point3.y));
            return;
        }
        Area redactedSegmentRegion = RedactionUtils.getRedactedArea(curvePath, redactionArea);
        PathIterator iterator = redactedSegmentRegion.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        Point2D.Double tempPoint = new Point2D.Double();
        Point2D.Double point1 = new Point2D.Double();
        Point2D.Double point2 = new Point2D.Double();
        Point2D.Double point3 = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentPoint.setLocation(coords[0], coords[1]);
                    startPoint.setLocation(currentPoint.x, currentPoint.y);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), tempPoint, (float)currentPoint.x, (float)currentPoint.y);
                    RedactionUtils.addInstructionToList(instrList, tempPoint.x, tempPoint.y);
                    break;
                }
                case 1: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), tempPoint, (float)coords[0], (float)coords[1]);
                    RedactionUtils.addInstructionToList(instrList, tempPoint.x, tempPoint.y);
                    currentPoint.setLocation(coords[0], coords[1]);
                    break;
                }
                case 3: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point1, (float)coords[0], (float)coords[1]);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point2, (float)coords[2], (float)coords[3]);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point3, (float)coords[4], (float)coords[5]);
                    instrList.add(InstructionFactory.newCurveTo((double)point1.x, (double)point1.y, (double)point2.x, (double)point2.y, (double)point3.x, (double)point3.y));
                    currentPoint.setLocation(coords[4], coords[5]);
                    break;
                }
                case 4: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), tempPoint, (float)startPoint.x, (float)startPoint.y);
                    RedactionUtils.addInstructionToList(instrList, tempPoint.x, tempPoint.y);
                    currentPoint.setLocation(startPoint.x, startPoint.y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
    }

    private static void addInstructionToList(List<Instruction> instructions, double moveToPointX, double moveToPointY) throws PDFInvalidContentException {
        if (!instructions.isEmpty()) {
            Instruction lastInstruction = instructions.get(instructions.size() - 1);
            if (lastInstruction.getOperator() == ASName.k_m) {
                instructions.remove(instructions.size() - 1);
            } else if (lastInstruction.getOperator() == ASName.k_l || lastInstruction.getOperator() == ASName.k_c) {
                OperandStack operands = lastInstruction.getOperands();
                float yPrev = operands.popNumber().floatValue();
                float xPrev = operands.popNumber().floatValue();
                operands.pushASNumber(new ASNumber(xPrev));
                operands.pushASNumber(new ASNumber(yPrev));
                if (RedactionUtils.equalPoints(xPrev, yPrev, moveToPointX, moveToPointY)) {
                    return;
                }
            }
        }
        instructions.add(InstructionFactory.newMoveTo((double)moveToPointX, (double)moveToPointY));
    }

    private static void writeInstructions(List<Instruction> instructions, ContentWriter writer) throws PDFIOException {
        for (int i = 0; i < instructions.size(); ++i) {
            writer.write(instructions.get(i));
        }
    }

    static void strokePath(ContentWriter writer, ASMatrix ctm, Area redactionArea, GeneralPath path) throws PDFIOException, PDFInvalidParameterException, PDFInvalidContentException {
        ArrayList<Instruction> instrList = new ArrayList<Instruction>();
        PathIterator iterator = path.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        Point2D.Double point1 = new Point2D.Double();
        Point2D.Double point2 = new Point2D.Double();
        Point2D.Double point3 = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    point1.setLocation((float)coords[0], (float)coords[1]);
                    currentPoint.setLocation(point1.x, point1.y);
                    startPoint.setLocation(point1.x, point1.y);
                    break;
                }
                case 1: {
                    point1.setLocation((float)coords[0], (float)coords[1]);
                    RedactionUtils.writeSegmentAfterRedaction(ctm, currentPoint, point1, redactionArea, instrList);
                    currentPoint.setLocation(point1.x, point1.y);
                    break;
                }
                case 3: {
                    point1.setLocation((float)coords[0], (float)coords[1]);
                    point2.setLocation((float)coords[2], (float)coords[3]);
                    point3.setLocation((float)coords[4], (float)coords[5]);
                    RedactionUtils.writeCurveAfterRedaction(ctm, currentPoint, point1, point2, point3, redactionArea, instrList);
                    currentPoint.setLocation(point3.x, point3.y);
                    break;
                }
                case 4: {
                    RedactionUtils.writeSegmentAfterRedaction(ctm, currentPoint, startPoint, redactionArea, instrList);
                    currentPoint.setLocation(startPoint.x, startPoint.y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
        RedactionUtils.writeInstructions(instrList, writer);
    }

    static boolean writeRedactedPathArea(ContentWriter writer, ASMatrix ctm, Area redactionArea, GeneralPath path) throws PDFIOException, PDFInvalidParameterException {
        Area redactedArea = RedactionUtils.getRedactedArea(path, redactionArea);
        PathIterator iterator = redactedArea.getPathIterator(null);
        return RedactionUtils.writePath(writer, ctm, iterator);
    }

    static boolean writePath(ContentWriter writer, ASMatrix ctm, PathIterator iterator) throws PDFInvalidParameterException, PDFIOException {
        boolean isUpdated = !iterator.isDone();
        double[] coords = new double[6];
        Point2D.Double point1 = new Point2D.Double();
        Point2D.Double point2 = new Point2D.Double();
        Point2D.Double point3 = new Point2D.Double();
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            Instruction instruction = null;
            switch (type) {
                case 0: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point1, (float)coords[0], (float)coords[1]);
                    instruction = InstructionFactory.newMoveTo((double)point1.x, (double)point1.y);
                    break;
                }
                case 1: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point1, (float)coords[0], (float)coords[1]);
                    instruction = InstructionFactory.newLineTo((double)point1.x, (double)point1.y);
                    break;
                }
                case 3: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point1, (float)coords[0], (float)coords[1]);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point2, (float)coords[2], (float)coords[3]);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), point3, (float)coords[4], (float)coords[5]);
                    instruction = InstructionFactory.newCurveTo((double)point1.x, (double)point1.y, (double)point2.x, (double)point2.y, (double)point3.x, (double)point3.y);
                    break;
                }
                case 4: {
                    instruction = InstructionFactory.newClosePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            writer.write(instruction);
            iterator.next();
        }
        return isUpdated;
    }

    static boolean equalPoints(Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        return RedactionUtils.equalPoints(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    static boolean equalPoints(double x1, double y1, double x2, double y2) {
        return RedactionUtils.compareDoubles(x1, x2) && RedactionUtils.compareDoubles(y1, y2);
    }

    static void getTransformedCoordinates(ASMatrix matrix, Point2D.Double point, double x, double y) {
        if (matrix.isIdentity6x6()) {
            point.setLocation(x, y);
        } else {
            ASMatrix m = matrix.preMultiply(x, y);
            point.setLocation(m.getx(), m.gety());
        }
    }

    private static Area getRedactedArea(Shape shape, Area redactionArea) {
        Area shapeArea = new Area(shape);
        shapeArea.subtract(redactionArea);
        return shapeArea;
    }

    static Area getTotalArea(List<Shape> shapes) {
        Area totalArea = new Area();
        Iterator<Shape> iterator = shapes.iterator();
        while (iterator.hasNext()) {
            totalArea.add(new Area(iterator.next()));
        }
        return totalArea;
    }

    private static GeneralPath createNonEmptyAreaForSegment(Point2D segmentP1, Point2D segmentP2) {
        Point2D.Double extraPoint = null;
        extraPoint = RedactionUtils.compareDoubles(segmentP1.getX(), segmentP2.getX()) ? new Point2D.Double(segmentP1.getX() + 1.0, segmentP1.getY()) : (RedactionUtils.compareDoubles(segmentP1.getY(), segmentP2.getY()) ? new Point2D.Double(segmentP1.getX(), segmentP1.getY() + 1.0) : new Point2D.Double(segmentP1.getX(), segmentP2.getY()));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)segmentP1.getX(), (float)segmentP1.getY());
        path.lineTo((float)segmentP2.getX(), (float)segmentP2.getY());
        path.lineTo((float)extraPoint.x, (float)extraPoint.y);
        path.closePath();
        return path;
    }

    private static boolean segmentsCoincide(Line2D.Double segment1, Line2D.Double segment2) {
        return RedactionUtils.segmentsParallel(segment1, segment2) && RedactionUtils.segmentsParallel(new Line2D.Double(segment1.getP1(), segment2.getP2()), segment2);
    }

    private static boolean segmentsParallel(Line2D.Double segment1, Line2D.Double segment2) {
        double vx1 = -segment1.x2 + segment1.x1;
        double vy1 = -segment1.y2 + segment1.y1;
        double vx2 = -segment2.x2 + segment2.x1;
        double vy2 = -segment2.y2 + segment2.y1;
        double crossProduct = vx1 * vy2 - vx2 * vy1;
        return RedactionUtils.compareDoubles(crossProduct, 0.0);
    }

    private static boolean compareDoubles(double d1, double d2) {
        if (d1 == d2) {
            return true;
        }
        double diff = Math.abs(d2 - d1);
        if (diff < 0.001) {
            return true;
        }
        return diff / Math.max(Math.abs(d1), Math.abs(d2)) < 1.0000000000065512E-5;
    }

    static PDFResources cloneResources(PDFResources srcResource) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName[] procSetList;
        PDFMCPropertyMap propertyMap;
        PDFPatternMap patternMap;
        PDFShadingMap shadingMap;
        PDFFontMap fontMap;
        PDFXObjectMap xObjectMap;
        PDFColorSpaceMap colorSpaceMap;
        PDFDocument pdfDoc = srcResource.getPDFDocument();
        PDFResources newResources = PDFResources.newInstance((PDFDocument)srcResource.getPDFDocument());
        PDFExtGStateMap extGStateMap = srcResource.getExtGStateMap();
        if (extGStateMap != null) {
            PDFExtGStateMap newExtGStateMap = PDFExtGStateMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)extGStateMap, (PDFCosDictionaryMap)newExtGStateMap);
            newResources.setExtGStateMap(newExtGStateMap);
        }
        if ((colorSpaceMap = srcResource.getColorSpaceMap()) != null) {
            PDFColorSpaceMap newColorSpaceMap = PDFColorSpaceMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)colorSpaceMap, (PDFCosDictionaryMap)newColorSpaceMap);
            newResources.setColorSpaceMap(newColorSpaceMap);
        }
        if ((xObjectMap = srcResource.getXObjectMap()) != null) {
            PDFXObjectMap newXObjectMap = PDFXObjectMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)xObjectMap, (PDFCosDictionaryMap)newXObjectMap);
            newResources.setXObjectMap(newXObjectMap);
        }
        if ((fontMap = srcResource.getFontMap()) != null) {
            PDFFontMap newFontMap = PDFFontMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)fontMap, (PDFCosDictionaryMap)newFontMap);
            newResources.setFontMap(newFontMap);
        }
        if ((shadingMap = srcResource.getShadingMap()) != null) {
            PDFShadingMap newShadingMap = PDFShadingMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)shadingMap, (PDFCosDictionaryMap)newShadingMap);
            newResources.setShadingMap(newShadingMap);
        }
        if ((patternMap = srcResource.getPatternMap()) != null) {
            PDFPatternMap newPatternMap = PDFPatternMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)patternMap, (PDFCosDictionaryMap)newPatternMap);
            newResources.setPatternMap(newPatternMap);
        }
        if ((propertyMap = srcResource.getMCPropertyMap()) != null) {
            PDFMCPropertyMap newPropertyMap = PDFMCPropertyMap.newInstance((PDFDocument)pdfDoc);
            RedactionUtils.copy((PDFCosDictionaryMap)propertyMap, (PDFCosDictionaryMap)newPropertyMap);
            newResources.setMCPropertyMap(newPropertyMap);
        }
        if ((procSetList = srcResource.getProcSetList()) != null) {
            ASName[] newProcSetList = new ASName[procSetList.length];
            System.arraycopy(procSetList, 0, newProcSetList, 0, procSetList.length);
            newResources.setProcSetList(newProcSetList);
        }
        return newResources;
    }

    private static void copy(PDFCosDictionaryMap sourceMap, PDFCosDictionaryMap destMap) {
        Set entrySet = sourceMap.entrySet();
        for (Map.Entry entry : entrySet) {
            destMap.put((ASName)entry.getKey(), (PDFCosObjectContainer)entry.getValue());
        }
    }

    static CosStream createClonedStream(CosStream sourceDict, PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream destDict = PDFCosUtils.newCosStream((PDFDocument)pdfDocument);
        Iterator keysIter = sourceDict.keyIterator();
        while (keysIter.hasNext()) {
            ASName key = (ASName)keysIter.next();
            destDict.put(key, sourceDict.get(key));
        }
        return destDict;
    }

    static void parseForResourcesInfo(Content content, ResourcesState resourcesState, ResourcesState pageResourcesState, RedactionState redactionState, boolean updateResources, int pageNumber, RedactionHandler redactionHandler, OCRedactor ocRedactor, boolean unredactedPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        ContentReader reader = ContentReader.newInstance((Content)content);
        class FontState {
            PDFFont font;
            boolean subsettingRequired;

            FontState(PDFFont font, boolean subsettingRequired) {
                this.font = font;
                this.subsettingRequired = subsettingRequired;
            }
        }
        Stack<FontState> fontStateStack = new Stack<FontState>();
        FontState currentState = null;
        fontStateStack.push(null);
        while (reader.hasNext()) {
            OperandStack operandStack;
            OperandStack operands;
            Instruction instruction = reader.next();
            ASName operator = instruction.getOperator();
            if (operator == ASName.k_Do) {
                PDFXObject xObj;
                operands = instruction.getOperands();
                ASName name = ContentModifier.getObjectName((OperandStack)operands);
                if (name != null && updateResources) {
                    resourcesState.removeXObj(name);
                }
                if (!((xObj = resourcesState.getResources().getXObject(name)) instanceof PDFXObjectForm)) continue;
                ResourcesState currentXObjResourceState = ((PDFXObjectForm)xObj).getResources() == null ? null : new ResourcesState(((PDFXObjectForm)xObj).getResources(), redactionHandler, pageNumber);
                RedactionUtils.parseForResourcesInfo(Content.newInstance((PDFXObjectForm)((PDFXObjectForm)xObj)), currentXObjResourceState == null ? pageResourcesState : currentXObjResourceState, pageResourcesState, redactionState, currentXObjResourceState == null, pageNumber, redactionHandler, ocRedactor, unredactedPage);
                continue;
            }
            if ((operator == ASName.k_Tj || operator == ASName.k_SingleQuote || operator == ASName.k_DoubleQuote) && currentState.subsettingRequired) {
                ASString tjString = instruction.getOperands().peekString();
                RedactionUtils.updateUnredactedCharCodes(currentState.font, tjString);
                continue;
            }
            if (operator == ASName.k_TJ && currentState.subsettingRequired) {
                ASArray tjArray = instruction.getOperands().peekArray();
                for (ASObject obj : tjArray) {
                    if (!(obj instanceof ASString)) continue;
                    RedactionUtils.updateUnredactedCharCodes(currentState.font, (ASString)obj);
                }
                continue;
            }
            if (operator == ASName.k_q) {
                fontStateStack.push(currentState);
                if (currentState == null) continue;
                currentState = new FontState(currentState.font, currentState.subsettingRequired);
                continue;
            }
            if (operator == ASName.k_Q) {
                currentState = (FontState)fontStateStack.pop();
                continue;
            }
            if (!(updateResources || operator != ASName.k_Tf && operator != ASName.k_TF)) {
                operands = instruction.getOperands();
                ASName name = ContentModifier.getObjectName((OperandStack)operands);
                PDFFont currentFont = resourcesState.getResources().getFont(name);
                boolean isSubset = FontResources.isFontCanBeSubsetted((PDFFont)currentFont);
                if (currentState == null) {
                    currentState = new FontState(currentFont, isSubset);
                    continue;
                }
                currentState.font = currentFont;
                currentState.subsettingRequired = isSubset;
                continue;
            }
            if (!updateResources) continue;
            if (operator == ASName.k_Tf || operator == ASName.k_TF) {
                PDFFont currentFont = RedactionUtils.handleTfInstruction(resourcesState, pageResourcesState, redactionState, instruction, pageNumber, redactionHandler, unredactedPage);
                boolean subsettingRequired = FontResources.isFontCanBeSubsetted((PDFFont)currentFont);
                if (currentState == null) {
                    currentState = new FontState(currentFont, subsettingRequired);
                    continue;
                }
                currentState.font = currentFont;
                currentState.subsettingRequired = subsettingRequired;
                continue;
            }
            if (operator == ASName.k_sh) {
                operandStack = instruction.getOperands();
                ASName name = ContentModifier.getObjectName((OperandStack)operandStack);
                if (name == null) continue;
                resourcesState.removeShading(name);
                continue;
            }
            if (operator == ASName.k_cs || operator == ASName.k_CS) {
                operandStack = instruction.getOperands();
                ASName name = ContentModifier.getObjectName((OperandStack)operandStack);
                if (name == null) continue;
                resourcesState.removeColour(name);
                continue;
            }
            if (operator == ASName.k_scn || operator == ASName.k_SCN) {
                ASName name;
                operandStack = instruction.getOperands();
                Iterator oprandIter = operandStack.iterator();
                Object currentOperand = oprandIter.next();
                if (!(currentOperand instanceof ASName) || (name = (ASName)currentOperand) == null) continue;
                resourcesState.removePattern(name);
                continue;
            }
            if (operator == ASName.k_gs) {
                operandStack = instruction.getOperands();
                ASName name = ContentModifier.getObjectName((OperandStack)operandStack);
                if (name == null) continue;
                resourcesState.removeExtGState(name);
                continue;
            }
            if (operator != ASName.k_BDC && operator != ASName.k_DP) continue;
            RedactionUtils.handleBDCDPInstruction(resourcesState, redactionState, instruction, pageNumber, ocRedactor);
        }
    }

    static void updateUnredactedCharCodes(PDFFont currentFont, ASString tjString) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        List<ArrayList> charCodesList = RedactionUtils.getCharCodesFromFont(currentFont, tjString.getBytes());
        PDFFontListener fontListener = PDFFontListener.getFontListener((PDFDocument)currentFont.getPDFDocument());
        for (int i = 0; i < charCodesList.size(); ++i) {
            byte[] currentCharCode = (byte[])((List)charCodesList.get(i)).get(0);
            fontListener.addToFontCache(currentFont, (int)PDFCMapUtils.getCharCode((byte[])currentCharCode), currentCharCode.length);
        }
    }

    static PDFFont handleTfInstruction(ResourcesState resourcesState, ResourcesState pageResourcesState, RedactionState redactionState, Instruction instruction, int pageNumber, RedactionHandler redactionHandler, boolean unredactedPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        PDFFontType3 fontObjType3;
        PDFFont fontObj;
        OperandStack operands = instruction.getOperands();
        ASName name = ContentModifier.getObjectName((OperandStack)operands);
        if (name != null) {
            resourcesState.removeFont(name);
        }
        if ((fontObj = resourcesState.getResources().getFont(name)) instanceof PDFFontType3 && (fontObjType3 = (PDFFontType3)fontObj).getResources() == null) {
            PDFCharProcs charProcs = fontObjType3.getCharProcs();
            Collection charProcsContents = charProcs.values();
            Iterator charProcsContentsIteraor = charProcsContents.iterator();
            while (charProcsContentsIteraor.hasNext()) {
                RedactionUtils.parseForResourcesInfo(Content.newInstance((PDFContents)((PDFContents)charProcsContentsIteraor.next()), (PDFResources)pageResourcesState.getResources()), pageResourcesState, pageResourcesState, redactionState, true, pageNumber, redactionHandler, null, unredactedPage);
            }
        }
        return fontObj;
    }

    static void handleBDCDPInstruction(ResourcesState resourcesState, RedactionState redactionState, Instruction instruction, int pageNumber, OCRedactor ocRedactor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Object dictMCID;
        ASName propertyName;
        OperandStack operandStack = instruction.getOperands();
        Object top = operandStack.peek();
        Number mcidValue = null;
        if (top instanceof ASName && (propertyName = (ASName)top) != null) {
            resourcesState.removeProperties(propertyName);
        }
        ASDictionary properties = null;
        if (operandStack.peekTypeIsName()) {
            PDFMCProperty property = resourcesState.getResources().getMCProperty(operandStack.peekName());
            if (property != null) {
                if (ocRedactor != null) {
                    ocRedactor.processPDFOCObject(PDFOCObject.getInstance((CosObject)property.getCosObject()));
                }
                mcidValue = property.getDictionaryNumericValue(ASName.k_MCID);
            }
        } else {
            properties = operandStack.peekDictionary();
        }
        if (properties != null && !properties.isEmpty() && properties.containsKey(ASName.k_MCID) && (dictMCID = properties.get(ASName.k_MCID)) instanceof ASNumber) {
            mcidValue = ((ASNumber)dictMCID).numberValue();
        }
        if (mcidValue != null) {
            redactionState.structParentReferenceUpdation(pageNumber, mcidValue.intValue());
        }
    }

    static PDFResources getResources(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = document.requireCatalog();
        PDFInteractiveForm interactiveForm = catalog.getInteractiveForm();
        if (interactiveForm != null) {
            return interactiveForm.getResources();
        }
        return null;
    }

    static boolean pathIntersectsArea(GeneralPath path, Area area, Area pathArea) {
        if (!pathArea.isEmpty()) {
            Area tempPathArea = (Area)pathArea.clone();
            tempPathArea.subtract(area);
            return !tempPathArea.equals(pathArea);
        }
        PathIterator iterator = path.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentPoint.setLocation(coords[0], coords[1]);
                    if (area.contains(currentPoint)) {
                        return true;
                    }
                    startPoint.setLocation(currentPoint);
                }
                case 1: {
                    Point2D.Double toPoint = new Point2D.Double(coords[0], coords[1]);
                    if (!RedactionUtils.equalPoints(toPoint, currentPoint) && RedactionUtils.lineIntersectsArea(currentPoint, toPoint, area)) {
                        return true;
                    }
                    currentPoint.setLocation(toPoint);
                    break;
                }
                case 4: {
                    if (!RedactionUtils.equalPoints(startPoint, currentPoint) && RedactionUtils.lineIntersectsArea(currentPoint, startPoint, area)) {
                        return true;
                    }
                    currentPoint.setLocation(startPoint);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
        return false;
    }

    private static boolean lineIntersectsArea(Point2D lineP1, Point2D lineP2, Area area) {
        GeneralPath linePath = RedactionUtils.createNonEmptyAreaForSegment(lineP1, lineP2);
        Area lineMinusArea = RedactionUtils.getRedactedArea(linePath, area);
        PathIterator iterator = lineMinusArea.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    currentPoint.setLocation(coords[0], coords[1]);
                    startPoint.setLocation(currentPoint);
                }
                case 1: {
                    Point2D.Double toPoint = new Point2D.Double(coords[0], coords[1]);
                    if (RedactionUtils.sameSegments(currentPoint, toPoint, lineP1, lineP2)) {
                        return false;
                    }
                    currentPoint.setLocation(toPoint);
                    break;
                }
                case 4: {
                    if (RedactionUtils.sameSegments(currentPoint, startPoint, lineP1, lineP2)) {
                        return false;
                    }
                    currentPoint.setLocation(startPoint);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
        return true;
    }

    private static boolean sameSegments(Point2D segment1P1, Point2D segment1P2, Point2D segment2P1, Point2D segment2P2) {
        return RedactionUtils.equalPoints(segment1P1, segment2P1) && RedactionUtils.equalPoints(segment1P2, segment2P2) || RedactionUtils.equalPoints(segment1P1, segment2P2) && RedactionUtils.equalPoints(segment1P2, segment2P1);
    }

    static void strokePath(ContentWriter writer, ASMatrix ctm, GeneralPath path) throws PDFIOException, PDFInvalidParameterException {
        PathIterator iterator = path.getPathIterator(null);
        Point2D.Double currentPoint = new Point2D.Double();
        Point2D.Double startPoint = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        Point2D.Double point1 = new Point2D.Double();
        double[] coords = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            point1.setLocation((float)coords[0], (float)coords[1]);
            switch (type) {
                case 0: {
                    currentPoint.setLocation(point1.x, point1.y);
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), p1, currentPoint.x, currentPoint.y);
                    writer.write(InstructionFactory.newMoveTo((double)p1.x, (double)p1.y));
                    startPoint.setLocation(point1.x, point1.y);
                    break;
                }
                case 1: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), p2, point1.x, point1.y);
                    writer.write(InstructionFactory.newLineTo((double)p2.x, (double)p2.y));
                    currentPoint.setLocation(point1.x, point1.y);
                    break;
                }
                case 4: {
                    RedactionUtils.getTransformedCoordinates(ctm.getInverse(), p2, startPoint.x, startPoint.y);
                    writer.write(InstructionFactory.newLineTo((double)p2.x, (double)p2.y));
                    currentPoint.setLocation(startPoint.x, startPoint.y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal segment type (" + type + ") encountered in the given path.");
                }
            }
            iterator.next();
        }
    }

    private static List<ArrayList> getCharCodesFromFont(PDFFont font, byte[] bytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (font instanceof PDFFontType0) {
            return PDFFontUtils.getCharCodes((byte[])bytes, (boolean)false, (boolean)false, (PDFFontType0)((PDFFontType0)font), (boolean)true);
        }
        return font.getCharCodes(bytes, false);
    }

    static void wrapImageInFormXObject(PDFXObjectImage originalImage, ASName key) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImage clonedImage = RedactionUtils.getClonedImage(originalImage);
        PDFXObjectForm xObjForm = PDFXObjectForm.newInstance((PDFDocument)originalImage.getPDFDocument());
        xObjForm.setBBox(PDFRectangle.newInstance((PDFDocument)originalImage.getPDFDocument(), (double)0.0, (double)0.0, (double)originalImage.getWidth(), (double)originalImage.getHeight()));
        ContentWriter writer = ContentWriter.newInstance((PDFDocument)originalImage.getPDFDocument());
        writer.write(InstructionFactory.newInvokeNamedXObject((ASName)key));
        PDFResources xObjResources = PDFResources.newInstance((PDFDocument)originalImage.getPDFDocument());
        xObjResources.procureXObjectMap().put(key, (PDFCosObjectContainer)clonedImage);
        xObjForm.setResources(xObjResources);
        CosStream originalImageStream = originalImage.getCosStream();
        originalImageStream.clear();
        RedactionUtils.copyCosDictionary(xObjForm.getCosDictionary(), (CosDictionary)originalImageStream);
        originalImageStream.newDataDecoded(writer.close().getContentStream());
        originalImageStream.remove(ASName.k_Filter);
        originalImageStream.put(ASName.k_Filter, ASName.k_FlateDecode);
    }

    private static void copyCosDictionary(CosDictionary sourceDictionary, CosDictionary destinationDictionary) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        Iterator iterator = sourceDictionary.keyIterator();
        while (iterator.hasNext()) {
            ASName key = (ASName)iterator.next();
            destinationDictionary.put(key, sourceDictionary.get(key));
        }
    }

    private static PDFXObjectImage getClonedImage(PDFXObjectImage originalImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        PDFXObjectImage xObj = null;
        xObj = PDFXObjectImage.getInstance((CosObject)RedactionUtils.createClonedStream(originalImage.getCosStream(), originalImage.getPDFDocument()));
        xObj.getCosStream().newDataDecoded(originalImage.getCosStream().getStreamDecoded());
        xObj.getCosStream().remove(ASName.k_Filter);
        xObj.getCosStream().put(ASName.k_Filter, ASName.k_FlateDecode);
        return xObj;
    }

    static double[] adjustBoundingBox(PDFPage currPage, TextExtractor textExtractor, Set<String> wordsToRemove, RedactionOptions options, boolean ignoreCase) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        List wordList;
        if (ignoreCase) {
            wordsToRemove = RedactionUtils.convertToLowerCase(wordsToRemove);
        }
        ArrayList<Object> quadPointsofWordsToBeRemoved = new ArrayList<Object>(512);
        double[] quadsPointsToRemoveArray = null;
        Word currentWord = null;
        String currentWordToCompare = null;
        int rotation = 0;
        if (currPage.getRotation() != null) {
            rotation = currPage.getRotation().getValue();
        }
        if ((wordList = textExtractor.getExtractedWordsLists(currPage, currPage.getIndex(), options.isConsiderSpecialCharacter())).isEmpty()) {
            return null;
        }
        ListIterator wordsIter = wordList.listIterator();
        while (wordsIter.hasNext()) {
            currentWord = (Word)wordsIter.next();
            currentWordToCompare = ignoreCase ? currentWord.toString().toLowerCase() : currentWord.toString();
            ASMatrix ctm = RedactionUtils.getCTM(rotation, currPage.getCropBox().width(), currPage.getCropBox().height());
            if (rotation != 0) {
                ctm = ctm.concat(new ASMatrix(1.0, 0.0, 0.0, 1.0, currPage.getCropBox().left(), currPage.getCropBox().bottom()));
            }
            block0 : switch (options.getWordMatch()) {
                case MARKWHOLEWORD: {
                    if (!wordsToRemove.contains(currentWordToCompare)) break;
                    quadPointsofWordsToBeRemoved.add(currentWord.getWordGlyphBounds().transform(ctm));
                    break;
                }
                case MATCHPARTIALWORD_MARKWHOLEWORD: {
                    for (String wordToCompareFromSet : wordsToRemove) {
                        if (!currentWordToCompare.contains(wordToCompareFromSet)) continue;
                        quadPointsofWordsToBeRemoved.add(currentWord.getWordGlyphBounds().transform(ctm));
                        break block0;
                    }
                    break;
                }
                case MATCHPARTIALWORD_MARKPARTIALWORD: {
                    for (String wordToCompareFromSet : wordsToRemove) {
                        if (!currentWordToCompare.contains(wordToCompareFromSet)) continue;
                        List partialWordsList = currentWord.getGlyphBoundsForPartialWords(wordToCompareFromSet, ignoreCase);
                        for (ASQuad q : partialWordsList) {
                            q = q.transform(ctm);
                        }
                        Iterator partialWordListIterator = partialWordsList.iterator();
                        while (partialWordListIterator.hasNext()) {
                            quadPointsofWordsToBeRemoved.add(partialWordListIterator.next());
                        }
                    }
                    break;
                }
            }
        }
        quadsPointsToRemoveArray = new double[quadPointsofWordsToBeRemoved.size() * 8];
        for (int i = 0; i < quadPointsofWordsToBeRemoved.size(); ++i) {
            ASQuad currQuadData = (ASQuad)quadPointsofWordsToBeRemoved.get(i);
            int index = i * 8;
            quadsPointsToRemoveArray[index] = currQuadData.p1().x();
            quadsPointsToRemoveArray[index + 1] = currQuadData.p1().y();
            quadsPointsToRemoveArray[index + 2] = currQuadData.p2().x();
            quadsPointsToRemoveArray[index + 3] = currQuadData.p2().y();
            quadsPointsToRemoveArray[index + 4] = currQuadData.p4().x();
            quadsPointsToRemoveArray[index + 5] = currQuadData.p4().y();
            quadsPointsToRemoveArray[index + 6] = currQuadData.p3().x();
            quadsPointsToRemoveArray[index + 7] = currQuadData.p3().y();
        }
        return quadsPointsToRemoveArray;
    }

    private static Set<String> convertToLowerCase(Set<String> wordsToRemove) {
        HashSet<String> lowerCaseData = new HashSet<String>(32);
        Iterator<String> stringIter = wordsToRemove.iterator();
        while (stringIter.hasNext()) {
            lowerCaseData.add(stringIter.next().toLowerCase());
        }
        return lowerCaseData;
    }

    private static double[] getQuad(ASQuad currQuad) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] quadArray = new double[]{currQuad.p1().x(), currQuad.p1().y(), currQuad.p2().x(), currQuad.p2().y(), currQuad.p4().x(), currQuad.p4().y(), currQuad.p3().x(), currQuad.p3().y()};
        return quadArray;
    }

    private static ASMatrix getCTM(int rotation, double width, double height) {
        rotation = 360 - rotation;
        switch (rotation) {
            case 0: 
            case 360: {
                return new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            }
            case 90: {
                return new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, height);
            }
            case 180: {
                return new ASMatrix(-1.0, 0.0, 0.0, -1.0, width, height);
            }
            case 270: {
                return new ASMatrix(0.0, 1.0, -1.0, 0.0, width, 0.0);
            }
        }
        return new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }
}

