/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ClipPathState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ContentStreamState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionAdditionalInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentStreamHandler;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.XObjectsNumberWrapper;
import java.awt.geom.Area;
import java.util.Map;
import java.util.Stack;

class ContentStreamRedactor {
    private PDFDocument pdfDocument;
    private Area redactionArea;
    private OCRedactor ocRedactor;
    private ResourcesState pageResourcesState;
    private RedactionOptions redactionOptions;
    private RedactionHandler redactionHandler;
    private RedactionState redactionState;
    private int pageNumber;

    ContentStreamRedactor(PDFDocument pdfDocument, Area redactionArea, ResourcesState pageResourcesState, RedactionOptions redactionOptions, RedactionHandler redactionHandler, RedactionState redactionState, int pageNumber, OCRedactor ocRedactor) {
        this.pdfDocument = pdfDocument;
        this.redactionArea = redactionArea;
        this.pageResourcesState = pageResourcesState;
        this.redactionOptions = redactionOptions;
        this.redactionHandler = redactionHandler;
        this.redactionState = redactionState;
        this.pageNumber = pageNumber;
        this.ocRedactor = ocRedactor;
    }

    void redactContentStream(Content content, RedactionContentWriter writer, ASMatrix currCTM, ResourcesState currentResourceState, RedactionAdditionalInfo additionalInfo, Map<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap, XObjectsNumberWrapper xObjectsNumberWrapper) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        ClipPathState clipPathState = new ClipPathState();
        Stack<ContentStreamState> state = new Stack<ContentStreamState>();
        ASMatrix currTextMatrix = ASMatrix.createIdentityMatrix();
        this.handleqInstr(writer, currCTM, clipPathState, state, currTextMatrix, RedactionUtils.GSAVE_INSTRUCTION);
        RedactionContentStreamHandler rp = new RedactionContentStreamHandler(this.pdfDocument, this.redactionArea, this.pageResourcesState, this.redactionOptions, this.redactionHandler, this.redactionState, this.pageNumber, this.ocRedactor, content, writer, currCTM, currentResourceState, additionalInfo, xObjsToInitialMatricesMap, xObjectsNumberWrapper);
        StatefulContentStreamProcessor streamProcessor = new StatefulContentStreamProcessor((StatefulOperatorHandler)rp);
        streamProcessor.process(content);
        writer.writeGRestoreInstruction(RedactionUtils.GRESTORE_INSTRUCTION);
    }

    private void handleqInstr(RedactionContentWriter writer, ASMatrix currCTM, ClipPathState clipPathState, Stack<ContentStreamState> state, ASMatrix currTextMatrix, Instruction instruction) throws PDFIOException {
        ContentStreamState streamState = new ContentStreamState();
        streamState.currCTM = currCTM;
        streamState.currTM = currTextMatrix;
        streamState.clipPathRedacted = clipPathState.clipPathRedacted;
        state.push(streamState);
        writer.writeGSaveInstruction(instruction);
    }
}

