/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rcg;

import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLExceptionUnsupportedFeature;
import com.adobe.internal.agm.AGMException;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import com.adobe.internal.pdftoolkit.services.pdfport.PDFPort;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortMultipleWriters;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGTargetRegion;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAResultInfo;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAText;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RichTextContentGenerator {
    private RichTextContentGenerator() {
    }

    public static void applyContent(PDFPage pdfPage, InputStream richTextStream, Charset encoding, PDFFontSet pdfFontSet, RCGOptions rcgOptions, XObjectApplyOptions applyOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnsupportedFeatureException, PDFInvalidParameterException {
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        PDFXObjectForm pdfXObjectForm = RichTextContentGenerator.generateXObject(pdfDocument, richTextStream, encoding, pdfFontSet, rcgOptions, useOptions);
        if (applyOptions == null) {
            applyOptions = new XObjectApplyOptions();
        }
        if (useOptions == null) {
            useOptions = new XObjectUseOptions();
        }
        applyOptions.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions);
    }

    public static void applyContent(PDFPage pdfPage, InputStream richTextStream, PDFFontSet pdfFontSet, RCGOptions rcgOptions, XObjectApplyOptions applyOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException, PDFUnsupportedFeatureException, PDFInvalidParameterException {
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        PDFXObjectForm pdfXObjectForm = RichTextContentGenerator.generateXObject(pdfDocument, richTextStream, null, pdfFontSet, rcgOptions, useOptions);
        if (applyOptions == null) {
            applyOptions = new XObjectApplyOptions();
        }
        if (useOptions == null) {
            useOptions = new XObjectUseOptions();
        }
        applyOptions.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions);
    }

    public static PDFXObjectForm[] generateXObjectArray(PDFDocument pdfDocument, InputStream[] richTextStreams, Charset encoding, PDFFontSet pdfFontSet, RCGOptions[] rcgOptions, XObjectUseOptions[] useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        try {
            int size = richTextStreams.length;
            try {
                for (int i = 0; i < size; ++i) {
                    richTextStreams[i] = RichTextContentGenerator.updateRichTextStream(richTextStreams[i], encoding);
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e.getMessage(), e.getCause());
            }
            ContentWriter[] contentWriters = new ContentWriter[size];
            OutputByteStream[] contentStream = new OutputByteStream[size];
            PDFXObjectForm[] xobjectArray = new PDFXObjectForm[size];
            for (int i = 0; i < size; ++i) {
                contentStream[i] = pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                contentWriters[i] = ContentWriter.newInstance((PDFDocument)pdfDocument, (OutputByteStream)contentStream[i]);
            }
            PDFResources resources = PDFResources.newInstance((PDFDocument)pdfDocument);
            ASName[] names = new ASName[]{ASName.k_PDF, ASName.k_Text};
            resources.setProcSetList(names);
            PDFFontMap fontMap = PDFFontMap.newInstance((PDFDocument)pdfDocument);
            resources.setFontMap(fontMap);
            PDFPortMultipleWriters pdfPort = new PDFPortMultipleWriters(contentWriters, resources);
            PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDocument, (PDFFontSet)pdfFontSet, null, null);
            for (int i = 0; i < size; ++i) {
                if (rcgOptions[i] == null) {
                    throw new PDFInvalidParameterException("RCGOptions cannot be null when generate a PDFXObjectForm.");
                }
                if (useOptions[i] == null) {
                    useOptions[i] = new XObjectUseOptions();
                }
                pdfPort.processWriterStart(i);
                RCGTargetRegion targetRegion = rcgOptions[i].getTargetRegion();
                FormatXFAText richTextFormatter = new FormatXFAText();
                richTextFormatter.processXFAText(targetRegion.toString(), rcgOptions[i].getDefaultStyle(), richTextStreams[i], pdfPort, workingFontSet, true);
                InputByteStream contents = contentStream[i].closeAndConvert();
                contentStream[i] = null;
                PDFRectangle bbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (double)0.0, (double)0.0, (double)targetRegion.getWidth(), (double)targetRegion.getHeight());
                PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance((PDFDocument)pdfDocument, (PDFRectangle)bbox, (PDFResources)resources, (InputByteStream)contents);
                useOptions[i].applyOptionalContent(pdfXObjectForm);
                useOptions[i].getContentType().applyPieceInfo(pdfXObjectForm);
                xobjectArray[i] = pdfXObjectForm;
            }
            pdfPort.closePDFPort();
            return xobjectArray;
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public static PDFXObjectForm[] generateXObjectArray(PDFDocument pdfDocument, InputStream[] richTextStreams, PDFFontSet pdfFontSet, RCGOptions[] rcgOptions, XObjectUseOptions[] useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        return RichTextContentGenerator.generateXObjectArray(pdfDocument, richTextStreams, null, pdfFontSet, rcgOptions, useOptions);
    }

    public static PDFXObjectForm[] generateXObjectArray(PDFDocument pdfDocument, FormatXFAResultInfo[] preformattedResults, RCGOptions[] rcgOptions, XObjectUseOptions[] useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException {
        try {
            int size = preformattedResults.length;
            PDFXObjectForm[] arr = new PDFXObjectForm[size];
            ContentWriter[] contentWriters = new ContentWriter[size];
            OutputByteStream[] contentStream = new OutputByteStream[size];
            for (int i = 0; i < size; ++i) {
                contentStream[i] = pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                contentWriters[i] = ContentWriter.newInstance((PDFDocument)pdfDocument, (OutputByteStream)contentStream[i]);
            }
            PDFResources resources = PDFResources.newInstance((PDFDocument)pdfDocument);
            ASName[] names = new ASName[]{ASName.k_PDF, ASName.k_Text};
            resources.setProcSetList(names);
            PDFFontMap fontMap = PDFFontMap.newInstance((PDFDocument)pdfDocument);
            resources.setFontMap(fontMap);
            PDFPortMultipleWriters pdfPort = new PDFPortMultipleWriters(contentWriters, resources);
            for (int i = 0; i < size; ++i) {
                if (rcgOptions[i] == null) {
                    rcgOptions[i] = new RCGOptions(0.0, 0.0);
                }
                if (useOptions[i] == null) {
                    useOptions[i] = new XObjectUseOptions();
                }
                pdfPort.processWriterStart(i);
                RCGTargetRegion targetRegion = rcgOptions[i].getTargetRegion();
                preformattedResults[i].renderRegion(pdfPort, 0, 0);
                InputByteStream contents = contentStream[i].closeAndConvert();
                contentStream[i] = null;
                PDFRectangle bbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (double)0.0, (double)0.0, (double)targetRegion.getWidth(), (double)targetRegion.getHeight());
                PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance((PDFDocument)pdfDocument, (PDFRectangle)bbox, (PDFResources)resources, (InputByteStream)contents);
                useOptions[i].applyOptionalContent(pdfXObjectForm);
                useOptions[i].getContentType().applyPieceInfo(pdfXObjectForm);
                arr[i] = pdfXObjectForm;
            }
            pdfPort.closePDFPort();
            return arr;
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    public static PDFXObjectForm generateXObject(PDFDocument pdfDocument, InputStream richTextStream, Charset encoding, PDFFontSet pdfFontSet, RCGOptions rcgOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        try {
            richTextStream = RichTextContentGenerator.updateRichTextStream(richTextStream, encoding);
        }
        catch (IOException e) {
            throw new PDFIOException(e.getMessage(), e.getCause());
        }
        try {
            if (rcgOptions == null) {
                throw new PDFInvalidParameterException("RCGOptions cannot be null when generate a PDFXObjectForm.");
            }
            if (useOptions == null) {
                useOptions = new XObjectUseOptions();
            }
            OutputByteStream contentStream = pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            ContentWriter contentWriter = ContentWriter.newInstance((PDFDocument)pdfDocument, (OutputByteStream)contentStream);
            PDFResources resources = PDFResources.newInstance((PDFDocument)pdfDocument);
            ASName[] names = new ASName[]{ASName.k_PDF, ASName.k_Text};
            resources.setProcSetList(names);
            PDFFontMap fontMap = PDFFontMap.newInstance((PDFDocument)pdfDocument);
            resources.setFontMap(fontMap);
            PDFPort pdfPort = new PDFPort(contentWriter, resources);
            PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDocument, (PDFFontSet)pdfFontSet, null, null);
            RCGTargetRegion targetRegion = rcgOptions.getTargetRegion();
            FormatXFAText richTextFormatter = new FormatXFAText();
            richTextFormatter.processXFAText(targetRegion.toString(), rcgOptions.getDefaultStyle(), richTextStream, pdfPort, workingFontSet, true);
            pdfPort.closePDFPort();
            InputByteStream contents = contentStream.closeAndConvert();
            contentStream = null;
            PDFRectangle bbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (double)0.0, (double)0.0, (double)targetRegion.getWidth(), (double)targetRegion.getHeight());
            PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance((PDFDocument)pdfDocument, (PDFRectangle)bbox, (PDFResources)resources, (InputByteStream)contents);
            useOptions.applyOptionalContent(pdfXObjectForm);
            useOptions.getContentType().applyPieceInfo(pdfXObjectForm);
            return pdfXObjectForm;
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (SAXParseException e) {
            throw new PDFConfigurationException("Error during parsing xml(input), " + e.getMessage() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public static PDFXObjectForm generateXObject(PDFDocument pdfDocument, InputStream richTextStream, PDFFontSet pdfFontSet, RCGOptions rcgOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        return RichTextContentGenerator.generateXObject(pdfDocument, richTextStream, null, pdfFontSet, rcgOptions, useOptions);
    }

    private static InputStream updateRichTextStream(InputStream richTextStream, Charset encoding) throws IOException {
        if (encoding != null && encoding != StandardCharsets.UTF_8) {
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(richTextStream, encoding));){
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            richTextStream = new ByteArrayInputStream(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        return richTextStream;
    }

    public static FormatXFAResultInfo preformatRCGContent(PDFDocument pdfDocument, InputStream richTextStream, PDFFontSet pdfFontSet, RCGOptions rcgOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException {
        if (rcgOptions == null) {
            rcgOptions = new RCGOptions(0.0, 0.0);
        }
        PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)pdfDocument, (PDFFontSet)pdfFontSet, null, null);
        RCGTargetRegion targetRegion = rcgOptions.getTargetRegion();
        try {
            FormatXFAText richTextFormatter = new FormatXFAText();
            FormatXFAResultInfo var_FormatterResultInfo = richTextFormatter.processXFAText(targetRegion.toString(), rcgOptions.getDefaultStyle(), richTextStream, null, workingFontSet, true);
            return var_FormatterResultInfo;
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AFMLExceptionUnsupportedFeature e) {
            throw new PDFUnsupportedFeatureException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FormattingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (PDFFontException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
    }

    public static PDFXObjectForm generateXObject(PDFDocument pdfDocument, FormatXFAResultInfo preformattedResult, RCGOptions rcgOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFFontException, PDFSecurityException {
        try {
            if (rcgOptions == null) {
                rcgOptions = new RCGOptions(0.0, 0.0);
            }
            if (useOptions == null) {
                useOptions = new XObjectUseOptions();
            }
            OutputByteStream contentStream = pdfDocument.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            ContentWriter contentWriter = ContentWriter.newInstance((PDFDocument)pdfDocument, (OutputByteStream)contentStream);
            PDFResources resources = PDFResources.newInstance((PDFDocument)pdfDocument);
            ASName[] names = new ASName[]{ASName.k_PDF, ASName.k_Text};
            resources.setProcSetList(names);
            PDFFontMap fontMap = PDFFontMap.newInstance((PDFDocument)pdfDocument);
            resources.setFontMap(fontMap);
            PDFPort pdfPort = new PDFPort(contentWriter, resources);
            RCGTargetRegion targetRegion = rcgOptions.getTargetRegion();
            preformattedResult.renderRegion(pdfPort, 0, 0);
            pdfPort.closePDFPort();
            InputByteStream contents = contentStream.closeAndConvert();
            contentStream = null;
            PDFRectangle bbox = PDFRectangle.newInstance((PDFDocument)pdfDocument, (double)0.0, (double)0.0, (double)targetRegion.getWidth(), (double)targetRegion.getHeight());
            PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance((PDFDocument)pdfDocument, (PDFRectangle)bbox, (PDFResources)resources, (InputByteStream)contents);
            useOptions.applyOptionalContent(pdfXObjectForm);
            useOptions.getContentType().applyPieceInfo(pdfXObjectForm);
            return pdfXObjectForm;
        }
        catch (AFMLExceptionInvalidParameter e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (AGMException e) {
            throw new PDFInvalidDocumentException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (InvalidFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (FontLoadingException e) {
            throw new PDFFontException("Invalid font in fontset, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFFontException("Error during text formatting, " + e.getMessage() + ".", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }
}

