/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.TemplateParams;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMTemplates;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class Template
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Template.class", new HashMap<String, Function>(1){
        private static final long serialVersionUID = 1L;
        {
            this.put("spawn", new Function(Template.class, "spawn", Param.Type.Object, TemplateParams.spawn, 4, false, false));
        }
    }, new HashMap<String, Property>(2){
        private static final long serialVersionUID = 1L;
        {
            this.put("name", new Property(Template.class, "name", "getName", null, null, false, false));
            this.put("hidden", new Property(Template.class, "hidden", "getHidden", "setHidden", TemplateParams.hidden, false, false));
        }
    });
    private static final long serialVersionUID = -3076603934132101786L;
    private PDFPage pdfTemplate;
    private String templateName;
    static final String className = "Template";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public PDFPage getPdfTemplate() {
        return this.pdfTemplate;
    }

    public void setPdfTemplate(PDFPage page) {
        this.pdfTemplate = page;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Template() {
    }

    public Template(Object template, String name, boolean visible) {
        if (template instanceof PDFTemplate) {
            this.pdfTemplate = (PDFTemplate)template;
        }
        this.templateName = name;
    }

    @Override
    public String getClassName() {
        return className;
    }

    public boolean getHidden() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PMMTemplates pmmService = new PMMTemplates(this.pdfTemplate.getPDFDocument());
        return !pmmService.templateExistsForPage(this.pdfTemplate);
    }

    public void setHidden(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        if (value.booleanValue()) {
            PMMTemplates pmmService = new PMMTemplates(this.pdfTemplate.getPDFDocument());
            pmmService.hideTemplate(this.pdfTemplate, this.templateName);
        }
    }

    public String getName() {
        return this.templateName;
    }

    public Object spawn(Integer nPage, Boolean rename, Boolean overlay, Object xobject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFDocument toDoc = this.pdfTemplate.getPDFDocument();
        if (xobject == Undefined.instance) {
            xobject = null;
        }
        PMMTemplates pmmService = new PMMTemplates(toDoc);
        PDFXObject pageXObject = pmmService.spawnPageFromTemplate(toDoc, nPage.intValue(), rename.booleanValue(), overlay.booleanValue(), (PDFXObject)xobject, this.templateName);
        return Context.javaToJS((Object)pageXObject, (Scriptable)this.getParentScope());
    }
}

