/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.DataParams;
import java.util.Date;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class Data
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Data.class", new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, new HashMap<String, Property>(7){
        private static final long serialVersionUID = 1L;
        {
            this.put("name", new Property(Data.class, "name", "getName", null, null, false, false));
            this.put("description", new Property(Data.class, "description", "getDescription", "setDescription", DataParams.description, false, false));
            this.put("MIMEType", new Property(Data.class, "MIMEType", "getMIMEType", null, null, false, false));
            this.put("path", new Property(Data.class, "path", "getPath", null, null, true, false));
            this.put("size", new Property(Data.class, "size", "getSize", null, null, false, false));
            this.put("creationDate", new Property(Data.class, "creationDate", "getCreationDate", null, null, false, false));
            this.put("modDate", new Property(Data.class, "modDate", "getModDate", null, null, false, false));
        }
    });
    private static final long serialVersionUID = 5696559350250807433L;
    private PDFEmbeddedFile embeddedFile;
    PDFFileSpecification fileSpec;
    private ASString nameTreeKey;
    static final String className = "Data";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Data() {
    }

    public Data(Object o) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (o instanceof PDFFileSpecification) {
            this.fileSpec = (PDFFileSpecification)o;
            this.embeddedFile = this.fileSpec.getEmbeddedFile();
        }
    }

    @Override
    public String getClassName() {
        return className;
    }

    public Date getCreationDate() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.embeddedFile.hasFileInfo() && this.embeddedFile.getFileInfo().hasCreationDate()) {
            return this.embeddedFile.getFileInfo().getCreationDate().toDate();
        }
        return null;
    }

    public Date getModDate() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.embeddedFile.hasFileInfo() && this.embeddedFile.getFileInfo().hasModificationDate()) {
            return this.embeddedFile.getFileInfo().getModificationDate().toDate();
        }
        return null;
    }

    public String getMIMEType() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.embeddedFile.hasMIMEType()) {
            return this.embeddedFile.getMIMEType();
        }
        return null;
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.fileSpec.hasFilename()) {
            return this.getNameTreeKey().asString();
        }
        return null;
    }

    public Object getPath() {
        throw new UnsupportedJavaScriptFeatureException("Unsupported JavaScript evaluation feature  # path");
    }

    public int getSize() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.embeddedFile.hasFileInfo() && this.embeddedFile.getFileInfo().hasSize()) {
            return this.embeddedFile.getFileInfo().getSize();
        }
        return 0;
    }

    public String getDescription() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return this.fileSpec.getDescription();
    }

    public void setDescription(String desc) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.fileSpec.setDescription(desc);
    }

    public PDFEmbeddedFile getEmbeddedFile() {
        return this.embeddedFile;
    }

    public void setEmbeddedFile(PDFEmbeddedFile embeddedFile) {
        this.embeddedFile = embeddedFile;
    }

    public PDFFileSpecification getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(PDFFileSpecification fileSpec) {
        this.fileSpec = fileSpec;
    }

    public void setNameTreeKey(ASString nameTreeKey) {
        this.nameTreeKey = nameTreeKey;
    }

    public ASString getNameTreeKey() {
        return this.nameTreeKey;
    }
}

