/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.model.manual.ColorParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Color
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Color.class", new HashMap<String, Function>(2){
        private static final long serialVersionUID = 1L;
        {
            this.put("convert", new Function(Color.class, "convert", Param.Type.Object, ColorParams.convert, 2, false, false));
            this.put("equal", new Function(Color.class, "equal", Param.Type.Boolean, ColorParams.equal, 2, false, false));
        }
    }, new HashMap<String, Property>(0){
        private static final long serialVersionUID = 1L;
    });
    private static final long serialVersionUID = 5715008858755620123L;
    private ColorArray color;
    static final String className = "color";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public void setValue(Object[] value, boolean isStrokeOp) throws PDFInvalidDocumentException, IllegalAccessException, NoSuchFieldException {
        this.color = new ColorArray(value, isStrokeOp);
    }

    public void setValue(String colorSpace, double[] colorValue) throws PDFInvalidDocumentException, IllegalAccessException, NoSuchFieldException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        this.color = new ColorArray(colorSpace, colorValue);
    }

    public Object getValue() throws PDFUnableToCompleteOperationException {
        return this.color.getColorArray();
    }

    public ASName getColorSpace() {
        return this.color.getColorSpace();
    }

    public double[] getColorValue() {
        return this.color.getColorValue();
    }

    @Override
    public String getClassName() {
        return className;
    }

    public void convert(Object arg2, Object arg1) {
    }

    public Boolean equal(Object arg2, Object arg1) {
        try {
            Object[] arrayOne = null;
            Object[] arrayTwo = null;
            if (arg1 instanceof NativeArray && arg2 instanceof NativeArray) {
                NativeArray colorArrayOne = (NativeArray)arg1;
                arrayOne = (Object[])JSUtils.scriptableToJava((ScriptableObject)colorArrayOne, Context.getCurrentContext());
                NativeArray colorArrayTwo = (NativeArray)arg2;
                arrayTwo = (Object[])JSUtils.scriptableToJava((ScriptableObject)colorArrayTwo, Context.getCurrentContext());
                return Arrays.equals(arrayOne, arrayTwo);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    String getPDFColorSpace(double[] value, boolean isStrokeOp) throws PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        if (value == null || value.length == 0) {
            throw new PDFInvalidDocumentException("Color space is not supported.");
        }
        if (value.length == 1) {
            if (isStrokeOp) {
                return "G";
            }
            return "g";
        }
        if (value.length == 3) {
            if (isStrokeOp) {
                return "RG";
            }
            return "rg";
        }
        if (value.length == 4) {
            if (isStrokeOp) {
                return "K";
            }
            return "k";
        }
        throw new PDFInvalidDocumentException("Color array is incorrect.");
    }

    static class ColorArray {
        List<Object> colorArray = null;
        boolean isStrokeOp;

        ColorArray(Object[] value, boolean isStrokeOp) throws PDFInvalidDocumentException, IllegalAccessException, NoSuchFieldException {
            this.isStrokeOp = isStrokeOp;
            if (value == null || value.length == 0) {
                throw new PDFInvalidDocumentException("Cannot create color array.");
            }
            this.colorArray = new ArrayList<Object>();
            if (value[0] instanceof String) {
                this.colorArray.add(0, value[0]);
            }
            for (int i = 1; i < value.length; ++i) {
                if (!(value[i] instanceof Double)) {
                    throw new PDFInvalidDocumentException("Cannot create color array. Invalid color data type.");
                }
                this.colorArray.add(value[i]);
            }
        }

        ColorArray(String colorSpace, double[] array) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
            String convertedColorSpace = this.convertColorSpaceFromPDFToJavascript(colorSpace);
            if (Arrays.binarySearch(ColorSpace.ColorSpaces, convertedColorSpace) == -1) {
                throw new PDFInvalidParameterException("Color space " + colorSpace + " is not supported.");
            }
            if (convertedColorSpace.equals("T")) {
                if (array != null) {
                    throw new PDFInvalidParameterException("Transparent color space doesn't take any color array.");
                }
            } else if (convertedColorSpace.equals("G")) {
                if (array == null || array.length != 1) {
                    throw new PDFInvalidParameterException("Device grey color space takes 1 element color array.");
                }
                this.addColorArray(convertedColorSpace, array);
            } else if (convertedColorSpace.equals("RGB")) {
                if (array == null || array.length != 3) {
                    throw new PDFInvalidParameterException("RGB color space takes 3 element color array.");
                }
                this.addColorArray(convertedColorSpace, array);
            } else if (convertedColorSpace.equals("CMYK")) {
                if (array == null || array.length != 4) {
                    throw new PDFInvalidParameterException("CMYK color space takes 4 element color array.");
                }
                this.addColorArray(convertedColorSpace, array);
            }
        }

        ASName getColorSpace() {
            if (this.colorArray != null && this.colorArray.size() > 0) {
                return this.convertColorSpaceFromJavascriptToPDF((String)this.colorArray.get(0), this.isStrokeOp);
            }
            return null;
        }

        double[] getColorValue() {
            if (this.colorArray.size() == 0) {
                return null;
            }
            double[] array = new double[this.colorArray.size() - 1];
            for (int i = 1; i < this.colorArray.size(); ++i) {
                array[i - 1] = (Double)this.colorArray.get(i);
            }
            return array;
        }

        Object getColorArray() {
            return this.colorArray;
        }

        private ASName convertColorSpaceFromJavascriptToPDF(String value, boolean isStrokeOp) {
            if ("G".equals(value)) {
                if (isStrokeOp) {
                    return ASName.k_G;
                }
                return ASName.k_g;
            }
            if ("RGB".equals(value)) {
                if (isStrokeOp) {
                    return ASName.k_RG;
                }
                return ASName.k_rg;
            }
            if ("CMYK".equals(value)) {
                if (isStrokeOp) {
                    return ASName.k_K;
                }
                return ASName.k_k;
            }
            throw new UnsupportedJavaScriptFeatureException("Colorspace is not supported.");
        }

        private Object addColorArray(String colorSpace, double[] colorValue) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
            this.colorArray = new ArrayList<Object>(colorValue.length + 1);
            this.colorArray.add(0, colorSpace);
            for (int i = 0; i < colorValue.length; ++i) {
                this.colorArray.add(colorValue[i]);
            }
            return this.colorArray;
        }

        private String convertColorSpaceFromPDFToJavascript(String value) throws PDFUnableToCompleteOperationException, UnsupportedJavaScriptFeatureException {
            if ("g".equals(value) || "G".equals(value)) {
                return "G";
            }
            if ("rg".equals(value) || "RG".equals(value)) {
                return "RGB";
            }
            if ("k".equals(value) || "K".equals(value)) {
                return "CMYK";
            }
            throw new UnsupportedJavaScriptFeatureException("Colorspace is not supported.");
        }
    }

    static final class ColorSpace {
        public static final String ColorSpaceTransparent = "T";
        public static final String ColorSpaceDeviceGrey = "G";
        public static final String ColorSpaceRGB = "RGB";
        public static final String ColorSpaceCMYK = "CMYK";
        public static final String[] ColorSpaces = new String[]{"CMYK", "G", "RGB", "T"};

        ColorSpace() {
        }
    }
}

