/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentFactory;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCIDReferences;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SimpleText {
    private static final ASName DefaultFontName = ASName.create((String)"T1_0");

    public static PDFPage createBoilerplatePage(PDFDocument pdfDoc, String[] boilerplateText, Integer mcid, HashMap roles) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFRectangle mediaBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.0, (double)0.0, (double)612.0, (double)792.0);
        PDFPage emptyPage = PDFPage.newInstance((PDFDocument)pdfDoc, (PDFRectangle)mediaBox);
        PDFPageTree.newInstance((PDFDocument)pdfDoc, (PDFPage)emptyPage);
        SimpleText.generatePageContent(emptyPage, boilerplateText, mcid, roles);
        return emptyPage;
    }

    public static void generatePageContent(PDFPage oPage, String[] boilerplateText, Integer mcid, HashMap roles) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFContents oPDEPageContent = PDFContents.newInstance((PDFDocument)oPage.getPDFDocument());
        PDFResources resources = PDFResources.newInstance((PDFDocument)oPage.getPDFDocument());
        PDFSimpleFontEncoding fontEncoding = PDFSimpleFontEncoding.newInstance((PDFDocument)oPage.getPDFDocument(), (CharSetEncoding)WinAnsiEncoding.getEncoding());
        PDFFontSimple defaultFont = PDFFontSimple.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)ASName.k_Helvetica, (ASName)ASName.k_Type1);
        defaultFont.setEncoding(fontEncoding);
        PDFFontMap drFontMap = PDFFontMap.newInstance((PDFDocument)oPage.getPDFDocument());
        drFontMap.set(DefaultFontName, (PDFFont)defaultFont);
        resources.setFontMap(drFontMap);
        resources.setProcSetList(new ASName[]{ASName.k_PDF, ASName.k_Text});
        oPage.setResources(resources);
        ContentWriter contentWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFContents)oPDEPageContent, (PDFResources)resources));
        contentWriter.write(InstructionFactory.newBeginText());
        if (mcid != null) {
            ASDictionary mParams = new ASDictionary();
            mParams.put(ASName.k_MCID, (ASObject)new ASNumber(mcid.intValue()));
            contentWriter.write(InstructionFactory.newBeginMarkedContent((ASName)ASName.create((String)"Content"), (ASDictionary)mParams));
        }
        contentWriter.write(InstructionFactory.newDeviceRGBFill((double)0.0, (double)0.0, (double)0.0));
        contentWriter.write(InstructionFactory.newRelativeColorimetric());
        contentWriter.write(InstructionFactory.newTextFont((ASName)DefaultFontName, (double)1.0));
        contentWriter.write(InstructionFactory.newTextMatrix((double)10.0, (double)0.0, (double)0.0, (double)10.0, (double)72.0, (double)720.0));
        try {
            for (int stringInd = 0; stringInd < boilerplateText.length; ++stringInd) {
                contentWriter.write(InstructionFactory.newShowText((byte[])boilerplateText[stringInd].getBytes("UTF-8")));
                contentWriter.write(InstructionFactory.newTextPosition((double)0.0, (double)-1.8));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 not supported", e);
        }
        if (mcid != null) {
            contentWriter.write(InstructionFactory.newEndMarkedContent());
        }
        contentWriter.write(InstructionFactory.newEndText());
        Content newContent = contentWriter.close();
        oPage.setContents(newContent.getContents());
        if (mcid != null) {
            SimpleText.replaceDocumentStructure(oPage, mcid, roles);
        }
    }

    public static void replaceDocumentStructure(PDFPage oPage, Integer mcid, Map roles) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFStructureRoot structRoot = oPage.getPDFDocument().requireCatalog().getStructureRoot();
        if (structRoot == null) {
            structRoot = PDFStructureRoot.newInstance((PDFDocument)oPage.getPDFDocument());
        }
        PDFStructureElement docElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_Document, (PDFStructureNode)structRoot);
        structRoot.addContent((PDFStructureContentInterface)docElem);
        PDFStructureElement divElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_Div, (PDFStructureNode)docElem);
        docElem.addContent((PDFStructureContentInterface)divElem);
        PDFStructureElement pageElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_P, (PDFStructureNode)divElem);
        divElem.addContent((PDFStructureContentInterface)pageElem);
        pageElem.setPage(oPage);
        PDFStructureMCID mcidLeaf = PDFStructureMCID.newInstance((PDFDocument)oPage.getPDFDocument(), (int)mcid);
        pageElem.addContent((PDFStructureContentInterface)mcidLeaf);
        PDFStructureMCIDReferences pageMCIDs = PDFStructureMCIDReferences.newInstance((PDFDocument)oPage.getPDFDocument(), (PDFStructureMCID)mcidLeaf, (PDFStructureElement)pageElem);
        int parentKey = structRoot.addParentTree(PDFStructureContentFactory.getInstance((CosObject)pageMCIDs.getCosObject()));
        PDFStructureUtils.setStructParent((int)(parentKey - 1), (PDFCosDictionary)oPage);
        if (roles != null) {
            PDFStructureRoleMap roleMap = PDFStructureRoleMap.newInstance((PDFDocument)oPage.getPDFDocument());
            for (Map.Entry curEntry : roles.entrySet()) {
                if (!(curEntry.getKey() instanceof ASName) || !(curEntry.getValue() instanceof ASName)) {
                    throw new PDFInvalidParameterException("Role is not ASName");
                }
                roleMap.addRole((ASName)curEntry.getKey(), (ASName)curEntry.getValue());
            }
            structRoot.setRoleMap(roleMap);
        }
        PDFStructureUtils.setStructParents((Integer)0, (PDFCosDictionary)oPage);
    }
}

