/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.formflattener;

import com.adobe.fontengine.font.Font;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.MarkedContentOperands;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.impl.XFAAttributesUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCManager;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCUsageAppHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.xfa.Node;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.containers.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;

public class FormFlattener {
    private static final int MAX_ALLOCATION = 64000;

    private FormFlattener() {
    }

    private static PDFXObjectForm getNormalAnnotAppearance(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        FormModel formModel;
        XFADOM xfaDom;
        Field oField;
        PDFFieldButton buttonField;
        PDFField field;
        if (annot instanceof PDFAnnotationWidget && (field = ((PDFAnnotationWidget)annot).getField()) instanceof PDFFieldButton && (buttonField = (PDFFieldButton)field).isCheckBox() && XFAService.getDocumentType(annot.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA && XFAAttributesUtils.allowNeutral(oField = XFAAttributesUtils.getXFAField(xfaDom = XFADOMService.ensureXFADOMCreated(annot.getPDFDocument()), (PDFField)buttonField), xfaDom) && (formModel = xfaDom.getFormModel()) != null) {
            Node formFieldNode = formModel.resolveNode(field.getQualifiedName());
            if (!(formFieldNode instanceof FormField)) {
                throw new PDFUnableToCompleteOperationException("FormField can not be found for check box");
            }
            FormField formField = (FormField)formFieldNode;
            String neutralValue = formField.getNeutralValue();
            String fieldRawValue = formField.getRawValue();
            if (neutralValue != null && neutralValue.equals(fieldRawValue)) {
                return annot.getAppearance().getNormalAppearance(PDFFieldButton.neutralState);
            }
        }
        return annot.getNormalStateAppearance();
    }

    private static boolean isAnnotationInVisible(APContext apContext, PDFAnnotation annot, AnnotOCVisibilityChecker annotOCChecker, PDFPage currentPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int annotFlags = annot.getFlags();
        return (annotFlags & 2) != 0 || (annotFlags & 0x20) != 0 || annotOCChecker.isInVisible(apContext, annot, currentPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addAnnotationsStream(PDFDocument doc, PDFPage curPage, APContext apContext, ContentWriter contentWriter, PDFAnnotationList pageAnnots, TextFormatter textFormatter, boolean genAppearances) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        EnumSet<PDFAnnotationEnum> annotsToFlat = apContext.getAnnotationsToBeProcessed();
        if (annotsToFlat == null || annotsToFlat.isEmpty()) {
            throw new PDFInvalidParameterException("Annotation type list to be flattened is empty in APContext.");
        }
        PDFAnnotationIterator annotsIterator = pageAnnots.iterator();
        PDFStructureContentArray pageStructParents = PDFStructureUtils.getStructParentArray((PDFCosDictionary)curPage);
        boolean annotFound = false;
        if (apContext != null) {
            apContext.setBuildFontSet(false);
        }
        AnnotOCVisibilityChecker annotOCChecker = new AnnotOCVisibilityChecker();
        while (annotsIterator.hasNext()) {
            PDFAnnotation annot = annotsIterator.next();
            if (annot instanceof PDFAnnotationPopup) {
                PDFAnnotation parentAnnot = ((PDFAnnotationPopup)annot).getParent();
                if (parentAnnot == null || !annotsToFlat.contains(PDFAnnotationEnum.getInstance((ASName)parentAnnot.getSubtype()))) continue;
                annotsIterator.remove();
                continue;
            }
            PDFAnnotationEnum annotEnum = PDFAnnotationEnum.getInstance((ASName)annot.getSubtype());
            if (!annotsToFlat.contains(annotEnum)) continue;
            try {
                PDFStructureElement annotsStructParent;
                ASMatrix transformMatrix;
                annotFound = true;
                if (FormFlattener.isAnnotationInVisible(apContext, annot, annotOCChecker, curPage)) continue;
                PDFXObjectForm annotAppearance = FormFlattener.getNormalAnnotAppearance(annot);
                if (annotAppearance == null) {
                    if (!genAppearances) continue;
                    if (annot instanceof PDFAnnotationWidget) {
                        PDFField field = PDFField.getInstance((CosObject)annot.getCosObject());
                        annotAppearance = AppearanceService.generateAnnotAppearance(doc, field, annot, apContext, textFormatter);
                    } else if (annotEnum.isAPGenerationSupported()) {
                        AnnotationAppearanceGenerator.setRotationEnum(apContext.getAnnotationRotationType());
                        AnnotationAppearanceGenerator.generateAppearance(annot, apContext.getSystemFonts());
                        annotAppearance = FormFlattener.getNormalAnnotAppearance(annot);
                    }
                    if (annotAppearance == null) continue;
                }
                if ((transformMatrix = annot.getTransformationMatrix(doc, annotAppearance)).geta() * transformMatrix.getd() - transformMatrix.getb() * transformMatrix.getc() == 0.0) continue;
                if (!annotAppearance.dictionaryContains(ASName.k_Subtype)) {
                    annotAppearance.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Form);
                }
                if ((annotsStructParent = PDFStructureUtils.getStructParentElement((PDFCosDictionary)annot)) != null) {
                    if (pageStructParents == null) {
                        pageStructParents = PDFStructureContentArray.newInstance((PDFDocument)curPage.getPDFDocument(), null);
                        PDFStructureUtils.setStructParentsInTree((PDFStructureContentArray)pageStructParents, (PDFCosDictionary)curPage);
                    }
                    PDFStructureUtils.removeOBJReference((PDFCosDictionary)annot);
                    annot.removeValue(ASName.k_StructParent);
                    int newMCID = pageStructParents.size();
                    ContentModifier.addXObject((ContentWriter)contentWriter, null, (ASMatrix)transformMatrix, (PDFXObject)annotAppearance, (MarkedContentOperands)new MarkedContentOperands(annotsStructParent, newMCID));
                    annotsStructParent.addMCID(pageStructParents, newMCID);
                    annotsStructParent.setPage(curPage);
                    continue;
                }
                ContentModifier.addXObject((ContentWriter)contentWriter, null, (ASMatrix)transformMatrix, (PDFXObject)annotAppearance);
            }
            finally {
                if (annot instanceof PDFAnnotationWidget) continue;
                annotsIterator.remove();
            }
        }
        return annotFound;
    }

    private static boolean flattenPageImpl(PDFDocument doc, PDFPage curPage, APContext apContext, TextFormatter textFormatter, boolean genAppearances) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFAnnotationList pageAnnots = curPage.getAnnotationList();
        boolean annotFlattened = false;
        if (pageAnnots != null) {
            Content newContent;
            ModifiableContent content = ModifiableContent.newInstance((PDFPage)curPage);
            ContentWriter contentWriter = ContentWriter.newInstance((ModifiableContent)content);
            if (content.getContents().hasContents()) {
                contentWriter.prepend(InstructionFactory.newGSave());
                contentWriter.write(InstructionFactory.newGRestore());
            }
            if ((annotFlattened = FormFlattener.addAnnotationsStream(doc, curPage, apContext, contentWriter, pageAnnots, textFormatter, genAppearances)) && (newContent = contentWriter.close()) != null) {
                curPage.setContents(newContent.getContents());
                curPage.setResources(newContent.getResources());
            }
        }
        return annotFlattened;
    }

    public static void flattenPage(APContext apContext, PDFDocument doc, PDFPage curPage, TextFormatter textFormatter) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        FormFlattener.flattenPage(apContext, doc, curPage, textFormatter, true);
    }

    public static void flattenPage(APContext apContext, PDFDocument doc, PDFPage curPage, TextFormatter textFormatter, boolean genAppearances) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        boolean widgetAnnotsFlattened;
        if (apContext == null) {
            apContext = new APContext(null, true, null);
        }
        if (apContext != null && apContext.isBuildFontSet()) {
            HashMap<Font, PDFFont> afePDFFontMap = apContext.getAfePDFFontMap();
            PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)doc, (PDFFontSet)apContext.getSystemFonts(), (Locale)apContext.getLocale(), afePDFFontMap);
            apContext.setAfePDFFontMap(afePDFFontMap);
            apContext.setSystemFonts(workingFontSet);
        }
        boolean annotFlattened = FormFlattener.flattenPageImpl(doc, curPage, apContext, textFormatter, genAppearances);
        boolean bl = widgetAnnotsFlattened = apContext.getAnnotationsToBeProcessed() == null ? false : apContext.getAnnotationsToBeProcessed().contains(PDFAnnotationEnum.Widget);
        if (annotFlattened && widgetAnnotsFlattened) {
            PMMService acroFormManipulator = new PMMService(doc);
            PDFPage[] page = new PDFPage[]{curPage};
            acroFormManipulator.deleteFormFields(page);
        }
    }

    public static void flattenDocument(APContext apContext, PDFDocument doc, TextFormatter textFormatter) throws PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFInvalidParameterException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (doc == null) {
            return;
        }
        if (apContext == null) {
            apContext = new APContext(null, true, null);
        }
        PMMService acroFormManipulator = null;
        int numPages = doc.requirePages().getNumPages();
        int curPageNum = 0;
        int pageCount = 0;
        if (apContext.isBuildFontSet()) {
            HashMap<Font, PDFFont> afePDFFontMap = apContext.getAfePDFFontMap();
            PDFFontSet workingFontSet = PDFFontSetUtil.buildWorkingFontSet((PDFDocument)doc, (PDFFontSet)apContext.getSystemFonts(), (Locale)apContext.getLocale(), afePDFFontMap);
            apContext.setSystemFonts(workingFontSet);
            apContext.setBuildFontSet(false);
            apContext.setAfePDFFontMap(afePDFFontMap);
        }
        boolean flatWidgetAnnots = apContext.getAnnotationsToBeProcessed() == null ? false : apContext.getAnnotationsToBeProcessed().contains(PDFAnnotationEnum.Widget);
        ArrayList<Object> formPages = null;
        if (flatWidgetAnnots) {
            if (doc.getInteractiveForm() != null && doc.getInteractiveForm().getNeedAppearances()) {
                AppearanceService.generateAppearances(doc, apContext, textFormatter);
                doc.getInteractiveForm().setNeedAppearances(false);
            }
            acroFormManipulator = new PMMService(doc);
            formPages = FormFlattener.deletePagesFormFields(null, acroFormManipulator, 0, numPages);
        }
        for (PDFPage curPage : doc.requirePages()) {
            boolean pageAnnotFlattened = FormFlattener.flattenPageImpl(doc, curPage, apContext, textFormatter, true);
            if (!flatWidgetAnnots || !pageAnnotFlattened) continue;
            formPages.add(curPage);
            ++curPageNum;
            if (++pageCount < 64000) continue;
            formPages = FormFlattener.deletePagesFormFields(formPages, acroFormManipulator, curPageNum, numPages);
            pageCount = 0;
        }
        if (flatWidgetAnnots) {
            FormFlattener.deletePagesFormFields(formPages, acroFormManipulator, curPageNum, numPages);
            if (doc.getInteractiveForm() != null) {
                doc.getInteractiveForm().removeXFA();
            }
        }
    }

    private static ArrayList<Object> deletePagesFormFields(ArrayList<?> pages, PMMService acroFormManipulator, int pageNum, int numPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (acroFormManipulator == null) {
            return null;
        }
        if (pages != null && !pages.isEmpty()) {
            PDFPage[] formsPages = new PDFPage[pages.size()];
            pages.toArray(formsPages);
            acroFormManipulator.deleteFormFields(formsPages);
        }
        return new ArrayList<Object>(Math.min(64000, numPages - pageNum));
    }

    private static class AnnotOCVisibilityChecker {
        private OCManager ocManager;

        private AnnotOCVisibilityChecker() {
        }

        private boolean isInVisible(final APContext apContext, PDFAnnotation annot, PDFPage currentPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFOCObject ocObject = PDFOCObject.getOC((PDFAnnotation)annot);
            if (ocObject != null) {
                PDFOCProperties ocProps;
                if (this.ocManager == null && (ocProps = currentPage.getPDFDocument().requireCatalog().getOCProperties()) != null && ocProps.getOCGs() != null && ocProps.getDefaultOCConfigDict() != null) {
                    this.ocManager = OCManager.newInstance((PDFOCProperties)ocProps, (OCUsageAppHandler)new OCUsageAppHandler(){

                        public Locale getLocale() {
                            return apContext != null ? apContext.getApResources().getLocale() : ocProps.getPDFDocument().getCosDocument().getOptions().getDocLocale();
                        }

                        public ASName getAppEvent() {
                            return apContext != null ? apContext.getOCUsageAppEvent() : null;
                        }
                    });
                }
                if (this.ocManager != null && !this.ocManager.isVisible(ocObject)) {
                    return true;
                }
            }
            return false;
        }
    }
}

