/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.digsig.impl.DisplayDN;
import com.adobe.internal.pdftoolkit.services.digsig.impl.RDNAttribute;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.OtherName;
import com.rsa.certj.cert.extensions.SubjectAltName;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public final class DNUtils {
    X500Name x500Name;
    static String RDN_EMPTY_VALUE = "=,";
    static String RDN_BLANK_VALUE = "='',";
    private Map<Integer, String> dnAttributeIDValueMap;
    private static final char[] printableChars = new char[]{'\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'};

    public DNUtils(X500Name subjectName) {
        this.x500Name = subjectName;
    }

    public static String getDisplayDN(X509Certificate cert) throws PDFInvalidParameterException {
        return DisplayDN.constructDisplayDN(cert);
    }

    String getSubjectNameRDN(int attributeType) throws PDFInvalidParameterException {
        String name = null;
        try {
            Map<Integer, String> dnAttrIDValueMap = this.createDNAttributeIDValueMap();
            Integer attributeID = attributeType;
            if (dnAttrIDValueMap.containsKey(attributeID)) {
                name = dnAttrIDValueMap.get(attributeID);
            }
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException("Could not extract the attribute type " + attributeType + " from the given dn name" + this.x500Name.toString(), (Throwable)e);
        }
        return name;
    }

    public String getNameRDN() throws PDFInvalidParameterException {
        String name = null;
        try {
            Map<Integer, String> dnAttrIDValueMap = this.createDNAttributeIDValueMap();
            Integer nameID = 17;
            if (dnAttrIDValueMap.containsKey(nameID)) {
                name = dnAttrIDValueMap.get(nameID);
            }
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException("Could not extract the name attribute from the given dn name" + this.x500Name.toString(), (Throwable)e);
        }
        return name;
    }

    public String getCommonNameRDN() throws PDFInvalidParameterException {
        String name = null;
        try {
            HashMap<Integer, String> dnAttrIDValueMap = this.createDisplayDNAttributeIDValueMap();
            Integer commonName = 0;
            if (dnAttrIDValueMap.containsKey(commonName)) {
                name = dnAttrIDValueMap.get(commonName);
            }
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException("Could not extract the common name attribute from the given dn name" + this.x500Name.toString(), (Throwable)e);
        }
        return name;
    }

    public HashMap<String, String> createDNAttributeValueMap() throws NameException {
        RDN rdnObj = null;
        int rdnCount = this.x500Name.getRDNCount();
        HashMap<String, String> dnAttrValueMap = new HashMap<String, String>(rdnCount);
        for (int idx = 0; idx < rdnCount; ++idx) {
            rdnObj = this.x500Name.getRDN(idx);
            String attributeString = rdnObj.getAttributeByIndex(0).toString();
            dnAttrValueMap.put(attributeString.substring(0, attributeString.indexOf(61)), attributeString.substring(attributeString.indexOf(61) + 1));
        }
        return dnAttrValueMap;
    }

    public Map<Integer, String> createDNAttributeIDValueMap() throws NameException {
        if (this.dnAttributeIDValueMap != null) {
            return this.dnAttributeIDValueMap;
        }
        RDN rdnObj = null;
        AttributeValueAssertion avaObj = null;
        int rdnCount = this.x500Name.getRDNCount();
        this.dnAttributeIDValueMap = new HashMap<Integer, String>();
        for (int idx = 0; idx < rdnCount; ++idx) {
            rdnObj = this.x500Name.getRDN(idx);
            avaObj = rdnObj.getAttributeByIndex(0);
            String attributeString = rdnObj.getAttributeByIndex(0).toString();
            this.dnAttributeIDValueMap.put(avaObj.getAttributeType(), attributeString.substring(attributeString.indexOf(61) + 1));
        }
        return this.dnAttributeIDValueMap;
    }

    public HashMap<Integer, String> createDisplayDNAttributeIDValueMap() throws NameException {
        RDN rdnObj = null;
        AttributeValueAssertion avaObj = null;
        int rdnCount = this.x500Name.getRDNCount();
        HashMap<Integer, String> dnAttrIDValueMap = new HashMap<Integer, String>();
        for (int idx = 0; idx < rdnCount; ++idx) {
            rdnObj = this.x500Name.getRDN(idx);
            avaObj = rdnObj.getAttributeByIndex(0);
            dnAttrIDValueMap.put(avaObj.getAttributeType(), avaObj.getStringAttributeNoEscapeSequences());
        }
        return dnAttrIDValueMap;
    }

    public Integer getAttributeID(String name) throws PDFInvalidParameterException {
        try {
            X500Name x500Name = new X500Name(name);
            RDN rdnObj = null;
            AttributeValueAssertion avaObj = null;
            if (x500Name != null && x500Name.getRDNCount() > 0) {
                rdnObj = x500Name.getRDN(0);
                avaObj = rdnObj.getAttributeByIndex(0);
                return avaObj.getAttributeType();
            }
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException("Cannot create an X500 name using the given name = " + name, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PDFInvalidParameterException("Cannot create an X500 name using the given name = " + name, (Throwable)e);
        }
        return null;
    }

    public static String getEscapedRDNValue(String name) {
        return RDNAttribute.escapeRDN(name);
    }

    public static String getSignerName(X509Certificate certificate) throws PDFInvalidParameterException {
        String signerName = null;
        try {
            signerName = DNUtils.getSignerName(certificate, 0);
            if (signerName == null || signerName.trim().length() == 0) {
                signerName = DNUtils.getSignerName(certificate, 17);
            }
            if (signerName == null || signerName.trim().length() == 0) {
                signerName = DNUtils.getSignerName(certificate, 13);
            }
            if (signerName == null || signerName.trim().length() == 0) {
                signerName = DNUtils.getSignerName(certificate, 12);
            }
            if (signerName == null || signerName.trim().length() == 0) {
                signerName = DNUtils.getSignerName(certificate, 15);
            }
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Cannot get encoded certificate", (Throwable)e);
        }
        catch (NameException e) {
            throw new PDFInvalidParameterException("Error parsing certificate", (Throwable)e);
        }
        return signerName;
    }

    private static String getSignerName(X509Certificate certificate, int nameType) throws PDFInvalidParameterException, CertificateException, NameException {
        GeneralNames altNames;
        SubjectAltName subjectAltNameExtension;
        String subjectStandardName = null;
        X500Name subjectX500Name = certificate.getSubjectName();
        if (subjectX500Name != null) {
            DNUtils dnUtils = new DNUtils(subjectX500Name);
            subjectStandardName = dnUtils.getSubjectNameRDN(nameType);
        }
        String subjectAlternateName = null;
        X509V3Extensions extensions = certificate.getExtensions();
        if (extensions != null && (subjectAltNameExtension = (SubjectAltName)extensions.getExtensionByType(17)) != null && (altNames = subjectAltNameExtension.getGeneralNames()) != null) {
            for (int i = 0; i < altNames.getNameCount(); ++i) {
                X500Name directoryName;
                AttributeValueAssertion attributeValue;
                OtherName currentOtherName;
                byte[] otherNameType;
                AttributeValueAssertion otherNameAttribute;
                GeneralName currentAltName = altNames.getGeneralName(i);
                if (currentAltName.getGeneralNameType() == 1 && (otherNameAttribute = new AttributeValueAssertion(otherNameType = (currentOtherName = (OtherName)currentAltName.getGeneralName()).getTypeID(), currentOtherName.getValue())).getAttributeType() == nameType) {
                    try {
                        subjectAlternateName = new String(currentOtherName.getValue(), "UTF8");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new PDFInvalidParameterException("Error fetching subjectAltName value", (Throwable)e);
                    }
                }
                if (currentAltName.getGeneralNameType() == 5 && (attributeValue = (directoryName = (X500Name)currentAltName.getGeneralName()).getAttribute(nameType)) != null && (subjectAlternateName = attributeValue.getStringAttributeNoEscapeSequences()) != null && subjectAlternateName.trim().length() != 0) break;
            }
        }
        if (subjectAlternateName == null || subjectAlternateName.trim().length() == 0) {
            return subjectStandardName;
        }
        if (subjectStandardName == null || subjectStandardName.trim().length() == 0) {
            return subjectStandardName;
        }
        if (DNUtils.isLocalisedString(subjectStandardName)) {
            return subjectStandardName;
        }
        if (DNUtils.isLocalisedString(subjectAlternateName)) {
            return subjectAlternateName;
        }
        return subjectStandardName;
    }

    static boolean isLocalisedString(String str) {
        return !DNUtils.isValidPrintableString(str);
    }

    private static boolean isValidPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (DNUtils.isValidPrintableStringChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPrintableStringChar(char c) {
        return c > '\u001f' && c < '{' && printableChars[c - 32] == '\u0001';
    }

    public X500Name getX500Name() {
        return this.x500Name;
    }

    public void setX500Name(X500Name x500Name) {
        this.x500Name = x500Name;
    }
}

