/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.AdditionalActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class PageDigester
extends ObjectDigester {
    private PDFPage page;

    public PageDigester(PDFDocument pdfDoc, PDFPage page, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.page = page;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary pageDict = this.page.getCosDictionary();
        if (!this.isDigestCached((CosObject)pageDict)) {
            ASName[] keys = new ASName[]{ASName.k_MediaBox, ASName.k_CropBox, ASName.k_Resources, ASName.k_Contents, ASName.k_Rotate};
            if (!this.page.getCosDictionary().containsKey((Object)ASName.k_CropBox)) {
                keys[1] = ASName.k_MediaBox;
            }
            this.updateValuesOnly(pageDict, keys, false);
            PDFAdditionalActionsPage actions = this.page.getAdditionalActions();
            if (actions != null && PageDigester.pageAdditionalActionIsValid((PDFAdditionalActions)actions)) {
                AdditionalActionsDigester actionsDigester = new AdditionalActionsDigester(this.pdfDoc, (PDFAdditionalActions)actions, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                byte[] actionsDigest = actionsDigester.digest();
                this.digester.update(actionsDigest);
            }
            digest = super.digest();
            this.cacheDigest((CosObject)pageDict, digest);
        } else {
            digest = this.getCachedDigest((CosObject)pageDict);
        }
        return digest;
    }

    private static boolean pageAdditionalActionIsValid(PDFAdditionalActions aa) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isValid;
        block8: {
            isValid = false;
            CosObject cosObj = aa.getCosObject();
            isValid = cosObj.getType() == 6;
            try {
                PDFAction action;
                CosDictionary cosDict;
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey((Object)ASName.k_O)) {
                        action = PDFActionFactory.getInstance((CosObject)cosDict.get(ASName.k_O));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (!isValid) break block8;
                cosDict = (CosDictionary)cosObj;
                if (cosDict.containsKey((Object)ASName.k_C)) {
                    action = PDFActionFactory.getInstance((CosObject)cosDict.get(ASName.k_C));
                    isValid = action.isValid();
                    break block8;
                }
                return false;
            }
            catch (PDFCosParseException e) {
                isValid = false;
            }
            catch (PDFIOException e) {
                isValid = false;
            }
            catch (PDFSecurityException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

